/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.BatteryStats;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SensorPowerCalculator
extends PowerCalculator
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private List<Sensor> mSensors;
    private double mGpsPowerOn;

    private void $$robo$$com_android_internal_os_SensorPowerCalculator$__constructor__(PowerProfile profile, SensorManager sensorManager) {
        this.mSensors = sensorManager.getSensorList(-1);
        this.mGpsPowerOn = profile.getAveragePower("gps.on");
    }

    private final void $$robo$$com_android_internal_os_SensorPowerCalculator$calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        SparseArray<? extends BatteryStats.Uid.Sensor> sensorStats = u.getSensorStats();
        int NSE = sensorStats.size();
        block3: for (int ise = 0; ise < NSE; ++ise) {
            BatteryStats.Uid.Sensor sensor = sensorStats.valueAt(ise);
            int sensorHandle = sensorStats.keyAt(ise);
            BatteryStats.Timer timer = sensor.getSensorTime();
            long sensorTime = timer.getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L;
            switch (sensorHandle) {
                case -10000: {
                    app.gpsTimeMs = sensorTime;
                    app.gpsPowerMah = (double)app.gpsTimeMs * this.mGpsPowerOn / 3600000.0;
                    continue block3;
                }
                default: {
                    int sensorsCount = this.mSensors.size();
                    for (int i = 0; i < sensorsCount; ++i) {
                        Sensor s = this.mSensors.get(i);
                        if (s.getHandle() != sensorHandle) continue;
                        app.sensorPowerMah += (double)((float)sensorTime * s.getPower() / 3600000.0f);
                        continue block3;
                    }
                }
            }
        }
    }

    private void __constructor__(PowerProfile powerProfile, SensorManager sensorManager) {
        this.$$robo$$com_android_internal_os_SensorPowerCalculator$__constructor__(powerProfile, sensorManager);
    }

    public SensorPowerCalculator(PowerProfile powerProfile, SensorManager sensorManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_SensorPowerCalculator$__constructor__(com.android.internal.os.PowerProfile android.hardware.SensorManager ), this, powerProfile, sensorManager);
    }

    @Override
    public void calculateApp(BatterySipper batterySipper, BatteryStats.Uid uid, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateApp", $$robo$$com_android_internal_os_SensorPowerCalculator$calculateApp(com.android.internal.os.BatterySipper android.os.BatteryStats$Uid long long int ), this, batterySipper, uid, l, l2, n);
    }

    public /* synthetic */ SensorPowerCalculator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SensorPowerCalculator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

