/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.view.DisplayInfo;
import com.android.internal.policy.DockedDividerUtils;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DividerSnapAlgorithm
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MIN_FLING_VELOCITY_DP_PER_SECOND = 400;
    private static int MIN_DISMISS_VELOCITY_DP_PER_SECOND = 600;
    private static int SNAP_MODE_16_9 = 0;
    private static int SNAP_FIXED_RATIO = 1;
    private static int SNAP_ONLY_1_1 = 2;
    private static int SNAP_MODE_MINIMIZED = 3;
    private float mMinFlingVelocityPxPerSecond;
    private float mMinDismissVelocityPxPerSecond;
    private int mDisplayWidth;
    private int mDisplayHeight;
    private int mDividerSize;
    private ArrayList<SnapTarget> mTargets;
    private Rect mInsets;
    private int mSnapMode;
    private int mMinimalSizeResizableTask;
    private int mTaskHeightInMinimizedMode;
    private float mFixedRatio;
    private boolean mIsHorizontalDivision;
    private SnapTarget mFirstSplitTarget;
    private SnapTarget mLastSplitTarget;
    private SnapTarget mDismissStartTarget;
    private SnapTarget mDismissEndTarget;
    private SnapTarget mMiddleTarget;

    private static final DividerSnapAlgorithm $$robo$$com_android_internal_policy_DividerSnapAlgorithm$create(Context ctx, Rect insets) {
        DisplayInfo displayInfo = new DisplayInfo();
        ctx.getSystemService(DisplayManager.class).getDisplay(0).getDisplayInfo(displayInfo);
        int dividerWindowWidth = ctx.getResources().getDimensionPixelSize(17105013);
        int dividerInsets = ctx.getResources().getDimensionPixelSize(17105012);
        return new DividerSnapAlgorithm(ctx.getResources(), displayInfo.logicalWidth, displayInfo.logicalHeight, dividerWindowWidth - 2 * dividerInsets, ctx.getApplicationContext().getResources().getConfiguration().orientation == 1, insets);
    }

    private void $$robo$$com_android_internal_policy_DividerSnapAlgorithm$__constructor__(Resources res, int displayWidth, int displayHeight, int dividerSize, boolean isHorizontalDivision, Rect insets) {
    }

    private void $$robo$$com_android_internal_policy_DividerSnapAlgorithm$__constructor__(Resources res, int displayWidth, int displayHeight, int dividerSize, boolean isHorizontalDivision, Rect insets, boolean isMinimizedMode) {
        this.mTargets = new ArrayList();
        this.mInsets = new Rect();
        this.mMinFlingVelocityPxPerSecond = 400.0f * res.getDisplayMetrics().density;
        this.mMinDismissVelocityPxPerSecond = 600.0f * res.getDisplayMetrics().density;
        this.mDividerSize = dividerSize;
        this.mDisplayWidth = displayWidth;
        this.mDisplayHeight = displayHeight;
        this.mIsHorizontalDivision = isHorizontalDivision;
        this.mInsets.set(insets);
        this.mSnapMode = isMinimizedMode ? 3 : res.getInteger(17694773);
        this.mFixedRatio = res.getFraction(18022404, 1, 1);
        this.mMinimalSizeResizableTask = res.getDimensionPixelSize(17104998);
        this.mTaskHeightInMinimizedMode = res.getDimensionPixelSize(0x1050151);
        this.calculateTargets(isHorizontalDivision);
        this.mFirstSplitTarget = this.mTargets.get(1);
        this.mLastSplitTarget = this.mTargets.get(this.mTargets.size() - 2);
        this.mDismissStartTarget = this.mTargets.get(0);
        this.mDismissEndTarget = this.mTargets.get(this.mTargets.size() - 1);
        this.mMiddleTarget = this.mTargets.get(this.mTargets.size() / 2);
    }

    private final boolean $$robo$$com_android_internal_policy_DividerSnapAlgorithm$isSplitScreenFeasible() {
        int statusBarSize = this.mInsets.top;
        int navBarSize = this.mIsHorizontalDivision ? this.mInsets.bottom : this.mInsets.right;
        int size = this.mIsHorizontalDivision ? this.mDisplayHeight : this.mDisplayWidth;
        int availableSpace = size - navBarSize - statusBarSize - this.mDividerSize;
        return availableSpace / 2 >= this.mMinimalSizeResizableTask;
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$calculateSnapTarget(int position, float velocity) {
        return this.calculateSnapTarget(position, velocity, true);
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$calculateSnapTarget(int position, float velocity, boolean hardDismiss) {
        if (position < this.mFirstSplitTarget.position && velocity < -this.mMinDismissVelocityPxPerSecond) {
            return this.mDismissStartTarget;
        }
        if (position > this.mLastSplitTarget.position && velocity > this.mMinDismissVelocityPxPerSecond) {
            return this.mDismissEndTarget;
        }
        if (Math.abs(velocity) < this.mMinFlingVelocityPxPerSecond) {
            return this.snap(position, hardDismiss);
        }
        if (velocity < 0.0f) {
            return this.mFirstSplitTarget;
        }
        return this.mLastSplitTarget;
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$calculateNonDismissingSnapTarget(int position) {
        SnapTarget target = this.snap(position, false);
        if (target == this.mDismissStartTarget) {
            return this.mFirstSplitTarget;
        }
        if (target == this.mDismissEndTarget) {
            return this.mLastSplitTarget;
        }
        return target;
    }

    private final float $$robo$$com_android_internal_policy_DividerSnapAlgorithm$calculateDismissingFraction(int position) {
        if (position < this.mFirstSplitTarget.position) {
            return 1.0f - (float)(position - this.getStartInset()) / (float)(this.mFirstSplitTarget.position - this.getStartInset());
        }
        if (position > this.mLastSplitTarget.position) {
            return (float)(position - this.mLastSplitTarget.position) / (float)(this.mDismissEndTarget.position - this.mLastSplitTarget.position - this.mDividerSize);
        }
        return 0.0f;
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getClosestDismissTarget(int position) {
        if (position < this.mFirstSplitTarget.position) {
            return this.mDismissStartTarget;
        }
        if (position > this.mLastSplitTarget.position) {
            return this.mDismissEndTarget;
        }
        if (position - this.mDismissStartTarget.position < this.mDismissEndTarget.position - position) {
            return this.mDismissStartTarget;
        }
        return this.mDismissEndTarget;
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getFirstSplitTarget() {
        return this.mFirstSplitTarget;
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getLastSplitTarget() {
        return this.mLastSplitTarget;
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getDismissStartTarget() {
        return this.mDismissStartTarget;
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getDismissEndTarget() {
        return this.mDismissEndTarget;
    }

    private final int $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getStartInset() {
        if (this.mIsHorizontalDivision) {
            return this.mInsets.top;
        }
        return this.mInsets.left;
    }

    private final int $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getEndInset() {
        if (this.mIsHorizontalDivision) {
            return this.mInsets.bottom;
        }
        return this.mInsets.right;
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$snap(int position, boolean hardDismiss) {
        int minIndex = -1;
        float minDistance = Float.MAX_VALUE;
        int size = this.mTargets.size();
        for (int i = 0; i < size; ++i) {
            SnapTarget target = this.mTargets.get(i);
            float distance = Math.abs(position - target.position);
            if (hardDismiss) {
                distance /= target.distanceMultiplier;
            }
            if (!(distance < minDistance)) continue;
            minIndex = i;
            minDistance = distance;
        }
        return this.mTargets.get(minIndex);
    }

    private final void $$robo$$com_android_internal_policy_DividerSnapAlgorithm$calculateTargets(boolean isHorizontalDivision) {
        this.mTargets.clear();
        int dividerMax = isHorizontalDivision ? this.mDisplayHeight : this.mDisplayWidth;
        int navBarSize = isHorizontalDivision ? this.mInsets.bottom : this.mInsets.right;
        this.mTargets.add(new SnapTarget(-this.mDividerSize, -this.mDividerSize, 1, 0.35f));
        switch (this.mSnapMode) {
            case 0: {
                this.addRatio16_9Targets(isHorizontalDivision, dividerMax);
                break;
            }
            case 1: {
                this.addFixedDivisionTargets(isHorizontalDivision, dividerMax);
                break;
            }
            case 2: {
                this.addMiddleTarget(isHorizontalDivision);
                break;
            }
            case 3: {
                this.addMinimizedTarget(isHorizontalDivision);
            }
        }
        this.mTargets.add(new SnapTarget(dividerMax - navBarSize, dividerMax, 2, 0.35f));
    }

    private final void $$robo$$com_android_internal_policy_DividerSnapAlgorithm$addNonDismissingTargets(boolean isHorizontalDivision, int topPosition, int bottomPosition, int dividerMax) {
        this.maybeAddTarget(topPosition, topPosition - this.mInsets.top);
        this.addMiddleTarget(isHorizontalDivision);
        this.maybeAddTarget(bottomPosition, dividerMax - this.mInsets.bottom - (bottomPosition + this.mDividerSize));
    }

    private final void $$robo$$com_android_internal_policy_DividerSnapAlgorithm$addFixedDivisionTargets(boolean isHorizontalDivision, int dividerMax) {
        int start = isHorizontalDivision ? this.mInsets.top : this.mInsets.left;
        int end = isHorizontalDivision ? this.mDisplayHeight - this.mInsets.bottom : this.mDisplayWidth - this.mInsets.right;
        int size = (int)(this.mFixedRatio * (float)(end - start)) - this.mDividerSize / 2;
        int topPosition = start + size;
        int bottomPosition = end - size - this.mDividerSize;
        this.addNonDismissingTargets(isHorizontalDivision, topPosition, bottomPosition, dividerMax);
    }

    private final void $$robo$$com_android_internal_policy_DividerSnapAlgorithm$addRatio16_9Targets(boolean isHorizontalDivision, int dividerMax) {
        int start = isHorizontalDivision ? this.mInsets.top : this.mInsets.left;
        int end = isHorizontalDivision ? this.mDisplayHeight - this.mInsets.bottom : this.mDisplayWidth - this.mInsets.right;
        int startOther = isHorizontalDivision ? this.mInsets.left : this.mInsets.top;
        int endOther = isHorizontalDivision ? this.mDisplayWidth - this.mInsets.right : this.mDisplayHeight - this.mInsets.bottom;
        float size = 0.5625f * (float)(endOther - startOther);
        int sizeInt = (int)Math.floor(size);
        int topPosition = start + sizeInt;
        int bottomPosition = end - sizeInt - this.mDividerSize;
        this.addNonDismissingTargets(isHorizontalDivision, topPosition, bottomPosition, dividerMax);
    }

    private final void $$robo$$com_android_internal_policy_DividerSnapAlgorithm$maybeAddTarget(int position, int smallerSize) {
        if (smallerSize >= this.mMinimalSizeResizableTask) {
            this.mTargets.add(new SnapTarget(position, position, 0));
        }
    }

    private final void $$robo$$com_android_internal_policy_DividerSnapAlgorithm$addMiddleTarget(boolean isHorizontalDivision) {
        int position = DockedDividerUtils.calculateMiddlePosition(isHorizontalDivision, this.mInsets, this.mDisplayWidth, this.mDisplayHeight, this.mDividerSize);
        this.mTargets.add(new SnapTarget(position, position, 0));
    }

    private final void $$robo$$com_android_internal_policy_DividerSnapAlgorithm$addMinimizedTarget(boolean isHorizontalDivision) {
        int position = this.mTaskHeightInMinimizedMode + this.mInsets.top;
        if (!isHorizontalDivision) {
            position += this.mInsets.left;
        }
        this.mTargets.add(new SnapTarget(position, position, 0));
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getMiddleTarget() {
        return this.mMiddleTarget;
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getNextTarget(SnapTarget snapTarget) {
        int index = this.mTargets.indexOf(snapTarget);
        if (index != -1 && index < this.mTargets.size() - 1) {
            return this.mTargets.get(index + 1);
        }
        return snapTarget;
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getPreviousTarget(SnapTarget snapTarget) {
        int index = this.mTargets.indexOf(snapTarget);
        if (index != -1 && index > 0) {
            return this.mTargets.get(index - 1);
        }
        return snapTarget;
    }

    private final boolean $$robo$$com_android_internal_policy_DividerSnapAlgorithm$isFirstSplitTargetAvailable() {
        return this.mFirstSplitTarget != this.mMiddleTarget;
    }

    private final boolean $$robo$$com_android_internal_policy_DividerSnapAlgorithm$isLastSplitTargetAvailable() {
        return this.mLastSplitTarget != this.mMiddleTarget;
    }

    private final SnapTarget $$robo$$com_android_internal_policy_DividerSnapAlgorithm$cycleNonDismissTarget(SnapTarget snapTarget, int increment) {
        int index = this.mTargets.indexOf(snapTarget);
        if (index != -1) {
            SnapTarget newTarget = this.mTargets.get((index + this.mTargets.size() + increment) % this.mTargets.size());
            if (newTarget == this.mDismissStartTarget) {
                return this.mLastSplitTarget;
            }
            if (newTarget == this.mDismissEndTarget) {
                return this.mFirstSplitTarget;
            }
            return newTarget;
        }
        return snapTarget;
    }

    public static DividerSnapAlgorithm create(Context context, Rect rect) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$create(android.content.Context android.graphics.Rect ), (Context)context, (Rect)rect);
    }

    private void __constructor__(Resources resources, int n, int n2, int n3, boolean bl, Rect rect) {
        this.$$robo$$com_android_internal_policy_DividerSnapAlgorithm$__constructor__(resources, n, n2, n3, bl, rect);
    }

    public DividerSnapAlgorithm(Resources resources, int n, int n2, int n3, boolean bl, Rect rect) {
        this(resources, n, n2, n3, bl, rect, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$__constructor__(android.content.res.Resources int int int boolean android.graphics.Rect ), this, resources, n, n2, n3, bl, rect);
    }

    private void __constructor__(Resources resources, int n, int n2, int n3, boolean bl, Rect rect, boolean bl2) {
        this.$$robo$$com_android_internal_policy_DividerSnapAlgorithm$__constructor__(resources, n, n2, n3, bl, rect, bl2);
    }

    public DividerSnapAlgorithm(Resources resources, int n, int n2, int n3, boolean bl, Rect rect, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$__constructor__(android.content.res.Resources int int int boolean android.graphics.Rect boolean ), this, resources, n, n2, n3, bl, rect, bl2);
    }

    public boolean isSplitScreenFeasible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSplitScreenFeasible", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$isSplitScreenFeasible(), this);
    }

    public SnapTarget calculateSnapTarget(int n, float f) {
        return InvokeDynamicSupport.bootstrap("calculateSnapTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$calculateSnapTarget(int float ), this, n, f);
    }

    public SnapTarget calculateSnapTarget(int n, float f, boolean bl) {
        return InvokeDynamicSupport.bootstrap("calculateSnapTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$calculateSnapTarget(int float boolean ), this, n, f, bl);
    }

    public SnapTarget calculateNonDismissingSnapTarget(int n) {
        return InvokeDynamicSupport.bootstrap("calculateNonDismissingSnapTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$calculateNonDismissingSnapTarget(int ), this, n);
    }

    public float calculateDismissingFraction(int n) {
        return (float)InvokeDynamicSupport.bootstrap("calculateDismissingFraction", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$calculateDismissingFraction(int ), this, n);
    }

    public SnapTarget getClosestDismissTarget(int n) {
        return InvokeDynamicSupport.bootstrap("getClosestDismissTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getClosestDismissTarget(int ), this, n);
    }

    public SnapTarget getFirstSplitTarget() {
        return InvokeDynamicSupport.bootstrap("getFirstSplitTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getFirstSplitTarget(), this);
    }

    public SnapTarget getLastSplitTarget() {
        return InvokeDynamicSupport.bootstrap("getLastSplitTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getLastSplitTarget(), this);
    }

    public SnapTarget getDismissStartTarget() {
        return InvokeDynamicSupport.bootstrap("getDismissStartTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getDismissStartTarget(), this);
    }

    public SnapTarget getDismissEndTarget() {
        return InvokeDynamicSupport.bootstrap("getDismissEndTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getDismissEndTarget(), this);
    }

    private int getStartInset() {
        return (int)InvokeDynamicSupport.bootstrap("getStartInset", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getStartInset(), this);
    }

    private int getEndInset() {
        return (int)InvokeDynamicSupport.bootstrap("getEndInset", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getEndInset(), this);
    }

    private SnapTarget snap(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("snap", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$snap(int boolean ), this, n, bl);
    }

    private void calculateTargets(boolean bl) {
        InvokeDynamicSupport.bootstrap("calculateTargets", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$calculateTargets(boolean ), this, bl);
    }

    private void addNonDismissingTargets(boolean bl, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("addNonDismissingTargets", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$addNonDismissingTargets(boolean int int int ), this, bl, n, n2, n3);
    }

    private void addFixedDivisionTargets(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("addFixedDivisionTargets", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$addFixedDivisionTargets(boolean int ), this, bl, n);
    }

    private void addRatio16_9Targets(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("addRatio16_9Targets", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$addRatio16_9Targets(boolean int ), this, bl, n);
    }

    private void maybeAddTarget(int n, int n2) {
        InvokeDynamicSupport.bootstrap("maybeAddTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$maybeAddTarget(int int ), this, n, n2);
    }

    private void addMiddleTarget(boolean bl) {
        InvokeDynamicSupport.bootstrap("addMiddleTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$addMiddleTarget(boolean ), this, bl);
    }

    private void addMinimizedTarget(boolean bl) {
        InvokeDynamicSupport.bootstrap("addMinimizedTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$addMinimizedTarget(boolean ), this, bl);
    }

    public SnapTarget getMiddleTarget() {
        return InvokeDynamicSupport.bootstrap("getMiddleTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getMiddleTarget(), this);
    }

    public SnapTarget getNextTarget(SnapTarget snapTarget) {
        return InvokeDynamicSupport.bootstrap("getNextTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getNextTarget(com.android.internal.policy.DividerSnapAlgorithm$SnapTarget ), this, snapTarget);
    }

    public SnapTarget getPreviousTarget(SnapTarget snapTarget) {
        return InvokeDynamicSupport.bootstrap("getPreviousTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$getPreviousTarget(com.android.internal.policy.DividerSnapAlgorithm$SnapTarget ), this, snapTarget);
    }

    public boolean isFirstSplitTargetAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFirstSplitTargetAvailable", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$isFirstSplitTargetAvailable(), this);
    }

    public boolean isLastSplitTargetAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLastSplitTargetAvailable", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$isLastSplitTargetAvailable(), this);
    }

    public SnapTarget cycleNonDismissTarget(SnapTarget snapTarget, int n) {
        return InvokeDynamicSupport.bootstrap("cycleNonDismissTarget", $$robo$$com_android_internal_policy_DividerSnapAlgorithm$cycleNonDismissTarget(com.android.internal.policy.DividerSnapAlgorithm$SnapTarget int ), this, snapTarget, n);
    }

    public /* synthetic */ DividerSnapAlgorithm() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DividerSnapAlgorithm)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SnapTarget
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int FLAG_NONE = 0;
        public static int FLAG_DISMISS_START = 1;
        public static int FLAG_DISMISS_END = 2;
        public int position;
        public int taskPosition;
        public int flag;
        private float distanceMultiplier;

        private void $$robo$$com_android_internal_policy_DividerSnapAlgorithm_SnapTarget$__constructor__(int position, int taskPosition, int flag) {
        }

        private void $$robo$$com_android_internal_policy_DividerSnapAlgorithm_SnapTarget$__constructor__(int position, int taskPosition, int flag, float distanceMultiplier) {
            this.position = position;
            this.taskPosition = taskPosition;
            this.flag = flag;
            this.distanceMultiplier = distanceMultiplier;
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$com_android_internal_policy_DividerSnapAlgorithm_SnapTarget$__constructor__(n, n2, n3);
        }

        public SnapTarget(int n, int n2, int n3) {
            this(n, n2, n3, 1.0f);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DividerSnapAlgorithm_SnapTarget$__constructor__(int int int ), this, n, n2, n3);
        }

        private void __constructor__(int n, int n2, int n3, float f) {
            this.$$robo$$com_android_internal_policy_DividerSnapAlgorithm_SnapTarget$__constructor__(n, n2, n3, f);
        }

        public SnapTarget(int n, int n2, int n3, float f) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DividerSnapAlgorithm_SnapTarget$__constructor__(int int int float ), this, n, n2, n3, f);
        }

        public /* synthetic */ SnapTarget() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SnapTarget)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

