/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.net.Uri;
import android.os.Bundle;
import android.os.SystemClock;
import android.telecom.ConferenceParticipant;
import android.telecom.Connection;
import android.telephony.Rlog;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.UUSInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Connection
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int AUDIO_QUALITY_STANDARD = 1;
    public static int AUDIO_QUALITY_HIGH_DEFINITION = 2;
    private String mTelecomCallId;
    protected String mCnapName;
    protected int mCnapNamePresentation;
    protected String mAddress;
    protected String mDialString;
    protected int mNumberPresentation;
    protected boolean mIsIncoming;
    protected long mCreateTime;
    protected long mConnectTime;
    protected long mConnectTimeReal;
    protected long mDuration;
    protected long mHoldingStartTime;
    protected Connection mOrigConnection;
    private List<PostDialListener> mPostDialListeners;
    public Set<Listener> mListeners;
    protected boolean mNumberConverted;
    protected String mConvertedNumber;
    protected String mPostDialString;
    protected int mNextPostDialChar;
    protected int mCause;
    protected PostDialState mPostDialState;
    private static String LOG_TAG;
    Object mUserData;
    private int mVideoState;
    private int mConnectionCapabilities;
    private boolean mIsWifi;
    private boolean mAudioModeIsVoip;
    private int mAudioQuality;
    private int mCallSubstate;
    private Connection.VideoProvider mVideoProvider;
    public Call.State mPreHandoverState;
    private Bundle mExtras;
    private int mPhoneType;
    private boolean mAnsweringDisconnectsActiveCall;
    private boolean mAllowAddCallDuringVideoCall;
    private boolean mIsPulledCall;
    private int mPulledDialogId;

    private void $$robo$$com_android_internal_telephony_Connection$__constructor__(int phoneType) {
        this.mCnapNamePresentation = 1;
        this.mNumberPresentation = 1;
        this.mPostDialListeners = new ArrayList<PostDialListener>();
        this.mListeners = new CopyOnWriteArraySet<Listener>();
        this.mNumberConverted = false;
        this.mCause = 0;
        this.mPostDialState = PostDialState.NOT_STARTED;
        this.mPreHandoverState = Call.State.IDLE;
        this.mIsPulledCall = false;
        this.mPhoneType = phoneType;
    }

    private final String $$robo$$com_android_internal_telephony_Connection$getTelecomCallId() {
        return this.mTelecomCallId;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setTelecomCallId(String telecomCallId) {
        this.mTelecomCallId = telecomCallId;
    }

    private final String $$robo$$com_android_internal_telephony_Connection$getAddress() {
        return this.mAddress;
    }

    private final String $$robo$$com_android_internal_telephony_Connection$getCnapName() {
        return this.mCnapName;
    }

    private final String $$robo$$com_android_internal_telephony_Connection$getOrigDialString() {
        return null;
    }

    private final int $$robo$$com_android_internal_telephony_Connection$getCnapNamePresentation() {
        return this.mCnapNamePresentation;
    }

    public abstract Call getCall();

    private final long $$robo$$com_android_internal_telephony_Connection$getCreateTime() {
        return this.mCreateTime;
    }

    private final long $$robo$$com_android_internal_telephony_Connection$getConnectTime() {
        return this.mConnectTime;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setConnectTime(long connectTime) {
        this.mConnectTime = connectTime;
    }

    private final long $$robo$$com_android_internal_telephony_Connection$getConnectTimeReal() {
        return this.mConnectTimeReal;
    }

    public abstract long getDisconnectTime();

    private final long $$robo$$com_android_internal_telephony_Connection$getDurationMillis() {
        if (this.mConnectTimeReal == 0L) {
            return 0L;
        }
        if (this.mDuration == 0L) {
            return SystemClock.elapsedRealtime() - this.mConnectTimeReal;
        }
        return this.mDuration;
    }

    private final long $$robo$$com_android_internal_telephony_Connection$getHoldingStartTime() {
        return this.mHoldingStartTime;
    }

    public abstract long getHoldDurationMillis();

    private final int $$robo$$com_android_internal_telephony_Connection$getDisconnectCause() {
        return this.mCause;
    }

    public abstract String getVendorDisconnectCause();

    private final boolean $$robo$$com_android_internal_telephony_Connection$isIncoming() {
        return this.mIsIncoming;
    }

    private final Call.State $$robo$$com_android_internal_telephony_Connection$getState() {
        Call c = this.getCall();
        if (c == null) {
            return Call.State.IDLE;
        }
        return c.getState();
    }

    private final Call.State $$robo$$com_android_internal_telephony_Connection$getStateBeforeHandover() {
        return this.mPreHandoverState;
    }

    private final List<ConferenceParticipant> $$robo$$com_android_internal_telephony_Connection$getConferenceParticipants() {
        Call c = this.getCall();
        if (c == null) {
            return null;
        }
        return c.getConferenceParticipants();
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$isAlive() {
        return this.getState().isAlive();
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$isRinging() {
        return this.getState().isRinging();
    }

    private final Object $$robo$$com_android_internal_telephony_Connection$getUserData() {
        return this.mUserData;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setUserData(Object userdata) {
        this.mUserData = userdata;
    }

    public abstract void hangup() throws CallStateException;

    public abstract void separate() throws CallStateException;

    private final void $$robo$$com_android_internal_telephony_Connection$clearUserData() {
        this.mUserData = null;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$addPostDialListener(PostDialListener listener) {
        if (!this.mPostDialListeners.contains(listener)) {
            this.mPostDialListeners.add(listener);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$removePostDialListener(PostDialListener listener) {
        this.mPostDialListeners.remove(listener);
    }

    private final void $$robo$$com_android_internal_telephony_Connection$clearPostDialListeners() {
        if (this.mPostDialListeners != null) {
            this.mPostDialListeners.clear();
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$notifyPostDialListeners() {
        if (this.getPostDialState() == PostDialState.WAIT) {
            for (PostDialListener listener : new ArrayList<PostDialListener>(this.mPostDialListeners)) {
                listener.onPostDialWait();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$notifyPostDialListenersNextChar(char c) {
        for (PostDialListener listener : new ArrayList<PostDialListener>(this.mPostDialListeners)) {
            listener.onPostDialChar(c);
        }
    }

    private final PostDialState $$robo$$com_android_internal_telephony_Connection$getPostDialState() {
        return this.mPostDialState;
    }

    private final String $$robo$$com_android_internal_telephony_Connection$getRemainingPostDialString() {
        if (this.mPostDialState == PostDialState.CANCELLED || this.mPostDialState == PostDialState.COMPLETE || this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            return "";
        }
        return this.mPostDialString.substring(this.mNextPostDialChar);
    }

    public abstract void proceedAfterWaitChar();

    public abstract void proceedAfterWildChar(String var1);

    public abstract void cancelPostDial();

    private final boolean $$robo$$com_android_internal_telephony_Connection$onDisconnect(int cause) {
        return false;
    }

    public abstract int getNumberPresentation();

    public abstract UUSInfo getUUSInfo();

    public abstract int getPreciseDisconnectCause();

    private final Connection $$robo$$com_android_internal_telephony_Connection$getOrigConnection() {
        return this.mOrigConnection;
    }

    public abstract boolean isMultiparty();

    private final boolean $$robo$$com_android_internal_telephony_Connection$isConferenceHost() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$isMemberOfPeerConference() {
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$migrateFrom(Connection c) {
        if (c == null) {
            return;
        }
        this.mListeners = c.mListeners;
        this.mDialString = c.getOrigDialString();
        this.mCreateTime = c.getCreateTime();
        this.mConnectTime = c.getConnectTime();
        this.mConnectTimeReal = c.getConnectTimeReal();
        this.mHoldingStartTime = c.getHoldingStartTime();
        this.mOrigConnection = c.getOrigConnection();
        this.mPostDialString = c.mPostDialString;
        this.mNextPostDialChar = c.mNextPostDialChar;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    private final void $$robo$$com_android_internal_telephony_Connection$removeListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    private final int $$robo$$com_android_internal_telephony_Connection$getVideoState() {
        return this.mVideoState;
    }

    private final int $$robo$$com_android_internal_telephony_Connection$getConnectionCapabilities() {
        return this.mConnectionCapabilities;
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$hasCapabilities(int connectionCapabilities) {
        return (this.mConnectionCapabilities & connectionCapabilities) == connectionCapabilities;
    }

    private static final int $$robo$$com_android_internal_telephony_Connection$addCapability(int capabilities, int capability) {
        return capabilities | capability;
    }

    private static final int $$robo$$com_android_internal_telephony_Connection$removeCapability(int capabilities, int capability) {
        return capabilities & ~capability;
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$isWifi() {
        return this.mIsWifi;
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$getAudioModeIsVoip() {
        return this.mAudioModeIsVoip;
    }

    private final Connection.VideoProvider $$robo$$com_android_internal_telephony_Connection$getVideoProvider() {
        return this.mVideoProvider;
    }

    private final int $$robo$$com_android_internal_telephony_Connection$getAudioQuality() {
        return this.mAudioQuality;
    }

    private final int $$robo$$com_android_internal_telephony_Connection$getCallSubstate() {
        return this.mCallSubstate;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setVideoState(int videoState) {
        this.mVideoState = videoState;
        for (Listener l : this.mListeners) {
            l.onVideoStateChanged(this.mVideoState);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setConnectionCapabilities(int capabilities) {
        if (this.mConnectionCapabilities != capabilities) {
            this.mConnectionCapabilities = capabilities;
            for (Listener l : this.mListeners) {
                l.onConnectionCapabilitiesChanged(this.mConnectionCapabilities);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setWifi(boolean isWifi) {
        this.mIsWifi = isWifi;
        for (Listener l : this.mListeners) {
            l.onWifiChanged(this.mIsWifi);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setAudioModeIsVoip(boolean isVoip) {
        this.mAudioModeIsVoip = isVoip;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setAudioQuality(int audioQuality) {
        this.mAudioQuality = audioQuality;
        for (Listener l : this.mListeners) {
            l.onAudioQualityChanged(this.mAudioQuality);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setConnectionExtras(Bundle extras) {
        this.mExtras = extras != null ? new Bundle(extras) : null;
        for (Listener l : this.mListeners) {
            l.onExtrasChanged(this.mExtras);
        }
    }

    private final Bundle $$robo$$com_android_internal_telephony_Connection$getConnectionExtras() {
        return this.mExtras == null ? null : new Bundle(this.mExtras);
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$isActiveCallDisconnectedOnAnswer() {
        return this.mAnsweringDisconnectsActiveCall;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setActiveCallDisconnectedOnAnswer(boolean answeringDisconnectsActiveCall) {
        this.mAnsweringDisconnectsActiveCall = answeringDisconnectsActiveCall;
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$shouldAllowAddCallDuringVideoCall() {
        return this.mAllowAddCallDuringVideoCall;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setAllowAddCallDuringVideoCall(boolean allowAddCallDuringVideoCall) {
        this.mAllowAddCallDuringVideoCall = allowAddCallDuringVideoCall;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setIsPulledCall(boolean isPulledCall) {
        this.mIsPulledCall = isPulledCall;
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$isPulledCall() {
        return this.mIsPulledCall;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setPulledDialogId(int pulledDialogId) {
        this.mPulledDialogId = pulledDialogId;
    }

    private final int $$robo$$com_android_internal_telephony_Connection$getPulledDialogId() {
        return this.mPulledDialogId;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setCallSubstate(int callSubstate) {
        this.mCallSubstate = callSubstate;
        for (Listener l : this.mListeners) {
            l.onCallSubstateChanged(this.mCallSubstate);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setVideoProvider(Connection.VideoProvider videoProvider) {
        this.mVideoProvider = videoProvider;
        for (Listener l : this.mListeners) {
            l.onVideoProviderChanged(this.mVideoProvider);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setConverted(String oriNumber) {
        this.mNumberConverted = true;
        this.mConvertedNumber = this.mAddress;
        this.mAddress = oriNumber;
        this.mDialString = oriNumber;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$updateConferenceParticipants(List<ConferenceParticipant> conferenceParticipants) {
        for (Listener l : this.mListeners) {
            l.onConferenceParticipantsChanged(conferenceParticipants);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$updateMultipartyState(boolean isMultiparty) {
        for (Listener l : this.mListeners) {
            l.onMultipartyStateChanged(isMultiparty);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$onConferenceMergeFailed() {
        for (Listener l : this.mListeners) {
            l.onConferenceMergedFailed();
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$onExitedEcmMode() {
        for (Listener l : this.mListeners) {
            l.onExitedEcmMode();
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$onCallPullFailed(Connection externalConnection) {
        for (Listener l : this.mListeners) {
            l.onCallPullFailed(externalConnection);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$onHandoverToWifiFailed() {
        for (Listener l : this.mListeners) {
            l.onHandoverToWifiFailed();
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$onConnectionEvent(String event, Bundle extras) {
        for (Listener l : this.mListeners) {
            l.onConnectionEvent(event, extras);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$onDisconnectConferenceParticipant(Uri endpoint) {
    }

    private final void $$robo$$com_android_internal_telephony_Connection$pullExternalCall() {
    }

    private final int $$robo$$com_android_internal_telephony_Connection$getPhoneType() {
        return this.mPhoneType;
    }

    private final String $$robo$$com_android_internal_telephony_Connection$toString() {
        StringBuilder str = new StringBuilder(128);
        str.append(" callId: " + this.getTelecomCallId());
        str.append(" isExternal: " + ((this.mConnectionCapabilities & 0x10) == 16 ? "Y" : "N"));
        if (Rlog.isLoggable(LOG_TAG, 3)) {
            str.append("addr: " + this.getAddress()).append(" pres.: " + this.getNumberPresentation()).append(" dial: " + this.getOrigDialString()).append(" postdial: " + this.getRemainingPostDialString()).append(" cnap name: " + this.getCnapName()).append("(" + this.getCnapNamePresentation() + ")");
        }
        str.append(" incoming: " + this.isIncoming()).append(" state: " + (Object)((Object)this.getState())).append(" post dial state: " + (Object)((Object)this.getPostDialState()));
        return str.toString();
    }

    static void __staticInitializer__() {
        LOG_TAG = "Connection";
    }

    private void __constructor__(int n) {
        this.$$robo$$com_android_internal_telephony_Connection$__constructor__(n);
    }

    public Connection(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Connection$__constructor__(int ), this, n);
    }

    public String getTelecomCallId() {
        return InvokeDynamicSupport.bootstrap("getTelecomCallId", $$robo$$com_android_internal_telephony_Connection$getTelecomCallId(), this);
    }

    public void setTelecomCallId(String string2) {
        InvokeDynamicSupport.bootstrap("setTelecomCallId", $$robo$$com_android_internal_telephony_Connection$setTelecomCallId(java.lang.String ), this, string2);
    }

    public String getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$com_android_internal_telephony_Connection$getAddress(), this);
    }

    public String getCnapName() {
        return InvokeDynamicSupport.bootstrap("getCnapName", $$robo$$com_android_internal_telephony_Connection$getCnapName(), this);
    }

    public String getOrigDialString() {
        return InvokeDynamicSupport.bootstrap("getOrigDialString", $$robo$$com_android_internal_telephony_Connection$getOrigDialString(), this);
    }

    public int getCnapNamePresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getCnapNamePresentation", $$robo$$com_android_internal_telephony_Connection$getCnapNamePresentation(), this);
    }

    public long getCreateTime() {
        return (long)InvokeDynamicSupport.bootstrap("getCreateTime", $$robo$$com_android_internal_telephony_Connection$getCreateTime(), this);
    }

    public long getConnectTime() {
        return (long)InvokeDynamicSupport.bootstrap("getConnectTime", $$robo$$com_android_internal_telephony_Connection$getConnectTime(), this);
    }

    public void setConnectTime(long l) {
        InvokeDynamicSupport.bootstrap("setConnectTime", $$robo$$com_android_internal_telephony_Connection$setConnectTime(long ), this, l);
    }

    public long getConnectTimeReal() {
        return (long)InvokeDynamicSupport.bootstrap("getConnectTimeReal", $$robo$$com_android_internal_telephony_Connection$getConnectTimeReal(), this);
    }

    public long getDurationMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getDurationMillis", $$robo$$com_android_internal_telephony_Connection$getDurationMillis(), this);
    }

    public long getHoldingStartTime() {
        return (long)InvokeDynamicSupport.bootstrap("getHoldingStartTime", $$robo$$com_android_internal_telephony_Connection$getHoldingStartTime(), this);
    }

    public int getDisconnectCause() {
        return (int)InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$com_android_internal_telephony_Connection$getDisconnectCause(), this);
    }

    public boolean isIncoming() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIncoming", $$robo$$com_android_internal_telephony_Connection$isIncoming(), this);
    }

    public Call.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_Connection$getState(), this);
    }

    public Call.State getStateBeforeHandover() {
        return InvokeDynamicSupport.bootstrap("getStateBeforeHandover", $$robo$$com_android_internal_telephony_Connection$getStateBeforeHandover(), this);
    }

    public List<ConferenceParticipant> getConferenceParticipants() {
        return InvokeDynamicSupport.bootstrap("getConferenceParticipants", $$robo$$com_android_internal_telephony_Connection$getConferenceParticipants(), this);
    }

    public boolean isAlive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlive", $$robo$$com_android_internal_telephony_Connection$isAlive(), this);
    }

    public boolean isRinging() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRinging", $$robo$$com_android_internal_telephony_Connection$isRinging(), this);
    }

    public Object getUserData() {
        return InvokeDynamicSupport.bootstrap("getUserData", $$robo$$com_android_internal_telephony_Connection$getUserData(), this);
    }

    public void setUserData(Object object) {
        InvokeDynamicSupport.bootstrap("setUserData", $$robo$$com_android_internal_telephony_Connection$setUserData(java.lang.Object ), this, object);
    }

    public void clearUserData() {
        InvokeDynamicSupport.bootstrap("clearUserData", $$robo$$com_android_internal_telephony_Connection$clearUserData(), this);
    }

    public void addPostDialListener(PostDialListener postDialListener) {
        InvokeDynamicSupport.bootstrap("addPostDialListener", $$robo$$com_android_internal_telephony_Connection$addPostDialListener(com.android.internal.telephony.Connection$PostDialListener ), this, postDialListener);
    }

    public void removePostDialListener(PostDialListener postDialListener) {
        InvokeDynamicSupport.bootstrap("removePostDialListener", $$robo$$com_android_internal_telephony_Connection$removePostDialListener(com.android.internal.telephony.Connection$PostDialListener ), this, postDialListener);
    }

    protected void clearPostDialListeners() {
        InvokeDynamicSupport.bootstrap("clearPostDialListeners", $$robo$$com_android_internal_telephony_Connection$clearPostDialListeners(), this);
    }

    protected void notifyPostDialListeners() {
        InvokeDynamicSupport.bootstrap("notifyPostDialListeners", $$robo$$com_android_internal_telephony_Connection$notifyPostDialListeners(), this);
    }

    protected void notifyPostDialListenersNextChar(char c) {
        InvokeDynamicSupport.bootstrap("notifyPostDialListenersNextChar", $$robo$$com_android_internal_telephony_Connection$notifyPostDialListenersNextChar(char ), this, c);
    }

    public PostDialState getPostDialState() {
        return InvokeDynamicSupport.bootstrap("getPostDialState", $$robo$$com_android_internal_telephony_Connection$getPostDialState(), this);
    }

    public String getRemainingPostDialString() {
        return InvokeDynamicSupport.bootstrap("getRemainingPostDialString", $$robo$$com_android_internal_telephony_Connection$getRemainingPostDialString(), this);
    }

    public boolean onDisconnect(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$com_android_internal_telephony_Connection$onDisconnect(int ), this, n);
    }

    public Connection getOrigConnection() {
        return InvokeDynamicSupport.bootstrap("getOrigConnection", $$robo$$com_android_internal_telephony_Connection$getOrigConnection(), this);
    }

    public boolean isConferenceHost() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConferenceHost", $$robo$$com_android_internal_telephony_Connection$isConferenceHost(), this);
    }

    public boolean isMemberOfPeerConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMemberOfPeerConference", $$robo$$com_android_internal_telephony_Connection$isMemberOfPeerConference(), this);
    }

    public void migrateFrom(Connection connection) {
        InvokeDynamicSupport.bootstrap("migrateFrom", $$robo$$com_android_internal_telephony_Connection$migrateFrom(com.android.internal.telephony.Connection ), this, connection);
    }

    public void addListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("addListener", $$robo$$com_android_internal_telephony_Connection$addListener(com.android.internal.telephony.Connection$Listener ), this, listener);
    }

    public void removeListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("removeListener", $$robo$$com_android_internal_telephony_Connection$removeListener(com.android.internal.telephony.Connection$Listener ), this, listener);
    }

    public int getVideoState() {
        return (int)InvokeDynamicSupport.bootstrap("getVideoState", $$robo$$com_android_internal_telephony_Connection$getVideoState(), this);
    }

    public int getConnectionCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionCapabilities", $$robo$$com_android_internal_telephony_Connection$getConnectionCapabilities(), this);
    }

    public boolean hasCapabilities(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCapabilities", $$robo$$com_android_internal_telephony_Connection$hasCapabilities(int ), this, n);
    }

    public static int addCapability(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("addCapability", $$robo$$com_android_internal_telephony_Connection$addCapability(int int ), (int)n, (int)n2);
    }

    public static int removeCapability(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("removeCapability", $$robo$$com_android_internal_telephony_Connection$removeCapability(int int ), (int)n, (int)n2);
    }

    public boolean isWifi() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWifi", $$robo$$com_android_internal_telephony_Connection$isWifi(), this);
    }

    public boolean getAudioModeIsVoip() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAudioModeIsVoip", $$robo$$com_android_internal_telephony_Connection$getAudioModeIsVoip(), this);
    }

    public Connection.VideoProvider getVideoProvider() {
        return InvokeDynamicSupport.bootstrap("getVideoProvider", $$robo$$com_android_internal_telephony_Connection$getVideoProvider(), this);
    }

    public int getAudioQuality() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioQuality", $$robo$$com_android_internal_telephony_Connection$getAudioQuality(), this);
    }

    public int getCallSubstate() {
        return (int)InvokeDynamicSupport.bootstrap("getCallSubstate", $$robo$$com_android_internal_telephony_Connection$getCallSubstate(), this);
    }

    public void setVideoState(int n) {
        InvokeDynamicSupport.bootstrap("setVideoState", $$robo$$com_android_internal_telephony_Connection$setVideoState(int ), this, n);
    }

    public void setConnectionCapabilities(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionCapabilities", $$robo$$com_android_internal_telephony_Connection$setConnectionCapabilities(int ), this, n);
    }

    public void setWifi(boolean bl) {
        InvokeDynamicSupport.bootstrap("setWifi", $$robo$$com_android_internal_telephony_Connection$setWifi(boolean ), this, bl);
    }

    public void setAudioModeIsVoip(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAudioModeIsVoip", $$robo$$com_android_internal_telephony_Connection$setAudioModeIsVoip(boolean ), this, bl);
    }

    public void setAudioQuality(int n) {
        InvokeDynamicSupport.bootstrap("setAudioQuality", $$robo$$com_android_internal_telephony_Connection$setAudioQuality(int ), this, n);
    }

    public void setConnectionExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setConnectionExtras", $$robo$$com_android_internal_telephony_Connection$setConnectionExtras(android.os.Bundle ), this, bundle);
    }

    public Bundle getConnectionExtras() {
        return InvokeDynamicSupport.bootstrap("getConnectionExtras", $$robo$$com_android_internal_telephony_Connection$getConnectionExtras(), this);
    }

    public boolean isActiveCallDisconnectedOnAnswer() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActiveCallDisconnectedOnAnswer", $$robo$$com_android_internal_telephony_Connection$isActiveCallDisconnectedOnAnswer(), this);
    }

    public void setActiveCallDisconnectedOnAnswer(boolean bl) {
        InvokeDynamicSupport.bootstrap("setActiveCallDisconnectedOnAnswer", $$robo$$com_android_internal_telephony_Connection$setActiveCallDisconnectedOnAnswer(boolean ), this, bl);
    }

    public boolean shouldAllowAddCallDuringVideoCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldAllowAddCallDuringVideoCall", $$robo$$com_android_internal_telephony_Connection$shouldAllowAddCallDuringVideoCall(), this);
    }

    public void setAllowAddCallDuringVideoCall(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowAddCallDuringVideoCall", $$robo$$com_android_internal_telephony_Connection$setAllowAddCallDuringVideoCall(boolean ), this, bl);
    }

    public void setIsPulledCall(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsPulledCall", $$robo$$com_android_internal_telephony_Connection$setIsPulledCall(boolean ), this, bl);
    }

    public boolean isPulledCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPulledCall", $$robo$$com_android_internal_telephony_Connection$isPulledCall(), this);
    }

    public void setPulledDialogId(int n) {
        InvokeDynamicSupport.bootstrap("setPulledDialogId", $$robo$$com_android_internal_telephony_Connection$setPulledDialogId(int ), this, n);
    }

    public int getPulledDialogId() {
        return (int)InvokeDynamicSupport.bootstrap("getPulledDialogId", $$robo$$com_android_internal_telephony_Connection$getPulledDialogId(), this);
    }

    public void setCallSubstate(int n) {
        InvokeDynamicSupport.bootstrap("setCallSubstate", $$robo$$com_android_internal_telephony_Connection$setCallSubstate(int ), this, n);
    }

    public void setVideoProvider(Connection.VideoProvider videoProvider) {
        InvokeDynamicSupport.bootstrap("setVideoProvider", $$robo$$com_android_internal_telephony_Connection$setVideoProvider(android.telecom.Connection$VideoProvider ), this, videoProvider);
    }

    public void setConverted(String string2) {
        InvokeDynamicSupport.bootstrap("setConverted", $$robo$$com_android_internal_telephony_Connection$setConverted(java.lang.String ), this, string2);
    }

    public void updateConferenceParticipants(List<ConferenceParticipant> list) {
        InvokeDynamicSupport.bootstrap("updateConferenceParticipants", $$robo$$com_android_internal_telephony_Connection$updateConferenceParticipants(java.util.List<android.telecom.ConferenceParticipant> ), this, list);
    }

    public void updateMultipartyState(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateMultipartyState", $$robo$$com_android_internal_telephony_Connection$updateMultipartyState(boolean ), this, bl);
    }

    public void onConferenceMergeFailed() {
        InvokeDynamicSupport.bootstrap("onConferenceMergeFailed", $$robo$$com_android_internal_telephony_Connection$onConferenceMergeFailed(), this);
    }

    public void onExitedEcmMode() {
        InvokeDynamicSupport.bootstrap("onExitedEcmMode", $$robo$$com_android_internal_telephony_Connection$onExitedEcmMode(), this);
    }

    public void onCallPullFailed(Connection connection) {
        InvokeDynamicSupport.bootstrap("onCallPullFailed", $$robo$$com_android_internal_telephony_Connection$onCallPullFailed(com.android.internal.telephony.Connection ), this, connection);
    }

    public void onHandoverToWifiFailed() {
        InvokeDynamicSupport.bootstrap("onHandoverToWifiFailed", $$robo$$com_android_internal_telephony_Connection$onHandoverToWifiFailed(), this);
    }

    public void onConnectionEvent(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onConnectionEvent", $$robo$$com_android_internal_telephony_Connection$onConnectionEvent(java.lang.String android.os.Bundle ), this, string2, bundle);
    }

    public void onDisconnectConferenceParticipant(Uri uri) {
        InvokeDynamicSupport.bootstrap("onDisconnectConferenceParticipant", $$robo$$com_android_internal_telephony_Connection$onDisconnectConferenceParticipant(android.net.Uri ), this, uri);
    }

    public void pullExternalCall() {
        InvokeDynamicSupport.bootstrap("pullExternalCall", $$robo$$com_android_internal_telephony_Connection$pullExternalCall(), this);
    }

    public int getPhoneType() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneType", $$robo$$com_android_internal_telephony_Connection$getPhoneType(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_Connection$toString(), this);
    }

    static {
        RobolectricInternals.classInitializing(Connection.class);
    }

    public /* synthetic */ Connection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Connection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PostDialState
    extends Enum<PostDialState> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ PostDialState NOT_STARTED;
        public static /* enum */ PostDialState STARTED;
        public static /* enum */ PostDialState WAIT;
        public static /* enum */ PostDialState WILD;
        public static /* enum */ PostDialState COMPLETE;
        public static /* enum */ PostDialState CANCELLED;
        public static /* enum */ PostDialState PAUSE;
        private static /* synthetic */ PostDialState[] $VALUES;

        private static final PostDialState[] $$robo$$com_android_internal_telephony_Connection_PostDialState$values() {
            return (PostDialState[])$VALUES.clone();
        }

        private static final PostDialState $$robo$$com_android_internal_telephony_Connection_PostDialState$valueOf(String name) {
            return Enum.valueOf(PostDialState.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_telephony_Connection_PostDialState$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NOT_STARTED = new PostDialState();
            STARTED = new PostDialState();
            WAIT = new PostDialState();
            WILD = new PostDialState();
            COMPLETE = new PostDialState();
            CANCELLED = new PostDialState();
            PAUSE = new PostDialState();
            $VALUES = new PostDialState[]{NOT_STARTED, STARTED, WAIT, WILD, COMPLETE, CANCELLED, PAUSE};
        }

        public static PostDialState[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_telephony_Connection_PostDialState$values());
        }

        public static PostDialState valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_telephony_Connection_PostDialState$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_telephony_Connection_PostDialState$__constructor__(string2, n);
        }

        public PostDialState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Connection_PostDialState$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(PostDialState.class);
        }

        public /* synthetic */ PostDialState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PostDialState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ListenerBase
    implements Listener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_telephony_Connection_ListenerBase$__constructor__() {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onVideoStateChanged(int videoState) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onConnectionCapabilitiesChanged(int capability) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onWifiChanged(boolean isWifi) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onVideoProviderChanged(Connection.VideoProvider videoProvider) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onAudioQualityChanged(int audioQuality) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onConferenceParticipantsChanged(List<ConferenceParticipant> participants) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onCallSubstateChanged(int callSubstate) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onMultipartyStateChanged(boolean isMultiParty) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onConferenceMergedFailed() {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onExtrasChanged(Bundle extras) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onExitedEcmMode() {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onCallPullFailed(Connection externalConnection) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onHandoverToWifiFailed() {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onConnectionEvent(String event, Bundle extras) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_Connection_ListenerBase$__constructor__();
        }

        public ListenerBase() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Connection_ListenerBase$__constructor__(), this);
        }

        @Override
        public void onVideoStateChanged(int n) {
            InvokeDynamicSupport.bootstrap("onVideoStateChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onVideoStateChanged(int ), this, n);
        }

        @Override
        public void onConnectionCapabilitiesChanged(int n) {
            InvokeDynamicSupport.bootstrap("onConnectionCapabilitiesChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onConnectionCapabilitiesChanged(int ), this, n);
        }

        @Override
        public void onWifiChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onWifiChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onWifiChanged(boolean ), this, bl);
        }

        @Override
        public void onVideoProviderChanged(Connection.VideoProvider videoProvider) {
            InvokeDynamicSupport.bootstrap("onVideoProviderChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onVideoProviderChanged(android.telecom.Connection$VideoProvider ), this, videoProvider);
        }

        @Override
        public void onAudioQualityChanged(int n) {
            InvokeDynamicSupport.bootstrap("onAudioQualityChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onAudioQualityChanged(int ), this, n);
        }

        @Override
        public void onConferenceParticipantsChanged(List<ConferenceParticipant> list) {
            InvokeDynamicSupport.bootstrap("onConferenceParticipantsChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onConferenceParticipantsChanged(java.util.List<android.telecom.ConferenceParticipant> ), this, list);
        }

        @Override
        public void onCallSubstateChanged(int n) {
            InvokeDynamicSupport.bootstrap("onCallSubstateChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onCallSubstateChanged(int ), this, n);
        }

        @Override
        public void onMultipartyStateChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onMultipartyStateChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onMultipartyStateChanged(boolean ), this, bl);
        }

        @Override
        public void onConferenceMergedFailed() {
            InvokeDynamicSupport.bootstrap("onConferenceMergedFailed", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onConferenceMergedFailed(), this);
        }

        @Override
        public void onExtrasChanged(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onExtrasChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onExtrasChanged(android.os.Bundle ), this, bundle);
        }

        @Override
        public void onExitedEcmMode() {
            InvokeDynamicSupport.bootstrap("onExitedEcmMode", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onExitedEcmMode(), this);
        }

        @Override
        public void onCallPullFailed(Connection connection) {
            InvokeDynamicSupport.bootstrap("onCallPullFailed", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onCallPullFailed(com.android.internal.telephony.Connection ), this, connection);
        }

        @Override
        public void onHandoverToWifiFailed() {
            InvokeDynamicSupport.bootstrap("onHandoverToWifiFailed", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onHandoverToWifiFailed(), this);
        }

        @Override
        public void onConnectionEvent(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onConnectionEvent", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onConnectionEvent(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListenerBase)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Listener
    extends InstrumentedInterface {
        public void onVideoStateChanged(int var1);

        public void onConnectionCapabilitiesChanged(int var1);

        public void onWifiChanged(boolean var1);

        public void onVideoProviderChanged(Connection.VideoProvider var1);

        public void onAudioQualityChanged(int var1);

        public void onConferenceParticipantsChanged(List<ConferenceParticipant> var1);

        public void onCallSubstateChanged(int var1);

        public void onMultipartyStateChanged(boolean var1);

        public void onConferenceMergedFailed();

        public void onExtrasChanged(Bundle var1);

        public void onExitedEcmMode();

        public void onCallPullFailed(Connection var1);

        public void onHandoverToWifiFailed();

        public void onConnectionEvent(String var1, Bundle var2);
    }

    public static class Capability
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int SUPPORTS_DOWNGRADE_TO_VOICE_LOCAL = 1;
        public static int SUPPORTS_DOWNGRADE_TO_VOICE_REMOTE = 2;
        public static int SUPPORTS_VT_LOCAL_BIDIRECTIONAL = 4;
        public static int SUPPORTS_VT_REMOTE_BIDIRECTIONAL = 8;
        public static int IS_EXTERNAL_CONNECTION = 16;
        public static int IS_PULLABLE = 32;

        private void $$robo$$com_android_internal_telephony_Connection_Capability$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_Connection_Capability$__constructor__();
        }

        public Capability() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Connection_Capability$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Capability)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface PostDialListener
    extends InstrumentedInterface {
        public void onPostDialWait();

        public void onPostDialChar(char var1);
    }
}

