/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentValues;
import android.database.Cursor;
import com.android.internal.util.HexDump;
import java.util.Arrays;
import java.util.Date;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InboundSmsTracker
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private byte[] mPdu;
    private long mTimestamp;
    private int mDestPort;
    private boolean mIs3gpp2;
    private boolean mIs3gpp2WapPdu;
    private String mMessageBody;
    private String mAddress;
    private int mReferenceNumber;
    private int mSequenceNumber;
    private int mMessageCount;
    private String mDeleteWhere;
    private String[] mDeleteWhereArgs;
    private String mDisplayAddress;
    public static int DEST_PORT_FLAG_NO_PORT = 65536;
    private static int DEST_PORT_FLAG_3GPP = 131072;
    public static int DEST_PORT_FLAG_3GPP2 = 262144;
    public static int DEST_PORT_FLAG_3GPP2_WAP_PDU = 524288;
    private static int DEST_PORT_MASK = 65535;
    public static String SELECT_BY_REFERENCE = "address=? AND reference_number=? AND count=? AND (destination_port & 524288=0) AND deleted=0";
    public static String SELECT_BY_REFERENCE_3GPP2WAP = "address=? AND reference_number=? AND count=? AND (destination_port & 524288=524288) AND deleted=0";
    public static String SELECT_BY_DUPLICATE_REFERENCE = "address=? AND reference_number=? AND count=? AND sequence=? AND ((date=? AND message_body=?) OR deleted=0) AND (destination_port & 524288=0)";
    public static String SELECT_BY_DUPLICATE_REFERENCE_3GPP2WAP = "address=? AND reference_number=? AND count=? AND sequence=? AND ((date=? AND message_body=?) OR deleted=0) AND (destination_port & 524288=524288)";

    private void $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byte[] pdu, long timestamp, int destPort, boolean is3gpp2, boolean is3gpp2WapPdu, String address, String displayAddress, String messageBody) {
        this.mPdu = pdu;
        this.mTimestamp = timestamp;
        this.mDestPort = destPort;
        this.mIs3gpp2 = is3gpp2;
        this.mIs3gpp2WapPdu = is3gpp2WapPdu;
        this.mMessageBody = messageBody;
        this.mAddress = address;
        this.mDisplayAddress = displayAddress;
        this.mReferenceNumber = -1;
        this.mSequenceNumber = this.getIndexOffset();
        this.mMessageCount = 1;
    }

    private void $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byte[] pdu, long timestamp, int destPort, boolean is3gpp2, String address, String displayAddress, int referenceNumber, int sequenceNumber, int messageCount, boolean is3gpp2WapPdu, String messageBody) {
        this.mPdu = pdu;
        this.mTimestamp = timestamp;
        this.mDestPort = destPort;
        this.mIs3gpp2 = is3gpp2;
        this.mIs3gpp2WapPdu = is3gpp2WapPdu;
        this.mMessageBody = messageBody;
        this.mDisplayAddress = displayAddress;
        this.mAddress = address;
        this.mReferenceNumber = referenceNumber;
        this.mSequenceNumber = sequenceNumber;
        this.mMessageCount = messageCount;
    }

    private void $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(Cursor cursor, boolean isCurrentFormat3gpp2) {
        this.mPdu = HexDump.hexStringToByteArray(cursor.getString(0));
        if (cursor.isNull(2)) {
            this.mDestPort = -1;
            this.mIs3gpp2 = isCurrentFormat3gpp2;
            this.mIs3gpp2WapPdu = false;
        } else {
            int destPort = cursor.getInt(2);
            this.mIs3gpp2 = (destPort & 0x20000) != 0 ? false : ((destPort & 0x40000) != 0 ? true : isCurrentFormat3gpp2);
            this.mIs3gpp2WapPdu = (destPort & 0x80000) != 0;
            this.mDestPort = InboundSmsTracker.getRealDestPort(destPort);
        }
        this.mTimestamp = cursor.getLong(3);
        this.mAddress = cursor.getString(6);
        this.mDisplayAddress = cursor.getString(9);
        if (cursor.isNull(5)) {
            long rowId = cursor.getLong(7);
            this.mReferenceNumber = -1;
            this.mSequenceNumber = this.getIndexOffset();
            this.mMessageCount = 1;
            this.mDeleteWhere = "_id=?";
            this.mDeleteWhereArgs = new String[]{Long.toString(rowId)};
        } else {
            this.mReferenceNumber = cursor.getInt(4);
            this.mMessageCount = cursor.getInt(5);
            this.mSequenceNumber = cursor.getInt(1);
            int index = this.mSequenceNumber - this.getIndexOffset();
            if (index < 0 || index >= this.mMessageCount) {
                throw new IllegalArgumentException("invalid PDU sequence " + this.mSequenceNumber + " of " + this.mMessageCount);
            }
            this.mDeleteWhere = this.getQueryForSegments();
            this.mDeleteWhereArgs = new String[]{this.mAddress, Integer.toString(this.mReferenceNumber), Integer.toString(this.mMessageCount)};
        }
        this.mMessageBody = cursor.getString(8);
    }

    private final ContentValues $$robo$$com_android_internal_telephony_InboundSmsTracker$getContentValues() {
        ContentValues values = new ContentValues();
        values.put("pdu", HexDump.toHexString(this.mPdu));
        values.put("date", this.mTimestamp);
        int destPort = this.mDestPort == -1 ? 65536 : this.mDestPort & 0xFFFF;
        destPort = this.mIs3gpp2 ? (destPort |= 0x40000) : (destPort |= 0x20000);
        if (this.mIs3gpp2WapPdu) {
            destPort |= 0x80000;
        }
        values.put("destination_port", destPort);
        if (this.mAddress != null) {
            values.put("address", this.mAddress);
            values.put("display_originating_addr", this.mDisplayAddress);
            values.put("reference_number", this.mReferenceNumber);
            values.put("sequence", this.mSequenceNumber);
            values.put("count", this.mMessageCount);
        }
        values.put("message_body", this.mMessageBody);
        return values;
    }

    private static final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getRealDestPort(int destPort) {
        if ((destPort & 0x10000) != 0) {
            return -1;
        }
        return destPort & 0xFFFF;
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsTracker$setDeleteWhere(String deleteWhere, String[] deleteWhereArgs) {
        this.mDeleteWhere = deleteWhere;
        this.mDeleteWhereArgs = deleteWhereArgs;
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$toString() {
        StringBuilder builder = new StringBuilder("SmsTracker{timestamp=");
        builder.append(new Date(this.mTimestamp));
        builder.append(" destPort=").append(this.mDestPort);
        builder.append(" is3gpp2=").append(this.mIs3gpp2);
        if (this.mAddress != null) {
            builder.append(" address=").append(this.mAddress);
            builder.append(" display_originating_addr=").append(this.mDisplayAddress);
            builder.append(" refNumber=").append(this.mReferenceNumber);
            builder.append(" seqNumber=").append(this.mSequenceNumber);
            builder.append(" msgCount=").append(this.mMessageCount);
        }
        if (this.mDeleteWhere != null) {
            builder.append(" deleteWhere(").append(this.mDeleteWhere);
            builder.append(") deleteArgs=(").append(Arrays.toString(this.mDeleteWhereArgs));
            builder.append(')');
        }
        builder.append('}');
        return builder.toString();
    }

    private final byte[] $$robo$$com_android_internal_telephony_InboundSmsTracker$getPdu() {
        return this.mPdu;
    }

    private final long $$robo$$com_android_internal_telephony_InboundSmsTracker$getTimestamp() {
        return this.mTimestamp;
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getDestPort() {
        return this.mDestPort;
    }

    private final boolean $$robo$$com_android_internal_telephony_InboundSmsTracker$is3gpp2() {
        return this.mIs3gpp2;
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$getFormat() {
        return this.mIs3gpp2 ? "3gpp2" : "3gpp";
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$getQueryForSegments() {
        return this.mIs3gpp2WapPdu ? "address=? AND reference_number=? AND count=? AND (destination_port & 524288=524288) AND deleted=0" : "address=? AND reference_number=? AND count=? AND (destination_port & 524288=0) AND deleted=0";
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$getQueryForMultiPartDuplicates() {
        return this.mIs3gpp2WapPdu ? "address=? AND reference_number=? AND count=? AND sequence=? AND ((date=? AND message_body=?) OR deleted=0) AND (destination_port & 524288=524288)" : "address=? AND reference_number=? AND count=? AND sequence=? AND ((date=? AND message_body=?) OR deleted=0) AND (destination_port & 524288=0)";
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getIndexOffset() {
        return this.mIs3gpp2 && this.mIs3gpp2WapPdu ? 0 : 1;
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$getAddress() {
        return this.mAddress;
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$getDisplayAddress() {
        return this.mDisplayAddress;
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$getMessageBody() {
        return this.mMessageBody;
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getReferenceNumber() {
        return this.mReferenceNumber;
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getSequenceNumber() {
        return this.mSequenceNumber;
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getMessageCount() {
        return this.mMessageCount;
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$getDeleteWhere() {
        return this.mDeleteWhere;
    }

    private final String[] $$robo$$com_android_internal_telephony_InboundSmsTracker$getDeleteWhereArgs() {
        return this.mDeleteWhereArgs;
    }

    private void __constructor__(byte[] byArray, long l, int n, boolean bl, boolean bl2, String string2, String string3, String string4) {
        this.$$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byArray, l, n, bl, bl2, string2, string3, string4);
    }

    public InboundSmsTracker(byte[] byArray, long l, int n, boolean bl, boolean bl2, String string2, String string3, String string4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byte[] long int boolean boolean java.lang.String java.lang.String java.lang.String ), this, byArray, l, n, bl, bl2, string2, string3, string4);
    }

    private void __constructor__(byte[] byArray, long l, int n, boolean bl, String string2, String string3, int n2, int n3, int n4, boolean bl2, String string4) {
        this.$$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byArray, l, n, bl, string2, string3, n2, n3, n4, bl2, string4);
    }

    public InboundSmsTracker(byte[] byArray, long l, int n, boolean bl, String string2, String string3, int n2, int n3, int n4, boolean bl2, String string4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byte[] long int boolean java.lang.String java.lang.String int int int boolean java.lang.String ), this, byArray, l, n, bl, string2, string3, n2, n3, n4, bl2, string4);
    }

    private void __constructor__(Cursor cursor, boolean bl) {
        this.$$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(cursor, bl);
    }

    public InboundSmsTracker(Cursor cursor, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(android.database.Cursor boolean ), this, cursor, bl);
    }

    public ContentValues getContentValues() {
        return InvokeDynamicSupport.bootstrap("getContentValues", $$robo$$com_android_internal_telephony_InboundSmsTracker$getContentValues(), this);
    }

    public static int getRealDestPort(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRealDestPort", $$robo$$com_android_internal_telephony_InboundSmsTracker$getRealDestPort(int ), (int)n);
    }

    public void setDeleteWhere(String string2, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setDeleteWhere", $$robo$$com_android_internal_telephony_InboundSmsTracker$setDeleteWhere(java.lang.String java.lang.String[] ), this, string2, stringArray);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_InboundSmsTracker$toString(), this);
    }

    public byte[] getPdu() {
        return InvokeDynamicSupport.bootstrap("getPdu", $$robo$$com_android_internal_telephony_InboundSmsTracker$getPdu(), this);
    }

    public long getTimestamp() {
        return (long)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$com_android_internal_telephony_InboundSmsTracker$getTimestamp(), this);
    }

    public int getDestPort() {
        return (int)InvokeDynamicSupport.bootstrap("getDestPort", $$robo$$com_android_internal_telephony_InboundSmsTracker$getDestPort(), this);
    }

    public boolean is3gpp2() {
        return (boolean)InvokeDynamicSupport.bootstrap("is3gpp2", $$robo$$com_android_internal_telephony_InboundSmsTracker$is3gpp2(), this);
    }

    public String getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$com_android_internal_telephony_InboundSmsTracker$getFormat(), this);
    }

    public String getQueryForSegments() {
        return InvokeDynamicSupport.bootstrap("getQueryForSegments", $$robo$$com_android_internal_telephony_InboundSmsTracker$getQueryForSegments(), this);
    }

    public String getQueryForMultiPartDuplicates() {
        return InvokeDynamicSupport.bootstrap("getQueryForMultiPartDuplicates", $$robo$$com_android_internal_telephony_InboundSmsTracker$getQueryForMultiPartDuplicates(), this);
    }

    public int getIndexOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getIndexOffset", $$robo$$com_android_internal_telephony_InboundSmsTracker$getIndexOffset(), this);
    }

    public String getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$com_android_internal_telephony_InboundSmsTracker$getAddress(), this);
    }

    public String getDisplayAddress() {
        return InvokeDynamicSupport.bootstrap("getDisplayAddress", $$robo$$com_android_internal_telephony_InboundSmsTracker$getDisplayAddress(), this);
    }

    public String getMessageBody() {
        return InvokeDynamicSupport.bootstrap("getMessageBody", $$robo$$com_android_internal_telephony_InboundSmsTracker$getMessageBody(), this);
    }

    public int getReferenceNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getReferenceNumber", $$robo$$com_android_internal_telephony_InboundSmsTracker$getReferenceNumber(), this);
    }

    public int getSequenceNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getSequenceNumber", $$robo$$com_android_internal_telephony_InboundSmsTracker$getSequenceNumber(), this);
    }

    public int getMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getMessageCount", $$robo$$com_android_internal_telephony_InboundSmsTracker$getMessageCount(), this);
    }

    public String getDeleteWhere() {
        return InvokeDynamicSupport.bootstrap("getDeleteWhere", $$robo$$com_android_internal_telephony_InboundSmsTracker$getDeleteWhere(), this);
    }

    public String[] getDeleteWhereArgs() {
        return InvokeDynamicSupport.bootstrap("getDeleteWhereArgs", $$robo$$com_android_internal_telephony_InboundSmsTracker$getDeleteWhereArgs(), this);
    }

    public /* synthetic */ InboundSmsTracker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InboundSmsTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

