/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PhoneSubInfoController
extends IPhoneSubInfo.Stub
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "PhoneSubInfoController";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private Phone[] mPhone;
    private Context mContext;
    private AppOpsManager mAppOps;

    private void $$robo$$com_android_internal_telephony_PhoneSubInfoController$__constructor__(Context context, Phone[] phone) {
        this.mPhone = phone;
        if (ServiceManager.getService("iphonesubinfo") == null) {
            ServiceManager.addService("iphonesubinfo", this);
        }
        this.mContext = context;
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getDeviceId(String callingPackage) {
        return this.getDeviceIdForPhone(SubscriptionManager.getPhoneId(this.getDefaultSubscription()), callingPackage);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getDeviceIdForPhone(int phoneId, String callingPackage) {
        Phone phone;
        if (!this.checkReadPhoneState(callingPackage, "getDeviceId")) {
            return null;
        }
        if (!SubscriptionManager.isValidPhoneId(phoneId)) {
            phoneId = 0;
        }
        if ((phone = this.mPhone[phoneId]) != null) {
            return phone.getDeviceId();
        }
        this.loge("getDeviceIdForPhone phone " + phoneId + " is null");
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getNaiForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getNai")) {
                return null;
            }
            return phone.getNai();
        }
        this.loge("getNai phone is null for Subscription:" + subId);
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getImeiForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getImei")) {
                return null;
            }
            return phone.getImei();
        }
        this.loge("getDeviceId phone is null for Subscription:" + subId);
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getDeviceSvn(String callingPackage) {
        return this.getDeviceSvnUsingSubId(this.getDefaultSubscription(), callingPackage);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getDeviceSvnUsingSubId(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getDeviceSvn")) {
                return null;
            }
            return phone.getDeviceSvn();
        }
        this.loge("getDeviceSvn phone is null");
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getSubscriberId(String callingPackage) {
        return this.getSubscriberIdForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getSubscriberIdForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getSubscriberId")) {
                return null;
            }
            return phone.getSubscriberId();
        }
        this.loge("getSubscriberId phone is null for Subscription:" + subId);
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIccSerialNumber(String callingPackage) {
        return this.getIccSerialNumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIccSerialNumberForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getIccSerialNumber")) {
                return null;
            }
            return phone.getIccSerialNumber();
        }
        this.loge("getIccSerialNumber phone is null for Subscription:" + subId);
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getLine1Number(String callingPackage) {
        return this.getLine1NumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getLine1NumberForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneNumber(callingPackage, "getLine1Number")) {
                return null;
            }
            return phone.getLine1Number();
        }
        this.loge("getLine1Number phone is null for Subscription:" + subId);
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getLine1AlphaTag(String callingPackage) {
        return this.getLine1AlphaTagForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getLine1AlphaTagForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getLine1AlphaTag")) {
                return null;
            }
            return phone.getLine1AlphaTag();
        }
        this.loge("getLine1AlphaTag phone is null for Subscription:" + subId);
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getMsisdn(String callingPackage) {
        return this.getMsisdnForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getMsisdnForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getMsisdn")) {
                return null;
            }
            return phone.getMsisdn();
        }
        this.loge("getMsisdn phone is null for Subscription:" + subId);
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getVoiceMailNumber(String callingPackage) {
        return this.getVoiceMailNumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getVoiceMailNumberForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getVoiceMailNumber")) {
                return null;
            }
            String number = PhoneNumberUtils.extractNetworkPortion(phone.getVoiceMailNumber());
            return number;
        }
        this.loge("getVoiceMailNumber phone is null for Subscription:" + subId);
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getCompleteVoiceMailNumber() {
        return this.getCompleteVoiceMailNumberForSubscriber(this.getDefaultSubscription());
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getCompleteVoiceMailNumberForSubscriber(int subId) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.CALL_PRIVILEGED", "Requires CALL_PRIVILEGED");
            String number = phone.getVoiceMailNumber();
            return number;
        }
        this.loge("getCompleteVoiceMailNumber phone is null for Subscription:" + subId);
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getVoiceMailAlphaTag(String callingPackage) {
        return this.getVoiceMailAlphaTagForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getVoiceMailAlphaTagForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getVoiceMailAlphaTag")) {
                return null;
            }
            return phone.getVoiceMailAlphaTag();
        }
        this.loge("getVoiceMailAlphaTag phone is null for Subscription:" + subId);
        return null;
    }

    private final Phone $$robo$$com_android_internal_telephony_PhoneSubInfoController$getPhone(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (!SubscriptionManager.isValidPhoneId(phoneId)) {
            phoneId = 0;
        }
        return this.mPhone[phoneId];
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSubInfoController$enforcePrivilegedPermissionOrCarrierPrivilege(Phone phone) {
        int permissionResult = this.mContext.checkCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE");
        if (permissionResult == 0) {
            return;
        }
        this.log("No read privileged phone permission, check carrier privilege next.");
        UiccCard uiccCard = phone.getUiccCard();
        if (uiccCard == null) {
            throw new SecurityException("No Carrier Privilege: No UICC");
        }
        if (uiccCard.getCarrierPrivilegeStatusForCurrentTransaction(this.mContext.getPackageManager()) != 1) {
            throw new SecurityException("No Carrier Privilege.");
        }
    }

    private final int $$robo$$com_android_internal_telephony_PhoneSubInfoController$getDefaultSubscription() {
        return PhoneFactory.getDefaultSubscription();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimImpi() {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimImpi();
        }
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimDomain() {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimDomain();
        }
        return null;
    }

    private final String[] $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimImpu() {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimImpu();
        }
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimIst() throws RemoteException {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimIst();
        }
        return null;
    }

    private final String[] $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimPcscf() throws RemoteException {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimPcscf();
        }
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimChallengeResponse(String nonce) throws RemoteException {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimChallengeResponse(nonce);
        }
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIccSimChallengeResponse(int subId, int appType, int authType, String data) throws RemoteException {
        Phone phone = this.getPhone(subId);
        this.enforcePrivilegedPermissionOrCarrierPrivilege(phone);
        UiccCard uiccCard = phone.getUiccCard();
        if (uiccCard == null) {
            this.loge("getIccSimChallengeResponse() UiccCard is null");
            return null;
        }
        UiccCardApplication uiccApp = uiccCard.getApplicationByType(appType);
        if (uiccApp == null) {
            this.loge("getIccSimChallengeResponse() no app with specified type -- " + appType);
            return null;
        }
        this.loge("getIccSimChallengeResponse() found app " + uiccApp.getAid() + " specified type -- " + appType);
        if (authType != 128 && authType != 129) {
            this.loge("getIccSimChallengeResponse() unsupported authType: " + authType);
            return null;
        }
        return uiccApp.getIccRecords().getIccSimChallengeResponse(authType, data);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getGroupIdLevel1(String callingPackage) {
        return this.getGroupIdLevel1ForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneSubInfoController$getGroupIdLevel1ForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getGroupIdLevel1")) {
                return null;
            }
            return phone.getGroupIdLevel1();
        }
        this.loge("getGroupIdLevel1 phone is null for Subscription:" + subId);
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneSubInfoController$checkReadPhoneState(String callingPackage, String message) {
        try {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", message);
            return true;
        }
        catch (SecurityException e) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", message);
            return this.mAppOps.noteOp(51, Binder.getCallingUid(), callingPackage) == 0;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneSubInfoController$checkReadPhoneNumber(String callingPackage, String message) {
        if (this.mAppOps.noteOp(15, Binder.getCallingUid(), callingPackage) == 0) {
            return true;
        }
        try {
            return this.checkReadPhoneState(callingPackage, message);
        }
        catch (SecurityException securityException) {
            try {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SMS", message);
                int opCode = AppOpsManager.permissionToOpCode("android.permission.READ_SMS");
                if (opCode != -1) {
                    return this.mAppOps.noteOp(opCode, Binder.getCallingUid(), callingPackage) == 0;
                }
                return true;
            }
            catch (SecurityException opCode) {
                try {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_NUMBERS", message);
                    int opCode2 = AppOpsManager.permissionToOpCode("android.permission.READ_PHONE_NUMBERS");
                    if (opCode2 != -1) {
                        return this.mAppOps.noteOp(opCode2, Binder.getCallingUid(), callingPackage) == 0;
                    }
                    return true;
                }
                catch (SecurityException securityException2) {
                    throw new SecurityException(message + ": Neither user " + Binder.getCallingUid() + " nor current process has " + "android.permission.READ_PHONE_STATE" + ", " + "android.permission.READ_SMS" + ", or " + "android.permission.READ_PHONE_STATE" + ".");
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSubInfoController$log(String s) {
        Rlog.d("PhoneSubInfoController", s);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSubInfoController$loge(String s) {
        Rlog.e("PhoneSubInfoController", s);
    }

    private void __constructor__(Context context, Phone[] phoneArray) {
        this.$$robo$$com_android_internal_telephony_PhoneSubInfoController$__constructor__(context, phoneArray);
    }

    public PhoneSubInfoController(Context context, Phone[] phoneArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneSubInfoController$__constructor__(android.content.Context com.android.internal.telephony.Phone[] ), this, context, phoneArray);
    }

    @Override
    public String getDeviceId(String string2) {
        return InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getDeviceId(java.lang.String ), this, string2);
    }

    @Override
    public String getDeviceIdForPhone(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getDeviceIdForPhone", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getDeviceIdForPhone(int java.lang.String ), this, n, string2);
    }

    @Override
    public String getNaiForSubscriber(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getNaiForSubscriber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getNaiForSubscriber(int java.lang.String ), this, n, string2);
    }

    @Override
    public String getImeiForSubscriber(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getImeiForSubscriber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getImeiForSubscriber(int java.lang.String ), this, n, string2);
    }

    @Override
    public String getDeviceSvn(String string2) {
        return InvokeDynamicSupport.bootstrap("getDeviceSvn", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getDeviceSvn(java.lang.String ), this, string2);
    }

    @Override
    public String getDeviceSvnUsingSubId(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getDeviceSvnUsingSubId", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getDeviceSvnUsingSubId(int java.lang.String ), this, n, string2);
    }

    @Override
    public String getSubscriberId(String string2) {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getSubscriberId(java.lang.String ), this, string2);
    }

    @Override
    public String getSubscriberIdForSubscriber(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getSubscriberIdForSubscriber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getSubscriberIdForSubscriber(int java.lang.String ), this, n, string2);
    }

    @Override
    public String getIccSerialNumber(String string2) {
        return InvokeDynamicSupport.bootstrap("getIccSerialNumber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIccSerialNumber(java.lang.String ), this, string2);
    }

    @Override
    public String getIccSerialNumberForSubscriber(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getIccSerialNumberForSubscriber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIccSerialNumberForSubscriber(int java.lang.String ), this, n, string2);
    }

    @Override
    public String getLine1Number(String string2) {
        return InvokeDynamicSupport.bootstrap("getLine1Number", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getLine1Number(java.lang.String ), this, string2);
    }

    @Override
    public String getLine1NumberForSubscriber(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getLine1NumberForSubscriber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getLine1NumberForSubscriber(int java.lang.String ), this, n, string2);
    }

    @Override
    public String getLine1AlphaTag(String string2) {
        return InvokeDynamicSupport.bootstrap("getLine1AlphaTag", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getLine1AlphaTag(java.lang.String ), this, string2);
    }

    @Override
    public String getLine1AlphaTagForSubscriber(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getLine1AlphaTagForSubscriber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getLine1AlphaTagForSubscriber(int java.lang.String ), this, n, string2);
    }

    @Override
    public String getMsisdn(String string2) {
        return InvokeDynamicSupport.bootstrap("getMsisdn", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getMsisdn(java.lang.String ), this, string2);
    }

    @Override
    public String getMsisdnForSubscriber(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getMsisdnForSubscriber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getMsisdnForSubscriber(int java.lang.String ), this, n, string2);
    }

    @Override
    public String getVoiceMailNumber(String string2) {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getVoiceMailNumber(java.lang.String ), this, string2);
    }

    @Override
    public String getVoiceMailNumberForSubscriber(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumberForSubscriber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getVoiceMailNumberForSubscriber(int java.lang.String ), this, n, string2);
    }

    @Override
    public String getCompleteVoiceMailNumber() {
        return InvokeDynamicSupport.bootstrap("getCompleteVoiceMailNumber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getCompleteVoiceMailNumber(), this);
    }

    @Override
    public String getCompleteVoiceMailNumberForSubscriber(int n) {
        return InvokeDynamicSupport.bootstrap("getCompleteVoiceMailNumberForSubscriber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getCompleteVoiceMailNumberForSubscriber(int ), this, n);
    }

    @Override
    public String getVoiceMailAlphaTag(String string2) {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTag", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getVoiceMailAlphaTag(java.lang.String ), this, string2);
    }

    @Override
    public String getVoiceMailAlphaTagForSubscriber(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTagForSubscriber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getVoiceMailAlphaTagForSubscriber(int java.lang.String ), this, n, string2);
    }

    private Phone getPhone(int n) {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getPhone(int ), this, n);
    }

    private void enforcePrivilegedPermissionOrCarrierPrivilege(Phone phone) {
        InvokeDynamicSupport.bootstrap("enforcePrivilegedPermissionOrCarrierPrivilege", $$robo$$com_android_internal_telephony_PhoneSubInfoController$enforcePrivilegedPermissionOrCarrierPrivilege(com.android.internal.telephony.Phone ), this, phone);
    }

    private int getDefaultSubscription() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultSubscription", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getDefaultSubscription(), this);
    }

    @Override
    public String getIsimImpi() {
        return InvokeDynamicSupport.bootstrap("getIsimImpi", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimImpi(), this);
    }

    @Override
    public String getIsimDomain() {
        return InvokeDynamicSupport.bootstrap("getIsimDomain", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimDomain(), this);
    }

    @Override
    public String[] getIsimImpu() {
        return InvokeDynamicSupport.bootstrap("getIsimImpu", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimImpu(), this);
    }

    @Override
    public String getIsimIst() throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getIsimIst", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimIst(), this);
    }

    @Override
    public String[] getIsimPcscf() throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getIsimPcscf", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimPcscf(), this);
    }

    @Override
    public String getIsimChallengeResponse(String string2) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getIsimChallengeResponse", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIsimChallengeResponse(java.lang.String ), this, string2);
    }

    @Override
    public String getIccSimChallengeResponse(int n, int n2, int n3, String string2) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getIccSimChallengeResponse", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getIccSimChallengeResponse(int int int java.lang.String ), this, n, n2, n3, string2);
    }

    @Override
    public String getGroupIdLevel1(String string2) {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel1", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getGroupIdLevel1(java.lang.String ), this, string2);
    }

    @Override
    public String getGroupIdLevel1ForSubscriber(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel1ForSubscriber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$getGroupIdLevel1ForSubscriber(int java.lang.String ), this, n, string2);
    }

    private boolean checkReadPhoneState(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkReadPhoneState", $$robo$$com_android_internal_telephony_PhoneSubInfoController$checkReadPhoneState(java.lang.String java.lang.String ), this, string2, string3);
    }

    private boolean checkReadPhoneNumber(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkReadPhoneNumber", $$robo$$com_android_internal_telephony_PhoneSubInfoController$checkReadPhoneNumber(java.lang.String java.lang.String ), this, string2, string3);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_PhoneSubInfoController$log(java.lang.String ), this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_PhoneSubInfoController$loge(java.lang.String ), this, string2);
    }

    public /* synthetic */ PhoneSubInfoController() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneSubInfoController)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

