/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PersistableBundle;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.telephony.Phone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RatRatcheter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "RilRatcheter";
    private SparseArray<SparseIntArray> mRatFamilyMap;
    private Phone mPhone;
    private BroadcastReceiver mConfigChangedReceiver;

    private void $$robo$$com_android_internal_telephony_RatRatcheter$__constructor__(Phone phone) {
        this.mRatFamilyMap = new SparseArray();
        this.mConfigChangedReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RatRatcheter this$0;

            private void $$robo$$com_android_internal_telephony_RatRatcheter_1$__constructor__(RatRatcheter this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_RatRatcheter_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.telephony.action.CARRIER_CONFIG_CHANGED".equals(action)) {
                    this.this$0.resetRatFamilyMap();
                }
            }

            private void __constructor__(RatRatcheter ratRatcheter) {
                this.$$robo$$com_android_internal_telephony_RatRatcheter_1$__constructor__(ratRatcheter);
            }
            {
                this.this$0 = ratRatcheter;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RatRatcheter_1$__constructor__(com.android.internal.telephony.RatRatcheter ), this, ratRatcheter);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_RatRatcheter_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        phone.getContext().registerReceiverAsUser(this.mConfigChangedReceiver, UserHandle.ALL, intentFilter, null, null);
        this.resetRatFamilyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_RatRatcheter$ratchetRat(int oldRat, int newRat) {
        SparseArray<SparseIntArray> sparseArray = this.mRatFamilyMap;
        synchronized (sparseArray) {
            int newRatRank;
            SparseIntArray oldFamily = this.mRatFamilyMap.get(oldRat);
            if (oldFamily == null) {
                return newRat;
            }
            SparseIntArray newFamily = this.mRatFamilyMap.get(newRat);
            if (newFamily != oldFamily) {
                return newRat;
            }
            int oldRatRank = newFamily.get(oldRat, -1);
            int n = oldRatRank > (newRatRank = newFamily.get(newRat, -1)) ? oldRat : newRat;
            return n;
        }
    }

    private final void $$robo$$com_android_internal_telephony_RatRatcheter$ratchetRat(ServiceState oldSS, ServiceState newSS) {
        int newVoiceRat = this.ratchetRat(oldSS.getRilVoiceRadioTechnology(), newSS.getRilVoiceRadioTechnology());
        int newDataRat = this.ratchetRat(oldSS.getRilDataRadioTechnology(), newSS.getRilDataRadioTechnology());
        boolean newUsingCA = oldSS.isUsingCarrierAggregation() || newSS.isUsingCarrierAggregation();
        newSS.setRilVoiceRadioTechnology(newVoiceRat);
        newSS.setRilDataRadioTechnology(newDataRat);
        newSS.setIsUsingCarrierAggregation(newUsingCA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RatRatcheter$resetRatFamilyMap() {
        SparseArray<SparseIntArray> sparseArray = this.mRatFamilyMap;
        synchronized (sparseArray) {
            this.mRatFamilyMap.clear();
            CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            if (configManager == null) {
                return;
            }
            PersistableBundle b = configManager.getConfig();
            if (b == null) {
                return;
            }
            String[] ratFamilies = b.getStringArray("ratchet_rat_families");
            if (ratFamilies == null) {
                return;
            }
            block5: for (String ratFamily : ratFamilies) {
                String[] rats = ratFamily.split(",");
                if (rats.length < 2) continue;
                SparseIntArray currentFamily = new SparseIntArray(rats.length);
                int pos = 0;
                for (String ratString : rats) {
                    int ratInt;
                    try {
                        ratInt = Integer.parseInt(ratString.trim());
                    }
                    catch (NumberFormatException e) {
                        Rlog.e("RilRatcheter", "NumberFormatException on " + ratString);
                        continue block5;
                    }
                    if (this.mRatFamilyMap.get(ratInt) != null) {
                        Rlog.e("RilRatcheter", "RAT listed twice: " + ratString);
                        continue block5;
                    }
                    currentFamily.put(ratInt, pos++);
                    this.mRatFamilyMap.put(ratInt, currentFamily);
                }
            }
        }
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_RatRatcheter$__constructor__(phone);
    }

    public RatRatcheter(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RatRatcheter$__constructor__(com.android.internal.telephony.Phone ), this, phone);
    }

    public int ratchetRat(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("ratchetRat", $$robo$$com_android_internal_telephony_RatRatcheter$ratchetRat(int int ), this, n, n2);
    }

    public void ratchetRat(ServiceState serviceState, ServiceState serviceState2) {
        InvokeDynamicSupport.bootstrap("ratchetRat", $$robo$$com_android_internal_telephony_RatRatcheter$ratchetRat(android.telephony.ServiceState android.telephony.ServiceState ), this, serviceState, serviceState2);
    }

    private void resetRatFamilyMap() {
        InvokeDynamicSupport.bootstrap("resetRatFamilyMap", $$robo$$com_android_internal_telephony_RatRatcheter$resetRatFamilyMap(), this);
    }

    public /* synthetic */ RatRatcheter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RatRatcheter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

