/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.TargetApi;
import android.os.Build;
import android.telephony.Rlog;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@TargetApi(value=8)
public class RilWakelockInfo
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private String LOG_TAG;
    private int mRilRequestSent;
    private int mTokenNumber;
    private long mRequestTime;
    private long mResponseTime;
    private long mWakelockTimeAttributedSoFar;
    private long mLastAggregatedTime;
    private int mConcurrentRequests;

    private final int $$robo$$com_android_internal_telephony_RilWakelockInfo$getConcurrentRequests() {
        return this.mConcurrentRequests;
    }

    private void $$robo$$com_android_internal_telephony_RilWakelockInfo$__constructor__(int rilRequest, int tokenNumber, int concurrentRequests, long requestTime) {
        this.LOG_TAG = RilWakelockInfo.class.getSimpleName();
        concurrentRequests = this.validateConcurrentRequests(concurrentRequests);
        this.mRilRequestSent = rilRequest;
        this.mTokenNumber = tokenNumber;
        this.mConcurrentRequests = concurrentRequests;
        this.mRequestTime = requestTime;
        this.mWakelockTimeAttributedSoFar = 0L;
        this.mLastAggregatedTime = requestTime;
    }

    private final int $$robo$$com_android_internal_telephony_RilWakelockInfo$validateConcurrentRequests(int concurrentRequests) {
        if (concurrentRequests <= 0) {
            if (Build.IS_DEBUGGABLE) {
                IllegalArgumentException e = new IllegalArgumentException("concurrentRequests should always be greater than 0.");
                Rlog.e(this.LOG_TAG, e.toString());
                throw e;
            }
            concurrentRequests = 1;
        }
        return concurrentRequests;
    }

    private final int $$robo$$com_android_internal_telephony_RilWakelockInfo$getTokenNumber() {
        return this.mTokenNumber;
    }

    private final int $$robo$$com_android_internal_telephony_RilWakelockInfo$getRilRequestSent() {
        return this.mRilRequestSent;
    }

    private final void $$robo$$com_android_internal_telephony_RilWakelockInfo$setResponseTime(long responseTime) {
        this.updateTime(responseTime);
        this.mResponseTime = responseTime;
    }

    private final void $$robo$$com_android_internal_telephony_RilWakelockInfo$updateConcurrentRequests(int concurrentRequests, long time) {
        concurrentRequests = this.validateConcurrentRequests(concurrentRequests);
        this.updateTime(time);
        this.mConcurrentRequests = concurrentRequests;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_RilWakelockInfo$updateTime(long time) {
        this.mWakelockTimeAttributedSoFar += (time - this.mLastAggregatedTime) / (long)this.mConcurrentRequests;
        this.mLastAggregatedTime = time;
    }

    private final long $$robo$$com_android_internal_telephony_RilWakelockInfo$getWakelockTimeAttributedToClient() {
        return this.mWakelockTimeAttributedSoFar;
    }

    private final String $$robo$$com_android_internal_telephony_RilWakelockInfo$toString() {
        return "WakelockInfo{rilRequestSent=" + this.mRilRequestSent + ", tokenNumber=" + this.mTokenNumber + ", requestTime=" + this.mRequestTime + ", responseTime=" + this.mResponseTime + ", mWakelockTimeAttributed=" + this.mWakelockTimeAttributedSoFar + '}';
    }

    public int getConcurrentRequests() {
        return (int)InvokeDynamicSupport.bootstrap("getConcurrentRequests", $$robo$$com_android_internal_telephony_RilWakelockInfo$getConcurrentRequests(), this);
    }

    private void __constructor__(int n, int n2, int n3, long l) {
        this.$$robo$$com_android_internal_telephony_RilWakelockInfo$__constructor__(n, n2, n3, l);
    }

    public RilWakelockInfo(int n, int n2, int n3, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RilWakelockInfo$__constructor__(int int int long ), this, n, n2, n3, l);
    }

    private int validateConcurrentRequests(int n) {
        return (int)InvokeDynamicSupport.bootstrap("validateConcurrentRequests", $$robo$$com_android_internal_telephony_RilWakelockInfo$validateConcurrentRequests(int ), this, n);
    }

    int getTokenNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getTokenNumber", $$robo$$com_android_internal_telephony_RilWakelockInfo$getTokenNumber(), this);
    }

    int getRilRequestSent() {
        return (int)InvokeDynamicSupport.bootstrap("getRilRequestSent", $$robo$$com_android_internal_telephony_RilWakelockInfo$getRilRequestSent(), this);
    }

    void setResponseTime(long l) {
        InvokeDynamicSupport.bootstrap("setResponseTime", $$robo$$com_android_internal_telephony_RilWakelockInfo$setResponseTime(long ), this, l);
    }

    void updateConcurrentRequests(int n, long l) {
        InvokeDynamicSupport.bootstrap("updateConcurrentRequests", $$robo$$com_android_internal_telephony_RilWakelockInfo$updateConcurrentRequests(int long ), this, n, l);
    }

    synchronized void updateTime(long l) {
        InvokeDynamicSupport.bootstrap("updateTime", $$robo$$com_android_internal_telephony_RilWakelockInfo$updateTime(long ), this, l);
    }

    long getWakelockTimeAttributedToClient() {
        return (long)InvokeDynamicSupport.bootstrap("getWakelockTimeAttributedToClient", $$robo$$com_android_internal_telephony_RilWakelockInfo$getWakelockTimeAttributedToClient(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_RilWakelockInfo$toString(), this);
    }

    public /* synthetic */ RilWakelockInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RilWakelockInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

