/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Binder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.RadioAccessFamily;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;
import com.android.internal.telephony.CallManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.ProxyController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SubscriptionController
extends ISub.Stub
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "SubscriptionController";
    static boolean DBG = true;
    static boolean VDBG = false;
    static int MAX_LOCAL_LOG_LINES = 500;
    private ScLocalLog mLocalLog;
    protected Object mLock;
    private static SubscriptionController sInstance;
    protected static Phone[] sPhones;
    protected Context mContext;
    protected TelephonyManager mTelephonyManager;
    protected CallManager mCM;
    private AppOpsManager mAppOps;
    private static Map<Integer, Integer> sSlotIndexToSubId;
    private static int mDefaultFallbackSubId;
    private static int mDefaultPhoneId;
    private int[] colorArr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SubscriptionController $$robo$$com_android_internal_telephony_SubscriptionController$init(Phone phone) {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                sInstance = new SubscriptionController(phone);
            } else {
                Log.wtf("SubscriptionController", "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SubscriptionController $$robo$$com_android_internal_telephony_SubscriptionController$init(Context c, CommandsInterface[] ci) {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                sInstance = new SubscriptionController(c);
            } else {
                Log.wtf("SubscriptionController", "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    private static final SubscriptionController $$robo$$com_android_internal_telephony_SubscriptionController$getInstance() {
        if (sInstance == null) {
            Log.wtf("SubscriptionController", "getInstance null");
        }
        return sInstance;
    }

    private void $$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(Context c) {
        this.mLocalLog = new ScLocalLog(500);
        this.mLock = new Object();
        this.init(c);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$init(Context c) {
        this.mContext = c;
        this.mCM = CallManager.getInstance();
        this.mTelephonyManager = TelephonyManager.from(this.mContext);
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        if (ServiceManager.getService("isub") == null) {
            ServiceManager.addService("isub", this);
        }
        this.logdl("[SubscriptionController] init by Context");
    }

    private final boolean $$robo$$com_android_internal_telephony_SubscriptionController$isSubInfoReady() {
        return sSlotIndexToSubId.size() > 0;
    }

    private void $$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(Phone phone) {
        this.mLocalLog = new ScLocalLog(500);
        this.mLock = new Object();
        this.mContext = phone.getContext();
        this.mCM = CallManager.getInstance();
        this.mAppOps = this.mContext.getSystemService(AppOpsManager.class);
        if (ServiceManager.getService("isub") == null) {
            ServiceManager.addService("isub", this);
        }
        this.logdl("[SubscriptionController] init by Phone");
    }

    private final boolean $$robo$$com_android_internal_telephony_SubscriptionController$canReadPhoneState(String callingPackage, String message) {
        try {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", message);
            return true;
        }
        catch (SecurityException e) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", message);
            return this.mAppOps.noteOp(51, Binder.getCallingUid(), callingPackage) == 0;
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$enforceModifyPhoneState(String message) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", message);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$broadcastSimInfoContentChanged() {
        Intent intent = new Intent("android.intent.action.ACTION_SUBINFO_CONTENT_CHANGE");
        this.mContext.sendBroadcast(intent);
        intent = new Intent("android.intent.action.ACTION_SUBINFO_RECORD_UPDATED");
        this.mContext.sendBroadcast(intent);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$notifySubscriptionInfoChanged() {
        ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        try {
            this.logd("notifySubscriptionInfoChanged:");
            tr.notifySubscriptionInfoChanged();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.broadcastSimInfoContentChanged();
    }

    private final SubscriptionInfo $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoRecord(Cursor cursor) {
        int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
        String iccId = cursor.getString(cursor.getColumnIndexOrThrow("icc_id"));
        int simSlotIndex = cursor.getInt(cursor.getColumnIndexOrThrow("sim_id"));
        String displayName = cursor.getString(cursor.getColumnIndexOrThrow("display_name"));
        String carrierName = cursor.getString(cursor.getColumnIndexOrThrow("carrier_name"));
        int nameSource = cursor.getInt(cursor.getColumnIndexOrThrow("name_source"));
        int iconTint = cursor.getInt(cursor.getColumnIndexOrThrow("color"));
        String number = cursor.getString(cursor.getColumnIndexOrThrow("number"));
        int dataRoaming = cursor.getInt(cursor.getColumnIndexOrThrow("data_roaming"));
        Bitmap iconBitmap = BitmapFactory.decodeResource(this.mContext.getResources(), 17302608);
        int mcc = cursor.getInt(cursor.getColumnIndexOrThrow("mcc"));
        int mnc = cursor.getInt(cursor.getColumnIndexOrThrow("mnc"));
        String countryIso = this.getSubscriptionCountryIso(id2);
        String line1Number = this.mTelephonyManager.getLine1Number(id2);
        if (!TextUtils.isEmpty(line1Number) && !line1Number.equals(number)) {
            number = line1Number;
        }
        return new SubscriptionInfo(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, dataRoaming, iconBitmap, mcc, mnc, countryIso);
    }

    private final String $$robo$$com_android_internal_telephony_SubscriptionController$getSubscriptionCountryIso(int subId) {
        int phoneId = this.getPhoneId(subId);
        if (phoneId < 0) {
            return "";
        }
        return this.mTelephonyManager.getSimCountryIsoForPhone(phoneId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<SubscriptionInfo> $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfo(String selection, Object queryKey) {
        String[] selectionArgs = null;
        if (queryKey != null) {
            selectionArgs = new String[]{queryKey.toString()};
        }
        ArrayList<SubscriptionInfo> subList = null;
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, selection, selectionArgs, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    SubscriptionInfo subInfo = this.getSubInfoRecord(cursor);
                    if (subInfo == null) continue;
                    if (subList == null) {
                        subList = new ArrayList<SubscriptionInfo>();
                    }
                    subList.add(subInfo);
                }
            } else {
                this.logd("Query fail");
            }
        }
        return subList;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getUnusedColor(String callingPackage) {
        List<SubscriptionInfo> availableSubInfos = this.getActiveSubscriptionInfoList(callingPackage);
        this.colorArr = this.mContext.getResources().getIntArray(17236060);
        int colorIdx = 0;
        if (availableSubInfos != null) {
            for (int i = 0; i < this.colorArr.length; ++i) {
                int j;
                for (j = 0; j < availableSubInfos.size() && this.colorArr[i] != availableSubInfos.get(j).getIconTint(); ++j) {
                }
                if (j != availableSubInfos.size()) continue;
                return this.colorArr[i];
            }
            colorIdx = availableSubInfos.size() % this.colorArr.length;
        }
        return this.colorArr[colorIdx];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SubscriptionInfo $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubscriptionInfo(int subId, String callingPackage) {
        if (!this.canReadPhoneState(callingPackage, "getActiveSubscriptionInfo")) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> subList = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (subList != null) {
                for (SubscriptionInfo si : subList) {
                    if (si.getSubscriptionId() != subId) continue;
                    this.logd("[getActiveSubscriptionInfo]+ subId=" + subId + " subInfo=" + si);
                    SubscriptionInfo subscriptionInfo = si;
                    return subscriptionInfo;
                }
            }
            this.logd("[getActiveSubInfoForSubscriber]- subId=" + subId + " subList=" + subList + " subInfo=null");
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SubscriptionInfo $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubscriptionInfoForIccId(String iccId, String callingPackage) {
        if (!this.canReadPhoneState(callingPackage, "getActiveSubscriptionInfoForIccId") || iccId == null) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> subList = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (subList != null) {
                for (SubscriptionInfo si : subList) {
                    if (!iccId.equals(si.getIccId())) continue;
                    this.logd("[getActiveSubInfoUsingIccId]+ iccId=" + iccId + " subInfo=" + si);
                    SubscriptionInfo subscriptionInfo = si;
                    return subscriptionInfo;
                }
            }
            this.logd("[getActiveSubInfoUsingIccId]+ iccId=" + iccId + " subList=" + subList + " subInfo=null");
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SubscriptionInfo $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubscriptionInfoForSimSlotIndex(int slotIndex, String callingPackage) {
        block7: {
            if (!this.canReadPhoneState(callingPackage, "getActiveSubscriptionInfoForSimSlotIndex")) {
                return null;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                List<SubscriptionInfo> subList = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
                if (subList != null) {
                    for (SubscriptionInfo si : subList) {
                        if (si.getSimSlotIndex() != slotIndex) continue;
                        this.logd("[getActiveSubscriptionInfoForSimSlotIndex]+ slotIndex=" + slotIndex + " subId=" + si);
                        SubscriptionInfo subscriptionInfo = si;
                        return subscriptionInfo;
                    }
                    this.logd("[getActiveSubscriptionInfoForSimSlotIndex]+ slotIndex=" + slotIndex + " subId=null");
                    break block7;
                }
                this.logd("[getActiveSubscriptionInfoForSimSlotIndex]+ subList=null");
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<SubscriptionInfo> $$robo$$com_android_internal_telephony_SubscriptionController$getAllSubInfoList(String callingPackage) {
        this.logd("[getAllSubInfoList]+");
        if (!this.canReadPhoneState(callingPackage, "getAllSubInfoList")) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> subList = null;
            subList = this.getSubInfo(null, null);
            if (subList != null) {
                this.logd("[getAllSubInfoList]- " + subList.size() + " infos return");
            } else {
                this.logd("[getAllSubInfoList]- no info return");
            }
            List<SubscriptionInfo> list = subList;
            return list;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<SubscriptionInfo> $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubscriptionInfoList(String callingPackage) {
        if (!this.canReadPhoneState(callingPackage, "getActiveSubscriptionInfoList")) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            if (!this.isSubInfoReady()) {
                this.logdl("[getActiveSubInfoList] Sub Controller not ready");
                List<SubscriptionInfo> list = null;
                return list;
            }
            List<SubscriptionInfo> subList = this.getSubInfo("sim_id>=0", null);
            if (subList != null) {
                Collections.sort(subList, new Comparator<SubscriptionInfo>(this){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ SubscriptionController this$0;

                    private void $$robo$$com_android_internal_telephony_SubscriptionController_1$__constructor__(SubscriptionController this$0) {
                    }

                    private final int $$robo$$com_android_internal_telephony_SubscriptionController_1$compare(SubscriptionInfo arg0, SubscriptionInfo arg1) {
                        int flag = arg0.getSimSlotIndex() - arg1.getSimSlotIndex();
                        if (flag == 0) {
                            return arg0.getSubscriptionId() - arg1.getSubscriptionId();
                        }
                        return flag;
                    }

                    private void __constructor__(SubscriptionController subscriptionController) {
                        this.$$robo$$com_android_internal_telephony_SubscriptionController_1$__constructor__(subscriptionController);
                    }
                    {
                        this.this$0 = subscriptionController;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionController_1$__constructor__(com.android.internal.telephony.SubscriptionController ), this, subscriptionController);
                    }

                    @Override
                    public int compare(SubscriptionInfo subscriptionInfo, SubscriptionInfo subscriptionInfo2) {
                        return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_telephony_SubscriptionController_1$compare(android.telephony.SubscriptionInfo android.telephony.SubscriptionInfo ), this, subscriptionInfo, subscriptionInfo2);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else {
                this.logdl("[getActiveSubInfoList]- no info return");
            }
            List<SubscriptionInfo> list = subList;
            return list;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubInfoCount(String callingPackage) {
        this.logd("[getActiveSubInfoCount]+");
        if (!this.canReadPhoneState(callingPackage, "getActiveSubInfoCount")) {
            return 0;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> records = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (records == null) {
                this.logd("[getActiveSubInfoCount] records null");
                int n = 0;
                return n;
            }
            this.logd("[getActiveSubInfoCount]- count: " + records.size());
            int n = records.size();
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getAllSubInfoCount(String callingPackage) {
        this.logd("[getAllSubInfoCount]+");
        if (!this.canReadPhoneState(callingPackage, "getAllSubInfoCount")) {
            return 0;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, null, null, null);){
                if (cursor != null) {
                    int count = cursor.getCount();
                    this.logd("[getAllSubInfoCount]- " + count + " SUB(s) in DB");
                    int n = count;
                    return n;
                }
            }
            this.logd("[getAllSubInfoCount]- no SUB in DB");
            int n = 0;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubInfoCountMax() {
        return this.mTelephonyManager.getSimCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$addSubInfoRecord(String iccId, int slotIndex) {
        this.logdl("[addSubInfoRecord]+ iccId:" + SubscriptionInfo.givePrintableIccid(iccId) + " slotIndex:" + slotIndex);
        this.enforceModifyPhoneState("addSubInfoRecord");
        long identity = Binder.clearCallingIdentity();
        try {
            if (iccId == null) {
                this.logdl("[addSubInfoRecord]- null iccId");
                int n = -1;
                return n;
            }
            ContentResolver resolver = this.mContext.getContentResolver();
            Cursor cursor = resolver.query(SubscriptionManager.CONTENT_URI, new String[]{"_id", "sim_id", "name_source"}, "icc_id=?", new String[]{iccId}, null);
            int color2 = this.getUnusedColor(this.mContext.getOpPackageName());
            boolean setDisplayName = false;
            try {
                if (cursor == null || !cursor.moveToFirst()) {
                    setDisplayName = true;
                    ContentValues value = new ContentValues();
                    value.put("icc_id", iccId);
                    value.put("color", color2);
                    value.put("sim_id", slotIndex);
                    value.put("carrier_name", "");
                    Uri uri = resolver.insert(SubscriptionManager.CONTENT_URI, value);
                    this.logdl("[addSubInfoRecord] New record created: " + uri);
                } else {
                    int subId = cursor.getInt(0);
                    int oldSimInfoId = cursor.getInt(1);
                    int nameSource = cursor.getInt(2);
                    ContentValues value = new ContentValues();
                    if (slotIndex != oldSimInfoId) {
                        value.put("sim_id", slotIndex);
                    }
                    if (nameSource != 2) {
                        setDisplayName = true;
                    }
                    if (value.size() > 0) {
                        resolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
                    }
                    this.logdl("[addSubInfoRecord] Record already exists");
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = resolver.query(SubscriptionManager.CONTENT_URI, null, "sim_id=?", new String[]{String.valueOf(slotIndex)}, null);
            try {
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        int subId = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
                        Integer currentSubId = sSlotIndexToSubId.get(slotIndex);
                        if (currentSubId == null || !SubscriptionManager.isValidSubscriptionId(currentSubId)) {
                            sSlotIndexToSubId.put(slotIndex, subId);
                            int subIdCountMax = this.getActiveSubInfoCountMax();
                            int defaultSubId = this.getDefaultSubId();
                            this.logdl("[addSubInfoRecord] sSlotIndexToSubId.size=" + sSlotIndexToSubId.size() + " slotIndex=" + slotIndex + " subId=" + subId + " defaultSubId=" + defaultSubId + " simCount=" + subIdCountMax);
                            if (!SubscriptionManager.isValidSubscriptionId(defaultSubId) || subIdCountMax == 1) {
                                this.setDefaultFallbackSubId(subId);
                            }
                            if (subIdCountMax == 1) {
                                this.logdl("[addSubInfoRecord] one sim set defaults to subId=" + subId);
                                this.setDefaultDataSubId(subId);
                                this.setDefaultSmsSubId(subId);
                                this.setDefaultVoiceSubId(subId);
                            }
                        } else {
                            this.logdl("[addSubInfoRecord] currentSubId != null && currentSubId is valid, IGNORE");
                        }
                        this.logdl("[addSubInfoRecord] hashmap(" + slotIndex + "," + subId + ")");
                    } while (cursor.moveToNext());
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            int subId = this.getSubIdUsingPhoneId(slotIndex);
            if (!SubscriptionManager.isValidSubscriptionId(subId)) {
                this.logdl("[addSubInfoRecord]- getSubId failed invalid subId = " + subId);
                int currentSubId = -1;
                return currentSubId;
            }
            if (setDisplayName) {
                String simCarrierName = this.mTelephonyManager.getSimOperatorName(subId);
                String nameToSet = !TextUtils.isEmpty(simCarrierName) ? simCarrierName : "CARD " + Integer.toString(slotIndex + 1);
                ContentValues value = new ContentValues();
                value.put("display_name", nameToSet);
                resolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
                this.logdl("[addSubInfoRecord] sim name = " + nameToSet);
            }
            sPhones[slotIndex].updateDataConnectionTracker();
            this.logdl("[addSubInfoRecord]- info size=" + sSlotIndexToSubId.size());
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_SubscriptionController$setPlmnSpn(int slotIndex, boolean showPlmn, String plmn, boolean showSpn, String spn) {
        Object object = this.mLock;
        synchronized (object) {
            int subId = this.getSubIdUsingPhoneId(slotIndex);
            if (this.mContext.getPackageManager().resolveContentProvider(SubscriptionManager.CONTENT_URI.getAuthority(), 0) == null || !SubscriptionManager.isValidSubscriptionId(subId)) {
                this.logd("[setPlmnSpn] No valid subscription to store info");
                this.notifySubscriptionInfoChanged();
                return false;
            }
            String carrierText = "";
            if (showPlmn) {
                carrierText = plmn;
                if (showSpn && !Objects.equals(spn, plmn)) {
                    String separator = this.mContext.getString(17040064).toString();
                    carrierText = carrierText + separator + spn;
                }
            } else if (showSpn) {
                carrierText = spn;
            }
            this.setCarrierText(carrierText, subId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setCarrierText(String text, int subId) {
        this.logd("[setCarrierText]+ text:" + text + " subId:" + subId);
        this.enforceModifyPhoneState("setCarrierText");
        long identity = Binder.clearCallingIdentity();
        try {
            ContentValues value = new ContentValues(1);
            value.put("carrier_name", text);
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setIconTint(int tint, int subId) {
        this.logd("[setIconTint]+ tint:" + tint + " subId:" + subId);
        this.enforceModifyPhoneState("setIconTint");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            ContentValues value = new ContentValues(1);
            value.put("color", tint);
            this.logd("[setIconTint]- tint:" + tint + " set");
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayName(String displayName, int subId) {
        return this.setDisplayNameUsingSrc(displayName, subId, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayNameUsingSrc(String displayName, int subId, long nameSource) {
        this.logd("[setDisplayName]+  displayName:" + displayName + " subId:" + subId + " nameSource:" + nameSource);
        this.enforceModifyPhoneState("setDisplayNameUsingSrc");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            String nameToSet = displayName == null ? this.mContext.getString(17039374) : displayName;
            ContentValues value = new ContentValues(1);
            value.put("display_name", nameToSet);
            if (nameSource >= 0L) {
                this.logd("Set nameSource=" + nameSource);
                value.put("name_source", nameSource);
            }
            this.logd("[setDisplayName]- mDisplayName:" + nameToSet + " set");
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayNumber(String number, int subId) {
        this.logd("[setDisplayNumber]+ subId:" + subId);
        this.enforceModifyPhoneState("setDisplayNumber");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            int phoneId = this.getPhoneId(subId);
            if (number == null || phoneId < 0 || phoneId >= this.mTelephonyManager.getPhoneCount()) {
                this.logd("[setDispalyNumber]- fail");
                int n = -1;
                return n;
            }
            ContentValues value = new ContentValues(1);
            value.put("number", number);
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.logd("[setDisplayNumber]- update result :" + result);
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setDataRoaming(int roaming, int subId) {
        this.logd("[setDataRoaming]+ roaming:" + roaming + " subId:" + subId);
        this.enforceModifyPhoneState("setDataRoaming");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            if (roaming < 0) {
                this.logd("[setDataRoaming]- fail");
                int n = -1;
                return n;
            }
            ContentValues value = new ContentValues(1);
            value.put("data_roaming", roaming);
            this.logd("[setDataRoaming]- roaming:" + roaming + " set");
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setMccMnc(String mccMnc, int subId) {
        int mcc = 0;
        int mnc = 0;
        try {
            mcc = Integer.parseInt(mccMnc.substring(0, 3));
            mnc = Integer.parseInt(mccMnc.substring(3));
        }
        catch (NumberFormatException e) {
            this.loge("[setMccMnc] - couldn't parse mcc/mnc: " + mccMnc);
        }
        this.logd("[setMccMnc]+ mcc/mnc:" + mcc + "/" + mnc + " subId:" + subId);
        ContentValues value = new ContentValues(2);
        value.put("mcc", mcc);
        value.put("mnc", mnc);
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.notifySubscriptionInfoChanged();
        return result;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getSlotIndex(int subId) {
        if (subId == Integer.MAX_VALUE) {
            subId = this.getDefaultSubId();
        }
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            this.logd("[getSlotIndex]- subId invalid");
            return -1;
        }
        int size = sSlotIndexToSubId.size();
        if (size == 0) {
            this.logd("[getSlotIndex]- size == 0, return SIM_NOT_INSERTED instead");
            return -1;
        }
        for (Map.Entry<Integer, Integer> entry : sSlotIndexToSubId.entrySet()) {
            int sim = entry.getKey();
            int sub = entry.getValue();
            if (subId != sub) continue;
            return sim;
        }
        this.logd("[getSlotIndex]- return fail");
        return -1;
    }

    @Deprecated
    private final int[] $$robo$$com_android_internal_telephony_SubscriptionController$getSubId(int slotIndex) {
        if (slotIndex == Integer.MAX_VALUE) {
            slotIndex = this.getSlotIndex(this.getDefaultSubId());
        }
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            this.logd("[getSubId]- invalid slotIndex=" + slotIndex);
            return null;
        }
        int size = sSlotIndexToSubId.size();
        if (size == 0) {
            return this.getDummySubIds(slotIndex);
        }
        ArrayList<Integer> subIds = new ArrayList<Integer>();
        for (Map.Entry<Integer, Integer> entry : sSlotIndexToSubId.entrySet()) {
            int slot = entry.getKey();
            int sub = entry.getValue();
            if (slotIndex != slot) continue;
            subIds.add(sub);
        }
        int numSubIds = subIds.size();
        if (numSubIds > 0) {
            int[] subIdArr = new int[numSubIds];
            for (int i = 0; i < numSubIds; ++i) {
                subIdArr[i] = (Integer)subIds.get(i);
            }
            return subIdArr;
        }
        this.logd("[getSubId]- numSubIds == 0, return DummySubIds slotIndex=" + slotIndex);
        return this.getDummySubIds(slotIndex);
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getPhoneId(int subId) {
        if (subId == Integer.MAX_VALUE) {
            subId = this.getDefaultSubId();
            this.logdl("[getPhoneId] asked for default subId=" + subId);
        }
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return -1;
        }
        int size = sSlotIndexToSubId.size();
        if (size == 0) {
            int phoneId = mDefaultPhoneId;
            this.logdl("[getPhoneId]- no sims, returning default phoneId=" + phoneId);
            return phoneId;
        }
        for (Map.Entry<Integer, Integer> entry : sSlotIndexToSubId.entrySet()) {
            int sim = entry.getKey();
            int sub = entry.getValue();
            if (subId != sub) continue;
            return sim;
        }
        int phoneId = mDefaultPhoneId;
        this.logdl("[getPhoneId]- subId=" + subId + " not found return default phoneId=" + phoneId);
        return phoneId;
    }

    private final int[] $$robo$$com_android_internal_telephony_SubscriptionController$getDummySubIds(int slotIndex) {
        int numSubs = this.getActiveSubInfoCountMax();
        if (numSubs > 0) {
            int[] dummyValues = new int[numSubs];
            for (int i = 0; i < numSubs; ++i) {
                dummyValues[i] = -2 - slotIndex;
            }
            return dummyValues;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$clearSubInfo() {
        this.enforceModifyPhoneState("clearSubInfo");
        long identity = Binder.clearCallingIdentity();
        try {
            int size = sSlotIndexToSubId.size();
            if (size == 0) {
                this.logdl("[clearSubInfo]- no simInfo size=" + size);
                int n = 0;
                return n;
            }
            sSlotIndexToSubId.clear();
            this.logdl("[clearSubInfo]- clear size=" + size);
            int n = size;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$logvl(String msg) {
        this.logv(msg);
        this.mLocalLog.log(msg);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$logv(String msg) {
        Rlog.v("SubscriptionController", msg);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$logdl(String msg) {
        this.logd(msg);
        this.mLocalLog.log(msg);
    }

    private static final void $$robo$$com_android_internal_telephony_SubscriptionController$slogd(String msg) {
        Rlog.d("SubscriptionController", msg);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$logd(String msg) {
        Rlog.d("SubscriptionController", msg);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$logel(String msg) {
        this.loge(msg);
        this.mLocalLog.log(msg);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$loge(String msg) {
        Rlog.e("SubscriptionController", msg);
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultSubId() {
        boolean isVoiceCapable = this.mContext.getResources().getBoolean(17957040);
        int subId = isVoiceCapable ? this.getDefaultVoiceSubId() : this.getDefaultDataSubId();
        if (!this.isActiveSubId(subId)) {
            subId = mDefaultFallbackSubId;
        }
        return subId;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultSmsSubId(int subId) {
        this.enforceModifyPhoneState("setDefaultSmsSubId");
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("setDefaultSmsSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultSmsSubId] subId=" + subId);
        Settings.Global.putInt(this.mContext.getContentResolver(), "multi_sim_sms", subId);
        this.broadcastDefaultSmsSubIdChanged(subId);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultSmsSubIdChanged(int subId) {
        this.logdl("[broadcastDefaultSmsSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.telephony.action.DEFAULT_SMS_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x21000000);
        intent.putExtra("subscription", subId);
        intent.putExtra("android.telephony.extra.SUBSCRIPTION_INDEX", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultSmsSubId() {
        int subId = Settings.Global.getInt(this.mContext.getContentResolver(), "multi_sim_sms", -1);
        return subId;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultVoiceSubId(int subId) {
        this.enforceModifyPhoneState("setDefaultVoiceSubId");
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("setDefaultVoiceSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultVoiceSubId] subId=" + subId);
        Settings.Global.putInt(this.mContext.getContentResolver(), "multi_sim_voice_call", subId);
        this.broadcastDefaultVoiceSubIdChanged(subId);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultVoiceSubIdChanged(int subId) {
        this.logdl("[broadcastDefaultVoiceSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_VOICE_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x21000000);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultVoiceSubId() {
        int subId = Settings.Global.getInt(this.mContext.getContentResolver(), "multi_sim_voice_call", -1);
        return subId;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultDataSubId() {
        int subId = Settings.Global.getInt(this.mContext.getContentResolver(), "multi_sim_data_call", -1);
        return subId;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultDataSubId(int subId) {
        this.enforceModifyPhoneState("setDefaultDataSubId");
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("setDefaultDataSubId called with DEFAULT_SUB_ID");
        }
        ProxyController proxyController = ProxyController.getInstance();
        int len = sPhones.length;
        this.logdl("[setDefaultDataSubId] num phones=" + len + ", subId=" + subId);
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            RadioAccessFamily[] rafs = new RadioAccessFamily[len];
            boolean atLeastOneMatch = false;
            for (int phoneId = 0; phoneId < len; ++phoneId) {
                int raf;
                Phone phone = sPhones[phoneId];
                int id2 = phone.getSubId();
                if (id2 == subId) {
                    raf = proxyController.getMaxRafSupported();
                    atLeastOneMatch = true;
                } else {
                    raf = proxyController.getMinRafSupported();
                }
                this.logdl("[setDefaultDataSubId] phoneId=" + phoneId + " subId=" + id2 + " RAF=" + raf);
                rafs[phoneId] = new RadioAccessFamily(phoneId, raf);
            }
            if (atLeastOneMatch) {
                proxyController.setRadioCapability(rafs);
            } else {
                this.logdl("[setDefaultDataSubId] no valid subId's found - not updating.");
            }
        }
        this.updateAllDataConnectionTrackers();
        Settings.Global.putInt(this.mContext.getContentResolver(), "multi_sim_data_call", subId);
        this.broadcastDefaultDataSubIdChanged(subId);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$updateAllDataConnectionTrackers() {
        int len = sPhones.length;
        this.logdl("[updateAllDataConnectionTrackers] sPhones.length=" + len);
        for (int phoneId = 0; phoneId < len; ++phoneId) {
            this.logdl("[updateAllDataConnectionTrackers] phoneId=" + phoneId);
            sPhones[phoneId].updateDataConnectionTracker();
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultDataSubIdChanged(int subId) {
        this.logdl("[broadcastDefaultDataSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x21000000);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultFallbackSubId(int subId) {
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("setDefaultSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultFallbackSubId] subId=" + subId);
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            int phoneId = this.getPhoneId(subId);
            if (phoneId >= 0 && (phoneId < this.mTelephonyManager.getPhoneCount() || this.mTelephonyManager.getSimCount() == 1)) {
                this.logdl("[setDefaultFallbackSubId] set mDefaultFallbackSubId=" + subId);
                mDefaultFallbackSubId = subId;
                String defaultMccMnc = this.mTelephonyManager.getSimOperatorNumericForPhone(phoneId);
                MccTable.updateMccMncConfiguration(this.mContext, defaultMccMnc, false);
                Intent intent = new Intent("android.telephony.action.DEFAULT_SUBSCRIPTION_CHANGED");
                intent.addFlags(0x21000000);
                SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subId);
                this.logdl("[setDefaultFallbackSubId] broadcast default subId changed phoneId=" + phoneId + " subId=" + subId);
                this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            } else {
                this.logdl("[setDefaultFallbackSubId] not set invalid phoneId=" + phoneId + " subId=" + subId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_SubscriptionController$clearDefaultsForInactiveSubIds() {
        this.enforceModifyPhoneState("clearDefaultsForInactiveSubIds");
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> records = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            this.logdl("[clearDefaultsForInactiveSubIds] records: " + records);
            if (this.shouldDefaultBeCleared(records, this.getDefaultDataSubId())) {
                this.logd("[clearDefaultsForInactiveSubIds] clearing default data sub id");
                this.setDefaultDataSubId(-1);
            }
            if (this.shouldDefaultBeCleared(records, this.getDefaultSmsSubId())) {
                this.logdl("[clearDefaultsForInactiveSubIds] clearing default sms sub id");
                this.setDefaultSmsSubId(-1);
            }
            if (this.shouldDefaultBeCleared(records, this.getDefaultVoiceSubId())) {
                this.logdl("[clearDefaultsForInactiveSubIds] clearing default voice sub id");
                this.setDefaultVoiceSubId(-1);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_SubscriptionController$shouldDefaultBeCleared(List<SubscriptionInfo> records, int subId) {
        this.logdl("[shouldDefaultBeCleared: subId] " + subId);
        if (records == null) {
            this.logdl("[shouldDefaultBeCleared] return true no records subId=" + subId);
            return true;
        }
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            this.logdl("[shouldDefaultBeCleared] return false only one subId, subId=" + subId);
            return false;
        }
        for (SubscriptionInfo record : records) {
            int id2 = record.getSubscriptionId();
            this.logdl("[shouldDefaultBeCleared] Record.id: " + id2);
            if (id2 != subId) continue;
            this.logdl("[shouldDefaultBeCleared] return false subId is active, subId=" + subId);
            return false;
        }
        this.logdl("[shouldDefaultBeCleared] return true not active subId=" + subId);
        return true;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getSubIdUsingPhoneId(int phoneId) {
        int[] subIds = this.getSubId(phoneId);
        if (subIds == null || subIds.length == 0) {
            return -1;
        }
        return subIds[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<SubscriptionInfo> $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoUsingSlotIndexWithCheck(int slotIndex, boolean needCheck, String callingPackage) {
        this.logd("[getSubInfoUsingSlotIndexWithCheck]+ slotIndex:" + slotIndex);
        if (!this.canReadPhoneState(callingPackage, "getSubInfoUsingSlotIndexWithCheck")) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            if (slotIndex == Integer.MAX_VALUE) {
                slotIndex = this.getSlotIndex(this.getDefaultSubId());
            }
            if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
                this.logd("[getSubInfoUsingSlotIndexWithCheck]- invalid slotIndex");
                List<SubscriptionInfo> list = null;
                return list;
            }
            if (needCheck && !this.isSubInfoReady()) {
                this.logd("[getSubInfoUsingSlotIndexWithCheck]- not ready");
                List<SubscriptionInfo> list = null;
                return list;
            }
            ArrayList<SubscriptionInfo> subList = null;
            try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, "sim_id=?", new String[]{String.valueOf(slotIndex)}, null);){
                if (cursor != null) {
                    while (cursor.moveToNext()) {
                        SubscriptionInfo subInfo = this.getSubInfoRecord(cursor);
                        if (subInfo == null) continue;
                        if (subList == null) {
                            subList = new ArrayList<SubscriptionInfo>();
                        }
                        subList.add(subInfo);
                    }
                }
            }
            this.logd("[getSubInfoUsingSlotIndex]- null info return");
            ArrayList<SubscriptionInfo> arrayList = subList;
            return arrayList;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$validateSubId(int subId) {
        this.logd("validateSubId subId: " + subId);
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new RuntimeException("Invalid sub id passed as parameter");
        }
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("Default sub id passed as parameter");
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$updatePhonesAvailability(Phone[] phones) {
        sPhones = phones;
    }

    private final int[] $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubIdList() {
        Set<Map.Entry<Integer, Integer>> simInfoSet = sSlotIndexToSubId.entrySet();
        int[] subIdArr = new int[simInfoSet.size()];
        int i = 0;
        for (Map.Entry<Integer, Integer> entry : simInfoSet) {
            int sub;
            subIdArr[i] = sub = entry.getValue().intValue();
            ++i;
        }
        return subIdArr;
    }

    private final boolean $$robo$$com_android_internal_telephony_SubscriptionController$isActiveSubId(int subId) {
        boolean retVal = SubscriptionManager.isValidSubscriptionId(subId) && sSlotIndexToSubId.containsValue(subId);
        return retVal;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getSimStateForSlotIndex(int slotIndex) {
        IccCardConstants.State simState;
        if (slotIndex < 0) {
            simState = IccCardConstants.State.UNKNOWN;
            String err = "invalid slotIndex";
        } else {
            Phone phone = PhoneFactory.getPhone(slotIndex);
            if (phone == null) {
                simState = IccCardConstants.State.UNKNOWN;
                String err = "phone == null";
            } else {
                IccCard icc = phone.getIccCard();
                if (icc == null) {
                    simState = IccCardConstants.State.UNKNOWN;
                    String err = "icc == null";
                } else {
                    simState = icc.getState();
                    String err = "";
                }
            }
        }
        return simState.ordinal();
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$setSubscriptionProperty(int subId, String propKey, String propValue) {
        this.enforceModifyPhoneState("setSubscriptionProperty");
        long token = Binder.clearCallingIdentity();
        ContentResolver resolver = this.mContext.getContentResolver();
        ContentValues value = new ContentValues();
        switch (propKey) {
            case "enable_cmas_extreme_threat_alerts": 
            case "enable_cmas_severe_threat_alerts": 
            case "enable_cmas_amber_alerts": 
            case "enable_emergency_alerts": 
            case "alert_sound_duration": 
            case "alert_reminder_interval": 
            case "enable_alert_vibrate": 
            case "enable_alert_speech": 
            case "enable_etws_test_alerts": 
            case "enable_channel_50_alerts": 
            case "enable_cmas_test_alerts": 
            case "show_cmas_opt_out_dialog": {
                value.put(propKey, Integer.parseInt(propValue));
                break;
            }
            default: {
                this.logd("Invalid column name");
            }
        }
        resolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Integer.toString(subId), null);
        Binder.restoreCallingIdentity(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$com_android_internal_telephony_SubscriptionController$getSubscriptionProperty(int subId, String propKey, String callingPackage) {
        if (!this.canReadPhoneState(callingPackage, "getSubInfoUsingSlotIndexWithCheck")) {
            return null;
        }
        String resultValue = null;
        ContentResolver resolver = this.mContext.getContentResolver();
        try (Cursor cursor = resolver.query(SubscriptionManager.CONTENT_URI, new String[]{propKey}, "_id=?", new String[]{subId + ""}, null);){
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    switch (propKey) {
                        case "enable_cmas_extreme_threat_alerts": 
                        case "enable_cmas_severe_threat_alerts": 
                        case "enable_cmas_amber_alerts": 
                        case "enable_emergency_alerts": 
                        case "alert_sound_duration": 
                        case "alert_reminder_interval": 
                        case "enable_alert_vibrate": 
                        case "enable_alert_speech": 
                        case "enable_etws_test_alerts": 
                        case "enable_channel_50_alerts": 
                        case "enable_cmas_test_alerts": 
                        case "show_cmas_opt_out_dialog": {
                            resultValue = cursor.getInt(0) + "";
                            break;
                        }
                        default: {
                            this.logd("Invalid column name");
                            break;
                        }
                    }
                } else {
                    this.logd("Valid row not present in db");
                }
            } else {
                this.logd("Query failed");
            }
        }
        this.logd("getSubscriptionProperty Query value = " + resultValue);
        return resultValue;
    }

    private static final void $$robo$$com_android_internal_telephony_SubscriptionController$printStackTrace(String msg) {
        RuntimeException re = new RuntimeException();
        SubscriptionController.slogd("StackTrace - " + msg);
        StackTraceElement[] st = re.getStackTrace();
        boolean first = true;
        for (StackTraceElement ste : st) {
            if (first) {
                first = false;
                continue;
            }
            SubscriptionController.slogd(ste.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_SubscriptionController$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        long token = Binder.clearCallingIdentity();
        try {
            pw.println("SubscriptionController:");
            pw.println(" defaultSubId=" + this.getDefaultSubId());
            pw.println(" defaultDataSubId=" + this.getDefaultDataSubId());
            pw.println(" defaultVoiceSubId=" + this.getDefaultVoiceSubId());
            pw.println(" defaultSmsSubId=" + this.getDefaultSmsSubId());
            pw.println(" defaultDataPhoneId=" + SubscriptionManager.from(this.mContext).getDefaultDataPhoneId());
            pw.println(" defaultVoicePhoneId=" + SubscriptionManager.getDefaultVoicePhoneId());
            pw.println(" defaultSmsPhoneId=" + SubscriptionManager.from(this.mContext).getDefaultSmsPhoneId());
            pw.flush();
            for (Map.Entry<Integer, Integer> entry : sSlotIndexToSubId.entrySet()) {
                pw.println(" sSlotIndexToSubId[" + entry.getKey() + "]: subId=" + entry.getValue());
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            List<SubscriptionInfo> sirl = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (sirl != null) {
                pw.println(" ActiveSubInfoList:");
                for (SubscriptionInfo entry : sirl) {
                    pw.println("  " + entry.toString());
                }
            } else {
                pw.println(" ActiveSubInfoList: is null");
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            sirl = this.getAllSubInfoList(this.mContext.getOpPackageName());
            if (sirl != null) {
                pw.println(" AllSubInfoList:");
                for (SubscriptionInfo entry : sirl) {
                    pw.println("  " + entry.toString());
                }
            } else {
                pw.println(" AllSubInfoList: is null");
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            this.mLocalLog.dump(fd, pw, args);
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            pw.flush();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    static void __staticInitializer__() {
        sInstance = null;
        sSlotIndexToSubId = new ConcurrentHashMap<Integer, Integer>();
        mDefaultFallbackSubId = -1;
        mDefaultPhoneId = Integer.MAX_VALUE;
    }

    public static SubscriptionController init(Phone phone) {
        return InvokeDynamicSupport.bootstrapStatic("init", $$robo$$com_android_internal_telephony_SubscriptionController$init(com.android.internal.telephony.Phone ), (Phone)phone);
    }

    public static SubscriptionController init(Context context, CommandsInterface[] commandsInterfaceArray) {
        return InvokeDynamicSupport.bootstrapStatic("init", $$robo$$com_android_internal_telephony_SubscriptionController$init(android.content.Context com.android.internal.telephony.CommandsInterface[] ), (Context)context, (CommandsInterface[])commandsInterfaceArray);
    }

    public static SubscriptionController getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_SubscriptionController$getInstance());
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(context);
    }

    public SubscriptionController(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(android.content.Context ), this, context);
    }

    protected void init(Context context) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_telephony_SubscriptionController$init(android.content.Context ), this, context);
    }

    private boolean isSubInfoReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSubInfoReady", $$robo$$com_android_internal_telephony_SubscriptionController$isSubInfoReady(), this);
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(phone);
    }

    public SubscriptionController(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(com.android.internal.telephony.Phone ), this, phone);
    }

    private boolean canReadPhoneState(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("canReadPhoneState", $$robo$$com_android_internal_telephony_SubscriptionController$canReadPhoneState(java.lang.String java.lang.String ), this, string2, string3);
    }

    private void enforceModifyPhoneState(String string2) {
        InvokeDynamicSupport.bootstrap("enforceModifyPhoneState", $$robo$$com_android_internal_telephony_SubscriptionController$enforceModifyPhoneState(java.lang.String ), this, string2);
    }

    private void broadcastSimInfoContentChanged() {
        InvokeDynamicSupport.bootstrap("broadcastSimInfoContentChanged", $$robo$$com_android_internal_telephony_SubscriptionController$broadcastSimInfoContentChanged(), this);
    }

    public void notifySubscriptionInfoChanged() {
        InvokeDynamicSupport.bootstrap("notifySubscriptionInfoChanged", $$robo$$com_android_internal_telephony_SubscriptionController$notifySubscriptionInfoChanged(), this);
    }

    private SubscriptionInfo getSubInfoRecord(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("getSubInfoRecord", $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoRecord(android.database.Cursor ), this, cursor);
    }

    private String getSubscriptionCountryIso(int n) {
        return InvokeDynamicSupport.bootstrap("getSubscriptionCountryIso", $$robo$$com_android_internal_telephony_SubscriptionController$getSubscriptionCountryIso(int ), this, n);
    }

    private List<SubscriptionInfo> getSubInfo(String string2, Object object) {
        return InvokeDynamicSupport.bootstrap("getSubInfo", $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfo(java.lang.String java.lang.Object ), this, string2, object);
    }

    private int getUnusedColor(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getUnusedColor", $$robo$$com_android_internal_telephony_SubscriptionController$getUnusedColor(java.lang.String ), this, string2);
    }

    @Override
    public SubscriptionInfo getActiveSubscriptionInfo(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfo", $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubscriptionInfo(int java.lang.String ), this, n, string2);
    }

    @Override
    public SubscriptionInfo getActiveSubscriptionInfoForIccId(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoForIccId", $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubscriptionInfoForIccId(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoForSimSlotIndex", $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubscriptionInfoForSimSlotIndex(int java.lang.String ), this, n, string2);
    }

    @Override
    public List<SubscriptionInfo> getAllSubInfoList(String string2) {
        return InvokeDynamicSupport.bootstrap("getAllSubInfoList", $$robo$$com_android_internal_telephony_SubscriptionController$getAllSubInfoList(java.lang.String ), this, string2);
    }

    @Override
    public List<SubscriptionInfo> getActiveSubscriptionInfoList(String string2) {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoList", $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubscriptionInfoList(java.lang.String ), this, string2);
    }

    @Override
    public int getActiveSubInfoCount(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getActiveSubInfoCount", $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubInfoCount(java.lang.String ), this, string2);
    }

    @Override
    public int getAllSubInfoCount(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getAllSubInfoCount", $$robo$$com_android_internal_telephony_SubscriptionController$getAllSubInfoCount(java.lang.String ), this, string2);
    }

    @Override
    public int getActiveSubInfoCountMax() {
        return (int)InvokeDynamicSupport.bootstrap("getActiveSubInfoCountMax", $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubInfoCountMax(), this);
    }

    @Override
    public int addSubInfoRecord(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("addSubInfoRecord", $$robo$$com_android_internal_telephony_SubscriptionController$addSubInfoRecord(java.lang.String int ), this, string2, n);
    }

    public boolean setPlmnSpn(int n, boolean bl, String string2, boolean bl2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPlmnSpn", $$robo$$com_android_internal_telephony_SubscriptionController$setPlmnSpn(int boolean java.lang.String boolean java.lang.String ), this, n, bl, string2, bl2, string3);
    }

    private int setCarrierText(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("setCarrierText", $$robo$$com_android_internal_telephony_SubscriptionController$setCarrierText(java.lang.String int ), this, string2, n);
    }

    @Override
    public int setIconTint(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("setIconTint", $$robo$$com_android_internal_telephony_SubscriptionController$setIconTint(int int ), this, n, n2);
    }

    @Override
    public int setDisplayName(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayName", $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayName(java.lang.String int ), this, string2, n);
    }

    @Override
    public int setDisplayNameUsingSrc(String string2, int n, long l) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayNameUsingSrc", $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayNameUsingSrc(java.lang.String int long ), this, string2, n, l);
    }

    @Override
    public int setDisplayNumber(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayNumber", $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayNumber(java.lang.String int ), this, string2, n);
    }

    @Override
    public int setDataRoaming(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("setDataRoaming", $$robo$$com_android_internal_telephony_SubscriptionController$setDataRoaming(int int ), this, n, n2);
    }

    public int setMccMnc(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("setMccMnc", $$robo$$com_android_internal_telephony_SubscriptionController$setMccMnc(java.lang.String int ), this, string2, n);
    }

    @Override
    public int getSlotIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSlotIndex", $$robo$$com_android_internal_telephony_SubscriptionController$getSlotIndex(int ), this, n);
    }

    @Override
    @Deprecated
    public int[] getSubId(int n) {
        return InvokeDynamicSupport.bootstrap("getSubId", $$robo$$com_android_internal_telephony_SubscriptionController$getSubId(int ), this, n);
    }

    @Override
    public int getPhoneId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$com_android_internal_telephony_SubscriptionController$getPhoneId(int ), this, n);
    }

    private int[] getDummySubIds(int n) {
        return InvokeDynamicSupport.bootstrap("getDummySubIds", $$robo$$com_android_internal_telephony_SubscriptionController$getDummySubIds(int ), this, n);
    }

    @Override
    public int clearSubInfo() {
        return (int)InvokeDynamicSupport.bootstrap("clearSubInfo", $$robo$$com_android_internal_telephony_SubscriptionController$clearSubInfo(), this);
    }

    private void logvl(String string2) {
        InvokeDynamicSupport.bootstrap("logvl", $$robo$$com_android_internal_telephony_SubscriptionController$logvl(java.lang.String ), this, string2);
    }

    private void logv(String string2) {
        InvokeDynamicSupport.bootstrap("logv", $$robo$$com_android_internal_telephony_SubscriptionController$logv(java.lang.String ), this, string2);
    }

    private void logdl(String string2) {
        InvokeDynamicSupport.bootstrap("logdl", $$robo$$com_android_internal_telephony_SubscriptionController$logdl(java.lang.String ), this, string2);
    }

    private static void slogd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("slogd", $$robo$$com_android_internal_telephony_SubscriptionController$slogd(java.lang.String ), (String)string2);
    }

    private void logd(String string2) {
        InvokeDynamicSupport.bootstrap("logd", $$robo$$com_android_internal_telephony_SubscriptionController$logd(java.lang.String ), this, string2);
    }

    private void logel(String string2) {
        InvokeDynamicSupport.bootstrap("logel", $$robo$$com_android_internal_telephony_SubscriptionController$logel(java.lang.String ), this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_SubscriptionController$loge(java.lang.String ), this, string2);
    }

    @Override
    public int getDefaultSubId() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultSubId", $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultSubId(), this);
    }

    @Override
    public void setDefaultSmsSubId(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultSmsSubId", $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultSmsSubId(int ), this, n);
    }

    private void broadcastDefaultSmsSubIdChanged(int n) {
        InvokeDynamicSupport.bootstrap("broadcastDefaultSmsSubIdChanged", $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultSmsSubIdChanged(int ), this, n);
    }

    @Override
    public int getDefaultSmsSubId() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultSmsSubId", $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultSmsSubId(), this);
    }

    @Override
    public void setDefaultVoiceSubId(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultVoiceSubId", $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultVoiceSubId(int ), this, n);
    }

    private void broadcastDefaultVoiceSubIdChanged(int n) {
        InvokeDynamicSupport.bootstrap("broadcastDefaultVoiceSubIdChanged", $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultVoiceSubIdChanged(int ), this, n);
    }

    @Override
    public int getDefaultVoiceSubId() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultVoiceSubId", $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultVoiceSubId(), this);
    }

    @Override
    public int getDefaultDataSubId() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultDataSubId", $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultDataSubId(), this);
    }

    @Override
    public void setDefaultDataSubId(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultDataSubId", $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultDataSubId(int ), this, n);
    }

    private void updateAllDataConnectionTrackers() {
        InvokeDynamicSupport.bootstrap("updateAllDataConnectionTrackers", $$robo$$com_android_internal_telephony_SubscriptionController$updateAllDataConnectionTrackers(), this);
    }

    private void broadcastDefaultDataSubIdChanged(int n) {
        InvokeDynamicSupport.bootstrap("broadcastDefaultDataSubIdChanged", $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultDataSubIdChanged(int ), this, n);
    }

    private void setDefaultFallbackSubId(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultFallbackSubId", $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultFallbackSubId(int ), this, n);
    }

    @Override
    public void clearDefaultsForInactiveSubIds() {
        InvokeDynamicSupport.bootstrap("clearDefaultsForInactiveSubIds", $$robo$$com_android_internal_telephony_SubscriptionController$clearDefaultsForInactiveSubIds(), this);
    }

    private boolean shouldDefaultBeCleared(List<SubscriptionInfo> list, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDefaultBeCleared", $$robo$$com_android_internal_telephony_SubscriptionController$shouldDefaultBeCleared(java.util.List<android.telephony.SubscriptionInfo> int ), this, list, n);
    }

    public int getSubIdUsingPhoneId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSubIdUsingPhoneId", $$robo$$com_android_internal_telephony_SubscriptionController$getSubIdUsingPhoneId(int ), this, n);
    }

    public List<SubscriptionInfo> getSubInfoUsingSlotIndexWithCheck(int n, boolean bl, String string2) {
        return InvokeDynamicSupport.bootstrap("getSubInfoUsingSlotIndexWithCheck", $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoUsingSlotIndexWithCheck(int boolean java.lang.String ), this, n, bl, string2);
    }

    private void validateSubId(int n) {
        InvokeDynamicSupport.bootstrap("validateSubId", $$robo$$com_android_internal_telephony_SubscriptionController$validateSubId(int ), this, n);
    }

    public void updatePhonesAvailability(Phone[] phoneArray) {
        InvokeDynamicSupport.bootstrap("updatePhonesAvailability", $$robo$$com_android_internal_telephony_SubscriptionController$updatePhonesAvailability(com.android.internal.telephony.Phone[] ), this, phoneArray);
    }

    @Override
    public int[] getActiveSubIdList() {
        return InvokeDynamicSupport.bootstrap("getActiveSubIdList", $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubIdList(), this);
    }

    @Override
    public boolean isActiveSubId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isActiveSubId", $$robo$$com_android_internal_telephony_SubscriptionController$isActiveSubId(int ), this, n);
    }

    @Override
    public int getSimStateForSlotIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSimStateForSlotIndex", $$robo$$com_android_internal_telephony_SubscriptionController$getSimStateForSlotIndex(int ), this, n);
    }

    @Override
    public void setSubscriptionProperty(int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSubscriptionProperty", $$robo$$com_android_internal_telephony_SubscriptionController$setSubscriptionProperty(int java.lang.String java.lang.String ), this, n, string2, string3);
    }

    @Override
    public String getSubscriptionProperty(int n, String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getSubscriptionProperty", $$robo$$com_android_internal_telephony_SubscriptionController$getSubscriptionProperty(int java.lang.String java.lang.String ), this, n, string2, string3);
    }

    private static void printStackTrace(String string2) {
        InvokeDynamicSupport.bootstrapStatic("printStackTrace", $$robo$$com_android_internal_telephony_SubscriptionController$printStackTrace(java.lang.String ), (String)string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_SubscriptionController$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(SubscriptionController.class);
    }

    public /* synthetic */ SubscriptionController() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionController)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ScLocalLog
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private LinkedList<String> mLog;
        private int mMaxLines;
        private Time mNow;

        private void $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$__constructor__(int maxLines) {
            this.mLog = new LinkedList();
            this.mMaxLines = maxLines;
            this.mNow = new Time();
        }

        private final synchronized void $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$log(String msg) {
            if (this.mMaxLines > 0) {
                int pid = Process.myPid();
                int tid = Process.myTid();
                this.mNow.setToNow();
                this.mLog.add(this.mNow.format("%m-%d %H:%M:%S") + " pid=" + pid + " tid=" + tid + " " + msg);
                while (this.mLog.size() > this.mMaxLines) {
                    this.mLog.remove();
                }
            }
        }

        private final synchronized void $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            int LOOPS_PER_FLUSH = 10;
            ListIterator<String> itr = this.mLog.listIterator(0);
            int i = 0;
            while (itr.hasNext()) {
                pw.println(Integer.toString(i++) + ": " + (String)itr.next());
                if (i % 10 != 0) continue;
                pw.flush();
            }
        }

        private void __constructor__(int n) {
            this.$$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$__constructor__(n);
        }

        public ScLocalLog(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$__constructor__(int ), this, n);
        }

        public synchronized void log(String string2) {
            InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$log(java.lang.String ), this, string2);
        }

        public synchronized void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
        }

        public /* synthetic */ ScLocalLog() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScLocalLog)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

