/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.cat.AppInterface;
import com.android.internal.telephony.cat.BIPClientParams;
import com.android.internal.telephony.cat.BerTlv;
import com.android.internal.telephony.cat.CallSetupParams;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.CommandDetails;
import com.android.internal.telephony.cat.CommandParams;
import com.android.internal.telephony.cat.ComprehensionTlv;
import com.android.internal.telephony.cat.ComprehensionTlvTag;
import com.android.internal.telephony.cat.DisplayTextParams;
import com.android.internal.telephony.cat.Duration;
import com.android.internal.telephony.cat.GetInputParams;
import com.android.internal.telephony.cat.IconId;
import com.android.internal.telephony.cat.IconLoader;
import com.android.internal.telephony.cat.Input;
import com.android.internal.telephony.cat.ItemsIconId;
import com.android.internal.telephony.cat.LaunchBrowserMode;
import com.android.internal.telephony.cat.LaunchBrowserParams;
import com.android.internal.telephony.cat.Menu;
import com.android.internal.telephony.cat.PlayToneParams;
import com.android.internal.telephony.cat.PresentationType;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.ResultException;
import com.android.internal.telephony.cat.RilMessageDecoder;
import com.android.internal.telephony.cat.SelectItemParams;
import com.android.internal.telephony.cat.SetEventListParams;
import com.android.internal.telephony.cat.TextMessage;
import com.android.internal.telephony.cat.Tone;
import com.android.internal.telephony.cat.ValueParser;
import com.android.internal.telephony.uicc.IccFileHandler;
import java.util.Iterator;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CommandParamsFactory
extends Handler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static CommandParamsFactory sInstance;
    private IconLoader mIconLoader;
    private CommandParams mCmdParams;
    private int mIconLoadState;
    private RilMessageDecoder mCaller;
    private boolean mloadIcon;
    static int MSG_ID_LOAD_ICON_DONE = 1;
    static int LOAD_NO_ICON = 0;
    static int LOAD_SINGLE_ICON = 1;
    static int LOAD_MULTI_ICONS = 2;
    static int REFRESH_NAA_INIT_AND_FULL_FILE_CHANGE = 0;
    static int REFRESH_NAA_INIT_AND_FILE_CHANGE = 2;
    static int REFRESH_NAA_INIT = 3;
    static int REFRESH_UICC_RESET = 4;
    static int DTTZ_SETTING = 3;
    static int LANGUAGE_SETTING = 4;
    private static int MAX_GSM7_DEFAULT_CHARS = 239;
    private static int MAX_UCS2_CHARS = 118;

    private static final synchronized CommandParamsFactory $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$getInstance(RilMessageDecoder caller, IccFileHandler fh) {
        if (sInstance != null) {
            return sInstance;
        }
        if (fh != null) {
            return new CommandParamsFactory(caller, fh);
        }
        return null;
    }

    private void $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$__constructor__(RilMessageDecoder caller, IccFileHandler fh) {
        this.mCmdParams = null;
        this.mIconLoadState = 0;
        this.mCaller = null;
        this.mloadIcon = false;
        this.mCaller = caller;
        this.mIconLoader = IconLoader.getInstance(this, fh);
    }

    private final CommandDetails $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processCommandDetails(List<ComprehensionTlv> ctlvs) {
        ComprehensionTlv ctlvCmdDet;
        CommandDetails cmdDet = null;
        if (ctlvs != null && (ctlvCmdDet = this.searchForTag(ComprehensionTlvTag.COMMAND_DETAILS, ctlvs)) != null) {
            try {
                cmdDet = ValueParser.retrieveCommandDetails(ctlvCmdDet);
            }
            catch (ResultException e) {
                CatLog.d(this, "processCommandDetails: Failed to procees command details e=" + e);
            }
        }
        return cmdDet;
    }

    private final void $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$make(BerTlv berTlv) {
        if (berTlv == null) {
            return;
        }
        this.mCmdParams = null;
        this.mIconLoadState = 0;
        if (berTlv.getTag() != 208) {
            this.sendCmdParams(ResultCode.CMD_TYPE_NOT_UNDERSTOOD);
            return;
        }
        boolean cmdPending = false;
        List<ComprehensionTlv> ctlvs = berTlv.getComprehensionTlvs();
        CommandDetails cmdDet = this.processCommandDetails(ctlvs);
        if (cmdDet == null) {
            this.sendCmdParams(ResultCode.CMD_TYPE_NOT_UNDERSTOOD);
            return;
        }
        AppInterface.CommandType cmdType = AppInterface.CommandType.fromInt(cmdDet.typeOfCommand);
        if (cmdType == null) {
            this.mCmdParams = new CommandParams(cmdDet);
            this.sendCmdParams(ResultCode.BEYOND_TERMINAL_CAPABILITY);
            return;
        }
        if (!berTlv.isLengthValid()) {
            this.mCmdParams = new CommandParams(cmdDet);
            this.sendCmdParams(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            return;
        }
        try {
            switch (1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[cmdType.ordinal()]) {
                case 1: {
                    cmdPending = this.processSelectItem(cmdDet, ctlvs);
                    break;
                }
                case 2: {
                    cmdPending = this.processSelectItem(cmdDet, ctlvs);
                    break;
                }
                case 3: {
                    cmdPending = this.processDisplayText(cmdDet, ctlvs);
                    break;
                }
                case 4: {
                    cmdPending = this.processSetUpIdleModeText(cmdDet, ctlvs);
                    break;
                }
                case 5: {
                    cmdPending = this.processGetInkey(cmdDet, ctlvs);
                    break;
                }
                case 6: {
                    cmdPending = this.processGetInput(cmdDet, ctlvs);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    cmdPending = this.processEventNotify(cmdDet, ctlvs);
                    break;
                }
                case 11: 
                case 12: {
                    cmdPending = this.processSetupCall(cmdDet, ctlvs);
                    break;
                }
                case 13: {
                    this.processRefresh(cmdDet, ctlvs);
                    cmdPending = false;
                    break;
                }
                case 14: {
                    cmdPending = this.processLaunchBrowser(cmdDet, ctlvs);
                    break;
                }
                case 15: {
                    cmdPending = this.processPlayTone(cmdDet, ctlvs);
                    break;
                }
                case 16: {
                    cmdPending = this.processSetUpEventList(cmdDet, ctlvs);
                    break;
                }
                case 17: {
                    cmdPending = this.processProvideLocalInfo(cmdDet, ctlvs);
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    cmdPending = this.processBIPClient(cmdDet, ctlvs);
                    break;
                }
                default: {
                    this.mCmdParams = new CommandParams(cmdDet);
                    this.sendCmdParams(ResultCode.BEYOND_TERMINAL_CAPABILITY);
                    return;
                }
            }
        }
        catch (ResultException e) {
            CatLog.d(this, "make: caught ResultException e=" + e);
            this.mCmdParams = new CommandParams(cmdDet);
            this.sendCmdParams(e.result());
            return;
        }
        if (!cmdPending) {
            this.sendCmdParams(ResultCode.OK);
        }
    }

    private final void $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                if (this.mIconLoader == null) break;
                this.sendCmdParams(this.setIcons(msg.obj));
            }
        }
    }

    private final ResultCode $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$setIcons(Object data) {
        Bitmap[] icons = null;
        boolean iconIndex = false;
        if (data == null) {
            CatLog.d(this, "Optional Icon data is NULL");
            this.mCmdParams.mLoadIconFailed = true;
            this.mloadIcon = false;
            return ResultCode.OK;
        }
        switch (this.mIconLoadState) {
            case 1: {
                this.mCmdParams.setIcon((Bitmap)data);
                break;
            }
            case 2: {
                for (Bitmap icon : icons = (Bitmap[])data) {
                    this.mCmdParams.setIcon(icon);
                    if (icon != null || !this.mloadIcon) continue;
                    CatLog.d(this, "Optional Icon data is NULL while loading multi icons");
                    this.mCmdParams.mLoadIconFailed = true;
                }
                break;
            }
        }
        return ResultCode.OK;
    }

    private final void $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$sendCmdParams(ResultCode resCode) {
        this.mCaller.sendMsgParamsDecoded(resCode, this.mCmdParams);
    }

    private final ComprehensionTlv $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$searchForTag(ComprehensionTlvTag tag, List<ComprehensionTlv> ctlvs) {
        Iterator<ComprehensionTlv> iter = ctlvs.iterator();
        return this.searchForNextTag(tag, iter);
    }

    private final ComprehensionTlv $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$searchForNextTag(ComprehensionTlvTag tag, Iterator<ComprehensionTlv> iter) {
        int tagValue = tag.value();
        while (iter.hasNext()) {
            ComprehensionTlv ctlv = iter.next();
            if (ctlv.getTag() != tagValue) continue;
            return ctlv;
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processDisplayText(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process DisplayText");
        TextMessage textMsg = new TextMessage();
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, ctlvs);
        if (ctlv != null) {
            textMsg.text = ValueParser.retrieveTextString(ctlv);
        }
        if (textMsg.text == null) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        ctlv = this.searchForTag(ComprehensionTlvTag.IMMEDIATE_RESPONSE, ctlvs);
        if (ctlv != null) {
            textMsg.responseNeeded = false;
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            textMsg.iconSelfExplanatory = iconId.selfExplanatory;
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.DURATION, ctlvs)) != null) {
            textMsg.duration = ValueParser.retrieveDuration(ctlv);
        }
        textMsg.isHighPriority = (cmdDet.commandQualifier & 1) != 0;
        textMsg.userClear = (cmdDet.commandQualifier & 0x80) != 0;
        this.mCmdParams = new DisplayTextParams(cmdDet, textMsg);
        if (iconId != null) {
            this.mloadIcon = true;
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processSetUpIdleModeText(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process SetUpIdleModeText");
        TextMessage textMsg = new TextMessage();
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, ctlvs);
        if (ctlv != null) {
            textMsg.text = ValueParser.retrieveTextString(ctlv);
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            textMsg.iconSelfExplanatory = iconId.selfExplanatory;
        }
        if (textMsg.text == null && iconId != null && !textMsg.iconSelfExplanatory) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        this.mCmdParams = new DisplayTextParams(cmdDet, textMsg);
        if (iconId != null) {
            this.mloadIcon = true;
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processGetInkey(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process GetInkey");
        Input input = new Input();
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, ctlvs);
        if (ctlv == null) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        input.text = ValueParser.retrieveTextString(ctlv);
        ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs);
        if (ctlv != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            input.iconSelfExplanatory = iconId.selfExplanatory;
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.DURATION, ctlvs)) != null) {
            input.duration = ValueParser.retrieveDuration(ctlv);
        }
        input.minLen = 1;
        input.maxLen = 1;
        input.digitOnly = (cmdDet.commandQualifier & 1) == 0;
        input.ucs2 = (cmdDet.commandQualifier & 2) != 0;
        input.yesNo = (cmdDet.commandQualifier & 4) != 0;
        input.helpAvailable = (cmdDet.commandQualifier & 0x80) != 0;
        input.echo = true;
        this.mCmdParams = new GetInputParams(cmdDet, input);
        if (iconId != null) {
            this.mloadIcon = true;
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processGetInput(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process GetInput");
        Input input = new Input();
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, ctlvs);
        if (ctlv == null) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        input.text = ValueParser.retrieveTextString(ctlv);
        ctlv = this.searchForTag(ComprehensionTlvTag.RESPONSE_LENGTH, ctlvs);
        if (ctlv != null) {
            try {
                byte[] rawValue = ctlv.getRawValue();
                int valueIndex = ctlv.getValueIndex();
                input.minLen = rawValue[valueIndex] & 0xFF;
                input.maxLen = rawValue[valueIndex + 1] & 0xFF;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        } else {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        ctlv = this.searchForTag(ComprehensionTlvTag.DEFAULT_TEXT, ctlvs);
        if (ctlv != null) {
            input.defaultText = ValueParser.retrieveTextString(ctlv);
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            input.iconSelfExplanatory = iconId.selfExplanatory;
        }
        input.digitOnly = (cmdDet.commandQualifier & 1) == 0;
        input.ucs2 = (cmdDet.commandQualifier & 2) != 0;
        input.echo = (cmdDet.commandQualifier & 4) == 0;
        input.packed = (cmdDet.commandQualifier & 8) != 0;
        boolean bl = input.helpAvailable = (cmdDet.commandQualifier & 0x80) != 0;
        if (input.ucs2 && input.maxLen > 118) {
            CatLog.d(this, "UCS2: received maxLen = " + input.maxLen + ", truncating to " + 118);
            input.maxLen = 118;
        } else if (!input.packed && input.maxLen > 239) {
            CatLog.d(this, "GSM 7Bit Default: received maxLen = " + input.maxLen + ", truncating to " + 239);
            input.maxLen = 239;
        }
        this.mCmdParams = new GetInputParams(cmdDet, input);
        if (iconId != null) {
            this.mloadIcon = true;
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processRefresh(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) {
        CatLog.d(this, "process Refresh");
        switch (cmdDet.commandQualifier) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                this.mCmdParams = new DisplayTextParams(cmdDet, null);
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processSelectItem(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        boolean presentTypeSpecified;
        CatLog.d(this, "process SelectItem");
        Menu menu2 = new Menu();
        IconId titleIconId = null;
        ItemsIconId itemsIconId = null;
        Iterator<ComprehensionTlv> iter = ctlvs.iterator();
        AppInterface.CommandType cmdType = AppInterface.CommandType.fromInt(cmdDet.typeOfCommand);
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, ctlvs);
        if (ctlv != null) {
            menu2.title = ValueParser.retrieveAlphaId(ctlv);
        } else if (cmdType == AppInterface.CommandType.SET_UP_MENU) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        while ((ctlv = this.searchForNextTag(ComprehensionTlvTag.ITEM, iter)) != null) {
            menu2.items.add(ValueParser.retrieveItem(ctlv));
        }
        if (menu2.items.size() == 0) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        ctlv = this.searchForTag(ComprehensionTlvTag.ITEM_ID, ctlvs);
        if (ctlv != null) {
            menu2.defaultItem = ValueParser.retrieveItemId(ctlv) - 1;
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            this.mIconLoadState = 1;
            titleIconId = ValueParser.retrieveIconId(ctlv);
            menu2.titleIconSelfExplanatory = titleIconId.selfExplanatory;
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ITEM_ICON_ID_LIST, ctlvs)) != null) {
            this.mIconLoadState = 2;
            itemsIconId = ValueParser.retrieveItemsIconId(ctlv);
            menu2.itemsIconSelfExplanatory = itemsIconId.selfExplanatory;
        }
        boolean bl = presentTypeSpecified = (cmdDet.commandQualifier & 1) != 0;
        if (presentTypeSpecified) {
            menu2.presentationType = (cmdDet.commandQualifier & 2) == 0 ? PresentationType.DATA_VALUES : PresentationType.NAVIGATION_OPTIONS;
        }
        menu2.softKeyPreferred = (cmdDet.commandQualifier & 4) != 0;
        menu2.helpAvailable = (cmdDet.commandQualifier & 0x80) != 0;
        this.mCmdParams = new SelectItemParams(cmdDet, menu2, titleIconId != null);
        switch (this.mIconLoadState) {
            case 0: {
                return false;
            }
            case 1: {
                this.mloadIcon = true;
                this.mIconLoader.loadIcon(titleIconId.recordNumber, this.obtainMessage(1));
                break;
            }
            case 2: {
                int[] recordNumbers = itemsIconId.recordNumbers;
                if (titleIconId != null) {
                    recordNumbers = new int[itemsIconId.recordNumbers.length + 1];
                    recordNumbers[0] = titleIconId.recordNumber;
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])itemsIconId.recordNumbers, (int)0, (int[])recordNumbers, (int)1, (int)itemsIconId.recordNumbers.length);
                }
                this.mloadIcon = true;
                this.mIconLoader.loadIcons(recordNumbers, this.obtainMessage(1));
            }
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processEventNotify(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process EventNotify");
        TextMessage textMsg = new TextMessage();
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, ctlvs);
        textMsg.text = ValueParser.retrieveAlphaId(ctlv);
        ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs);
        if (ctlv != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            textMsg.iconSelfExplanatory = iconId.selfExplanatory;
        }
        textMsg.responseNeeded = false;
        this.mCmdParams = new DisplayTextParams(cmdDet, textMsg);
        if (iconId != null) {
            this.mloadIcon = true;
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processSetUpEventList(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) {
        CatLog.d(this, "process SetUpEventList");
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.EVENT_LIST, ctlvs);
        if (ctlv != null) {
            try {
                int valueLen;
                byte[] rawValue = ctlv.getRawValue();
                int valueIndex = ctlv.getValueIndex();
                int[] eventList = new int[valueLen];
                int eventValue = -1;
                int i = 0;
                block5: for (valueLen = ctlv.getLength(); valueLen > 0; --valueLen) {
                    eventValue = rawValue[valueIndex] & 0xFF;
                    ++valueIndex;
                    switch (eventValue) {
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 15: {
                            eventList[i] = eventValue;
                            ++i;
                            continue block5;
                        }
                    }
                }
                this.mCmdParams = new SetEventListParams(cmdDet, eventList);
            }
            catch (IndexOutOfBoundsException e) {
                CatLog.e(this, " IndexOutofBoundException in processSetUpEventList");
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processLaunchBrowser(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        LaunchBrowserMode mode;
        CatLog.d(this, "process LaunchBrowser");
        TextMessage confirmMsg = new TextMessage();
        IconId iconId = null;
        String url = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.URL, ctlvs);
        if (ctlv != null) {
            try {
                byte[] rawValue = ctlv.getRawValue();
                int valueIndex = ctlv.getValueIndex();
                int valueLen = ctlv.getLength();
                url = valueLen > 0 ? GsmAlphabet.gsm8BitUnpackedToString(rawValue, valueIndex, valueLen) : null;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        }
        ctlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, ctlvs);
        confirmMsg.text = ValueParser.retrieveAlphaId(ctlv);
        ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs);
        if (ctlv != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            confirmMsg.iconSelfExplanatory = iconId.selfExplanatory;
        }
        switch (cmdDet.commandQualifier) {
            default: {
                mode = LaunchBrowserMode.LAUNCH_IF_NOT_ALREADY_LAUNCHED;
                break;
            }
            case 2: {
                mode = LaunchBrowserMode.USE_EXISTING_BROWSER;
                break;
            }
            case 3: {
                mode = LaunchBrowserMode.LAUNCH_NEW_BROWSER;
            }
        }
        this.mCmdParams = new LaunchBrowserParams(cmdDet, confirmMsg, url, mode);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processPlayTone(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process PlayTone");
        Tone tone = null;
        TextMessage textMsg = new TextMessage();
        Duration duration = null;
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.TONE, ctlvs);
        if (ctlv != null && ctlv.getLength() > 0) {
            try {
                byte[] rawValue = ctlv.getRawValue();
                int valueIndex = ctlv.getValueIndex();
                byte toneVal = rawValue[valueIndex];
                tone = Tone.fromInt(toneVal);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, ctlvs)) != null) {
            textMsg.text = ValueParser.retrieveAlphaId(ctlv);
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.DURATION, ctlvs)) != null) {
            duration = ValueParser.retrieveDuration(ctlv);
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            textMsg.iconSelfExplanatory = iconId.selfExplanatory;
        }
        boolean vibrate = (cmdDet.commandQualifier & 1) != 0;
        textMsg.responseNeeded = false;
        this.mCmdParams = new PlayToneParams(cmdDet, textMsg, tone, duration, vibrate);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processSetupCall(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process SetupCall");
        Iterator<ComprehensionTlv> iter = ctlvs.iterator();
        ComprehensionTlv ctlv = null;
        TextMessage confirmMsg = new TextMessage();
        TextMessage callMsg = new TextMessage();
        IconId confirmIconId = null;
        IconId callIconId = null;
        ctlv = this.searchForNextTag(ComprehensionTlvTag.ALPHA_ID, iter);
        confirmMsg.text = ValueParser.retrieveAlphaId(ctlv);
        ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs);
        if (ctlv != null) {
            confirmIconId = ValueParser.retrieveIconId(ctlv);
            confirmMsg.iconSelfExplanatory = confirmIconId.selfExplanatory;
        }
        if ((ctlv = this.searchForNextTag(ComprehensionTlvTag.ALPHA_ID, iter)) != null) {
            callMsg.text = ValueParser.retrieveAlphaId(ctlv);
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            callIconId = ValueParser.retrieveIconId(ctlv);
            callMsg.iconSelfExplanatory = callIconId.selfExplanatory;
        }
        this.mCmdParams = new CallSetupParams(cmdDet, confirmMsg, callMsg);
        if (confirmIconId != null || callIconId != null) {
            this.mIconLoadState = 2;
            int[] recordNumbers = new int[]{confirmIconId != null ? confirmIconId.recordNumber : -1, callIconId != null ? callIconId.recordNumber : -1};
            this.mIconLoader.loadIcons(recordNumbers, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processProvideLocalInfo(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process ProvideLocalInfo");
        switch (cmdDet.commandQualifier) {
            case 3: {
                CatLog.d(this, "PLI [DTTZ_SETTING]");
                this.mCmdParams = new CommandParams(cmdDet);
                break;
            }
            case 4: {
                CatLog.d(this, "PLI [LANGUAGE_SETTING]");
                this.mCmdParams = new CommandParams(cmdDet);
                break;
            }
            default: {
                CatLog.d(this, "PLI[" + cmdDet.commandQualifier + "] Command Not Supported");
                this.mCmdParams = new CommandParams(cmdDet);
                throw new ResultException(ResultCode.BEYOND_TERMINAL_CAPABILITY);
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processBIPClient(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        AppInterface.CommandType commandType = AppInterface.CommandType.fromInt(cmdDet.typeOfCommand);
        if (commandType != null) {
            CatLog.d(this, "process " + commandType.name());
        }
        TextMessage textMsg = new TextMessage();
        IconId iconId = null;
        ComprehensionTlv ctlv = null;
        boolean has_alpha_id = false;
        ctlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, ctlvs);
        if (ctlv != null) {
            textMsg.text = ValueParser.retrieveAlphaId(ctlv);
            CatLog.d(this, "alpha TLV text=" + textMsg.text);
            has_alpha_id = true;
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            textMsg.iconSelfExplanatory = iconId.selfExplanatory;
        }
        textMsg.responseNeeded = false;
        this.mCmdParams = new BIPClientParams(cmdDet, textMsg, has_alpha_id);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$dispose() {
        this.mIconLoader.dispose();
        this.mIconLoader = null;
        this.mCmdParams = null;
        this.mCaller = null;
        sInstance = null;
    }

    static void __staticInitializer__() {
        sInstance = null;
    }

    static synchronized CommandParamsFactory getInstance(RilMessageDecoder rilMessageDecoder, IccFileHandler iccFileHandler) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$getInstance(com.android.internal.telephony.cat.RilMessageDecoder com.android.internal.telephony.uicc.IccFileHandler ), (RilMessageDecoder)rilMessageDecoder, (IccFileHandler)iccFileHandler);
    }

    private void __constructor__(RilMessageDecoder rilMessageDecoder, IccFileHandler iccFileHandler) {
        this.$$robo$$com_android_internal_telephony_cat_CommandParamsFactory$__constructor__(rilMessageDecoder, iccFileHandler);
    }

    public CommandParamsFactory(RilMessageDecoder rilMessageDecoder, IccFileHandler iccFileHandler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$__constructor__(com.android.internal.telephony.cat.RilMessageDecoder com.android.internal.telephony.uicc.IccFileHandler ), this, rilMessageDecoder, iccFileHandler);
    }

    private CommandDetails processCommandDetails(List<ComprehensionTlv> list) {
        return InvokeDynamicSupport.bootstrap("processCommandDetails", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processCommandDetails(java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, list);
    }

    void make(BerTlv berTlv) {
        InvokeDynamicSupport.bootstrap("make", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$make(com.android.internal.telephony.cat.BerTlv ), this, berTlv);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$handleMessage(android.os.Message ), this, message);
    }

    private ResultCode setIcons(Object object) {
        return InvokeDynamicSupport.bootstrap("setIcons", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$setIcons(java.lang.Object ), this, object);
    }

    private void sendCmdParams(ResultCode resultCode) {
        InvokeDynamicSupport.bootstrap("sendCmdParams", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$sendCmdParams(com.android.internal.telephony.cat.ResultCode ), this, resultCode);
    }

    private ComprehensionTlv searchForTag(ComprehensionTlvTag comprehensionTlvTag, List<ComprehensionTlv> list) {
        return InvokeDynamicSupport.bootstrap("searchForTag", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$searchForTag(com.android.internal.telephony.cat.ComprehensionTlvTag java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, comprehensionTlvTag, list);
    }

    private ComprehensionTlv searchForNextTag(ComprehensionTlvTag comprehensionTlvTag, Iterator<ComprehensionTlv> iterator) {
        return InvokeDynamicSupport.bootstrap("searchForNextTag", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$searchForNextTag(com.android.internal.telephony.cat.ComprehensionTlvTag java.util.Iterator<com.android.internal.telephony.cat.ComprehensionTlv> ), this, comprehensionTlvTag, iterator);
    }

    private boolean processDisplayText(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        return (boolean)InvokeDynamicSupport.bootstrap("processDisplayText", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processDisplayText(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processSetUpIdleModeText(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        return (boolean)InvokeDynamicSupport.bootstrap("processSetUpIdleModeText", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processSetUpIdleModeText(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processGetInkey(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        return (boolean)InvokeDynamicSupport.bootstrap("processGetInkey", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processGetInkey(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processGetInput(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        return (boolean)InvokeDynamicSupport.bootstrap("processGetInput", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processGetInput(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processRefresh(CommandDetails commandDetails, List<ComprehensionTlv> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("processRefresh", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processRefresh(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processSelectItem(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        return (boolean)InvokeDynamicSupport.bootstrap("processSelectItem", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processSelectItem(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processEventNotify(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        return (boolean)InvokeDynamicSupport.bootstrap("processEventNotify", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processEventNotify(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processSetUpEventList(CommandDetails commandDetails, List<ComprehensionTlv> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("processSetUpEventList", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processSetUpEventList(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processLaunchBrowser(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        return (boolean)InvokeDynamicSupport.bootstrap("processLaunchBrowser", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processLaunchBrowser(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processPlayTone(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        return (boolean)InvokeDynamicSupport.bootstrap("processPlayTone", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processPlayTone(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processSetupCall(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        return (boolean)InvokeDynamicSupport.bootstrap("processSetupCall", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processSetupCall(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processProvideLocalInfo(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        return (boolean)InvokeDynamicSupport.bootstrap("processProvideLocalInfo", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processProvideLocalInfo(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    private boolean processBIPClient(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        return (boolean)InvokeDynamicSupport.bootstrap("processBIPClient", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$processBIPClient(com.android.internal.telephony.cat.CommandDetails java.util.List<com.android.internal.telephony.cat.ComprehensionTlv> ), this, commandDetails, list);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_cat_CommandParamsFactory$dispose(), this);
    }

    static {
        RobolectricInternals.classInitializing(CommandParamsFactory.class);
    }

    public /* synthetic */ CommandParamsFactory() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CommandParamsFactory)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

