/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.ImageDescriptor;
import com.android.internal.telephony.uicc.IccFileHandler;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IconLoader
extends Handler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int mState;
    private ImageDescriptor mId;
    private Bitmap mCurrentIcon;
    private int mRecordNumber;
    private IccFileHandler mSimFH;
    private Message mEndMsg;
    private byte[] mIconData;
    private int[] mRecordNumbers;
    private int mCurrentRecordIndex;
    private Bitmap[] mIcons;
    private HashMap<Integer, Bitmap> mIconsCache;
    private static IconLoader sLoader;
    private static HandlerThread sThread;
    private static int STATE_SINGLE_ICON = 1;
    private static int STATE_MULTI_ICONS = 2;
    private static int EVENT_READ_EF_IMG_RECOED_DONE = 1;
    private static int EVENT_READ_ICON_DONE = 2;
    private static int EVENT_READ_CLUT_DONE = 3;
    private static int CLUT_LOCATION_OFFSET = 4;
    private static int CLUT_ENTRY_SIZE = 3;

    private void $$robo$$com_android_internal_telephony_cat_IconLoader$__constructor__(Looper looper, IccFileHandler fh) {
        this.mState = 1;
        this.mId = null;
        this.mCurrentIcon = null;
        this.mSimFH = null;
        this.mEndMsg = null;
        this.mIconData = null;
        this.mRecordNumbers = null;
        this.mCurrentRecordIndex = 0;
        this.mIcons = null;
        this.mIconsCache = null;
        this.mSimFH = fh;
        this.mIconsCache = new HashMap(50);
    }

    private static final IconLoader $$robo$$com_android_internal_telephony_cat_IconLoader$getInstance(Handler caller, IccFileHandler fh) {
        if (sLoader != null) {
            return sLoader;
        }
        if (fh != null) {
            sThread = new HandlerThread("Cat Icon Loader");
            sThread.start();
            return new IconLoader(sThread.getLooper(), fh);
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_cat_IconLoader$loadIcons(int[] recordNumbers, Message msg) {
        if (recordNumbers == null || recordNumbers.length == 0 || msg == null) {
            return;
        }
        this.mEndMsg = msg;
        this.mIcons = new Bitmap[recordNumbers.length];
        this.mRecordNumbers = recordNumbers;
        this.mCurrentRecordIndex = 0;
        this.mState = 2;
        this.startLoadingIcon(recordNumbers[0]);
    }

    private final void $$robo$$com_android_internal_telephony_cat_IconLoader$loadIcon(int recordNumber, Message msg) {
        if (msg == null) {
            return;
        }
        this.mEndMsg = msg;
        this.mState = 1;
        this.startLoadingIcon(recordNumber);
    }

    private final void $$robo$$com_android_internal_telephony_cat_IconLoader$startLoadingIcon(int recordNumber) {
        this.mId = null;
        this.mIconData = null;
        this.mCurrentIcon = null;
        this.mRecordNumber = recordNumber;
        if (this.mIconsCache.containsKey(recordNumber)) {
            this.mCurrentIcon = this.mIconsCache.get(recordNumber);
            this.postIcon();
            return;
        }
        this.readId();
    }

    private final void $$robo$$com_android_internal_telephony_cat_IconLoader$handleMessage(Message msg) {
        try {
            switch (msg.what) {
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (this.handleImageDescriptor((byte[])ar.result)) {
                        this.readIconData();
                        break;
                    }
                    throw new Exception("Unable to parse image descriptor");
                }
                case 2: {
                    CatLog.d(this, "load icon done");
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] rawData = (byte[])ar.result;
                    if (this.mId.mCodingScheme == 17) {
                        this.mCurrentIcon = IconLoader.parseToBnW(rawData, rawData.length);
                        this.mIconsCache.put(this.mRecordNumber, this.mCurrentIcon);
                        this.postIcon();
                        break;
                    }
                    if (this.mId.mCodingScheme == 33) {
                        this.mIconData = rawData;
                        this.readClut();
                        break;
                    }
                    CatLog.d(this, "else  /postIcon ");
                    this.postIcon();
                    break;
                }
                case 3: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] clut = (byte[])ar.result;
                    this.mCurrentIcon = IconLoader.parseToRGB(this.mIconData, this.mIconData.length, false, clut);
                    this.mIconsCache.put(this.mRecordNumber, this.mCurrentIcon);
                    this.postIcon();
                }
            }
        }
        catch (Exception e) {
            CatLog.d(this, "Icon load failed");
            this.postIcon();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_IconLoader$handleImageDescriptor(byte[] rawData) {
        this.mId = ImageDescriptor.parse(rawData, 1);
        return this.mId != null;
    }

    private final void $$robo$$com_android_internal_telephony_cat_IconLoader$readClut() {
        int length = this.mIconData[3] * 3;
        Message msg = this.obtainMessage(3);
        this.mSimFH.loadEFImgTransparent(this.mId.mImageId, this.mIconData[4], this.mIconData[5], length, msg);
    }

    private final void $$robo$$com_android_internal_telephony_cat_IconLoader$readId() {
        if (this.mRecordNumber < 0) {
            this.mCurrentIcon = null;
            this.postIcon();
            return;
        }
        Message msg = this.obtainMessage(1);
        this.mSimFH.loadEFImgLinearFixed(this.mRecordNumber, msg);
    }

    private final void $$robo$$com_android_internal_telephony_cat_IconLoader$readIconData() {
        Message msg = this.obtainMessage(2);
        this.mSimFH.loadEFImgTransparent(this.mId.mImageId, 0, 0, this.mId.mLength, msg);
    }

    private final void $$robo$$com_android_internal_telephony_cat_IconLoader$postIcon() {
        if (this.mState == 1) {
            this.mEndMsg.obj = this.mCurrentIcon;
            this.mEndMsg.sendToTarget();
        } else if (this.mState == 2) {
            this.mIcons[this.mCurrentRecordIndex++] = this.mCurrentIcon;
            if (this.mCurrentRecordIndex < this.mRecordNumbers.length) {
                this.startLoadingIcon(this.mRecordNumbers[this.mCurrentRecordIndex]);
            } else {
                this.mEndMsg.obj = this.mIcons;
                this.mEndMsg.sendToTarget();
            }
        }
    }

    private static final Bitmap $$robo$$com_android_internal_telephony_cat_IconLoader$parseToBnW(byte[] data, int length) {
        int valueIndex = 0;
        int width = data[valueIndex++] & 0xFF;
        int height = data[valueIndex++] & 0xFF;
        int numOfPixels = width * height;
        int[] pixels = new int[numOfPixels];
        int pixelIndex = 0;
        int bitIndex = 7;
        byte currentByte = 0;
        while (pixelIndex < numOfPixels) {
            if (pixelIndex % 8 == 0) {
                currentByte = data[valueIndex++];
                bitIndex = 7;
            }
            pixels[pixelIndex++] = IconLoader.bitToBnW(currentByte >> bitIndex-- & 1);
        }
        if (pixelIndex != numOfPixels) {
            CatLog.d("IconLoader", "parseToBnW; size error");
        }
        return Bitmap.createBitmap(pixels, width, height, Bitmap.Config.ARGB_8888);
    }

    private static final int $$robo$$com_android_internal_telephony_cat_IconLoader$bitToBnW(int bit) {
        if (bit == 1) {
            return -1;
        }
        return -16777216;
    }

    private static final Bitmap $$robo$$com_android_internal_telephony_cat_IconLoader$parseToRGB(byte[] data, int length, boolean transparency, byte[] clut) {
        boolean bitsOverlaps;
        int bitsStartOffset;
        int valueIndex = 0;
        int width = data[valueIndex++] & 0xFF;
        int height = data[valueIndex++] & 0xFF;
        int bitsPerImg = data[valueIndex++] & 0xFF;
        int numOfClutEntries = data[valueIndex++] & 0xFF;
        if (transparency) {
            clut[numOfClutEntries - 1] = 0;
        }
        int numOfPixels = width * height;
        int[] pixels = new int[numOfPixels];
        valueIndex = 6;
        int pixelIndex = 0;
        int bitIndex = bitsStartOffset = 8 - bitsPerImg;
        byte currentByte = data[valueIndex++];
        int mask = IconLoader.getMask(bitsPerImg);
        boolean bl = bitsOverlaps = 8 % bitsPerImg == 0;
        while (pixelIndex < numOfPixels) {
            if (bitIndex < 0) {
                currentByte = data[valueIndex++];
                bitIndex = bitsOverlaps ? bitsStartOffset : bitIndex * -1;
            }
            int clutEntry = currentByte >> bitIndex & mask;
            int clutIndex = clutEntry * 3;
            pixels[pixelIndex++] = Color.rgb(clut[clutIndex], clut[clutIndex + 1], clut[clutIndex + 2]);
            bitIndex -= bitsPerImg;
        }
        return Bitmap.createBitmap(pixels, width, height, Bitmap.Config.ARGB_8888);
    }

    private static final int $$robo$$com_android_internal_telephony_cat_IconLoader$getMask(int numOfBits) {
        int mask = 0;
        switch (numOfBits) {
            case 1: {
                mask = 1;
                break;
            }
            case 2: {
                mask = 3;
                break;
            }
            case 3: {
                mask = 7;
                break;
            }
            case 4: {
                mask = 15;
                break;
            }
            case 5: {
                mask = 31;
                break;
            }
            case 6: {
                mask = 63;
                break;
            }
            case 7: {
                mask = 127;
                break;
            }
            case 8: {
                mask = 255;
            }
        }
        return mask;
    }

    private final void $$robo$$com_android_internal_telephony_cat_IconLoader$dispose() {
        this.mSimFH = null;
        if (sThread != null) {
            sThread.quit();
            sThread = null;
        }
        this.mIconsCache = null;
        sLoader = null;
    }

    static void __staticInitializer__() {
        sLoader = null;
        sThread = null;
    }

    private void __constructor__(Looper looper, IccFileHandler iccFileHandler) {
        this.$$robo$$com_android_internal_telephony_cat_IconLoader$__constructor__(looper, iccFileHandler);
    }

    public IconLoader(Looper looper, IccFileHandler iccFileHandler) {
        super(looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cat_IconLoader$__constructor__(android.os.Looper com.android.internal.telephony.uicc.IccFileHandler ), this, looper, iccFileHandler);
    }

    static IconLoader getInstance(Handler handler, IccFileHandler iccFileHandler) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_cat_IconLoader$getInstance(android.os.Handler com.android.internal.telephony.uicc.IccFileHandler ), (Handler)handler, (IccFileHandler)iccFileHandler);
    }

    void loadIcons(int[] nArray, Message message) {
        InvokeDynamicSupport.bootstrap("loadIcons", $$robo$$com_android_internal_telephony_cat_IconLoader$loadIcons(int[] android.os.Message ), this, nArray, message);
    }

    void loadIcon(int n, Message message) {
        InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$com_android_internal_telephony_cat_IconLoader$loadIcon(int android.os.Message ), this, n, message);
    }

    private void startLoadingIcon(int n) {
        InvokeDynamicSupport.bootstrap("startLoadingIcon", $$robo$$com_android_internal_telephony_cat_IconLoader$startLoadingIcon(int ), this, n);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_cat_IconLoader$handleMessage(android.os.Message ), this, message);
    }

    private boolean handleImageDescriptor(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleImageDescriptor", $$robo$$com_android_internal_telephony_cat_IconLoader$handleImageDescriptor(byte[] ), this, byArray);
    }

    private void readClut() {
        InvokeDynamicSupport.bootstrap("readClut", $$robo$$com_android_internal_telephony_cat_IconLoader$readClut(), this);
    }

    private void readId() {
        InvokeDynamicSupport.bootstrap("readId", $$robo$$com_android_internal_telephony_cat_IconLoader$readId(), this);
    }

    private void readIconData() {
        InvokeDynamicSupport.bootstrap("readIconData", $$robo$$com_android_internal_telephony_cat_IconLoader$readIconData(), this);
    }

    private void postIcon() {
        InvokeDynamicSupport.bootstrap("postIcon", $$robo$$com_android_internal_telephony_cat_IconLoader$postIcon(), this);
    }

    public static Bitmap parseToBnW(byte[] byArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("parseToBnW", $$robo$$com_android_internal_telephony_cat_IconLoader$parseToBnW(byte[] int ), (byte[])byArray, (int)n);
    }

    private static int bitToBnW(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bitToBnW", $$robo$$com_android_internal_telephony_cat_IconLoader$bitToBnW(int ), (int)n);
    }

    public static Bitmap parseToRGB(byte[] byArray, int n, boolean bl, byte[] byArray2) {
        return InvokeDynamicSupport.bootstrapStatic("parseToRGB", $$robo$$com_android_internal_telephony_cat_IconLoader$parseToRGB(byte[] int boolean byte[] ), (byte[])byArray, (int)n, (boolean)bl, (byte[])byArray2);
    }

    private static int getMask(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMask", $$robo$$com_android_internal_telephony_cat_IconLoader$getMask(int ), (int)n);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_cat_IconLoader$dispose(), this);
    }

    static {
        RobolectricInternals.classInitializing(IconLoader.class);
    }

    public /* synthetic */ IconLoader() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IconLoader)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

