/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.android.ims.internal.IImsServiceController;
import com.android.ims.internal.IImsServiceFeatureListener;
import com.android.internal.telephony.ims.ImsServiceController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsResolver
implements ImsServiceController.ImsServiceControllerCallbacks,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ImsResolver";
    public static String SERVICE_INTERFACE = "android.telephony.ims.ImsService";
    public static String METADATA_EMERGENCY_MMTEL_FEATURE = "android.telephony.ims.EMERGENCY_MMTEL_FEATURE";
    public static String METADATA_MMTEL_FEATURE = "android.telephony.ims.MMTEL_FEATURE";
    public static String METADATA_RCS_FEATURE = "android.telephony.ims.RCS_FEATURE";
    private static int HANDLER_ADD_PACKAGE = 0;
    private static int HANDLER_REMOVE_PACKAGE = 1;
    private static int HANDLER_CONFIG_CHANGED = 2;
    private BroadcastReceiver mAppChangedReceiver;
    private BroadcastReceiver mConfigChangedReceiver;
    private SubscriptionManagerProxy mSubscriptionManagerProxy;
    private ImsServiceControllerFactory mImsServiceControllerFactory;
    private CarrierConfigManager mCarrierConfigManager;
    private Context mContext;
    private Object mBoundServicesLock;
    private int mNumSlots;
    private Handler mHandler;
    private String mDeviceService;
    private String[] mCarrierServices;
    private List<SparseArray<ImsServiceController>> mBoundImsServicesByFeature;
    private Set<ImsServiceInfo> mInstalledServicesCache;
    private Set<ImsServiceController> mActiveControllers;

    private void $$robo$$com_android_internal_telephony_ims_ImsResolver$__constructor__(Context context2, String defaultImsPackageName, int numSlots) {
        this.mAppChangedReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsResolver this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsResolver_1$__constructor__(ImsResolver this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_ims_ImsResolver_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                String packageName = intent.getData().getSchemeSpecificPart();
                switch (action) {
                    case "android.intent.action.PACKAGE_ADDED": 
                    case "android.intent.action.PACKAGE_CHANGED": {
                        this.this$0.mHandler.obtainMessage(0, packageName).sendToTarget();
                        break;
                    }
                    case "android.intent.action.PACKAGE_REMOVED": {
                        this.this$0.mHandler.obtainMessage(1, packageName).sendToTarget();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }

            private void __constructor__(ImsResolver imsResolver) {
                this.$$robo$$com_android_internal_telephony_ims_ImsResolver_1$__constructor__(imsResolver);
            }
            {
                this.this$0 = imsResolver;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_1$__constructor__(com.android.internal.telephony.ims.ImsResolver ), this, imsResolver);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_ims_ImsResolver_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConfigChangedReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsResolver this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsResolver_2$__constructor__(ImsResolver this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_ims_ImsResolver_2$onReceive(Context context, Intent intent) {
                int subId = intent.getIntExtra("subscription", -1);
                if (subId == -1) {
                    Log.i("ImsResolver", "Received SIM change for invalid sub id.");
                    return;
                }
                Log.i("ImsResolver", "Received Carrier Config Changed for SubId: " + subId);
                this.this$0.mHandler.obtainMessage(2, subId).sendToTarget();
            }

            private void __constructor__(ImsResolver imsResolver) {
                this.$$robo$$com_android_internal_telephony_ims_ImsResolver_2$__constructor__(imsResolver);
            }
            {
                this.this$0 = imsResolver;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_2$__constructor__(com.android.internal.telephony.ims.ImsResolver ), this, imsResolver);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_ims_ImsResolver_2$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mSubscriptionManagerProxy = new SubscriptionManagerProxy(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsResolver this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsResolver_3$__constructor__(ImsResolver this$0) {
            }

            private final int $$robo$$com_android_internal_telephony_ims_ImsResolver_3$getSubId(int slotId) {
                int[] subIds = SubscriptionManager.getSubId(slotId);
                if (subIds != null) {
                    return subIds[0];
                }
                return -1;
            }

            private final int $$robo$$com_android_internal_telephony_ims_ImsResolver_3$getSlotIndex(int subId) {
                return SubscriptionManager.getSlotIndex(subId);
            }

            private void __constructor__(ImsResolver imsResolver) {
                this.$$robo$$com_android_internal_telephony_ims_ImsResolver_3$__constructor__(imsResolver);
            }
            {
                this.this$0 = imsResolver;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_3$__constructor__(com.android.internal.telephony.ims.ImsResolver ), this, imsResolver);
            }

            @Override
            public int getSubId(int n) {
                return (int)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$com_android_internal_telephony_ims_ImsResolver_3$getSubId(int ), this, n);
            }

            @Override
            public int getSlotIndex(int n) {
                return (int)InvokeDynamicSupport.bootstrap("getSlotIndex", $$robo$$com_android_internal_telephony_ims_ImsResolver_3$getSlotIndex(int ), this, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsServiceControllerFactory = (context, componentName) -> new ImsServiceController(context, componentName, this);
        this.mBoundServicesLock = new Object();
        this.mHandler = new Handler(Looper.getMainLooper(), msg -> {
            switch (msg.what) {
                case 0: {
                    String packageName = (String)msg.obj;
                    this.maybeAddedImsService(packageName);
                    break;
                }
                case 1: {
                    String packageName = (String)msg.obj;
                    this.maybeRemovedImsService(packageName);
                    break;
                }
                case 2: {
                    int subId = (Integer)msg.obj;
                    this.maybeRebindService(subId);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        this.mInstalledServicesCache = new ArraySet<ImsServiceInfo>();
        this.mActiveControllers = new ArraySet<ImsServiceController>();
        this.mContext = context2;
        this.mDeviceService = defaultImsPackageName;
        this.mNumSlots = numSlots;
        this.mCarrierConfigManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        this.mCarrierServices = new String[numSlots];
        this.mBoundImsServicesByFeature = Stream.generate(SparseArray::new).limit(this.mNumSlots).collect(Collectors.toList());
        IntentFilter appChangedFilter = new IntentFilter();
        appChangedFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        appChangedFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        appChangedFilter.addAction("android.intent.action.PACKAGE_ADDED");
        appChangedFilter.addDataScheme("package");
        context2.registerReceiverAsUser(this.mAppChangedReceiver, UserHandle.ALL, appChangedFilter, null, null);
        context2.registerReceiver(this.mConfigChangedReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$setSubscriptionManagerProxy(SubscriptionManagerProxy proxy) {
        this.mSubscriptionManagerProxy = proxy;
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$setImsServiceControllerFactory(ImsServiceControllerFactory factory) {
        this.mImsServiceControllerFactory = factory;
    }

    private final Handler $$robo$$com_android_internal_telephony_ims_ImsResolver$getHandler() {
        return this.mHandler;
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$populateCacheAndStartBind() {
        Log.i("ImsResolver", "Initializing cache and binding.");
        this.mHandler.obtainMessage(2, -1).sendToTarget();
        this.mHandler.obtainMessage(0, null).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IImsServiceController $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceControllerAndListen(int slotId, int feature, IImsServiceFeatureListener callback) {
        ImsServiceController controller;
        if (slotId < 0 || slotId >= this.mNumSlots || feature <= -1 || feature >= 3) {
            return null;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                return null;
            }
            controller = services.get(feature);
        }
        if (controller != null) {
            controller.addImsServiceFeatureListener(callback);
            return controller.getImsServiceController();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$putImsController(int slotId, int feature, ImsServiceController controller) {
        if (slotId < 0 || slotId >= this.mNumSlots || feature <= -1 || feature >= 3) {
            Log.w("ImsResolver", "putImsController received invalid parameters - slot: " + slotId + ", feature: " + feature);
            return;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                services = new SparseArray();
                this.mBoundImsServicesByFeature.add(slotId, services);
            }
            Log.i("ImsResolver", "ImsServiceController added on slot: " + slotId + " with feature: " + feature + " using package: " + controller.getComponentName());
            services.put(feature, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ImsServiceController $$robo$$com_android_internal_telephony_ims_ImsResolver$removeImsController(int slotId, int feature) {
        if (slotId < 0 || slotId >= this.mNumSlots || feature <= -1 || feature >= 3) {
            Log.w("ImsResolver", "removeImsController received invalid parameters - slot: " + slotId + ", feature: " + feature);
            return null;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                return null;
            }
            ImsServiceController c = services.get(feature, null);
            if (c != null) {
                Log.i("ImsResolver", "ImsServiceController removed on slot: " + slotId + " with feature: " + feature + " using package: " + c.getComponentName());
                services.remove(feature);
            }
            return c;
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeAddedImsService(String packageName) {
        Log.d("ImsResolver", "maybeAddedImsService, packageName: " + packageName);
        List<ImsServiceInfo> infos = this.getImsServiceInfo(packageName);
        ArrayList<ImsServiceInfo> newlyAddedInfos = new ArrayList<ImsServiceInfo>();
        for (ImsServiceInfo info : infos) {
            Optional<ImsServiceInfo> match = this.getInfoByComponentName(this.mInstalledServicesCache, info.name);
            if (match.isPresent()) {
                Log.i("ImsResolver", "Updating features in cached ImsService: " + info.name);
                Log.d("ImsResolver", "Updating features - Old features: " + match.get().supportedFeatures + " new features: " + info.supportedFeatures);
                match.get().supportedFeatures = info.supportedFeatures;
                this.updateImsServiceFeatures(info);
                continue;
            }
            Log.i("ImsResolver", "Adding newly added ImsService to cache: " + info.name);
            this.mInstalledServicesCache.add(info);
            newlyAddedInfos.add(info);
        }
        for (ImsServiceInfo info : newlyAddedInfos) {
            if (this.isActiveCarrierService(info)) {
                this.bindNewImsService(info);
                this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
                continue;
            }
            if (!this.isDeviceService(info)) continue;
            this.bindNewImsService(info);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeRemovedImsService(String packageName) {
        Optional<ImsServiceInfo> match = this.getInfoByPackageName(this.mInstalledServicesCache, packageName);
        if (match.isPresent()) {
            this.mInstalledServicesCache.remove(match.get());
            Log.i("ImsResolver", "Removing ImsService: " + match.get().name);
            this.unbindImsService(match.get());
            this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_ImsResolver$isActiveCarrierService(ImsServiceInfo info) {
        for (int i = 0; i < this.mNumSlots; ++i) {
            if (!TextUtils.equals(this.mCarrierServices[i], info.name.getPackageName())) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_ImsResolver$isDeviceService(ImsServiceInfo info) {
        return TextUtils.equals(this.mDeviceService, info.name.getPackageName());
    }

    private final int $$robo$$com_android_internal_telephony_ims_ImsResolver$getSlotForActiveCarrierService(ImsServiceInfo info) {
        for (int i = 0; i < this.mNumSlots; ++i) {
            if (!TextUtils.equals(this.mCarrierServices[i], info.name.getPackageName())) continue;
            return i;
        }
        return -1;
    }

    private final Optional<ImsServiceController> $$robo$$com_android_internal_telephony_ims_ImsResolver$getControllerByServiceInfo(Set<ImsServiceController> searchSet, ImsServiceInfo matchValue) {
        return searchSet.stream().filter(c -> Objects.equals(c.getComponentName(), matchValue.name)).findFirst();
    }

    private final Optional<ImsServiceInfo> $$robo$$com_android_internal_telephony_ims_ImsResolver$getInfoByPackageName(Set<ImsServiceInfo> searchSet, String matchValue) {
        return searchSet.stream().filter(i -> Objects.equals(i.name.getPackageName(), matchValue)).findFirst();
    }

    private final Optional<ImsServiceInfo> $$robo$$com_android_internal_telephony_ims_ImsResolver$getInfoByComponentName(Set<ImsServiceInfo> searchSet, ComponentName matchValue) {
        return searchSet.stream().filter(i -> Objects.equals(i.name, matchValue)).findFirst();
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$updateImsServiceFeatures(ImsServiceInfo newInfo) {
        if (newInfo == null) {
            return;
        }
        Optional<ImsServiceController> o = this.getControllerByServiceInfo(this.mActiveControllers, newInfo);
        if (o.isPresent()) {
            Log.i("ImsResolver", "Updating features for ImsService: " + o.get().getComponentName());
            HashSet<Pair<Integer, Integer>> features = this.calculateFeaturesToCreate(newInfo);
            try {
                if (features.size() > 0) {
                    Log.d("ImsResolver", "Updating Features - New Features: " + features);
                    o.get().changeImsServiceFeatures(features);
                    if (this.isActiveCarrierService(newInfo) && !TextUtils.equals(newInfo.name.getPackageName(), this.mDeviceService)) {
                        Log.i("ImsResolver", "Updating device default");
                        this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
                    }
                } else {
                    Log.i("ImsResolver", "Unbinding: features = 0 for ImsService: " + o.get().getComponentName());
                    o.get().unbind();
                }
            }
            catch (RemoteException e) {
                Log.e("ImsResolver", "updateImsServiceFeatures: Remote Exception: " + e.getMessage());
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$bindNewImsService(ImsServiceInfo info) {
        if (info == null) {
            return;
        }
        ImsServiceController controller = this.mImsServiceControllerFactory.get(this.mContext, info.name);
        HashSet<Pair<Integer, Integer>> features = this.calculateFeaturesToCreate(info);
        if (features.size() > 0) {
            Log.i("ImsResolver", "Binding ImsService: " + controller.getComponentName() + " with features: " + features);
            controller.bind(features);
            this.mActiveControllers.add(controller);
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$unbindImsService(ImsServiceInfo info) {
        if (info == null) {
            return;
        }
        Optional<ImsServiceController> o = this.getControllerByServiceInfo(this.mActiveControllers, info);
        if (o.isPresent()) {
            try {
                Log.i("ImsResolver", "Unbinding ImsService: " + o.get().getComponentName());
                o.get().unbind();
            }
            catch (RemoteException e) {
                Log.e("ImsResolver", "unbindImsService: Remote Exception: " + e.getMessage());
            }
            this.mActiveControllers.remove(o.get());
        }
    }

    private final HashSet<Pair<Integer, Integer>> $$robo$$com_android_internal_telephony_ims_ImsResolver$calculateFeaturesToCreate(ImsServiceInfo info) {
        HashSet<Pair<Integer, Integer>> imsFeaturesBySlot = new HashSet<Pair<Integer, Integer>>();
        int slotId = this.getSlotForActiveCarrierService(info);
        if (slotId != -1) {
            imsFeaturesBySlot.addAll(info.supportedFeatures.stream().map(feature -> new Pair<Integer, Integer>(slotId, (Integer)feature)).collect(Collectors.toList()));
        } else if (this.isDeviceService(info)) {
            for (int i = 0; i < this.mNumSlots; ++i) {
                int currSlotId = i;
                ImsServiceInfo carrierImsInfo = this.getImsServiceInfoFromCache(this.mCarrierServices[i]);
                if (carrierImsInfo == null) {
                    imsFeaturesBySlot.addAll(info.supportedFeatures.stream().map(feature -> new Pair<Integer, Integer>(currSlotId, (Integer)feature)).collect(Collectors.toList()));
                    continue;
                }
                HashSet<Integer> deviceFeatures = new HashSet<Integer>(info.supportedFeatures);
                deviceFeatures.removeAll(carrierImsInfo.supportedFeatures);
                imsFeaturesBySlot.addAll(deviceFeatures.stream().map(feature -> new Pair<Integer, Integer>(currSlotId, (Integer)feature)).collect(Collectors.toList()));
            }
        }
        return imsFeaturesBySlot;
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$imsServiceFeatureCreated(int slotId, int feature, ImsServiceController controller) {
        this.putImsController(slotId, feature, controller);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$imsServiceFeatureRemoved(int slotId, int feature, ImsServiceController controller) {
        this.removeImsController(slotId, feature);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeRebindService(int subId) {
        if (subId <= -1) {
            for (int i = 0; i < this.mNumSlots; ++i) {
                subId = this.mSubscriptionManagerProxy.getSubId(i);
                this.updateBoundCarrierServices(subId);
            }
        } else {
            this.updateBoundCarrierServices(subId);
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$updateBoundCarrierServices(int subId) {
        int slotId = this.mSubscriptionManagerProxy.getSlotIndex(subId);
        String newPackageName = this.mCarrierConfigManager.getConfigForSubId(subId).getString("config_ims_package_override_string", null);
        if (slotId != -1 && slotId < this.mNumSlots) {
            String oldPackageName = this.mCarrierServices[slotId];
            this.mCarrierServices[slotId] = newPackageName;
            if (!TextUtils.equals(newPackageName, oldPackageName)) {
                Log.i("ImsResolver", "Carrier Config updated, binding new ImsService");
                this.unbindImsService(this.getImsServiceInfoFromCache(oldPackageName));
                this.bindNewImsService(this.getImsServiceInfoFromCache(newPackageName));
                this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
            }
        }
    }

    private final ImsServiceInfo $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceInfoFromCache(String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return null;
        }
        Optional<ImsServiceInfo> infoFilter = this.getInfoByPackageName(this.mInstalledServicesCache, packageName);
        if (infoFilter.isPresent()) {
            return infoFilter.get();
        }
        return null;
    }

    private final List<ImsServiceInfo> $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceInfo(String packageName) {
        ArrayList<ImsServiceInfo> infos = new ArrayList<ImsServiceInfo>();
        Intent serviceIntent = new Intent("android.telephony.ims.ImsService");
        serviceIntent.setPackage(packageName);
        PackageManager packageManager = this.mContext.getPackageManager();
        for (ResolveInfo entry : packageManager.queryIntentServicesAsUser(serviceIntent, 128, this.mContext.getUserId())) {
            ServiceInfo serviceInfo = entry.serviceInfo;
            if (serviceInfo == null) continue;
            ImsServiceInfo info = new ImsServiceInfo();
            info.name = new ComponentName(serviceInfo.packageName, serviceInfo.name);
            info.supportedFeatures = new HashSet<Integer>(3);
            if (serviceInfo.metaData != null) {
                if (serviceInfo.metaData.getBoolean("android.telephony.ims.EMERGENCY_MMTEL_FEATURE", false)) {
                    info.supportedFeatures.add(0);
                }
                if (serviceInfo.metaData.getBoolean("android.telephony.ims.MMTEL_FEATURE", false)) {
                    info.supportedFeatures.add(1);
                }
                if (serviceInfo.metaData.getBoolean("android.telephony.ims.RCS_FEATURE", false)) {
                    info.supportedFeatures.add(2);
                }
            }
            if (TextUtils.equals(serviceInfo.permission, "android.permission.BIND_IMS_SERVICE")) {
                Log.d("ImsResolver", "ImsService added to cache: " + info.name + " with features: " + info.supportedFeatures);
                infos.add(info);
                continue;
            }
            Log.w("ImsResolver", "ImsService does not have BIND_IMS_SERVICE permission: " + info.name);
        }
        return infos;
    }

    private void __constructor__(Context context, String string2, int n) {
        this.$$robo$$com_android_internal_telephony_ims_ImsResolver$__constructor__(context, string2, n);
    }

    public ImsResolver(Context context, String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver$__constructor__(android.content.Context java.lang.String int ), this, context, string2, n);
    }

    public void setSubscriptionManagerProxy(SubscriptionManagerProxy subscriptionManagerProxy) {
        InvokeDynamicSupport.bootstrap("setSubscriptionManagerProxy", $$robo$$com_android_internal_telephony_ims_ImsResolver$setSubscriptionManagerProxy(com.android.internal.telephony.ims.ImsResolver$SubscriptionManagerProxy ), this, subscriptionManagerProxy);
    }

    public void setImsServiceControllerFactory(ImsServiceControllerFactory imsServiceControllerFactory) {
        InvokeDynamicSupport.bootstrap("setImsServiceControllerFactory", $$robo$$com_android_internal_telephony_ims_ImsResolver$setImsServiceControllerFactory(com.android.internal.telephony.ims.ImsResolver$ImsServiceControllerFactory ), this, imsServiceControllerFactory);
    }

    public Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$com_android_internal_telephony_ims_ImsResolver$getHandler(), this);
    }

    public void populateCacheAndStartBind() {
        InvokeDynamicSupport.bootstrap("populateCacheAndStartBind", $$robo$$com_android_internal_telephony_ims_ImsResolver$populateCacheAndStartBind(), this);
    }

    public IImsServiceController getImsServiceControllerAndListen(int n, int n2, IImsServiceFeatureListener iImsServiceFeatureListener) {
        return InvokeDynamicSupport.bootstrap("getImsServiceControllerAndListen", $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceControllerAndListen(int int com.android.ims.internal.IImsServiceFeatureListener ), this, n, n2, iImsServiceFeatureListener);
    }

    private void putImsController(int n, int n2, ImsServiceController imsServiceController) {
        InvokeDynamicSupport.bootstrap("putImsController", $$robo$$com_android_internal_telephony_ims_ImsResolver$putImsController(int int com.android.internal.telephony.ims.ImsServiceController ), this, n, n2, imsServiceController);
    }

    private ImsServiceController removeImsController(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("removeImsController", $$robo$$com_android_internal_telephony_ims_ImsResolver$removeImsController(int int ), this, n, n2);
    }

    private void maybeAddedImsService(String string2) {
        InvokeDynamicSupport.bootstrap("maybeAddedImsService", $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeAddedImsService(java.lang.String ), this, string2);
    }

    private boolean maybeRemovedImsService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("maybeRemovedImsService", $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeRemovedImsService(java.lang.String ), this, string2);
    }

    private boolean isActiveCarrierService(ImsServiceInfo imsServiceInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("isActiveCarrierService", $$robo$$com_android_internal_telephony_ims_ImsResolver$isActiveCarrierService(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private boolean isDeviceService(ImsServiceInfo imsServiceInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceService", $$robo$$com_android_internal_telephony_ims_ImsResolver$isDeviceService(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private int getSlotForActiveCarrierService(ImsServiceInfo imsServiceInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getSlotForActiveCarrierService", $$robo$$com_android_internal_telephony_ims_ImsResolver$getSlotForActiveCarrierService(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private Optional<ImsServiceController> getControllerByServiceInfo(Set<ImsServiceController> set, ImsServiceInfo imsServiceInfo) {
        return InvokeDynamicSupport.bootstrap("getControllerByServiceInfo", $$robo$$com_android_internal_telephony_ims_ImsResolver$getControllerByServiceInfo(java.util.Set<com.android.internal.telephony.ims.ImsServiceController> com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, set, imsServiceInfo);
    }

    private Optional<ImsServiceInfo> getInfoByPackageName(Set<ImsServiceInfo> set, String string2) {
        return InvokeDynamicSupport.bootstrap("getInfoByPackageName", $$robo$$com_android_internal_telephony_ims_ImsResolver$getInfoByPackageName(java.util.Set<com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo> java.lang.String ), this, set, string2);
    }

    private Optional<ImsServiceInfo> getInfoByComponentName(Set<ImsServiceInfo> set, ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getInfoByComponentName", $$robo$$com_android_internal_telephony_ims_ImsResolver$getInfoByComponentName(java.util.Set<com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo> android.content.ComponentName ), this, set, componentName);
    }

    private void updateImsServiceFeatures(ImsServiceInfo imsServiceInfo) {
        InvokeDynamicSupport.bootstrap("updateImsServiceFeatures", $$robo$$com_android_internal_telephony_ims_ImsResolver$updateImsServiceFeatures(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private void bindNewImsService(ImsServiceInfo imsServiceInfo) {
        InvokeDynamicSupport.bootstrap("bindNewImsService", $$robo$$com_android_internal_telephony_ims_ImsResolver$bindNewImsService(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private void unbindImsService(ImsServiceInfo imsServiceInfo) {
        InvokeDynamicSupport.bootstrap("unbindImsService", $$robo$$com_android_internal_telephony_ims_ImsResolver$unbindImsService(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private HashSet<Pair<Integer, Integer>> calculateFeaturesToCreate(ImsServiceInfo imsServiceInfo) {
        return InvokeDynamicSupport.bootstrap("calculateFeaturesToCreate", $$robo$$com_android_internal_telephony_ims_ImsResolver$calculateFeaturesToCreate(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    @Override
    public void imsServiceFeatureCreated(int n, int n2, ImsServiceController imsServiceController) {
        InvokeDynamicSupport.bootstrap("imsServiceFeatureCreated", $$robo$$com_android_internal_telephony_ims_ImsResolver$imsServiceFeatureCreated(int int com.android.internal.telephony.ims.ImsServiceController ), this, n, n2, imsServiceController);
    }

    @Override
    public void imsServiceFeatureRemoved(int n, int n2, ImsServiceController imsServiceController) {
        InvokeDynamicSupport.bootstrap("imsServiceFeatureRemoved", $$robo$$com_android_internal_telephony_ims_ImsResolver$imsServiceFeatureRemoved(int int com.android.internal.telephony.ims.ImsServiceController ), this, n, n2, imsServiceController);
    }

    private void maybeRebindService(int n) {
        InvokeDynamicSupport.bootstrap("maybeRebindService", $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeRebindService(int ), this, n);
    }

    private void updateBoundCarrierServices(int n) {
        InvokeDynamicSupport.bootstrap("updateBoundCarrierServices", $$robo$$com_android_internal_telephony_ims_ImsResolver$updateBoundCarrierServices(int ), this, n);
    }

    public ImsServiceInfo getImsServiceInfoFromCache(String string2) {
        return InvokeDynamicSupport.bootstrap("getImsServiceInfoFromCache", $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceInfoFromCache(java.lang.String ), this, string2);
    }

    private List<ImsServiceInfo> getImsServiceInfo(String string2) {
        return InvokeDynamicSupport.bootstrap("getImsServiceInfo", $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceInfo(java.lang.String ), this, string2);
    }

    public /* synthetic */ ImsResolver() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsResolver)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ImsServiceControllerFactory
    extends InstrumentedInterface {
        public ImsServiceController get(Context var1, ComponentName var2);
    }

    public static interface SubscriptionManagerProxy
    extends InstrumentedInterface {
        public int getSubId(int var1);

        public int getSlotIndex(int var1);
    }

    public static class ImsServiceInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ComponentName name;
        public Set<Integer> supportedFeatures;

        private void $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$__constructor__() {
        }

        private final boolean $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImsServiceInfo that = (ImsServiceInfo)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return this.supportedFeatures != null ? this.supportedFeatures.equals(that.supportedFeatures) : that.supportedFeatures == null;
        }

        private final int $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.supportedFeatures != null ? this.supportedFeatures.hashCode() : 0);
            return result;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$__constructor__();
        }

        public ImsServiceInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$__constructor__(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$hashCode(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsServiceInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

