/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.SystemClock;
import android.telecom.Connection;
import android.telecom.VideoProfile;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.ims.ImsCall;
import com.android.ims.ImsCallProfile;
import com.android.ims.ImsException;
import com.android.ims.internal.ImsVideoCallProviderWrapper;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsPhoneConnection
extends Connection
implements ImsVideoCallProviderWrapper.ImsVideoProviderWrapperCallback,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ImsPhoneConnection";
    private static boolean DBG = true;
    private ImsPhoneCallTracker mOwner;
    private ImsPhoneCall mParent;
    private ImsCall mImsCall;
    private Bundle mExtras;
    private boolean mDisconnected;
    private long mDisconnectTime;
    private UUSInfo mUusInfo;
    private Handler mHandler;
    private PowerManager.WakeLock mPartialWakeLock;
    private long mConferenceConnectTime;
    private int mDtmfToneDelay;
    private boolean mIsEmergency;
    private boolean mShouldIgnoreVideoStateChanges;
    private ImsVideoCallProviderWrapper mImsVideoCallProviderWrapper;
    private int mPreciseDisconnectCause;
    private static int EVENT_DTMF_DONE = 1;
    private static int EVENT_PAUSE_DONE = 2;
    private static int EVENT_NEXT_POST_DIAL = 3;
    private static int EVENT_WAKE_LOCK_TIMEOUT = 4;
    private static int EVENT_DTMF_DELAY_DONE = 5;
    private static int PAUSE_DELAY_MILLIS = 3000;
    private static int WAKE_LOCK_TIMEOUT_MILLIS = 60000;

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(Phone phone, ImsCall imsCall, ImsPhoneCallTracker ct, ImsPhoneCall parent, boolean isUnknown) {
        this.mExtras = new Bundle();
        this.mConferenceConnectTime = 0L;
        this.mDtmfToneDelay = 0;
        this.mIsEmergency = false;
        this.mShouldIgnoreVideoStateChanges = false;
        this.mPreciseDisconnectCause = 0;
        this.createWakeLock(phone.getContext());
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        this.mImsCall = imsCall;
        if (imsCall != null && imsCall.getCallProfile() != null) {
            this.mAddress = imsCall.getCallProfile().getCallExtra("oi");
            this.mCnapName = imsCall.getCallProfile().getCallExtra("cna");
            this.mNumberPresentation = ImsCallProfile.OIRToPresentation(imsCall.getCallProfile().getCallExtraInt("oir"));
            this.mCnapNamePresentation = ImsCallProfile.OIRToPresentation(imsCall.getCallProfile().getCallExtraInt("cnap"));
            this.updateMediaCapabilities(imsCall);
        } else {
            this.mNumberPresentation = 3;
            this.mCnapNamePresentation = 3;
        }
        this.mIsIncoming = !isUnknown;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mUusInfo = null;
        this.updateExtras(imsCall);
        this.mParent = parent;
        this.mParent.attach(this, this.mIsIncoming ? Call.State.INCOMING : Call.State.DIALING);
        this.fetchDtmfToneDelay(phone);
        if (phone.getContext().getResources().getBoolean(17957038)) {
            this.setAudioModeIsVoip(true);
        }
    }

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(Phone phone, String dialString, ImsPhoneCallTracker ct, ImsPhoneCall parent, boolean isEmergency) {
        this.mExtras = new Bundle();
        this.mConferenceConnectTime = 0L;
        this.mDtmfToneDelay = 0;
        this.mIsEmergency = false;
        this.mShouldIgnoreVideoStateChanges = false;
        this.mPreciseDisconnectCause = 0;
        this.createWakeLock(phone.getContext());
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        this.mDialString = dialString;
        this.mAddress = PhoneNumberUtils.extractNetworkPortionAlt(dialString);
        this.mPostDialString = PhoneNumberUtils.extractPostDialPortion(dialString);
        this.mIsIncoming = false;
        this.mCnapName = null;
        this.mCnapNamePresentation = 1;
        this.mNumberPresentation = 1;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mParent = parent;
        parent.attachFake(this, Call.State.DIALING);
        this.mIsEmergency = isEmergency;
        this.fetchDtmfToneDelay(phone);
        if (phone.getContext().getResources().getBoolean(17957038)) {
            this.setAudioModeIsVoip(true);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$dispose() {
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private static final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$applyLocalCallCapabilities(ImsCallProfile localProfile, int capabilities) {
        Rlog.w("ImsPhoneConnection", "applyLocalCallCapabilities - localProfile = " + localProfile);
        capabilities = ImsPhoneConnection.removeCapability(capabilities, 4);
        switch (localProfile.mCallType) {
            case 3: 
            case 4: {
                capabilities = ImsPhoneConnection.addCapability(capabilities, 4);
            }
        }
        return capabilities;
    }

    private static final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$applyRemoteCallCapabilities(ImsCallProfile remoteProfile, int capabilities) {
        Rlog.w("ImsPhoneConnection", "applyRemoteCallCapabilities - remoteProfile = " + remoteProfile);
        capabilities = ImsPhoneConnection.removeCapability(capabilities, 8);
        switch (remoteProfile.mCallType) {
            case 3: 
            case 4: {
                capabilities = ImsPhoneConnection.addCapability(capabilities, 8);
            }
        }
        return capabilities;
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOrigDialString() {
        return this.mDialString;
    }

    private final ImsPhoneCall $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getCall() {
        return this.mParent;
    }

    private final long $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getDisconnectTime() {
        return this.mDisconnectTime;
    }

    private final long $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getHoldingStartTime() {
        return this.mHoldingStartTime;
    }

    private final long $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.mHoldingStartTime;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setDisconnectCause(int cause) {
        this.mCause = cause;
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getVendorDisconnectCause() {
        return null;
    }

    private final ImsPhoneCallTracker $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOwner() {
        return this.mOwner;
    }

    private final Call.State $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getState() {
        if (this.mDisconnected) {
            return Call.State.DISCONNECTED;
        }
        return super.getState();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$hangup() throws CallStateException {
        if (this.mDisconnected) {
            throw new CallStateException("disconnected");
        }
        this.mOwner.hangup(this);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$separate() throws CallStateException {
        throw new CallStateException("not supported");
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$proceedAfterWaitChar() {
        if (this.mPostDialState != Connection.PostDialState.WAIT) {
            Rlog.w("ImsPhoneConnection", "ImsPhoneConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WAIT but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        this.processNextPostDialChar();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$proceedAfterWildChar(String str) {
        if (this.mPostDialState != Connection.PostDialState.WILD) {
            Rlog.w("ImsPhoneConnection", "ImsPhoneConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WILD but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        StringBuilder buf = new StringBuilder(str);
        buf.append(this.mPostDialString.substring(this.mNextPostDialChar));
        this.mPostDialString = buf.toString();
        this.mNextPostDialChar = 0;
        Rlog.d("ImsPhoneConnection", "proceedAfterWildChar: new postDialString is " + this.mPostDialString);
        this.processNextPostDialChar();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$cancelPostDial() {
        this.setPostDialState(Connection.PostDialState.CANCELLED);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onHangupLocal() {
        this.mCause = 3;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onDisconnect(int cause) {
        Rlog.d("ImsPhoneConnection", "onDisconnect: cause=" + cause);
        if (this.mCause != 3 || cause == 16) {
            this.mCause = cause;
        }
        return this.onDisconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onDisconnect() {
        boolean changed = false;
        if (!this.mDisconnected) {
            this.mDisconnectTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.mDuration = SystemClock.elapsedRealtime() - this.mConnectTimeReal;
            this.mDisconnected = true;
            this.mOwner.mPhone.notifyDisconnect(this);
            if (this.mParent != null) {
                changed = this.mParent.connectionDisconnected(this);
            } else {
                Rlog.d("ImsPhoneConnection", "onDisconnect: no parent");
            }
            ImsPhoneConnection imsPhoneConnection = this;
            synchronized (imsPhoneConnection) {
                if (this.mImsCall != null) {
                    this.mImsCall.close();
                }
                this.mImsCall = null;
            }
        }
        this.releaseWakeLock();
        return changed;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onConnectedInOrOut() {
        this.mConnectTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mConnectTimeReal = SystemClock.elapsedRealtime();
        this.mDuration = 0L;
        Rlog.d("ImsPhoneConnection", "onConnectedInOrOut: connectTime=" + this.mConnectTime);
        if (!this.mIsIncoming) {
            this.processNextPostDialChar();
        }
        this.releaseWakeLock();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onStartedHolding() {
        this.mHoldingStartTime = SystemClock.elapsedRealtime();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$processPostDialChar(char c) {
        if (PhoneNumberUtils.is12Key(c)) {
            this.mOwner.sendDtmf(c, this.mHandler.obtainMessage(1));
        } else if (c == ',') {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), 3000L);
        } else if (c == ';') {
            this.setPostDialState(Connection.PostDialState.WAIT);
        } else if (c == 'N') {
            this.setPostDialState(Connection.PostDialState.WILD);
        } else {
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$finalize() {
        this.releaseWakeLock();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$processNextPostDialChar() {
        Message notifyMessage;
        char c = '\u0000';
        if (this.mPostDialState == Connection.PostDialState.CANCELLED) {
            return;
        }
        if (this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            this.setPostDialState(Connection.PostDialState.COMPLETE);
            c = '\u0000';
        } else {
            this.setPostDialState(Connection.PostDialState.STARTED);
            c = this.mPostDialString.charAt(this.mNextPostDialChar++);
            boolean isValid = this.processPostDialChar(c);
            if (!isValid) {
                this.mHandler.obtainMessage(3).sendToTarget();
                Rlog.e("ImsPhoneConnection", "processNextPostDialChar: c=" + c + " isn't valid!");
                return;
            }
        }
        this.notifyPostDialListenersNextChar(c);
        Registrant postDialHandler = this.mOwner.mPhone.getPostDialHandler();
        if (postDialHandler != null && (notifyMessage = postDialHandler.messageForRegistrant()) != null) {
            Connection.PostDialState state = this.mPostDialState;
            AsyncResult ar = AsyncResult.forMessage(notifyMessage);
            ar.result = this;
            ar.userObj = state;
            notifyMessage.arg1 = c;
            notifyMessage.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setPostDialState(Connection.PostDialState s) {
        if (this.mPostDialState != Connection.PostDialState.STARTED && s == Connection.PostDialState.STARTED) {
            this.acquireWakeLock();
            Message msg = this.mHandler.obtainMessage(4);
            this.mHandler.sendMessageDelayed(msg, 60000L);
        } else if (this.mPostDialState == Connection.PostDialState.STARTED && s != Connection.PostDialState.STARTED) {
            this.mHandler.removeMessages(4);
            this.releaseWakeLock();
        }
        this.mPostDialState = s;
        this.notifyPostDialListeners();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$createWakeLock(Context context) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mPartialWakeLock = pm.newWakeLock(1, "ImsPhoneConnection");
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$acquireWakeLock() {
        Rlog.d("ImsPhoneConnection", "acquireWakeLock");
        this.mPartialWakeLock.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$releaseWakeLock() {
        if (this.mPartialWakeLock != null) {
            PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
            synchronized (wakeLock) {
                if (this.mPartialWakeLock.isHeld()) {
                    Rlog.d("ImsPhoneConnection", "releaseWakeLock");
                    this.mPartialWakeLock.release();
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$fetchDtmfToneDelay(Phone phone) {
        CarrierConfigManager configMgr = (CarrierConfigManager)phone.getContext().getSystemService("carrier_config");
        PersistableBundle b = configMgr.getConfigForSubId(phone.getSubId());
        if (b != null) {
            this.mDtmfToneDelay = b.getInt("ims_dtmf_tone_delay_int");
        }
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getNumberPresentation() {
        return this.mNumberPresentation;
    }

    private final UUSInfo $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getUUSInfo() {
        return this.mUusInfo;
    }

    private final Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOrigConnection() {
        return null;
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$isMultiparty() {
        return this.mImsCall != null && this.mImsCall.isMultiparty();
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$isConferenceHost() {
        return this.mImsCall != null && this.mImsCall.isConferenceHost();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$isMemberOfPeerConference() {
        return !this.isConferenceHost();
    }

    private final synchronized ImsCall $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getImsCall() {
        return this.mImsCall;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setImsCall(ImsCall imsCall) {
        this.mImsCall = imsCall;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$changeParent(ImsPhoneCall parent) {
        this.mParent = parent;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$update(ImsCall imsCall, Call.State state) {
        if (state == Call.State.ACTIVE) {
            if (imsCall.isPendingHold()) {
                Rlog.w("ImsPhoneConnection", "update : state is ACTIVE, but call is pending hold, skipping");
                return false;
            }
            if (this.mParent.getState().isRinging() || this.mParent.getState().isDialing()) {
                this.onConnectedInOrOut();
            }
            if (this.mParent.getState().isRinging() || this.mParent == this.mOwner.mBackgroundCall) {
                this.mParent.detach(this);
                this.mParent = this.mOwner.mForegroundCall;
                this.mParent.attach(this);
            }
        } else if (state == Call.State.HOLDING) {
            this.onStartedHolding();
        }
        boolean updateParent = this.mParent.update(this, imsCall, state);
        boolean updateAddressDisplay = this.updateAddressDisplay(imsCall);
        boolean updateMediaCapabilities = this.updateMediaCapabilities(imsCall);
        boolean updateExtras = this.updateExtras(imsCall);
        return updateParent || updateAddressDisplay || updateMediaCapabilities || updateExtras;
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getPreciseDisconnectCause() {
        return this.mPreciseDisconnectCause;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setPreciseDisconnectCause(int cause) {
        this.mPreciseDisconnectCause = cause;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onDisconnectConferenceParticipant(Uri endpoint) {
        ImsCall imsCall = this.getImsCall();
        if (imsCall == null) {
            return;
        }
        try {
            imsCall.removeParticipants(new String[]{endpoint.toString()});
        }
        catch (ImsException e) {
            Rlog.e("ImsPhoneConnection", "onDisconnectConferenceParticipant: no session in place. Failed to disconnect endpoint = " + endpoint);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setConferenceConnectTime(long conferenceConnectTime) {
        this.mConferenceConnectTime = conferenceConnectTime;
    }

    private final long $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getConferenceConnectTime() {
        return this.mConferenceConnectTime;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$updateAddressDisplay(ImsCall imsCall) {
        if (imsCall == null) {
            return false;
        }
        boolean changed = false;
        ImsCallProfile callProfile = imsCall.getCallProfile();
        if (callProfile != null) {
            String address = callProfile.getCallExtra("oi");
            String name = callProfile.getCallExtra("cna");
            int nump = ImsCallProfile.OIRToPresentation(callProfile.getCallExtraInt("oir"));
            int namep = ImsCallProfile.OIRToPresentation(callProfile.getCallExtraInt("cnap"));
            Rlog.d("ImsPhoneConnection", "address = " + Rlog.pii("ImsPhoneConnection", (Object)address) + " name = " + name + " nump = " + nump + " namep = " + namep);
            if (ImsPhoneConnection.equalsHandlesNulls(this.mAddress, address)) {
                this.mAddress = address;
                changed = true;
            }
            if (TextUtils.isEmpty(name)) {
                if (!TextUtils.isEmpty(this.mCnapName)) {
                    this.mCnapName = "";
                    changed = true;
                }
            } else if (!name.equals(this.mCnapName)) {
                this.mCnapName = name;
                changed = true;
            }
            if (this.mNumberPresentation != nump) {
                this.mNumberPresentation = nump;
                changed = true;
            }
            if (this.mCnapNamePresentation != namep) {
                this.mCnapNamePresentation = namep;
                changed = true;
            }
        }
        return changed;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$updateMediaCapabilities(ImsCall imsCall) {
        if (imsCall == null) {
            return false;
        }
        boolean changed = false;
        try {
            int newVideoState;
            int oldVideoState;
            ImsCallProfile negotiatedCallProfile = imsCall.getCallProfile();
            if (negotiatedCallProfile != null && (oldVideoState = this.getVideoState()) != (newVideoState = ImsCallProfile.getVideoStateFromImsCallProfile(negotiatedCallProfile))) {
                if (VideoProfile.isPaused(oldVideoState) && !VideoProfile.isPaused(newVideoState)) {
                    this.mShouldIgnoreVideoStateChanges = false;
                }
                if (!this.mShouldIgnoreVideoStateChanges) {
                    if (this.mImsVideoCallProviderWrapper != null) {
                        this.mImsVideoCallProviderWrapper.onVideoStateChanged(newVideoState);
                    }
                    this.setVideoState(newVideoState);
                    changed = true;
                } else {
                    Rlog.d("ImsPhoneConnection", "updateMediaCapabilities - ignoring video state change due to paused state.");
                }
                if (!VideoProfile.isPaused(oldVideoState) && VideoProfile.isPaused(newVideoState)) {
                    this.mShouldIgnoreVideoStateChanges = true;
                }
            }
            int capabilities = this.getConnectionCapabilities();
            capabilities = this.mOwner.isCarrierDowngradeOfVtCallSupported() ? ImsPhoneConnection.addCapability(capabilities, 3) : ImsPhoneConnection.removeCapability(capabilities, 3);
            ImsCallProfile localCallProfile = imsCall.getLocalCallProfile();
            Rlog.v("ImsPhoneConnection", "update localCallProfile=" + localCallProfile);
            if (localCallProfile != null) {
                capabilities = ImsPhoneConnection.applyLocalCallCapabilities(localCallProfile, capabilities);
            }
            ImsCallProfile remoteCallProfile = imsCall.getRemoteCallProfile();
            Rlog.v("ImsPhoneConnection", "update remoteCallProfile=" + remoteCallProfile);
            if (remoteCallProfile != null) {
                capabilities = ImsPhoneConnection.applyRemoteCallCapabilities(remoteCallProfile, capabilities);
            }
            if (this.getConnectionCapabilities() != capabilities) {
                this.setConnectionCapabilities(capabilities);
                changed = true;
            }
            int newAudioQuality = this.getAudioQualityFromCallProfile(localCallProfile, remoteCallProfile);
            if (this.getAudioQuality() != newAudioQuality) {
                this.setAudioQuality(newAudioQuality);
                changed = true;
            }
        }
        catch (ImsException imsException) {
            // empty catch block
        }
        return changed;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$updateWifiStateFromExtras(Bundle extras) {
        if (extras.containsKey("CallRadioTech") || extras.containsKey("callRadioTech")) {
            ImsCall call = this.getImsCall();
            boolean isWifi = false;
            if (call != null) {
                isWifi = call.isWifiCall();
            }
            if (this.isWifi() != isWifi) {
                this.setWifi(isWifi);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$updateExtras(ImsCall imsCall) {
        boolean changed;
        Bundle extras;
        if (imsCall == null) {
            return false;
        }
        ImsCallProfile callProfile = imsCall.getCallProfile();
        Bundle bundle = extras = callProfile != null ? callProfile.mCallExtras : null;
        if (extras == null) {
            Rlog.d("ImsPhoneConnection", "Call profile extras are null.");
        }
        boolean bl = changed = !ImsPhoneConnection.areBundlesEqual(extras, this.mExtras);
        if (changed) {
            this.updateWifiStateFromExtras(extras);
            this.mExtras.clear();
            this.mExtras.putAll(extras);
            this.setConnectionExtras(this.mExtras);
        }
        return changed;
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$areBundlesEqual(Bundle extras, Bundle newExtras) {
        if (extras == null || newExtras == null) {
            return extras == newExtras;
        }
        if (extras.size() != newExtras.size()) {
            return false;
        }
        for (String key : extras.keySet()) {
            Object newValue;
            Object value;
            if (key == null || Objects.equals(value = extras.get(key), newValue = newExtras.get(key))) continue;
            return false;
        }
        return true;
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getAudioQualityFromCallProfile(ImsCallProfile localCallProfile, ImsCallProfile remoteCallProfile) {
        if (localCallProfile == null || remoteCallProfile == null || localCallProfile.mMediaProfile == null) {
            return 1;
        }
        boolean isEvsCodecHighDef = localCallProfile.mMediaProfile.mAudioQuality == 18 || localCallProfile.mMediaProfile.mAudioQuality == 19 || localCallProfile.mMediaProfile.mAudioQuality == 20;
        boolean isHighDef = (localCallProfile.mMediaProfile.mAudioQuality == 2 || localCallProfile.mMediaProfile.mAudioQuality == 6 || isEvsCodecHighDef) && remoteCallProfile.mRestrictCause == 0;
        return isHighDef ? 2 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ImsPhoneConnection objId: ");
        sb.append(System.identityHashCode(this));
        sb.append(" telecomCallID: ");
        sb.append(this.getTelecomCallId());
        sb.append(" address: ");
        sb.append(Rlog.pii("ImsPhoneConnection", (Object)this.getAddress()));
        sb.append(" ImsCall: ");
        ImsPhoneConnection imsPhoneConnection = this;
        synchronized (imsPhoneConnection) {
            if (this.mImsCall == null) {
                sb.append("null");
            } else {
                sb.append(this.mImsCall);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setVideoProvider(Connection.VideoProvider videoProvider) {
        super.setVideoProvider(videoProvider);
        if (videoProvider instanceof ImsVideoCallProviderWrapper) {
            this.mImsVideoCallProviderWrapper = (ImsVideoCallProviderWrapper)videoProvider;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$isEmergency() {
        return this.mIsEmergency;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onReceiveSessionModifyResponse(int status, VideoProfile requestProfile, VideoProfile responseProfile) {
        if (status == 1 && this.mShouldIgnoreVideoStateChanges) {
            int currentVideoState = this.getVideoState();
            int newVideoState = responseProfile.getVideoState();
            int changedBits = currentVideoState ^ newVideoState;
            if ((changedBits &= 3) == 0) {
                return;
            }
            currentVideoState &= ~(changedBits & currentVideoState);
            Rlog.d("ImsPhoneConnection", "onReceiveSessionModifyResponse : received " + VideoProfile.videoStateToString(requestProfile.getVideoState()) + " / " + VideoProfile.videoStateToString(responseProfile.getVideoState()) + " while paused ; sending new videoState = " + VideoProfile.videoStateToString(currentVideoState |= changedBits & newVideoState));
            this.setVideoState(currentVideoState);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$pauseVideo(int source) {
        if (this.mImsVideoCallProviderWrapper == null) {
            return;
        }
        this.mImsVideoCallProviderWrapper.pauseVideo(this.getVideoState(), source);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$resumeVideo(int source) {
        if (this.mImsVideoCallProviderWrapper == null) {
            return;
        }
        this.mImsVideoCallProviderWrapper.resumeVideo(this.getVideoState(), source);
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$wasVideoPausedFromSource(int source) {
        if (this.mImsVideoCallProviderWrapper == null) {
            return false;
        }
        return this.mImsVideoCallProviderWrapper.wasVideoPausedFromSource(source);
    }

    private void __constructor__(Phone phone, ImsCall imsCall, ImsPhoneCallTracker imsPhoneCallTracker, ImsPhoneCall imsPhoneCall, boolean bl) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(phone, imsCall, imsPhoneCallTracker, imsPhoneCall, bl);
    }

    public ImsPhoneConnection(Phone phone, ImsCall imsCall, ImsPhoneCallTracker imsPhoneCallTracker, ImsPhoneCall imsPhoneCall, boolean bl) {
        super(5);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(com.android.internal.telephony.Phone com.android.ims.ImsCall com.android.internal.telephony.imsphone.ImsPhoneCallTracker com.android.internal.telephony.imsphone.ImsPhoneCall boolean ), this, phone, imsCall, imsPhoneCallTracker, imsPhoneCall, bl);
    }

    private void __constructor__(Phone phone, String string2, ImsPhoneCallTracker imsPhoneCallTracker, ImsPhoneCall imsPhoneCall, boolean bl) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(phone, string2, imsPhoneCallTracker, imsPhoneCall, bl);
    }

    public ImsPhoneConnection(Phone phone, String string2, ImsPhoneCallTracker imsPhoneCallTracker, ImsPhoneCall imsPhoneCall, boolean bl) {
        super(5);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(com.android.internal.telephony.Phone java.lang.String com.android.internal.telephony.imsphone.ImsPhoneCallTracker com.android.internal.telephony.imsphone.ImsPhoneCall boolean ), this, phone, string2, imsPhoneCallTracker, imsPhoneCall, bl);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$dispose(), this);
    }

    static boolean equalsHandlesNulls(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equalsHandlesNulls", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$equalsHandlesNulls(java.lang.Object java.lang.Object ), (Object)object, (Object)object2);
    }

    private static int applyLocalCallCapabilities(ImsCallProfile imsCallProfile, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("applyLocalCallCapabilities", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$applyLocalCallCapabilities(com.android.ims.ImsCallProfile int ), (ImsCallProfile)imsCallProfile, (int)n);
    }

    private static int applyRemoteCallCapabilities(ImsCallProfile imsCallProfile, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("applyRemoteCallCapabilities", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$applyRemoteCallCapabilities(com.android.ims.ImsCallProfile int ), (ImsCallProfile)imsCallProfile, (int)n);
    }

    @Override
    public String getOrigDialString() {
        return InvokeDynamicSupport.bootstrap("getOrigDialString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOrigDialString(), this);
    }

    @Override
    public ImsPhoneCall getCall() {
        return InvokeDynamicSupport.bootstrap("getCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getCall(), this);
    }

    @Override
    public long getDisconnectTime() {
        return (long)InvokeDynamicSupport.bootstrap("getDisconnectTime", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getDisconnectTime(), this);
    }

    @Override
    public long getHoldingStartTime() {
        return (long)InvokeDynamicSupport.bootstrap("getHoldingStartTime", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getHoldingStartTime(), this);
    }

    @Override
    public long getHoldDurationMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getHoldDurationMillis", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getHoldDurationMillis(), this);
    }

    public void setDisconnectCause(int n) {
        InvokeDynamicSupport.bootstrap("setDisconnectCause", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setDisconnectCause(int ), this, n);
    }

    @Override
    public String getVendorDisconnectCause() {
        return InvokeDynamicSupport.bootstrap("getVendorDisconnectCause", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getVendorDisconnectCause(), this);
    }

    public ImsPhoneCallTracker getOwner() {
        return InvokeDynamicSupport.bootstrap("getOwner", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOwner(), this);
    }

    @Override
    public Call.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getState(), this);
    }

    @Override
    public void hangup() throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$hangup(), this);
    }

    @Override
    public void separate() throws CallStateException {
        InvokeDynamicSupport.bootstrap("separate", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$separate(), this);
    }

    @Override
    public void proceedAfterWaitChar() {
        InvokeDynamicSupport.bootstrap("proceedAfterWaitChar", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$proceedAfterWaitChar(), this);
    }

    @Override
    public void proceedAfterWildChar(String string2) {
        InvokeDynamicSupport.bootstrap("proceedAfterWildChar", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$proceedAfterWildChar(java.lang.String ), this, string2);
    }

    @Override
    public void cancelPostDial() {
        InvokeDynamicSupport.bootstrap("cancelPostDial", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$cancelPostDial(), this);
    }

    void onHangupLocal() {
        InvokeDynamicSupport.bootstrap("onHangupLocal", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onHangupLocal(), this);
    }

    @Override
    public boolean onDisconnect(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onDisconnect(int ), this, n);
    }

    public boolean onDisconnect() {
        return (boolean)InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onDisconnect(), this);
    }

    void onConnectedInOrOut() {
        InvokeDynamicSupport.bootstrap("onConnectedInOrOut", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onConnectedInOrOut(), this);
    }

    void onStartedHolding() {
        InvokeDynamicSupport.bootstrap("onStartedHolding", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onStartedHolding(), this);
    }

    private boolean processPostDialChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("processPostDialChar", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$processPostDialChar(char ), this, c);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$finalize(), this);
    }

    private void processNextPostDialChar() {
        InvokeDynamicSupport.bootstrap("processNextPostDialChar", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$processNextPostDialChar(), this);
    }

    private void setPostDialState(Connection.PostDialState postDialState) {
        InvokeDynamicSupport.bootstrap("setPostDialState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setPostDialState(com.android.internal.telephony.Connection$PostDialState ), this, postDialState);
    }

    private void createWakeLock(Context context) {
        InvokeDynamicSupport.bootstrap("createWakeLock", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$createWakeLock(android.content.Context ), this, context);
    }

    private void acquireWakeLock() {
        InvokeDynamicSupport.bootstrap("acquireWakeLock", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$acquireWakeLock(), this);
    }

    void releaseWakeLock() {
        InvokeDynamicSupport.bootstrap("releaseWakeLock", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$releaseWakeLock(), this);
    }

    private void fetchDtmfToneDelay(Phone phone) {
        InvokeDynamicSupport.bootstrap("fetchDtmfToneDelay", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$fetchDtmfToneDelay(com.android.internal.telephony.Phone ), this, phone);
    }

    @Override
    public int getNumberPresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberPresentation", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getNumberPresentation(), this);
    }

    @Override
    public UUSInfo getUUSInfo() {
        return InvokeDynamicSupport.bootstrap("getUUSInfo", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getUUSInfo(), this);
    }

    @Override
    public Connection getOrigConnection() {
        return InvokeDynamicSupport.bootstrap("getOrigConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOrigConnection(), this);
    }

    @Override
    public synchronized boolean isMultiparty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiparty", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$isMultiparty(), this);
    }

    @Override
    public synchronized boolean isConferenceHost() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConferenceHost", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$isConferenceHost(), this);
    }

    @Override
    public boolean isMemberOfPeerConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMemberOfPeerConference", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$isMemberOfPeerConference(), this);
    }

    public synchronized ImsCall getImsCall() {
        return InvokeDynamicSupport.bootstrap("getImsCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getImsCall(), this);
    }

    public synchronized void setImsCall(ImsCall imsCall) {
        InvokeDynamicSupport.bootstrap("setImsCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setImsCall(com.android.ims.ImsCall ), this, imsCall);
    }

    public void changeParent(ImsPhoneCall imsPhoneCall) {
        InvokeDynamicSupport.bootstrap("changeParent", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$changeParent(com.android.internal.telephony.imsphone.ImsPhoneCall ), this, imsPhoneCall);
    }

    public boolean update(ImsCall imsCall, Call.State state) {
        return (boolean)InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$update(com.android.ims.ImsCall com.android.internal.telephony.Call$State ), this, imsCall, state);
    }

    @Override
    public int getPreciseDisconnectCause() {
        return (int)InvokeDynamicSupport.bootstrap("getPreciseDisconnectCause", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getPreciseDisconnectCause(), this);
    }

    public void setPreciseDisconnectCause(int n) {
        InvokeDynamicSupport.bootstrap("setPreciseDisconnectCause", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setPreciseDisconnectCause(int ), this, n);
    }

    @Override
    public void onDisconnectConferenceParticipant(Uri uri) {
        InvokeDynamicSupport.bootstrap("onDisconnectConferenceParticipant", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onDisconnectConferenceParticipant(android.net.Uri ), this, uri);
    }

    public void setConferenceConnectTime(long l) {
        InvokeDynamicSupport.bootstrap("setConferenceConnectTime", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setConferenceConnectTime(long ), this, l);
    }

    public long getConferenceConnectTime() {
        return (long)InvokeDynamicSupport.bootstrap("getConferenceConnectTime", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getConferenceConnectTime(), this);
    }

    public boolean updateAddressDisplay(ImsCall imsCall) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateAddressDisplay", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$updateAddressDisplay(com.android.ims.ImsCall ), this, imsCall);
    }

    public boolean updateMediaCapabilities(ImsCall imsCall) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateMediaCapabilities", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$updateMediaCapabilities(com.android.ims.ImsCall ), this, imsCall);
    }

    private void updateWifiStateFromExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("updateWifiStateFromExtras", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$updateWifiStateFromExtras(android.os.Bundle ), this, bundle);
    }

    boolean updateExtras(ImsCall imsCall) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateExtras", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$updateExtras(com.android.ims.ImsCall ), this, imsCall);
    }

    private static boolean areBundlesEqual(Bundle bundle, Bundle bundle2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("areBundlesEqual", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$areBundlesEqual(android.os.Bundle android.os.Bundle ), (Bundle)bundle, (Bundle)bundle2);
    }

    private int getAudioQualityFromCallProfile(ImsCallProfile imsCallProfile, ImsCallProfile imsCallProfile2) {
        return (int)InvokeDynamicSupport.bootstrap("getAudioQualityFromCallProfile", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getAudioQualityFromCallProfile(com.android.ims.ImsCallProfile com.android.ims.ImsCallProfile ), this, imsCallProfile, imsCallProfile2);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$toString(), this);
    }

    @Override
    public void setVideoProvider(Connection.VideoProvider videoProvider) {
        InvokeDynamicSupport.bootstrap("setVideoProvider", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setVideoProvider(android.telecom.Connection$VideoProvider ), this, videoProvider);
    }

    protected boolean isEmergency() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmergency", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$isEmergency(), this);
    }

    @Override
    public void onReceiveSessionModifyResponse(int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
        InvokeDynamicSupport.bootstrap("onReceiveSessionModifyResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onReceiveSessionModifyResponse(int android.telecom.VideoProfile android.telecom.VideoProfile ), this, n, videoProfile, videoProfile2);
    }

    public void pauseVideo(int n) {
        InvokeDynamicSupport.bootstrap("pauseVideo", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$pauseVideo(int ), this, n);
    }

    public void resumeVideo(int n) {
        InvokeDynamicSupport.bootstrap("resumeVideo", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$resumeVideo(int ), this, n);
    }

    public boolean wasVideoPausedFromSource(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("wasVideoPausedFromSource", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$wasVideoPausedFromSource(int ), this, n);
    }

    public /* synthetic */ ImsPhoneConnection() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsPhoneConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class MyHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ImsPhoneConnection this$0;

        private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection_MyHandler$__constructor__(ImsPhoneConnection this$0, Looper l) {
        }

        private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection_MyHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 2: 
                case 3: 
                case 5: {
                    this.this$0.processNextPostDialChar();
                    break;
                }
                case 4: {
                    this.this$0.releaseWakeLock();
                    break;
                }
                case 1: {
                    this.this$0.mHandler.sendMessageDelayed(this.this$0.mHandler.obtainMessage(5), this.this$0.mDtmfToneDelay);
                }
            }
        }

        private void __constructor__(ImsPhoneConnection imsPhoneConnection, Looper looper) {
            this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection_MyHandler$__constructor__(imsPhoneConnection, looper);
        }

        public MyHandler(ImsPhoneConnection imsPhoneConnection, Looper looper) {
            this.this$0 = imsPhoneConnection;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection_MyHandler$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneConnection android.os.Looper ), this, imsPhoneConnection, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection_MyHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

