/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.ResultReceiver;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.android.ims.ImsException;
import com.android.ims.ImsSsInfo;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.uicc.IccRecords;
import com.google.errorprone.annotations.DoNotMock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ImsPhoneMmiCode
extends Handler
implements MmiCode,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "ImsPhoneMmiCode";
    private static int MAX_LENGTH_SHORT_CODE = 2;
    private static char END_OF_USSD_COMMAND = '#';
    private static String ACTION_ACTIVATE = "*";
    private static String ACTION_DEACTIVATE = "#";
    private static String ACTION_INTERROGATE = "*#";
    private static String ACTION_REGISTER = "**";
    private static String ACTION_ERASURE = "##";
    private static String SC_CLIP = "30";
    private static String SC_CLIR = "31";
    private static String SC_COLP = "76";
    private static String SC_COLR = "77";
    private static String SC_CNAP = "300";
    private static String SC_CFU = "21";
    private static String SC_CFB = "67";
    private static String SC_CFNRy = "61";
    private static String SC_CFNR = "62";
    private static String SC_CFUT = "22";
    private static String SC_CF_All = "002";
    private static String SC_CF_All_Conditional = "004";
    private static String SC_WAIT = "43";
    private static String SC_BAOC = "33";
    private static String SC_BAOIC = "331";
    private static String SC_BAOICxH = "332";
    private static String SC_BAIC = "35";
    private static String SC_BAICr = "351";
    private static String SC_BA_ALL = "330";
    private static String SC_BA_MO = "333";
    private static String SC_BA_MT = "353";
    private static String SC_BS_MT = "156";
    private static String SC_BAICa = "157";
    private static String SC_PWD = "03";
    private static String SC_PIN = "04";
    private static String SC_PIN2 = "042";
    private static String SC_PUK = "05";
    private static String SC_PUK2 = "052";
    private static int EVENT_SET_COMPLETE = 0;
    private static int EVENT_QUERY_CF_COMPLETE = 1;
    private static int EVENT_USSD_COMPLETE = 2;
    private static int EVENT_QUERY_COMPLETE = 3;
    private static int EVENT_SET_CFF_COMPLETE = 4;
    private static int EVENT_USSD_CANCEL_COMPLETE = 5;
    private static int EVENT_GET_CLIR_COMPLETE = 6;
    private static int EVENT_SUPP_SVC_QUERY_COMPLETE = 7;
    private static int EVENT_QUERY_ICB_COMPLETE = 10;
    private static int NUM_PRESENTATION_ALLOWED = 0;
    private static int NUM_PRESENTATION_RESTRICTED = 1;
    public static String UT_BUNDLE_KEY_CLIR = "queryClir";
    public static String UT_BUNDLE_KEY_SSINFO = "imsSsInfo";
    private static int CLIR_NOT_PROVISIONED = 0;
    private static int CLIR_PROVISIONED_PERMANENT = 1;
    private static int CLIR_PRESENTATION_RESTRICTED_TEMPORARY = 3;
    private static int CLIR_PRESENTATION_ALLOWED_TEMPORARY = 4;
    private static int CLIR_DEFAULT = 0;
    private static int CLIR_INVOCATION = 1;
    private static int CLIR_SUPPRESSION = 2;
    private ImsPhone mPhone;
    private Context mContext;
    private IccRecords mIccRecords;
    private String mAction;
    private String mSc;
    private String mSia;
    private String mSib;
    private String mSic;
    private String mPoundString;
    private String mDialingNumber;
    private String mPwd;
    private ResultReceiver mCallbackReceiver;
    private boolean mIsPendingUSSD;
    private boolean mIsUssdRequest;
    private boolean mIsCallFwdReg;
    private MmiCode.State mState;
    private CharSequence mMessage;
    static String IcbDnMmi = "Specific Incoming Call Barring";
    static String IcbAnonymousMmi = "Anonymous Incoming Call Barring";
    private static Pattern sPatternSuppService;
    private static int MATCH_GROUP_POUND_STRING = 1;
    private static int MATCH_GROUP_ACTION = 2;
    private static int MATCH_GROUP_SERVICE_CODE = 3;
    private static int MATCH_GROUP_SIA = 5;
    private static int MATCH_GROUP_SIB = 7;
    private static int MATCH_GROUP_SIC = 9;
    private static int MATCH_GROUP_PWD_CONFIRM = 11;
    private static int MATCH_GROUP_DIALING_NUMBER = 12;
    private static String[] sTwoDigitNumberPattern;

    private static final ImsPhoneMmiCode $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$newFromDialString(String dialString, ImsPhone phone) {
        return ImsPhoneMmiCode.newFromDialString(dialString, phone, null);
    }

    private static final ImsPhoneMmiCode $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$newFromDialString(String dialString, ImsPhone phone, ResultReceiver wrappedCallback) {
        ImsPhoneMmiCode ret = null;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            ret = new ImsPhoneMmiCode(phone);
            ret.mPoundString = ImsPhoneMmiCode.makeEmptyNull(m.group(1));
            ret.mAction = ImsPhoneMmiCode.makeEmptyNull(m.group(2));
            ret.mSc = ImsPhoneMmiCode.makeEmptyNull(m.group(3));
            ret.mSia = ImsPhoneMmiCode.makeEmptyNull(m.group(5));
            ret.mSib = ImsPhoneMmiCode.makeEmptyNull(m.group(7));
            ret.mSic = ImsPhoneMmiCode.makeEmptyNull(m.group(9));
            ret.mPwd = ImsPhoneMmiCode.makeEmptyNull(m.group(11));
            ret.mDialingNumber = ImsPhoneMmiCode.makeEmptyNull(m.group(12));
            ret.mCallbackReceiver = wrappedCallback;
            if (ret.mDialingNumber != null && ret.mDialingNumber.endsWith("#") && dialString.endsWith("#")) {
                ret = new ImsPhoneMmiCode(phone);
                ret.mPoundString = dialString;
            }
        } else if (dialString.endsWith("#")) {
            ret = new ImsPhoneMmiCode(phone);
            ret.mPoundString = dialString;
        } else if (ImsPhoneMmiCode.isTwoDigitShortCode(phone.getContext(), dialString)) {
            ret = null;
        } else if (ImsPhoneMmiCode.isShortCode(dialString, phone)) {
            ret = new ImsPhoneMmiCode(phone);
            ret.mDialingNumber = dialString;
        }
        return ret;
    }

    private static final ImsPhoneMmiCode $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$newNetworkInitiatedUssd(String ussdMessage, boolean isUssdRequest, ImsPhone phone) {
        ImsPhoneMmiCode ret = new ImsPhoneMmiCode(phone);
        ret.mMessage = ussdMessage;
        ret.mIsUssdRequest = isUssdRequest;
        if (isUssdRequest) {
            ret.mIsPendingUSSD = true;
            ret.mState = MmiCode.State.PENDING;
        } else {
            ret.mState = MmiCode.State.COMPLETE;
        }
        return ret;
    }

    private static final ImsPhoneMmiCode $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$newFromUssdUserInput(String ussdMessge, ImsPhone phone) {
        ImsPhoneMmiCode ret = new ImsPhoneMmiCode(phone);
        ret.mMessage = ussdMessge;
        ret.mState = MmiCode.State.PENDING;
        ret.mIsPendingUSSD = true;
        return ret;
    }

    private static final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$makeEmptyNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isScMatchesSuppServType(String dialString) {
        boolean isMatch = false;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            String sc = ImsPhoneMmiCode.makeEmptyNull(m.group(3));
            if (sc.equals("22")) {
                isMatch = true;
            } else if (sc.equals("156")) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isEmptyOrNull(CharSequence s) {
        return s == null || s.length() == 0;
    }

    private static final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$scToCallForwardReason(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call forward sc");
        }
        if (sc.equals("002")) {
            return 4;
        }
        if (sc.equals("21")) {
            return 0;
        }
        if (sc.equals("67")) {
            return 1;
        }
        if (sc.equals("62")) {
            return 3;
        }
        if (sc.equals("61")) {
            return 2;
        }
        if (sc.equals("004")) {
            return 5;
        }
        throw new RuntimeException("invalid call forward sc");
    }

    private static final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$siToServiceClass(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        int serviceCode = Integer.parseInt(si, 10);
        switch (serviceCode) {
            case 10: {
                return 13;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 19: {
                return 5;
            }
            case 20: {
                return 48;
            }
            case 21: {
                return 160;
            }
            case 22: {
                return 80;
            }
            case 24: {
                return 16;
            }
            case 25: {
                return 32;
            }
            case 26: {
                return 17;
            }
            case 99: {
                return 64;
            }
        }
        throw new RuntimeException("unsupported MMI service code " + si);
    }

    private static final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$siToTime(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        return Integer.parseInt(si, 10);
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isServiceCodeCallForwarding(String sc) {
        return sc != null && (sc.equals("21") || sc.equals("67") || sc.equals("61") || sc.equals("62") || sc.equals("002") || sc.equals("004"));
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isServiceCodeCallBarring(String sc) {
        String[] barringMMI;
        Resources resource = Resources.getSystem();
        if (sc != null && (barringMMI = resource.getStringArray(17235987)) != null) {
            for (String match : barringMMI) {
                if (!sc.equals(match)) continue;
                return true;
            }
        }
        return false;
    }

    private static final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$scToBarringFacility(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call barring sc");
        }
        if (sc.equals("33")) {
            return "AO";
        }
        if (sc.equals("331")) {
            return "OI";
        }
        if (sc.equals("332")) {
            return "OX";
        }
        if (sc.equals("35")) {
            return "AI";
        }
        if (sc.equals("351")) {
            return "IR";
        }
        if (sc.equals("330")) {
            return "AB";
        }
        if (sc.equals("333")) {
            return "AG";
        }
        if (sc.equals("353")) {
            return "AC";
        }
        throw new RuntimeException("invalid call barring sc");
    }

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$__constructor__(ImsPhone phone) {
        this.mState = MmiCode.State.PENDING;
        this.mPhone = phone;
        this.mContext = phone.getContext();
        this.mIccRecords = this.mPhone.mDefaultPhone.getIccRecords();
    }

    private final MmiCode.State $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getState() {
        return this.mState;
    }

    private final CharSequence $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getMessage() {
        return this.mMessage;
    }

    private final Phone $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getPhone() {
        return this.mPhone;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$cancel() {
        if (this.mState == MmiCode.State.COMPLETE || this.mState == MmiCode.State.FAILED) {
            return;
        }
        this.mState = MmiCode.State.CANCELLED;
        if (this.mIsPendingUSSD) {
            this.mPhone.cancelUSSD();
        } else {
            this.mPhone.onMMIDone(this);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isCancelable() {
        return this.mIsPendingUSSD;
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getDialingNumber() {
        return this.mDialingNumber;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isMMI() {
        return this.mPoundString != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isShortCode() {
        return this.mPoundString == null && this.mDialingNumber != null && this.mDialingNumber.length() <= 2;
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getDialString() {
        return this.mPoundString;
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isTwoDigitShortCode(Context context, String dialString) {
        Rlog.d("ImsPhoneMmiCode", "isTwoDigitShortCode");
        if (dialString == null || dialString.length() > 2) {
            return false;
        }
        if (sTwoDigitNumberPattern == null) {
            sTwoDigitNumberPattern = context.getResources().getStringArray(17236040);
        }
        for (String dialnumber : sTwoDigitNumberPattern) {
            Rlog.d("ImsPhoneMmiCode", "Two Digit Number Pattern " + dialnumber);
            if (!dialString.equals(dialnumber)) continue;
            Rlog.d("ImsPhoneMmiCode", "Two Digit Number Pattern -true");
            return true;
        }
        Rlog.d("ImsPhoneMmiCode", "Two Digit Number Pattern -false");
        return false;
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isShortCode(String dialString, ImsPhone phone) {
        if (dialString == null) {
            return false;
        }
        if (dialString.length() == 0) {
            return false;
        }
        if (PhoneNumberUtils.isLocalEmergencyNumber(phone.getContext(), dialString)) {
            return false;
        }
        return ImsPhoneMmiCode.isShortCodeUSSD(dialString, phone);
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isShortCodeUSSD(String dialString, ImsPhone phone) {
        if (dialString != null && dialString.length() <= 2) {
            if (phone.isInCall()) {
                return true;
            }
            if (dialString.length() != 2 || dialString.charAt(0) != '1') {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isPinPukCommand() {
        return this.mSc != null && (this.mSc.equals("04") || this.mSc.equals("042") || this.mSc.equals("05") || this.mSc.equals("052"));
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isTemporaryModeCLIR() {
        return this.mSc != null && this.mSc.equals("31") && this.mDialingNumber != null && (this.isActivate() || this.isDeactivate());
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getCLIRMode() {
        if (this.mSc != null && this.mSc.equals("31")) {
            if (this.isActivate()) {
                return 2;
            }
            if (this.isDeactivate()) {
                return 1;
            }
        }
        return 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isActivate() {
        return this.mAction != null && this.mAction.equals("*");
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isDeactivate() {
        return this.mAction != null && this.mAction.equals("#");
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isInterrogate() {
        return this.mAction != null && this.mAction.equals("*#");
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isRegister() {
        return this.mAction != null && this.mAction.equals("**");
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isErasure() {
        return this.mAction != null && this.mAction.equals("##");
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isPendingUSSD() {
        return this.mIsPendingUSSD;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isUssdRequest() {
        return this.mIsUssdRequest;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isSupportedOverImsPhone() {
        if (this.isShortCode()) {
            return true;
        }
        if (this.mDialingNumber != null) {
            return false;
        }
        if (ImsPhoneMmiCode.isServiceCodeCallForwarding(this.mSc) || ImsPhoneMmiCode.isServiceCodeCallBarring(this.mSc) || this.mSc != null && this.mSc.equals("43") || this.mSc != null && this.mSc.equals("31") || this.mSc != null && this.mSc.equals("30") || this.mSc != null && this.mSc.equals("77") || this.mSc != null && this.mSc.equals("76") || this.mSc != null && this.mSc.equals("156") || this.mSc != null && this.mSc.equals("157")) {
            try {
                int serviceClass = ImsPhoneMmiCode.siToServiceClass(this.mSib);
                return serviceClass == 0 || serviceClass == 1;
            }
            catch (RuntimeException exc) {
                Rlog.d("ImsPhoneMmiCode", "Invalid service class " + exc);
            }
        } else {
            if (this.isPinPukCommand() || this.mSc != null && (this.mSc.equals("03") || this.mSc.equals("30") || this.mSc.equals("31"))) {
                return false;
            }
            if (this.mPoundString != null) {
                return true;
            }
        }
        return false;
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$callBarAction(String dialingNumber) {
        if (this.isActivate()) {
            return 1;
        }
        if (this.isDeactivate()) {
            return 0;
        }
        if (this.isRegister()) {
            if (!ImsPhoneMmiCode.isEmptyOrNull(dialingNumber)) {
                return 3;
            }
            throw new RuntimeException("invalid action");
        }
        if (this.isErasure()) {
            return 4;
        }
        throw new RuntimeException("invalid action");
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$processCode() throws CallStateException {
        block68: {
            try {
                if (this.isShortCode()) {
                    Rlog.d("ImsPhoneMmiCode", "processCode: isShortCode");
                    Rlog.d("ImsPhoneMmiCode", "processCode: Sending short code '" + this.mDialingNumber + "' over CS pipe.");
                    throw new CallStateException("cs_fallback");
                }
                if (ImsPhoneMmiCode.isServiceCodeCallForwarding(this.mSc)) {
                    Rlog.d("ImsPhoneMmiCode", "processCode: is CF");
                    String dialingNumber = this.mSia;
                    int reason = ImsPhoneMmiCode.scToCallForwardReason(this.mSc);
                    int serviceClass = ImsPhoneMmiCode.siToServiceClass(this.mSib);
                    int time = ImsPhoneMmiCode.siToTime(this.mSic);
                    if (this.isInterrogate()) {
                        this.mPhone.getCallForwardingOption(reason, this.obtainMessage(1, this));
                    } else {
                        int cfAction;
                        if (this.isActivate()) {
                            if (ImsPhoneMmiCode.isEmptyOrNull(dialingNumber)) {
                                cfAction = 1;
                                this.mIsCallFwdReg = false;
                            } else {
                                cfAction = 3;
                                this.mIsCallFwdReg = true;
                            }
                        } else if (this.isDeactivate()) {
                            cfAction = 0;
                        } else if (this.isRegister()) {
                            cfAction = 3;
                        } else if (this.isErasure()) {
                            cfAction = 4;
                        } else {
                            throw new RuntimeException("invalid action");
                        }
                        int isSettingUnconditional = reason == 0 || reason == 4 ? 1 : 0;
                        int isEnableDesired = cfAction == 1 || cfAction == 3 ? 1 : 0;
                        Rlog.d("ImsPhoneMmiCode", "processCode: is CF setCallForward");
                        this.mPhone.setCallForwardingOption(cfAction, reason, dialingNumber, serviceClass, time, this.obtainMessage(4, isSettingUnconditional, isEnableDesired, this));
                    }
                    break block68;
                }
                if (ImsPhoneMmiCode.isServiceCodeCallBarring(this.mSc)) {
                    String password = this.mSia;
                    String facility = ImsPhoneMmiCode.scToBarringFacility(this.mSc);
                    if (this.isInterrogate()) {
                        this.mPhone.getCallBarring(facility, this.obtainMessage(7, this));
                        break block68;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        this.mPhone.setCallBarring(facility, this.isActivate(), password, this.obtainMessage(0, this));
                        break block68;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals("31")) {
                    if (this.isActivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCLIR(1, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for updateCLIR.");
                        }
                        break block68;
                    }
                    if (this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCLIR(2, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for updateCLIR.");
                        }
                        break block68;
                    }
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCLIR(this.obtainMessage(6, this));
                        }
                        catch (ImsException e) {
                            Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for queryCLIR.");
                        }
                        break block68;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals("30")) {
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCLIP(this.obtainMessage(7, this));
                        }
                        catch (ImsException e) {
                            Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for queryCLIP.");
                        }
                        break block68;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCLIP(this.isActivate(), this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for updateCLIP.");
                        }
                        break block68;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals("76")) {
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCOLP(this.obtainMessage(7, this));
                        }
                        catch (ImsException e) {
                            Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for queryCOLP.");
                        }
                        break block68;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCOLP(this.isActivate(), this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for updateCOLP.");
                        }
                        break block68;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals("77")) {
                    if (this.isActivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCOLR(1, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for updateCOLR.");
                        }
                        break block68;
                    }
                    if (this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCOLR(0, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for updateCOLR.");
                        }
                        break block68;
                    }
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCOLR(this.obtainMessage(7, this));
                        }
                        catch (ImsException e) {
                            Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for queryCOLR.");
                        }
                        break block68;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals("156")) {
                    try {
                        if (this.isInterrogate()) {
                            this.mPhone.mCT.getUtInterface().queryCallBarring(10, this.obtainMessage(10, this));
                            break block68;
                        }
                        this.processIcbMmiCodeForUpdate();
                    }
                    catch (ImsException e) {
                        Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for ICB.");
                    }
                    break block68;
                }
                if (this.mSc != null && this.mSc.equals("157")) {
                    int callAction = 0;
                    try {
                        if (this.isInterrogate()) {
                            this.mPhone.mCT.getUtInterface().queryCallBarring(6, this.obtainMessage(10, this));
                            break block68;
                        }
                        if (this.isActivate()) {
                            callAction = 1;
                        } else if (this.isDeactivate()) {
                            callAction = 0;
                        }
                        this.mPhone.mCT.getUtInterface().updateCallBarring(6, callAction, this.obtainMessage(0, this), null);
                    }
                    catch (ImsException e) {
                        Rlog.d("ImsPhoneMmiCode", "processCode: Could not get UT handle for ICBa.");
                    }
                    break block68;
                }
                if (this.mSc != null && this.mSc.equals("43")) {
                    int serviceClass = ImsPhoneMmiCode.siToServiceClass(this.mSib);
                    if (this.isActivate() || this.isDeactivate()) {
                        this.mPhone.setCallWaiting(this.isActivate(), serviceClass, this.obtainMessage(0, this));
                        break block68;
                    }
                    if (this.isInterrogate()) {
                        this.mPhone.getCallWaiting(this.obtainMessage(3, this));
                        break block68;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mPoundString != null) {
                    Rlog.d("ImsPhoneMmiCode", "processCode: Sending pound string '" + this.mDialingNumber + "' over CS pipe.");
                    throw new CallStateException("cs_fallback");
                }
                Rlog.d("ImsPhoneMmiCode", "processCode: invalid or unsupported MMI");
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            catch (RuntimeException exc) {
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.mContext.getText(17040268);
                Rlog.d("ImsPhoneMmiCode", "processCode: RuntimeException = " + exc);
                this.mPhone.onMMIDone(this);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onUssdFinished(String ussdMessage, boolean isUssdRequest) {
        if (this.mState == MmiCode.State.PENDING) {
            if (TextUtils.isEmpty(ussdMessage)) {
                this.mMessage = this.mContext.getText(17040267);
                Rlog.v("ImsPhoneMmiCode", "onUssdFinished: no message; using: " + this.mMessage);
            } else {
                Rlog.v("ImsPhoneMmiCode", "onUssdFinished: message: " + ussdMessage);
                this.mMessage = ussdMessage;
            }
            this.mIsUssdRequest = isUssdRequest;
            if (!isUssdRequest) {
                this.mState = MmiCode.State.COMPLETE;
            }
            this.mPhone.onMMIDone(this);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onUssdFinishedError() {
        if (this.mState == MmiCode.State.PENDING) {
            this.mState = MmiCode.State.FAILED;
            this.mMessage = this.mContext.getText(17040268);
            Rlog.d("ImsPhoneMmiCode", "onUssdFinishedError: mmi=" + this);
            this.mPhone.onMMIDone(this);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$sendUssd(String ussdMessage) {
        this.mIsPendingUSSD = true;
        this.mPhone.sendUSSD(ussdMessage, this.obtainMessage(2, this));
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSetComplete(msg, ar);
                break;
            }
            case 4: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && msg.arg1 == 1) {
                    boolean cffEnabled;
                    boolean bl = cffEnabled = msg.arg2 == 1;
                    if (this.mIccRecords != null) {
                        this.mPhone.setVoiceCallForwardingFlag(1, cffEnabled, this.mDialingNumber);
                    }
                }
                this.onSetComplete(msg, ar);
                break;
            }
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryCfComplete(ar);
                break;
            }
            case 3: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryComplete(ar);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) break;
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.getErrorMessage(ar);
                this.mPhone.onMMIDone(this);
                break;
            }
            case 5: {
                this.mPhone.onMMIDone(this);
                break;
            }
            case 7: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSuppSvcQueryComplete(ar);
                break;
            }
            case 10: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onIcbQueryComplete(ar);
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryClirComplete(ar);
                break;
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$processIcbMmiCodeForUpdate() {
        String dialingNumber = this.mSia;
        String[] icbNum = null;
        if (dialingNumber != null) {
            icbNum = dialingNumber.split("\\$");
        }
        int callAction = this.callBarAction(dialingNumber);
        try {
            this.mPhone.mCT.getUtInterface().updateCallBarring(10, callAction, this.obtainMessage(0, this), icbNum);
        }
        catch (ImsException e) {
            Rlog.d("ImsPhoneMmiCode", "processIcbMmiCodeForUpdate:Could not get UT handle for updating ICB.");
        }
    }

    private final CharSequence $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getErrorMessage(AsyncResult ar) {
        return this.mContext.getText(17040268);
    }

    private final CharSequence $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getScString() {
        if (this.mSc != null) {
            if (ImsPhoneMmiCode.isServiceCodeCallBarring(this.mSc)) {
                return this.mContext.getText(17039386);
            }
            if (ImsPhoneMmiCode.isServiceCodeCallForwarding(this.mSc)) {
                return this.mContext.getText(17039392);
            }
            if (this.mSc.equals("03")) {
                return this.mContext.getText(17039407);
            }
            if (this.mSc.equals("43")) {
                return this.mContext.getText(17039400);
            }
            if (this.mSc.equals("30")) {
                return this.mContext.getText(17039393);
            }
            if (this.mSc.equals("31")) {
                return this.mContext.getText(17039394);
            }
            if (this.mSc.equals("76")) {
                return this.mContext.getText(17039398);
            }
            if (this.mSc.equals("77")) {
                return this.mContext.getText(17039399);
            }
            if (this.mSc.equals("156")) {
                return "Specific Incoming Call Barring";
            }
            if (this.mSc.equals("157")) {
                return "Anonymous Incoming Call Barring";
            }
        }
        return "";
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onSetComplete(Message msg, AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof CommandException) {
                CommandException err = (CommandException)ar.exception;
                if (err.getCommandError() == CommandException.Error.PASSWORD_INCORRECT) {
                    sb.append(this.mContext.getText(17040350));
                } else if (err.getMessage() != null) {
                    sb.append(err.getMessage());
                } else {
                    sb.append(this.mContext.getText(17040268));
                }
            } else {
                ImsException error = (ImsException)ar.exception;
                if (error.getMessage() != null) {
                    sb.append(error.getMessage());
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            }
        } else if (this.isActivate()) {
            this.mState = MmiCode.State.COMPLETE;
            if (this.mIsCallFwdReg) {
                sb.append(this.mContext.getText(17040768));
            } else {
                sb.append(this.mContext.getText(17040764));
            }
        } else if (this.isDeactivate()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17040763));
        } else if (this.isRegister()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17040768));
        } else if (this.isErasure()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17040766));
        } else {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.mContext.getText(17040268));
        }
        this.mMessage = sb;
        Rlog.d("ImsPhoneMmiCode", "onSetComplete: mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private final CharSequence $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$serviceClassToCFString(int serviceClass) {
        switch (serviceClass) {
            case 1: {
                return this.mContext.getText(17040762);
            }
            case 2: {
                return this.mContext.getText(17040755);
            }
            case 4: {
                return this.mContext.getText(17040758);
            }
            case 8: {
                return this.mContext.getText(17040761);
            }
            case 16: {
                return this.mContext.getText(17040757);
            }
            case 32: {
                return this.mContext.getText(17040756);
            }
            case 64: {
                return this.mContext.getText(17040760);
            }
            case 128: {
                return this.mContext.getText(17040759);
            }
        }
        return null;
    }

    private final CharSequence $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$makeCFQueryResultMessage(CallForwardInfo info, int serviceClassMask) {
        boolean needTimeTemplate;
        String[] sources = new String[]{"{0}", "{1}", "{2}"};
        CharSequence[] destinations = new CharSequence[3];
        boolean bl = needTimeTemplate = info.reason == 2;
        CharSequence template = info.status == 1 ? (needTimeTemplate ? this.mContext.getText(17039603) : this.mContext.getText(17039602)) : (info.status == 0 && ImsPhoneMmiCode.isEmptyOrNull(info.number) ? this.mContext.getText(17039604) : (needTimeTemplate ? this.mContext.getText(17039606) : this.mContext.getText(17039605)));
        destinations[0] = this.serviceClassToCFString(info.serviceClass & serviceClassMask);
        destinations[1] = PhoneNumberUtils.stringFromStringAndTOA(info.number, info.toa);
        destinations[2] = Integer.toString(info.timeSeconds);
        if (info.reason == 0 && (info.serviceClass & serviceClassMask) == 1) {
            boolean cffEnabled;
            boolean bl2 = cffEnabled = info.status == 1;
            if (this.mIccRecords != null) {
                this.mPhone.setVoiceCallForwardingFlag(1, cffEnabled, info.number);
            }
        }
        return TextUtils.replace(template, sources, destinations);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onQueryCfComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof ImsException) {
                ImsException error = (ImsException)ar.exception;
                if (error.getMessage() != null) {
                    sb.append(error.getMessage());
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            } else {
                sb.append(this.getErrorMessage(ar));
            }
        } else {
            CallForwardInfo[] infos = (CallForwardInfo[])ar.result;
            if (infos.length == 0) {
                sb.append(this.mContext.getText(17040763));
                if (this.mIccRecords != null) {
                    this.mPhone.setVoiceCallForwardingFlag(1, false, null);
                }
            } else {
                SpannableStringBuilder tb = new SpannableStringBuilder();
                for (int serviceClassMask = 1; serviceClassMask <= 128; serviceClassMask <<= 1) {
                    int s = infos.length;
                    for (int i = 0; i < s; ++i) {
                        if ((serviceClassMask & infos[i].serviceClass) == 0) continue;
                        tb.append(this.makeCFQueryResultMessage(infos[i], serviceClassMask));
                        tb.append("\n");
                    }
                }
                sb.append(tb);
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        Rlog.d("ImsPhoneMmiCode", "onQueryCfComplete: mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onSuppSvcQueryComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof ImsException) {
                ImsException error = (ImsException)ar.exception;
                if (error.getMessage() != null) {
                    sb.append(error.getMessage());
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            } else {
                sb.append(this.getErrorMessage(ar));
            }
        } else {
            this.mState = MmiCode.State.FAILED;
            ImsSsInfo ssInfo = null;
            if (ar.result instanceof Bundle) {
                Rlog.d("ImsPhoneMmiCode", "onSuppSvcQueryComplete: Received CLIP/COLP/COLR Response.");
                Bundle ssInfoResp = (Bundle)ar.result;
                ssInfo = (ImsSsInfo)ssInfoResp.getParcelable("imsSsInfo");
                if (ssInfo != null) {
                    Rlog.d("ImsPhoneMmiCode", "onSuppSvcQueryComplete: ImsSsInfo mStatus = " + ssInfo.mStatus);
                    if (ssInfo.mStatus == 0) {
                        sb.append(this.mContext.getText(17040763));
                        this.mState = MmiCode.State.COMPLETE;
                    } else if (ssInfo.mStatus == 1) {
                        sb.append(this.mContext.getText(17040764));
                        this.mState = MmiCode.State.COMPLETE;
                    } else {
                        sb.append(this.mContext.getText(17040268));
                    }
                } else {
                    sb.append(this.mContext.getText(17040268));
                }
            } else {
                Rlog.d("ImsPhoneMmiCode", "onSuppSvcQueryComplete: Received Call Barring Response.");
                int[] cbInfos = (int[])ar.result;
                if (cbInfos[0] == 1) {
                    sb.append(this.mContext.getText(17040764));
                    this.mState = MmiCode.State.COMPLETE;
                } else {
                    sb.append(this.mContext.getText(17040763));
                    this.mState = MmiCode.State.COMPLETE;
                }
            }
        }
        this.mMessage = sb;
        Rlog.d("ImsPhoneMmiCode", "onSuppSvcQueryComplete mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onIcbQueryComplete(AsyncResult ar) {
        Rlog.d("ImsPhoneMmiCode", "onIcbQueryComplete mmi=" + this);
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof ImsException) {
                ImsException error = (ImsException)ar.exception;
                if (error.getMessage() != null) {
                    sb.append(error.getMessage());
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            } else {
                sb.append(this.getErrorMessage(ar));
            }
        } else {
            ImsSsInfo[] infos = (ImsSsInfo[])ar.result;
            if (infos.length == 0) {
                sb.append(this.mContext.getText(17040763));
            } else {
                int s = infos.length;
                for (int i = 0; i < s; ++i) {
                    if (infos[i].mIcbNum != null) {
                        sb.append("Num: " + infos[i].mIcbNum + " status: " + infos[i].mStatus + "\n");
                        continue;
                    }
                    if (infos[i].mStatus == 1) {
                        sb.append(this.mContext.getText(17040764));
                        continue;
                    }
                    sb.append(this.mContext.getText(17040763));
                }
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onQueryClirComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        this.mState = MmiCode.State.FAILED;
        if (ar.exception != null) {
            if (ar.exception instanceof ImsException) {
                ImsException error = (ImsException)ar.exception;
                if (error.getMessage() != null) {
                    sb.append(error.getMessage());
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            }
        } else {
            Bundle ssInfo = (Bundle)ar.result;
            int[] clirInfo = ssInfo.getIntArray("queryClir");
            Rlog.d("ImsPhoneMmiCode", "onQueryClirComplete: CLIR param n=" + clirInfo[0] + " m=" + clirInfo[1]);
            block0 : switch (clirInfo[1]) {
                case 0: {
                    sb.append(this.mContext.getText(17040767));
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 1: {
                    sb.append(this.mContext.getText(17039391));
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 3: {
                    switch (clirInfo[0]) {
                        case 0: {
                            sb.append(this.mContext.getText(17039390));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 1: {
                            sb.append(this.mContext.getText(17039390));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 2: {
                            sb.append(this.mContext.getText(17039389));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                    }
                    sb.append(this.mContext.getText(17040268));
                    this.mState = MmiCode.State.FAILED;
                    break;
                }
                case 4: {
                    switch (clirInfo[0]) {
                        case 0: {
                            sb.append(this.mContext.getText(17039387));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 1: {
                            sb.append(this.mContext.getText(17039388));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 2: {
                            sb.append(this.mContext.getText(17039387));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                    }
                    sb.append(this.mContext.getText(17040268));
                    this.mState = MmiCode.State.FAILED;
                    break;
                }
                default: {
                    sb.append(this.mContext.getText(17040268));
                    this.mState = MmiCode.State.FAILED;
                }
            }
        }
        this.mMessage = sb;
        Rlog.d("ImsPhoneMmiCode", "onQueryClirComplete mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onQueryComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof ImsException) {
                ImsException error = (ImsException)ar.exception;
                if (error.getMessage() != null) {
                    sb.append(error.getMessage());
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            } else {
                sb.append(this.getErrorMessage(ar));
            }
        } else {
            int[] ints = (int[])ar.result;
            if (ints.length != 0) {
                if (ints[0] == 0) {
                    sb.append(this.mContext.getText(17040763));
                } else if (this.mSc.equals("43")) {
                    sb.append(this.createQueryCallWaitingResultMessage(ints[1]));
                } else if (ints[0] == 1) {
                    sb.append(this.mContext.getText(17040764));
                } else {
                    sb.append(this.mContext.getText(17040268));
                }
            } else {
                sb.append(this.mContext.getText(17040268));
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        Rlog.d("ImsPhoneMmiCode", "onQueryComplete mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private final CharSequence $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$createQueryCallWaitingResultMessage(int serviceClass) {
        StringBuilder sb = new StringBuilder(this.mContext.getText(17040765));
        for (int classMask = 1; classMask <= 128; classMask <<= 1) {
            if ((classMask & serviceClass) == 0) continue;
            sb.append("\n");
            sb.append(this.serviceClassToCFString(classMask & serviceClass));
        }
        return sb;
    }

    private final ResultReceiver $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getUssdCallbackReceiver() {
        return this.mCallbackReceiver;
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$toString() {
        StringBuilder sb = new StringBuilder("ImsPhoneMmiCode {");
        sb.append("State=" + (Object)((Object)this.getState()));
        if (this.mAction != null) {
            sb.append(" action=" + this.mAction);
        }
        if (this.mSc != null) {
            sb.append(" sc=" + this.mSc);
        }
        if (this.mSia != null) {
            sb.append(" sia=" + this.mSia);
        }
        if (this.mSib != null) {
            sb.append(" sib=" + this.mSib);
        }
        if (this.mSic != null) {
            sb.append(" sic=" + this.mSic);
        }
        if (this.mPoundString != null) {
            sb.append(" poundString=" + Rlog.pii("ImsPhoneMmiCode", (Object)this.mPoundString));
        }
        if (this.mDialingNumber != null) {
            sb.append(" dialingNumber=" + Rlog.pii("ImsPhoneMmiCode", (Object)this.mDialingNumber));
        }
        if (this.mPwd != null) {
            sb.append(" pwd=" + Rlog.pii("ImsPhoneMmiCode", (Object)this.mPwd));
        }
        if (this.mCallbackReceiver != null) {
            sb.append(" hasReceiver");
        }
        sb.append("}");
        return sb.toString();
    }

    static void __staticInitializer__() {
        sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    }

    static ImsPhoneMmiCode newFromDialString(String string2, ImsPhone imsPhone) {
        return InvokeDynamicSupport.bootstrapStatic("newFromDialString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$newFromDialString(java.lang.String com.android.internal.telephony.imsphone.ImsPhone ), (String)string2, (ImsPhone)imsPhone);
    }

    static ImsPhoneMmiCode newFromDialString(String string2, ImsPhone imsPhone, ResultReceiver resultReceiver) {
        return InvokeDynamicSupport.bootstrapStatic("newFromDialString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$newFromDialString(java.lang.String com.android.internal.telephony.imsphone.ImsPhone android.os.ResultReceiver ), (String)string2, (ImsPhone)imsPhone, (ResultReceiver)resultReceiver);
    }

    static ImsPhoneMmiCode newNetworkInitiatedUssd(String string2, boolean bl, ImsPhone imsPhone) {
        return InvokeDynamicSupport.bootstrapStatic("newNetworkInitiatedUssd", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$newNetworkInitiatedUssd(java.lang.String boolean com.android.internal.telephony.imsphone.ImsPhone ), (String)string2, (boolean)bl, (ImsPhone)imsPhone);
    }

    static ImsPhoneMmiCode newFromUssdUserInput(String string2, ImsPhone imsPhone) {
        return InvokeDynamicSupport.bootstrapStatic("newFromUssdUserInput", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$newFromUssdUserInput(java.lang.String com.android.internal.telephony.imsphone.ImsPhone ), (String)string2, (ImsPhone)imsPhone);
    }

    private static String makeEmptyNull(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeEmptyNull", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$makeEmptyNull(java.lang.String ), (String)string2);
    }

    static boolean isScMatchesSuppServType(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isScMatchesSuppServType", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isScMatchesSuppServType(java.lang.String ), (String)string2);
    }

    private static boolean isEmptyOrNull(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmptyOrNull", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isEmptyOrNull(java.lang.CharSequence ), (CharSequence)charSequence);
    }

    private static int scToCallForwardReason(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("scToCallForwardReason", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$scToCallForwardReason(java.lang.String ), (String)string2);
    }

    private static int siToServiceClass(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("siToServiceClass", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$siToServiceClass(java.lang.String ), (String)string2);
    }

    private static int siToTime(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("siToTime", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$siToTime(java.lang.String ), (String)string2);
    }

    static boolean isServiceCodeCallForwarding(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isServiceCodeCallForwarding", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isServiceCodeCallForwarding(java.lang.String ), (String)string2);
    }

    static boolean isServiceCodeCallBarring(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isServiceCodeCallBarring", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isServiceCodeCallBarring(java.lang.String ), (String)string2);
    }

    static String scToBarringFacility(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("scToBarringFacility", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$scToBarringFacility(java.lang.String ), (String)string2);
    }

    private void __constructor__(ImsPhone imsPhone) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$__constructor__(imsPhone);
    }

    public ImsPhoneMmiCode(ImsPhone imsPhone) {
        super(imsPhone.getHandler().getLooper());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$__constructor__(com.android.internal.telephony.imsphone.ImsPhone ), this, imsPhone);
    }

    @Override
    public MmiCode.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getState(), this);
    }

    @Override
    public CharSequence getMessage() {
        return InvokeDynamicSupport.bootstrap("getMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getMessage(), this);
    }

    @Override
    public Phone getPhone() {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getPhone(), this);
    }

    @Override
    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$cancel(), this);
    }

    @Override
    public boolean isCancelable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCancelable", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isCancelable(), this);
    }

    String getDialingNumber() {
        return InvokeDynamicSupport.bootstrap("getDialingNumber", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getDialingNumber(), this);
    }

    boolean isMMI() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMMI", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isMMI(), this);
    }

    boolean isShortCode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShortCode", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isShortCode(), this);
    }

    @Override
    public String getDialString() {
        return InvokeDynamicSupport.bootstrap("getDialString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getDialString(), this);
    }

    private static boolean isTwoDigitShortCode(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTwoDigitShortCode", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isTwoDigitShortCode(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    private static boolean isShortCode(String string2, ImsPhone imsPhone) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isShortCode", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isShortCode(java.lang.String com.android.internal.telephony.imsphone.ImsPhone ), (String)string2, (ImsPhone)imsPhone);
    }

    private static boolean isShortCodeUSSD(String string2, ImsPhone imsPhone) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isShortCodeUSSD", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isShortCodeUSSD(java.lang.String com.android.internal.telephony.imsphone.ImsPhone ), (String)string2, (ImsPhone)imsPhone);
    }

    @Override
    public boolean isPinPukCommand() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPinPukCommand", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isPinPukCommand(), this);
    }

    boolean isTemporaryModeCLIR() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTemporaryModeCLIR", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isTemporaryModeCLIR(), this);
    }

    int getCLIRMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCLIRMode", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getCLIRMode(), this);
    }

    boolean isActivate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActivate", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isActivate(), this);
    }

    boolean isDeactivate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeactivate", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isDeactivate(), this);
    }

    boolean isInterrogate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInterrogate", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isInterrogate(), this);
    }

    boolean isRegister() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRegister", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isRegister(), this);
    }

    boolean isErasure() {
        return (boolean)InvokeDynamicSupport.bootstrap("isErasure", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isErasure(), this);
    }

    public boolean isPendingUSSD() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPendingUSSD", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isPendingUSSD(), this);
    }

    @Override
    public boolean isUssdRequest() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUssdRequest", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isUssdRequest(), this);
    }

    boolean isSupportedOverImsPhone() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSupportedOverImsPhone", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$isSupportedOverImsPhone(), this);
    }

    public int callBarAction(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("callBarAction", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$callBarAction(java.lang.String ), this, string2);
    }

    @Override
    public void processCode() throws CallStateException {
        InvokeDynamicSupport.bootstrap("processCode", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$processCode(), this);
    }

    void onUssdFinished(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("onUssdFinished", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onUssdFinished(java.lang.String boolean ), this, string2, bl);
    }

    void onUssdFinishedError() {
        InvokeDynamicSupport.bootstrap("onUssdFinishedError", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onUssdFinishedError(), this);
    }

    void sendUssd(String string2) {
        InvokeDynamicSupport.bootstrap("sendUssd", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$sendUssd(java.lang.String ), this, string2);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$handleMessage(android.os.Message ), this, message);
    }

    private void processIcbMmiCodeForUpdate() {
        InvokeDynamicSupport.bootstrap("processIcbMmiCodeForUpdate", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$processIcbMmiCodeForUpdate(), this);
    }

    private CharSequence getErrorMessage(AsyncResult asyncResult) {
        return InvokeDynamicSupport.bootstrap("getErrorMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getErrorMessage(android.os.AsyncResult ), this, asyncResult);
    }

    private CharSequence getScString() {
        return InvokeDynamicSupport.bootstrap("getScString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getScString(), this);
    }

    private void onSetComplete(Message message, AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onSetComplete", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onSetComplete(android.os.Message android.os.AsyncResult ), this, message, asyncResult);
    }

    private CharSequence serviceClassToCFString(int n) {
        return InvokeDynamicSupport.bootstrap("serviceClassToCFString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$serviceClassToCFString(int ), this, n);
    }

    private CharSequence makeCFQueryResultMessage(CallForwardInfo callForwardInfo, int n) {
        return InvokeDynamicSupport.bootstrap("makeCFQueryResultMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$makeCFQueryResultMessage(com.android.internal.telephony.CallForwardInfo int ), this, callForwardInfo, n);
    }

    private void onQueryCfComplete(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onQueryCfComplete", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onQueryCfComplete(android.os.AsyncResult ), this, asyncResult);
    }

    private void onSuppSvcQueryComplete(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onSuppSvcQueryComplete", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onSuppSvcQueryComplete(android.os.AsyncResult ), this, asyncResult);
    }

    private void onIcbQueryComplete(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onIcbQueryComplete", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onIcbQueryComplete(android.os.AsyncResult ), this, asyncResult);
    }

    private void onQueryClirComplete(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onQueryClirComplete", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onQueryClirComplete(android.os.AsyncResult ), this, asyncResult);
    }

    private void onQueryComplete(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onQueryComplete", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$onQueryComplete(android.os.AsyncResult ), this, asyncResult);
    }

    private CharSequence createQueryCallWaitingResultMessage(int n) {
        return InvokeDynamicSupport.bootstrap("createQueryCallWaitingResultMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$createQueryCallWaitingResultMessage(int ), this, n);
    }

    @Override
    public ResultReceiver getUssdCallbackReceiver() {
        return InvokeDynamicSupport.bootstrap("getUssdCallbackReceiver", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$getUssdCallbackReceiver(), this);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneMmiCode$toString(), this);
    }

    static {
        RobolectricInternals.classInitializing(ImsPhoneMmiCode.class);
    }

    public /* synthetic */ ImsPhoneMmiCode() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsPhoneMmiCode)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

