/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.metrics;

import android.os.SystemClock;
import com.android.internal.telephony.metrics.SmsSessionEventBuilder;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.nano.TelephonyProto;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InProgressSmsSession
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MAX_EVENTS = 20;
    public int phoneId;
    public Deque<TelephonyProto.SmsSession.Event> events;
    public int startSystemTimeMin;
    public long startElapsedTimeMs;
    private long mLastElapsedTimeMs;
    private boolean mEventsDropped;
    private AtomicInteger mNumExpectedResponses;

    private final void $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$increaseExpectedResponse() {
        this.mNumExpectedResponses.incrementAndGet();
    }

    private final void $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$decreaseExpectedResponse() {
        this.mNumExpectedResponses.decrementAndGet();
    }

    private final int $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$getNumExpectedResponses() {
        return this.mNumExpectedResponses.get();
    }

    private final boolean $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$isEventsDropped() {
        return this.mEventsDropped;
    }

    private void $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$__constructor__(int phoneId) {
        this.mEventsDropped = false;
        this.mNumExpectedResponses = new AtomicInteger(0);
        this.phoneId = phoneId;
        this.events = new ArrayDeque<TelephonyProto.SmsSession.Event>();
        this.startSystemTimeMin = TelephonyMetrics.roundSessionStart((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        this.mLastElapsedTimeMs = this.startElapsedTimeMs = SystemClock.elapsedRealtime();
    }

    private final void $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$addEvent(SmsSessionEventBuilder builder) {
        this.addEvent(SystemClock.elapsedRealtime(), builder);
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$addEvent(long timestamp, SmsSessionEventBuilder builder) {
        if (this.events.size() >= 20) {
            this.events.removeFirst();
            this.mEventsDropped = true;
        }
        builder.setDelay(TelephonyMetrics.toPrivacyFuzzedTimeInterval(this.mLastElapsedTimeMs, timestamp));
        this.events.add(builder.build());
        this.mLastElapsedTimeMs = timestamp;
    }

    public void increaseExpectedResponse() {
        InvokeDynamicSupport.bootstrap("increaseExpectedResponse", $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$increaseExpectedResponse(), this);
    }

    public void decreaseExpectedResponse() {
        InvokeDynamicSupport.bootstrap("decreaseExpectedResponse", $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$decreaseExpectedResponse(), this);
    }

    public int getNumExpectedResponses() {
        return (int)InvokeDynamicSupport.bootstrap("getNumExpectedResponses", $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$getNumExpectedResponses(), this);
    }

    public boolean isEventsDropped() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEventsDropped", $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$isEventsDropped(), this);
    }

    private void __constructor__(int n) {
        this.$$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$__constructor__(n);
    }

    public InProgressSmsSession(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$__constructor__(int ), this, n);
    }

    public void addEvent(SmsSessionEventBuilder smsSessionEventBuilder) {
        InvokeDynamicSupport.bootstrap("addEvent", $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$addEvent(com.android.internal.telephony.metrics.SmsSessionEventBuilder ), this, smsSessionEventBuilder);
    }

    public synchronized void addEvent(long l, SmsSessionEventBuilder smsSessionEventBuilder) {
        InvokeDynamicSupport.bootstrap("addEvent", $$robo$$com_android_internal_telephony_metrics_InProgressSmsSession$addEvent(long com.android.internal.telephony.metrics.SmsSessionEventBuilder ), this, l, smsSessionEventBuilder);
    }

    public /* synthetic */ InProgressSmsSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InProgressSmsSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

