/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IsimUiccRecords
extends IccRecords
implements IsimRecords,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected static String LOG_TAG = "IsimUiccRecords";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static boolean DUMP_RECORDS = false;
    public static String INTENT_ISIM_REFRESH = "com.android.intent.isim_refresh";
    private static int EVENT_APP_READY = 1;
    private static int EVENT_ISIM_REFRESH = 31;
    private static int EVENT_ISIM_AUTHENTICATE_DONE = 91;
    private String mIsimImpi;
    private String mIsimDomain;
    private String[] mIsimImpu;
    private String mIsimIst;
    private String[] mIsimPcscf;
    private String auth_rsp;
    private Object mLock;
    private static int TAG_ISIM_VALUE = 128;

    private final String $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$toString() {
        return "IsimUiccRecords: " + super.toString() + "";
    }

    private void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$__constructor__(UiccCardApplication app, Context c, CommandsInterface ci) {
        this.mLock = new Object();
        this.mRecordsRequested = false;
        this.mRecordsToLoad = 0;
        this.resetRecords();
        this.mCi.registerForIccRefresh(this, 31, null);
        this.mParentApp.registerForReady(this, 1, null);
        this.log("IsimUiccRecords X ctor this=" + this);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$dispose() {
        this.log("Disposing " + this);
        this.mCi.unregisterForIccRefresh(this);
        this.mParentApp.unregisterForReady(this);
        this.resetRecords();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$handleMessage(Message msg) {
        if (this.mDestroyed.get()) {
            Rlog.e("IsimUiccRecords", "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        this.loge("IsimUiccRecords: handleMessage " + msg + "[" + msg.what + "] ");
        try {
            switch (msg.what) {
                case 1: {
                    this.onReady();
                    break;
                }
                case 31: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.loge("ISim REFRESH(EVENT_ISIM_REFRESH) with exception: " + ar.exception);
                    if (ar.exception == null) {
                        Intent intent = new Intent("com.android.intent.isim_refresh");
                        this.loge("send ISim REFRESH: com.android.intent.isim_refresh");
                        this.mContext.sendBroadcast(intent);
                        this.handleIsimRefresh((IccRefreshResponse)ar.result);
                    }
                    break;
                }
                case 91: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.log("EVENT_ISIM_AUTHENTICATE_DONE");
                    if (ar.exception != null) {
                        this.log("Exception ISIM AKA: " + ar.exception);
                    } else {
                        try {
                            this.auth_rsp = (String)ar.result;
                            this.log("ISIM AKA: auth_rsp = " + this.auth_rsp);
                        }
                        catch (Exception e) {
                            this.log("Failed to parse ISIM AKA contents: " + e);
                        }
                    }
                    Object e = this.mLock;
                    synchronized (e) {
                        this.mLock.notifyAll();
                        break;
                    }
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
        catch (RuntimeException exc) {
            Rlog.w("IsimUiccRecords", "Exception parsing SIM record", exc);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$fetchIsimRecords() {
        this.mRecordsRequested = true;
        this.mFh.loadEFTransparent(28418, this.obtainMessage(100, new EfIsimImpiLoaded(this, null)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixedAll(28420, this.obtainMessage(100, new EfIsimImpuLoaded(this, null)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28419, this.obtainMessage(100, new EfIsimDomainLoaded(this, null)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28423, this.obtainMessage(100, new EfIsimIstLoaded(this, null)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixedAll(28425, this.obtainMessage(100, new EfIsimPcscfLoaded(this, null)));
        ++this.mRecordsToLoad;
        this.log("fetchIsimRecords " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$resetRecords() {
        this.mIsimImpi = null;
        this.mIsimDomain = null;
        this.mIsimImpu = null;
        this.mIsimIst = null;
        this.mIsimPcscf = null;
        this.auth_rsp = null;
        this.mRecordsRequested = false;
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$isimTlvToString(byte[] record) {
        SimTlv tlv = new SimTlv(record, 0, record.length);
        do {
            if (tlv.getTag() != 128) continue;
            return new String(tlv.getData(), Charset.forName("UTF-8"));
        } while (tlv.nextObject());
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$onRecordLoaded() {
        --this.mRecordsToLoad;
        this.log("onRecordLoaded " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
        if (this.mRecordsToLoad == 0 && this.mRecordsRequested) {
            this.onAllRecordsLoaded();
        } else if (this.mRecordsToLoad < 0) {
            this.loge("recordsToLoad <0, programmer error suspected");
            this.mRecordsToLoad = 0;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$onAllRecordsLoaded() {
        this.log("record load complete");
        this.mRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$handleFileUpdate(int efid) {
        switch (efid) {
            case 28418: {
                this.mFh.loadEFTransparent(28418, this.obtainMessage(100, new EfIsimImpiLoaded(this, null)));
                ++this.mRecordsToLoad;
                break;
            }
            case 28420: {
                this.mFh.loadEFLinearFixedAll(28420, this.obtainMessage(100, new EfIsimImpuLoaded(this, null)));
                ++this.mRecordsToLoad;
                break;
            }
            case 28419: {
                this.mFh.loadEFTransparent(28419, this.obtainMessage(100, new EfIsimDomainLoaded(this, null)));
                ++this.mRecordsToLoad;
                break;
            }
            case 28423: {
                this.mFh.loadEFTransparent(28423, this.obtainMessage(100, new EfIsimIstLoaded(this, null)));
                ++this.mRecordsToLoad;
                break;
            }
            case 28425: {
                this.mFh.loadEFLinearFixedAll(28425, this.obtainMessage(100, new EfIsimPcscfLoaded(this, null)));
                ++this.mRecordsToLoad;
            }
            default: {
                this.fetchIsimRecords();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$handleIsimRefresh(IccRefreshResponse refreshResponse) {
        if (refreshResponse == null) {
            this.log("handleIsimRefresh received without input");
            return;
        }
        if (!TextUtils.isEmpty(refreshResponse.aid) && !refreshResponse.aid.equals(this.mParentApp.getAid())) {
            this.log("handleIsimRefresh received different app");
            return;
        }
        switch (refreshResponse.refreshResult) {
            case 0: {
                this.log("handleIsimRefresh with REFRESH_RESULT_FILE_UPDATE");
                this.handleFileUpdate(refreshResponse.efId);
                break;
            }
            case 1: {
                this.log("handleIsimRefresh with REFRESH_RESULT_INIT");
                this.fetchIsimRecords();
                break;
            }
            case 2: {
                this.log("handleIsimRefresh with REFRESH_RESULT_RESET");
                break;
            }
            default: {
                this.log("handleIsimRefresh with unknown operation");
            }
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimImpi() {
        return this.mIsimImpi;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimDomain() {
        return this.mIsimDomain;
    }

    private final String[] $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimImpu() {
        return this.mIsimImpu != null ? (String[])this.mIsimImpu.clone() : null;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimIst() {
        return this.mIsimIst;
    }

    private final String[] $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimPcscf() {
        return this.mIsimPcscf != null ? (String[])this.mIsimPcscf.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimChallengeResponse(String nonce) {
        this.log("getIsimChallengeResponse-nonce:" + nonce);
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mCi.requestIsimAuthentication(nonce, this.obtainMessage(91));
                try {
                    this.mLock.wait();
                }
                catch (InterruptedException e) {
                    this.log("interrupted while trying to request Isim Auth");
                }
            }
        }
        catch (Exception e) {
            this.log("Fail while trying to request Isim Auth");
            return null;
        }
        this.log("getIsimChallengeResponse-auth_rsp" + this.auth_rsp);
        return this.auth_rsp;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getDisplayRule(String plmn) {
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$onReady() {
        this.fetchIsimRecords();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$onRefresh(boolean fileChanged, int[] fileList) {
        if (fileChanged) {
            this.fetchIsimRecords();
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$setVoiceMailNumber(String alphaTag, String voiceNumber, Message onComplete) {
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$setVoiceMessageWaiting(int line, int countWaiting) {
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$log(String s) {
        Rlog.d("IsimUiccRecords", "[ISIM] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$loge(String s) {
        Rlog.e("IsimUiccRecords", "[ISIM] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("IsimRecords: " + this);
        pw.println(" extends:");
        super.dump(fd, pw, args);
        pw.flush();
    }

    private final int $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getVoiceMessageCount() {
        return 0;
    }

    static /* synthetic */ String[] access$702(IsimUiccRecords x0, String[] x1) {
        x0.mIsimImpu = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1002(IsimUiccRecords x0, String[] x1) {
        x0.mIsimPcscf = x1;
        return x1;
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$toString(), this);
    }

    private void __constructor__(UiccCardApplication uiccCardApplication, Context context, CommandsInterface commandsInterface) {
        this.$$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$__constructor__(uiccCardApplication, context, commandsInterface);
    }

    public IsimUiccRecords(UiccCardApplication uiccCardApplication, Context context, CommandsInterface commandsInterface) {
        super(uiccCardApplication, context, commandsInterface);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$__constructor__(com.android.internal.telephony.uicc.UiccCardApplication android.content.Context com.android.internal.telephony.CommandsInterface ), this, uiccCardApplication, context, commandsInterface);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$dispose(), this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$handleMessage(android.os.Message ), this, message);
    }

    protected void fetchIsimRecords() {
        InvokeDynamicSupport.bootstrap("fetchIsimRecords", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$fetchIsimRecords(), this);
    }

    protected void resetRecords() {
        InvokeDynamicSupport.bootstrap("resetRecords", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$resetRecords(), this);
    }

    private static String isimTlvToString(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("isimTlvToString", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$isimTlvToString(byte[] ), (byte[])byArray);
    }

    @Override
    protected void onRecordLoaded() {
        InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$onRecordLoaded(), this);
    }

    @Override
    protected void onAllRecordsLoaded() {
        InvokeDynamicSupport.bootstrap("onAllRecordsLoaded", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$onAllRecordsLoaded(), this);
    }

    private void handleFileUpdate(int n) {
        InvokeDynamicSupport.bootstrap("handleFileUpdate", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$handleFileUpdate(int ), this, n);
    }

    private void handleIsimRefresh(IccRefreshResponse iccRefreshResponse) {
        InvokeDynamicSupport.bootstrap("handleIsimRefresh", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$handleIsimRefresh(com.android.internal.telephony.uicc.IccRefreshResponse ), this, iccRefreshResponse);
    }

    @Override
    public String getIsimImpi() {
        return InvokeDynamicSupport.bootstrap("getIsimImpi", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimImpi(), this);
    }

    @Override
    public String getIsimDomain() {
        return InvokeDynamicSupport.bootstrap("getIsimDomain", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimDomain(), this);
    }

    @Override
    public String[] getIsimImpu() {
        return InvokeDynamicSupport.bootstrap("getIsimImpu", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimImpu(), this);
    }

    @Override
    public String getIsimIst() {
        return InvokeDynamicSupport.bootstrap("getIsimIst", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimIst(), this);
    }

    @Override
    public String[] getIsimPcscf() {
        return InvokeDynamicSupport.bootstrap("getIsimPcscf", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimPcscf(), this);
    }

    @Override
    public String getIsimChallengeResponse(String string2) {
        return InvokeDynamicSupport.bootstrap("getIsimChallengeResponse", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getIsimChallengeResponse(java.lang.String ), this, string2);
    }

    @Override
    public int getDisplayRule(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getDisplayRule", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getDisplayRule(java.lang.String ), this, string2);
    }

    @Override
    public void onReady() {
        InvokeDynamicSupport.bootstrap("onReady", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$onReady(), this);
    }

    @Override
    public void onRefresh(boolean bl, int[] nArray) {
        InvokeDynamicSupport.bootstrap("onRefresh", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$onRefresh(boolean int[] ), this, bl, nArray);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setVoiceMailNumber", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$setVoiceMailNumber(java.lang.String java.lang.String android.os.Message ), this, string2, string3, message);
    }

    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVoiceMessageWaiting", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$setVoiceMessageWaiting(int int ), this, n, n2);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$log(java.lang.String ), this, string2);
    }

    @Override
    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$loge(java.lang.String ), this, string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public int getVoiceMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMessageCount", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords$getVoiceMessageCount(), this);
    }

    public /* synthetic */ IsimUiccRecords() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IsimUiccRecords)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class EfIsimPcscfLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ IsimUiccRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimPcscfLoaded$__constructor__(IsimUiccRecords isimUiccRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimPcscfLoaded$getEfName() {
            return "EF_ISIM_PCSCF";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimPcscfLoaded$onRecordLoaded(AsyncResult ar) {
            ArrayList pcscflist = (ArrayList)ar.result;
            this.this$0.log("EF_PCSCF record count: " + pcscflist.size());
            IsimUiccRecords.access$1002(this.this$0, new String[pcscflist.size()]);
            int i = 0;
            for (byte[] identity : pcscflist) {
                String pcscf = IsimUiccRecords.isimTlvToString(identity);
                ((IsimUiccRecords)this.this$0).mIsimPcscf[i++] = pcscf;
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimPcscfLoaded$__constructor__(IsimUiccRecords x0, 1 x1) {
        }

        private void __constructor__(IsimUiccRecords isimUiccRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimPcscfLoaded$__constructor__(isimUiccRecords);
        }

        public EfIsimPcscfLoaded(IsimUiccRecords isimUiccRecords) {
            this.this$0 = isimUiccRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimPcscfLoaded$__constructor__(com.android.internal.telephony.uicc.IsimUiccRecords ), this, isimUiccRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimPcscfLoaded$getEfName(), this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimPcscfLoaded$onRecordLoaded(android.os.AsyncResult ), this, asyncResult);
        }

        private /* synthetic */ void __constructor__(IsimUiccRecords isimUiccRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimPcscfLoaded$__constructor__(isimUiccRecords, var2_2);
        }

        public /* synthetic */ EfIsimPcscfLoaded(IsimUiccRecords isimUiccRecords, 1 var2_2) {
            this(isimUiccRecords);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimPcscfLoaded$__constructor__(com.android.internal.telephony.uicc.IsimUiccRecords com.android.internal.telephony.uicc.IsimUiccRecords$1 ), this, isimUiccRecords, var2_2);
        }

        public /* synthetic */ EfIsimPcscfLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfIsimPcscfLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfIsimIstLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ IsimUiccRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimIstLoaded$__constructor__(IsimUiccRecords isimUiccRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimIstLoaded$getEfName() {
            return "EF_ISIM_IST";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimIstLoaded$onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            this.this$0.mIsimIst = IccUtils.bytesToHexString(data);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimIstLoaded$__constructor__(IsimUiccRecords x0, 1 x1) {
        }

        private void __constructor__(IsimUiccRecords isimUiccRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimIstLoaded$__constructor__(isimUiccRecords);
        }

        public EfIsimIstLoaded(IsimUiccRecords isimUiccRecords) {
            this.this$0 = isimUiccRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimIstLoaded$__constructor__(com.android.internal.telephony.uicc.IsimUiccRecords ), this, isimUiccRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimIstLoaded$getEfName(), this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimIstLoaded$onRecordLoaded(android.os.AsyncResult ), this, asyncResult);
        }

        private /* synthetic */ void __constructor__(IsimUiccRecords isimUiccRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimIstLoaded$__constructor__(isimUiccRecords, var2_2);
        }

        public /* synthetic */ EfIsimIstLoaded(IsimUiccRecords isimUiccRecords, 1 var2_2) {
            this(isimUiccRecords);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimIstLoaded$__constructor__(com.android.internal.telephony.uicc.IsimUiccRecords com.android.internal.telephony.uicc.IsimUiccRecords$1 ), this, isimUiccRecords, var2_2);
        }

        public /* synthetic */ EfIsimIstLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfIsimIstLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfIsimDomainLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ IsimUiccRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimDomainLoaded$__constructor__(IsimUiccRecords isimUiccRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimDomainLoaded$getEfName() {
            return "EF_ISIM_DOMAIN";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimDomainLoaded$onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            this.this$0.mIsimDomain = IsimUiccRecords.isimTlvToString(data);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimDomainLoaded$__constructor__(IsimUiccRecords x0, 1 x1) {
        }

        private void __constructor__(IsimUiccRecords isimUiccRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimDomainLoaded$__constructor__(isimUiccRecords);
        }

        public EfIsimDomainLoaded(IsimUiccRecords isimUiccRecords) {
            this.this$0 = isimUiccRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimDomainLoaded$__constructor__(com.android.internal.telephony.uicc.IsimUiccRecords ), this, isimUiccRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimDomainLoaded$getEfName(), this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimDomainLoaded$onRecordLoaded(android.os.AsyncResult ), this, asyncResult);
        }

        private /* synthetic */ void __constructor__(IsimUiccRecords isimUiccRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimDomainLoaded$__constructor__(isimUiccRecords, var2_2);
        }

        public /* synthetic */ EfIsimDomainLoaded(IsimUiccRecords isimUiccRecords, 1 var2_2) {
            this(isimUiccRecords);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimDomainLoaded$__constructor__(com.android.internal.telephony.uicc.IsimUiccRecords com.android.internal.telephony.uicc.IsimUiccRecords$1 ), this, isimUiccRecords, var2_2);
        }

        public /* synthetic */ EfIsimDomainLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfIsimDomainLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfIsimImpuLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ IsimUiccRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpuLoaded$__constructor__(IsimUiccRecords isimUiccRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpuLoaded$getEfName() {
            return "EF_ISIM_IMPU";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpuLoaded$onRecordLoaded(AsyncResult ar) {
            ArrayList impuList = (ArrayList)ar.result;
            this.this$0.log("EF_IMPU record count: " + impuList.size());
            IsimUiccRecords.access$702(this.this$0, new String[impuList.size()]);
            int i = 0;
            for (byte[] identity : impuList) {
                String impu = IsimUiccRecords.isimTlvToString(identity);
                ((IsimUiccRecords)this.this$0).mIsimImpu[i++] = impu;
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpuLoaded$__constructor__(IsimUiccRecords x0, 1 x1) {
        }

        private void __constructor__(IsimUiccRecords isimUiccRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpuLoaded$__constructor__(isimUiccRecords);
        }

        public EfIsimImpuLoaded(IsimUiccRecords isimUiccRecords) {
            this.this$0 = isimUiccRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpuLoaded$__constructor__(com.android.internal.telephony.uicc.IsimUiccRecords ), this, isimUiccRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpuLoaded$getEfName(), this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpuLoaded$onRecordLoaded(android.os.AsyncResult ), this, asyncResult);
        }

        private /* synthetic */ void __constructor__(IsimUiccRecords isimUiccRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpuLoaded$__constructor__(isimUiccRecords, var2_2);
        }

        public /* synthetic */ EfIsimImpuLoaded(IsimUiccRecords isimUiccRecords, 1 var2_2) {
            this(isimUiccRecords);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpuLoaded$__constructor__(com.android.internal.telephony.uicc.IsimUiccRecords com.android.internal.telephony.uicc.IsimUiccRecords$1 ), this, isimUiccRecords, var2_2);
        }

        public /* synthetic */ EfIsimImpuLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfIsimImpuLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfIsimImpiLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ IsimUiccRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpiLoaded$__constructor__(IsimUiccRecords isimUiccRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpiLoaded$getEfName() {
            return "EF_ISIM_IMPI";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpiLoaded$onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            this.this$0.mIsimImpi = IsimUiccRecords.isimTlvToString(data);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpiLoaded$__constructor__(IsimUiccRecords x0, 1 x1) {
        }

        private void __constructor__(IsimUiccRecords isimUiccRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpiLoaded$__constructor__(isimUiccRecords);
        }

        public EfIsimImpiLoaded(IsimUiccRecords isimUiccRecords) {
            this.this$0 = isimUiccRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpiLoaded$__constructor__(com.android.internal.telephony.uicc.IsimUiccRecords ), this, isimUiccRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpiLoaded$getEfName(), this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpiLoaded$onRecordLoaded(android.os.AsyncResult ), this, asyncResult);
        }

        private /* synthetic */ void __constructor__(IsimUiccRecords isimUiccRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpiLoaded$__constructor__(isimUiccRecords, var2_2);
        }

        public /* synthetic */ EfIsimImpiLoaded(IsimUiccRecords isimUiccRecords, 1 var2_2) {
            this(isimUiccRecords);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IsimUiccRecords_EfIsimImpiLoaded$__constructor__(com.android.internal.telephony.uicc.IsimUiccRecords com.android.internal.telephony.uicc.IsimUiccRecords$1 ), this, isimUiccRecords, var2_2);
        }

        public /* synthetic */ EfIsimImpiLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfIsimImpiLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

