/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.os.storage.StorageManager;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.text.format.Time;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccStateChangedLauncher;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UiccController
extends Handler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DBG = true;
    private static String LOG_TAG = "UiccController";
    public static int APP_FAM_3GPP = 1;
    public static int APP_FAM_3GPP2 = 2;
    public static int APP_FAM_IMS = 3;
    private static int EVENT_ICC_STATUS_CHANGED = 1;
    private static int EVENT_GET_ICC_STATUS_DONE = 2;
    private static int EVENT_RADIO_UNAVAILABLE = 3;
    private static int EVENT_SIM_REFRESH = 4;
    private static String DECRYPT_STATE = "trigger_restart_framework";
    private CommandsInterface[] mCis;
    private UiccCard[] mUiccCards;
    private static Object mLock;
    private static UiccController mInstance;
    private Context mContext;
    protected RegistrantList mIccChangedRegistrants;
    private UiccStateChangedLauncher mLauncher;
    private static int MAX_PROACTIVE_COMMANDS_TO_LOG = 20;
    private LinkedList<String> mCardLogs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final UiccController $$robo$$com_android_internal_telephony_uicc_UiccController$make(Context c, CommandsInterface[] ci) {
        Object object = mLock;
        synchronized (object) {
            if (mInstance != null) {
                throw new RuntimeException("MSimUiccController.make() should only be called once");
            }
            mInstance = new UiccController(c, ci);
            return mInstance;
        }
    }

    private void $$robo$$com_android_internal_telephony_uicc_UiccController$__constructor__(Context c, CommandsInterface[] ci) {
        this.mUiccCards = new UiccCard[TelephonyManager.getDefault().getPhoneCount()];
        this.mIccChangedRegistrants = new RegistrantList();
        this.mCardLogs = new LinkedList();
        this.log("Creating UiccController");
        this.mContext = c;
        this.mCis = ci;
        for (int i = 0; i < this.mCis.length; ++i) {
            Integer index = new Integer(i);
            this.mCis[i].registerForIccStatusChanged(this, 1, index);
            if ("trigger_restart_framework".equals(SystemProperties.get("vold.decrypt")) || StorageManager.isFileEncryptedNativeOrEmulated()) {
                this.mCis[i].registerForAvailable(this, 1, index);
            } else {
                this.mCis[i].registerForOn(this, 1, index);
            }
            this.mCis[i].registerForNotAvailable(this, 3, index);
            this.mCis[i].registerForIccRefresh(this, 4, index);
        }
        this.mLauncher = new UiccStateChangedLauncher(c, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final UiccController $$robo$$com_android_internal_telephony_uicc_UiccController$getInstance() {
        Object object = mLock;
        synchronized (object) {
            if (mInstance == null) {
                throw new RuntimeException("UiccController.getInstance can't be called before make()");
            }
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCard $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCard(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            if (this.isValidCardIndex(phoneId)) {
                return this.mUiccCards[phoneId];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCard[] $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCards() {
        Object object = mLock;
        synchronized (object) {
            return (UiccCard[])this.mUiccCards.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccRecords $$robo$$com_android_internal_telephony_uicc_UiccController$getIccRecords(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app = this.getUiccCardApplication(phoneId, family);
            if (app != null) {
                return app.getIccRecords();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccFileHandler $$robo$$com_android_internal_telephony_uicc_UiccController$getIccFileHandler(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app = this.getUiccCardApplication(phoneId, family);
            if (app != null) {
                return app.getIccFileHandler();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$registerForIccChanged(Handler h, int what, Object obj) {
        Object object = mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mIccChangedRegistrants.add(r);
            r.notifyRegistrant();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$unregisterForIccChanged(Handler h) {
        Object object = mLock;
        synchronized (object) {
            this.mIccChangedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$handleMessage(Message msg) {
        Object object = mLock;
        synchronized (object) {
            Integer index = this.getCiIndex(msg);
            if (index < 0 || index >= this.mCis.length) {
                Rlog.e("UiccController", "Invalid index : " + index + " received with event " + msg.what);
                return;
            }
            AsyncResult ar = (AsyncResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    this.log("Received EVENT_ICC_STATUS_CHANGED, calling getIccCardStatus");
                    this.mCis[index].getIccCardStatus(this.obtainMessage(2, index));
                    break;
                }
                case 2: {
                    this.log("Received EVENT_GET_ICC_STATUS_DONE");
                    this.onGetIccCardStatusDone(ar, index);
                    break;
                }
                case 3: {
                    this.log("EVENT_RADIO_UNAVAILABLE, dispose card");
                    if (this.mUiccCards[index] != null) {
                        this.mUiccCards[index].dispose();
                    }
                    this.mUiccCards[index.intValue()] = null;
                    this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, index, null));
                    break;
                }
                case 4: {
                    this.log("Received EVENT_SIM_REFRESH");
                    this.onSimRefresh(ar, index);
                    break;
                }
                default: {
                    Rlog.e("UiccController", " Unknown Event " + msg.what);
                }
            }
        }
    }

    private final Integer $$robo$$com_android_internal_telephony_uicc_UiccController$getCiIndex(Message msg) {
        Integer index = new Integer(0);
        if (msg != null) {
            if (msg.obj != null && msg.obj instanceof Integer) {
                index = (Integer)msg.obj;
            } else if (msg.obj != null && msg.obj instanceof AsyncResult) {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.userObj != null && ar.userObj instanceof Integer) {
                    index = (Integer)ar.userObj;
                }
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCardApplication $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCardApplication(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCard c;
            if (this.isValidCardIndex(phoneId) && (c = this.mUiccCards[phoneId]) != null) {
                return this.mUiccCards[phoneId].getApplication(family);
            }
            return null;
        }
    }

    private final synchronized void $$robo$$com_android_internal_telephony_uicc_UiccController$onGetIccCardStatusDone(AsyncResult ar, Integer index) {
        if (ar.exception != null) {
            Rlog.e("UiccController", "Error getting ICC status. RIL_REQUEST_GET_ICC_STATUS should never return an error", ar.exception);
            return;
        }
        if (!this.isValidCardIndex(index)) {
            Rlog.e("UiccController", "onGetIccCardStatusDone: invalid index : " + index);
            return;
        }
        IccCardStatus status = (IccCardStatus)ar.result;
        if (this.mUiccCards[index] == null) {
            this.mUiccCards[index.intValue()] = new UiccCard(this.mContext, this.mCis[index], status, index);
        } else {
            this.mUiccCards[index].update(this.mContext, this.mCis[index], status);
        }
        this.log("Notifying IccChangedRegistrants");
        this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, index, null));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$onSimRefresh(AsyncResult ar, Integer index) {
        if (ar.exception != null) {
            Rlog.e("UiccController", "Sim REFRESH with exception: " + ar.exception);
            return;
        }
        if (!this.isValidCardIndex(index)) {
            Rlog.e("UiccController", "onSimRefresh: invalid index : " + index);
            return;
        }
        IccRefreshResponse resp = (IccRefreshResponse)ar.result;
        Rlog.d("UiccController", "onSimRefresh: " + resp);
        if (this.mUiccCards[index] == null) {
            Rlog.e("UiccController", "onSimRefresh: refresh on null card : " + index);
            return;
        }
        if (resp.refreshResult != 2) {
            Rlog.d("UiccController", "Ignoring non reset refresh: " + resp);
            return;
        }
        Rlog.d("UiccController", "Handling refresh reset: " + resp);
        boolean changed = this.mUiccCards[index].resetAppWithAid(resp.aid);
        if (changed) {
            boolean requirePowerOffOnSimRefreshReset = this.mContext.getResources().getBoolean(17956987);
            if (requirePowerOffOnSimRefreshReset) {
                this.mCis[index].setRadioPower(false, null);
            } else {
                this.mCis[index].getIccCardStatus(this.obtainMessage(2));
            }
            this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, index, null));
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccController$isValidCardIndex(int index) {
        return index >= 0 && index < this.mUiccCards.length;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$log(String string2) {
        Rlog.d("UiccController", string2);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$addCardLog(String data) {
        Time t = new Time();
        t.setToNow();
        this.mCardLogs.addLast(t.format("%m-%d %H:%M:%S") + " " + data);
        if (this.mCardLogs.size() > 20) {
            this.mCardLogs.removeFirst();
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("UiccController: " + this);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mInstance=" + mInstance);
        pw.println(" mIccChangedRegistrants: size=" + this.mIccChangedRegistrants.size());
        for (i = 0; i < this.mIccChangedRegistrants.size(); ++i) {
            pw.println("  mIccChangedRegistrants[" + i + "]=" + ((Registrant)this.mIccChangedRegistrants.get(i)).getHandler());
        }
        pw.println();
        pw.flush();
        pw.println(" mUiccCards: size=" + this.mUiccCards.length);
        for (i = 0; i < this.mUiccCards.length; ++i) {
            if (this.mUiccCards[i] == null) {
                pw.println("  mUiccCards[" + i + "]=null");
                continue;
            }
            pw.println("  mUiccCards[" + i + "]=" + this.mUiccCards[i]);
            this.mUiccCards[i].dump(fd, pw, args);
        }
        pw.println("mCardLogs: ");
        for (i = 0; i < this.mCardLogs.size(); ++i) {
            pw.println("  " + this.mCardLogs.get(i));
        }
    }

    static void __staticInitializer__() {
        mLock = new Object();
    }

    public static UiccController make(Context context, CommandsInterface[] commandsInterfaceArray) {
        return InvokeDynamicSupport.bootstrapStatic("make", $$robo$$com_android_internal_telephony_uicc_UiccController$make(android.content.Context com.android.internal.telephony.CommandsInterface[] ), (Context)context, (CommandsInterface[])commandsInterfaceArray);
    }

    private void __constructor__(Context context, CommandsInterface[] commandsInterfaceArray) {
        this.$$robo$$com_android_internal_telephony_uicc_UiccController$__constructor__(context, commandsInterfaceArray);
    }

    public UiccController(Context context, CommandsInterface[] commandsInterfaceArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccController$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface[] ), this, context, commandsInterfaceArray);
    }

    public static UiccController getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_uicc_UiccController$getInstance());
    }

    public UiccCard getUiccCard(int n) {
        return InvokeDynamicSupport.bootstrap("getUiccCard", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCard(int ), this, n);
    }

    public UiccCard[] getUiccCards() {
        return InvokeDynamicSupport.bootstrap("getUiccCards", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCards(), this);
    }

    public IccRecords getIccRecords(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getIccRecords", $$robo$$com_android_internal_telephony_uicc_UiccController$getIccRecords(int int ), this, n, n2);
    }

    public IccFileHandler getIccFileHandler(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getIccFileHandler", $$robo$$com_android_internal_telephony_uicc_UiccController$getIccFileHandler(int int ), this, n, n2);
    }

    public void registerForIccChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForIccChanged", $$robo$$com_android_internal_telephony_uicc_UiccController$registerForIccChanged(android.os.Handler int java.lang.Object ), this, handler, n, object);
    }

    public void unregisterForIccChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForIccChanged", $$robo$$com_android_internal_telephony_uicc_UiccController$unregisterForIccChanged(android.os.Handler ), this, handler);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_UiccController$handleMessage(android.os.Message ), this, message);
    }

    private Integer getCiIndex(Message message) {
        return InvokeDynamicSupport.bootstrap("getCiIndex", $$robo$$com_android_internal_telephony_uicc_UiccController$getCiIndex(android.os.Message ), this, message);
    }

    public UiccCardApplication getUiccCardApplication(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getUiccCardApplication", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCardApplication(int int ), this, n, n2);
    }

    private synchronized void onGetIccCardStatusDone(AsyncResult asyncResult, Integer n) {
        InvokeDynamicSupport.bootstrap("onGetIccCardStatusDone", $$robo$$com_android_internal_telephony_uicc_UiccController$onGetIccCardStatusDone(android.os.AsyncResult java.lang.Integer ), this, asyncResult, n);
    }

    private void onSimRefresh(AsyncResult asyncResult, Integer n) {
        InvokeDynamicSupport.bootstrap("onSimRefresh", $$robo$$com_android_internal_telephony_uicc_UiccController$onSimRefresh(android.os.AsyncResult java.lang.Integer ), this, asyncResult, n);
    }

    private boolean isValidCardIndex(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidCardIndex", $$robo$$com_android_internal_telephony_uicc_UiccController$isValidCardIndex(int ), this, n);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_uicc_UiccController$log(java.lang.String ), this, string2);
    }

    public void addCardLog(String string2) {
        InvokeDynamicSupport.bootstrap("addCardLog", $$robo$$com_android_internal_telephony_uicc_UiccController$addCardLog(java.lang.String ), this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_UiccController$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(UiccController.class);
    }

    public /* synthetic */ UiccController() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiccController)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

