/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImageUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int TOLERANCE = 20;
    private static int ALPHA_TOLERANCE = 50;
    private static int COMPACT_BITMAP_SIZE = 64;
    private int[] mTempBuffer;
    private Bitmap mTempCompactBitmap;
    private Canvas mTempCompactBitmapCanvas;
    private Paint mTempCompactBitmapPaint;
    private Matrix mTempMatrix;

    private void $$robo$$com_android_internal_util_ImageUtils$__constructor__() {
        this.mTempMatrix = new Matrix();
    }

    private final boolean $$robo$$com_android_internal_util_ImageUtils$isGrayscale(Bitmap bitmap) {
        int height = bitmap.getHeight();
        int width = bitmap.getWidth();
        if (height > 64 || width > 64) {
            if (this.mTempCompactBitmap == null) {
                this.mTempCompactBitmap = Bitmap.createBitmap(64, 64, Bitmap.Config.ARGB_8888);
                this.mTempCompactBitmapCanvas = new Canvas(this.mTempCompactBitmap);
                this.mTempCompactBitmapPaint = new Paint(1);
                this.mTempCompactBitmapPaint.setFilterBitmap(true);
            }
            this.mTempMatrix.reset();
            this.mTempMatrix.setScale(64.0f / (float)width, 64.0f / (float)height, 0.0f, 0.0f);
            this.mTempCompactBitmapCanvas.drawColor(0, PorterDuff.Mode.SRC);
            this.mTempCompactBitmapCanvas.drawBitmap(bitmap, this.mTempMatrix, this.mTempCompactBitmapPaint);
            bitmap = this.mTempCompactBitmap;
            height = 64;
            width = 64;
        }
        int size = height * width;
        this.ensureBufferSize(size);
        bitmap.getPixels(this.mTempBuffer, 0, width, 0, 0, width, height);
        for (int i = 0; i < size; ++i) {
            if (ImageUtils.isGrayscale(this.mTempBuffer[i])) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_util_ImageUtils$ensureBufferSize(int size) {
        if (this.mTempBuffer == null || this.mTempBuffer.length < size) {
            this.mTempBuffer = new int[size];
        }
    }

    private static final boolean $$robo$$com_android_internal_util_ImageUtils$isGrayscale(int color2) {
        int alpha = 0xFF & color2 >> 24;
        if (alpha < 50) {
            return true;
        }
        int r = 0xFF & color2 >> 16;
        int g = 0xFF & color2 >> 8;
        int b = 0xFF & color2;
        return Math.abs(r - g) < 20 && Math.abs(r - b) < 20 && Math.abs(g - b) < 20;
    }

    private static final Bitmap $$robo$$com_android_internal_util_ImageUtils$buildScaledBitmap(Drawable drawable2, int maxWidth, int maxHeight) {
        if (drawable2 == null) {
            return null;
        }
        int originalWidth = drawable2.getIntrinsicWidth();
        int originalHeight = drawable2.getIntrinsicHeight();
        if (originalWidth <= maxWidth && originalHeight <= maxHeight && drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        if (originalHeight <= 0 || originalWidth <= 0) {
            return null;
        }
        float ratio = Math.min((float)maxWidth / (float)originalWidth, (float)maxHeight / (float)originalHeight);
        ratio = Math.min(1.0f, ratio);
        int scaledWidth = (int)(ratio * (float)originalWidth);
        int scaledHeight = (int)(ratio * (float)originalHeight);
        Bitmap result = Bitmap.createBitmap(scaledWidth, scaledHeight, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        drawable2.setBounds(0, 0, scaledWidth, scaledHeight);
        drawable2.draw(canvas);
        return result;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_ImageUtils$__constructor__();
    }

    public ImageUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_ImageUtils$__constructor__(), this);
    }

    public boolean isGrayscale(Bitmap bitmap) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGrayscale", $$robo$$com_android_internal_util_ImageUtils$isGrayscale(android.graphics.Bitmap ), this, bitmap);
    }

    private void ensureBufferSize(int n) {
        InvokeDynamicSupport.bootstrap("ensureBufferSize", $$robo$$com_android_internal_util_ImageUtils$ensureBufferSize(int ), this, n);
    }

    public static boolean isGrayscale(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isGrayscale", $$robo$$com_android_internal_util_ImageUtils$isGrayscale(int ), (int)n);
    }

    public static Bitmap buildScaledBitmap(Drawable drawable2, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("buildScaledBitmap", $$robo$$com_android_internal_util_ImageUtils$buildScaledBitmap(android.graphics.drawable.Drawable int int ), (Drawable)drawable2, (int)n, (int)n2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImageUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

