/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LineBreakBufferedWriter
extends PrintWriter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private char[] buffer;
    private int bufferIndex;
    private int bufferSize;
    private int lastNewline;
    private String lineSeparator;

    private void $$robo$$com_android_internal_util_LineBreakBufferedWriter$__constructor__(Writer out, int bufferSize) {
    }

    private void $$robo$$com_android_internal_util_LineBreakBufferedWriter$__constructor__(Writer out, int bufferSize, int initialCapacity) {
        this.lastNewline = -1;
        this.buffer = new char[Math.min(initialCapacity, bufferSize)];
        this.bufferIndex = 0;
        this.bufferSize = bufferSize;
        this.lineSeparator = System.getProperty("line.separator");
    }

    private final void $$robo$$com_android_internal_util_LineBreakBufferedWriter$flush() {
        this.writeBuffer(this.bufferIndex);
        this.bufferIndex = 0;
        super.flush();
    }

    private final void $$robo$$com_android_internal_util_LineBreakBufferedWriter$write(int c) {
        if (this.bufferIndex < this.buffer.length) {
            this.buffer[this.bufferIndex] = (char)c;
            ++this.bufferIndex;
            if ((char)c == '\n') {
                this.lastNewline = this.bufferIndex;
            }
        } else {
            this.write(new char[]{(char)c}, 0, 1);
        }
    }

    private final void $$robo$$com_android_internal_util_LineBreakBufferedWriter$println() {
        this.write(this.lineSeparator);
    }

    private final void $$robo$$com_android_internal_util_LineBreakBufferedWriter$write(char[] buf, int off, int len) {
        while (this.bufferIndex + len > this.bufferSize) {
            int nextNewLine = -1;
            int maxLength = this.bufferSize - this.bufferIndex;
            for (int i = 0; i < maxLength; ++i) {
                if (buf[off + i] != '\n') continue;
                if (this.bufferIndex + i >= this.bufferSize) break;
                nextNewLine = i;
            }
            if (nextNewLine != -1) {
                this.appendToBuffer(buf, off, nextNewLine);
                this.writeBuffer(this.bufferIndex);
                this.bufferIndex = 0;
                this.lastNewline = -1;
                off += nextNewLine + 1;
                len -= nextNewLine + 1;
                continue;
            }
            if (this.lastNewline != -1) {
                this.writeBuffer(this.lastNewline);
                this.removeFromBuffer(this.lastNewline + 1);
                this.lastNewline = -1;
                continue;
            }
            int rest = this.bufferSize - this.bufferIndex;
            this.appendToBuffer(buf, off, rest);
            this.writeBuffer(this.bufferIndex);
            this.bufferIndex = 0;
            off += rest;
            len -= rest;
        }
        if (len > 0) {
            this.appendToBuffer(buf, off, len);
            for (int i = len - 1; i >= 0; --i) {
                if (buf[off + i] != '\n') continue;
                this.lastNewline = this.bufferIndex - len + i;
                break;
            }
        }
    }

    private final void $$robo$$com_android_internal_util_LineBreakBufferedWriter$write(String s, int off, int len) {
        while (this.bufferIndex + len > this.bufferSize) {
            int nextNewLine = -1;
            int maxLength = this.bufferSize - this.bufferIndex;
            for (int i = 0; i < maxLength; ++i) {
                if (s.charAt(off + i) != '\n') continue;
                if (this.bufferIndex + i >= this.bufferSize) break;
                nextNewLine = i;
            }
            if (nextNewLine != -1) {
                this.appendToBuffer(s, off, nextNewLine);
                this.writeBuffer(this.bufferIndex);
                this.bufferIndex = 0;
                this.lastNewline = -1;
                off += nextNewLine + 1;
                len -= nextNewLine + 1;
                continue;
            }
            if (this.lastNewline != -1) {
                this.writeBuffer(this.lastNewline);
                this.removeFromBuffer(this.lastNewline + 1);
                this.lastNewline = -1;
                continue;
            }
            int rest = this.bufferSize - this.bufferIndex;
            this.appendToBuffer(s, off, rest);
            this.writeBuffer(this.bufferIndex);
            this.bufferIndex = 0;
            off += rest;
            len -= rest;
        }
        if (len > 0) {
            this.appendToBuffer(s, off, len);
            for (int i = len - 1; i >= 0; --i) {
                if (s.charAt(off + i) != '\n') continue;
                this.lastNewline = this.bufferIndex - len + i;
                break;
            }
        }
    }

    private final void $$robo$$com_android_internal_util_LineBreakBufferedWriter$appendToBuffer(char[] buf, int off, int len) {
        if (this.bufferIndex + len > this.buffer.length) {
            this.ensureCapacity(this.bufferIndex + len);
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])buf, (int)off, (char[])this.buffer, (int)this.bufferIndex, (int)len);
        this.bufferIndex += len;
    }

    private final void $$robo$$com_android_internal_util_LineBreakBufferedWriter$appendToBuffer(String s, int off, int len) {
        if (this.bufferIndex + len > this.buffer.length) {
            this.ensureCapacity(this.bufferIndex + len);
        }
        s.getChars(off, off + len, this.buffer, this.bufferIndex);
        this.bufferIndex += len;
    }

    private final void $$robo$$com_android_internal_util_LineBreakBufferedWriter$ensureCapacity(int capacity) {
        int newSize = this.buffer.length * 2 + 2;
        if (newSize < capacity) {
            newSize = capacity;
        }
        this.buffer = Arrays.copyOf(this.buffer, newSize);
    }

    private final void $$robo$$com_android_internal_util_LineBreakBufferedWriter$removeFromBuffer(int i) {
        int rest = this.bufferIndex - i;
        if (rest > 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.buffer, (int)(this.bufferIndex - rest), (char[])this.buffer, (int)0, (int)rest);
            this.bufferIndex = rest;
        } else {
            this.bufferIndex = 0;
        }
    }

    private final void $$robo$$com_android_internal_util_LineBreakBufferedWriter$writeBuffer(int length) {
        if (length > 0) {
            super.write(this.buffer, 0, length);
        }
    }

    private void __constructor__(Writer writer, int n) {
        this.$$robo$$com_android_internal_util_LineBreakBufferedWriter$__constructor__(writer, n);
    }

    public LineBreakBufferedWriter(Writer writer, int n) {
        this(writer, n, 16);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_LineBreakBufferedWriter$__constructor__(java.io.Writer int ), this, writer, n);
    }

    private void __constructor__(Writer writer, int n, int n2) {
        this.$$robo$$com_android_internal_util_LineBreakBufferedWriter$__constructor__(writer, n, n2);
    }

    public LineBreakBufferedWriter(Writer writer, int n, int n2) {
        super(writer);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_LineBreakBufferedWriter$__constructor__(java.io.Writer int int ), this, writer, n, n2);
    }

    @Override
    public void flush() {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$com_android_internal_util_LineBreakBufferedWriter$flush(), this);
    }

    @Override
    public void write(int n) {
        InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_util_LineBreakBufferedWriter$write(int ), this, n);
    }

    @Override
    public void println() {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_util_LineBreakBufferedWriter$println(), this);
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_util_LineBreakBufferedWriter$write(char[] int int ), this, cArray, n, n2);
    }

    @Override
    public void write(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_util_LineBreakBufferedWriter$write(java.lang.String int int ), this, string2, n, n2);
    }

    private void appendToBuffer(char[] cArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("appendToBuffer", $$robo$$com_android_internal_util_LineBreakBufferedWriter$appendToBuffer(char[] int int ), this, cArray, n, n2);
    }

    private void appendToBuffer(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("appendToBuffer", $$robo$$com_android_internal_util_LineBreakBufferedWriter$appendToBuffer(java.lang.String int int ), this, string2, n, n2);
    }

    private void ensureCapacity(int n) {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$com_android_internal_util_LineBreakBufferedWriter$ensureCapacity(int ), this, n);
    }

    private void removeFromBuffer(int n) {
        InvokeDynamicSupport.bootstrap("removeFromBuffer", $$robo$$com_android_internal_util_LineBreakBufferedWriter$removeFromBuffer(int ), this, n);
    }

    private void writeBuffer(int n) {
        InvokeDynamicSupport.bootstrap("writeBuffer", $$robo$$com_android_internal_util_LineBreakBufferedWriter$writeBuffer(int ), this, n);
    }

    public /* synthetic */ LineBreakBufferedWriter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LineBreakBufferedWriter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

