/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.ContextThemeWrapper;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.menu.BaseMenuPresenter;
import com.android.internal.view.menu.IconMenuItemView;
import com.android.internal.view.menu.IconMenuView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuDialogHelper;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IconMenuPresenter
extends BaseMenuPresenter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private IconMenuItemView mMoreView;
    private int mMaxItems;
    int mOpenSubMenuId;
    SubMenuPresenterCallback mSubMenuPresenterCallback;
    MenuDialogHelper mOpenSubMenu;
    private static String VIEWS_TAG = "android:menu:icon";
    private static String OPEN_SUBMENU_KEY = "android:menu:icon:submenu";

    private void $$robo$$com_android_internal_view_menu_IconMenuPresenter$__constructor__(Context context) {
        this.mMaxItems = -1;
        this.mSubMenuPresenterCallback = new SubMenuPresenterCallback(this);
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuPresenter$initForMenu(Context context, MenuBuilder menu2) {
        super.initForMenu(context, menu2);
        this.mMaxItems = -1;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuPresenter$bindItemView(MenuItemImpl item, MenuView.ItemView itemView) {
        IconMenuItemView view = (IconMenuItemView)itemView;
        view.setItemData(item);
        view.initialize(item.getTitleForItemView(view), item.getIcon());
        view.setVisibility(item.isVisible() ? 0 : 8);
        view.setEnabled(view.isEnabled());
        view.setLayoutParams(view.getTextAppropriateLayoutParams());
    }

    private final boolean $$robo$$com_android_internal_view_menu_IconMenuPresenter$shouldIncludeItem(int childIndex, MenuItemImpl item) {
        ArrayList<MenuItemImpl> itemsToShow = this.mMenu.getNonActionItems();
        boolean fits = itemsToShow.size() == this.mMaxItems && childIndex < this.mMaxItems || childIndex < this.mMaxItems - 1;
        return fits && !item.isActionButton();
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuPresenter$addItemView(View itemView, int childIndex) {
        IconMenuItemView v = (IconMenuItemView)itemView;
        IconMenuView parent = (IconMenuView)this.mMenuView;
        v.setIconMenuView(parent);
        v.setItemInvoker(parent);
        v.setBackgroundDrawable(parent.getItemBackgroundDrawable());
        super.addItemView(itemView, childIndex);
    }

    private final boolean $$robo$$com_android_internal_view_menu_IconMenuPresenter$onSubMenuSelected(SubMenuBuilder subMenu) {
        if (!subMenu.hasVisibleItems()) {
            return false;
        }
        MenuDialogHelper helper = new MenuDialogHelper(subMenu);
        helper.setPresenterCallback(this.mSubMenuPresenterCallback);
        helper.show(null);
        this.mOpenSubMenu = helper;
        this.mOpenSubMenuId = subMenu.getItem().getItemId();
        super.onSubMenuSelected(subMenu);
        return true;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuPresenter$updateMenuView(boolean cleared) {
        ArrayList<MenuItemImpl> itemsToShow;
        IconMenuView menuView = (IconMenuView)this.mMenuView;
        if (this.mMaxItems < 0) {
            this.mMaxItems = menuView.getMaxItems();
        }
        boolean needsMore = (itemsToShow = this.mMenu.getNonActionItems()).size() > this.mMaxItems;
        super.updateMenuView(cleared);
        if (needsMore && (this.mMoreView == null || this.mMoreView.getParent() != menuView)) {
            if (this.mMoreView == null) {
                this.mMoreView = menuView.createMoreItemView();
                this.mMoreView.setBackgroundDrawable(menuView.getItemBackgroundDrawable());
            }
            menuView.addView(this.mMoreView);
        } else if (!needsMore && this.mMoreView != null) {
            menuView.removeView(this.mMoreView);
        }
        menuView.setNumActualItemsShown(needsMore ? this.mMaxItems - 1 : itemsToShow.size());
    }

    private final boolean $$robo$$com_android_internal_view_menu_IconMenuPresenter$filterLeftoverView(ViewGroup parent, int childIndex) {
        if (parent.getChildAt(childIndex) != this.mMoreView) {
            return super.filterLeftoverView(parent, childIndex);
        }
        return false;
    }

    private final int $$robo$$com_android_internal_view_menu_IconMenuPresenter$getNumActualItemsShown() {
        return ((IconMenuView)this.mMenuView).getNumActualItemsShown();
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuPresenter$saveHierarchyState(Bundle outState) {
        SparseArray<Parcelable> viewStates = new SparseArray<Parcelable>();
        if (this.mMenuView != null) {
            ((View)((Object)this.mMenuView)).saveHierarchyState(viewStates);
        }
        outState.putSparseParcelableArray("android:menu:icon", viewStates);
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuPresenter$restoreHierarchyState(Bundle inState) {
        MenuItem item;
        int subMenuId;
        SparseArray<Parcelable> viewStates = inState.getSparseParcelableArray("android:menu:icon");
        if (viewStates != null) {
            ((View)((Object)this.mMenuView)).restoreHierarchyState(viewStates);
        }
        if ((subMenuId = inState.getInt("android:menu:icon:submenu", 0)) > 0 && this.mMenu != null && (item = this.mMenu.findItem(subMenuId)) != null) {
            this.onSubMenuSelected((SubMenuBuilder)item.getSubMenu());
        }
    }

    private final Parcelable $$robo$$com_android_internal_view_menu_IconMenuPresenter$onSaveInstanceState() {
        if (this.mMenuView == null) {
            return null;
        }
        Bundle state = new Bundle();
        this.saveHierarchyState(state);
        if (this.mOpenSubMenuId > 0) {
            state.putInt("android:menu:icon:submenu", this.mOpenSubMenuId);
        }
        return state;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuPresenter$onRestoreInstanceState(Parcelable state) {
        this.restoreHierarchyState((Bundle)state);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_view_menu_IconMenuPresenter$__constructor__(context);
    }

    public IconMenuPresenter(Context context) {
        super(new ContextThemeWrapper(context, 16974816), 17367147, 17367146);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuPresenter$__constructor__(android.content.Context ), this, context);
    }

    @Override
    public void initForMenu(Context context, MenuBuilder menuBuilder) {
        InvokeDynamicSupport.bootstrap("initForMenu", $$robo$$com_android_internal_view_menu_IconMenuPresenter$initForMenu(android.content.Context com.android.internal.view.menu.MenuBuilder ), this, context, menuBuilder);
    }

    @Override
    public void bindItemView(MenuItemImpl menuItemImpl, MenuView.ItemView itemView) {
        InvokeDynamicSupport.bootstrap("bindItemView", $$robo$$com_android_internal_view_menu_IconMenuPresenter$bindItemView(com.android.internal.view.menu.MenuItemImpl com.android.internal.view.menu.MenuView$ItemView ), this, menuItemImpl, itemView);
    }

    @Override
    public boolean shouldIncludeItem(int n, MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldIncludeItem", $$robo$$com_android_internal_view_menu_IconMenuPresenter$shouldIncludeItem(int com.android.internal.view.menu.MenuItemImpl ), this, n, menuItemImpl);
    }

    @Override
    protected void addItemView(View view, int n) {
        InvokeDynamicSupport.bootstrap("addItemView", $$robo$$com_android_internal_view_menu_IconMenuPresenter$addItemView(android.view.View int ), this, view, n);
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSubMenuSelected", $$robo$$com_android_internal_view_menu_IconMenuPresenter$onSubMenuSelected(com.android.internal.view.menu.SubMenuBuilder ), this, subMenuBuilder);
    }

    @Override
    public void updateMenuView(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateMenuView", $$robo$$com_android_internal_view_menu_IconMenuPresenter$updateMenuView(boolean ), this, bl);
    }

    @Override
    protected boolean filterLeftoverView(ViewGroup viewGroup, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("filterLeftoverView", $$robo$$com_android_internal_view_menu_IconMenuPresenter$filterLeftoverView(android.view.ViewGroup int ), this, viewGroup, n);
    }

    public int getNumActualItemsShown() {
        return (int)InvokeDynamicSupport.bootstrap("getNumActualItemsShown", $$robo$$com_android_internal_view_menu_IconMenuPresenter$getNumActualItemsShown(), this);
    }

    public void saveHierarchyState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("saveHierarchyState", $$robo$$com_android_internal_view_menu_IconMenuPresenter$saveHierarchyState(android.os.Bundle ), this, bundle);
    }

    public void restoreHierarchyState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("restoreHierarchyState", $$robo$$com_android_internal_view_menu_IconMenuPresenter$restoreHierarchyState(android.os.Bundle ), this, bundle);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$com_android_internal_view_menu_IconMenuPresenter$onSaveInstanceState(), this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_view_menu_IconMenuPresenter$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    public /* synthetic */ IconMenuPresenter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IconMenuPresenter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class SubMenuPresenterCallback
    implements MenuPresenter.Callback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ IconMenuPresenter this$0;

        private void $$robo$$com_android_internal_view_menu_IconMenuPresenter_SubMenuPresenterCallback$__constructor__(IconMenuPresenter this$0) {
        }

        private final void $$robo$$com_android_internal_view_menu_IconMenuPresenter_SubMenuPresenterCallback$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            this.this$0.mOpenSubMenuId = 0;
            if (this.this$0.mOpenSubMenu != null) {
                this.this$0.mOpenSubMenu.dismiss();
                this.this$0.mOpenSubMenu = null;
            }
        }

        private final boolean $$robo$$com_android_internal_view_menu_IconMenuPresenter_SubMenuPresenterCallback$onOpenSubMenu(MenuBuilder subMenu) {
            if (subMenu != null) {
                this.this$0.mOpenSubMenuId = ((SubMenuBuilder)subMenu).getItem().getItemId();
            }
            return false;
        }

        private void __constructor__(IconMenuPresenter iconMenuPresenter) {
            this.$$robo$$com_android_internal_view_menu_IconMenuPresenter_SubMenuPresenterCallback$__constructor__(iconMenuPresenter);
        }

        public SubMenuPresenterCallback(IconMenuPresenter iconMenuPresenter) {
            this.this$0 = iconMenuPresenter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuPresenter_SubMenuPresenterCallback$__constructor__(com.android.internal.view.menu.IconMenuPresenter ), this, iconMenuPresenter);
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$com_android_internal_view_menu_IconMenuPresenter_SubMenuPresenterCallback$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), this, menuBuilder, bl);
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            return (boolean)InvokeDynamicSupport.bootstrap("onOpenSubMenu", $$robo$$com_android_internal_view_menu_IconMenuPresenter_SubMenuPresenterCallback$onOpenSubMenu(com.android.internal.view.menu.MenuBuilder ), this, menuBuilder);
        }

        public /* synthetic */ SubMenuPresenterCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubMenuPresenterCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

