/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.android.internal.R;
import com.android.internal.view.menu.IconMenuItemView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class IconMenuView
extends ViewGroup
implements MenuBuilder.ItemInvoker,
MenuView,
Runnable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int ITEM_CAPTION_CYCLE_DELAY = 1000;
    private MenuBuilder mMenu;
    private int mRowHeight;
    private int mMaxRows;
    private int mMaxItems;
    private int mMaxItemsPerRow;
    private int mNumActualItemsShown;
    private Drawable mHorizontalDivider;
    private int mHorizontalDividerHeight;
    private ArrayList<Rect> mHorizontalDividerRects;
    private Drawable mVerticalDivider;
    private int mVerticalDividerWidth;
    private ArrayList<Rect> mVerticalDividerRects;
    private Drawable mMoreIcon;
    private Drawable mItemBackground;
    private int mAnimations;
    private boolean mHasStaleChildren;
    private boolean mMenuBeingLongpressed;
    private boolean mLastChildrenCaptionMode;
    private int[] mLayout;
    private int mLayoutNumRows;

    private void $$robo$$com_android_internal_view_menu_IconMenuView$__constructor__(Context context, AttributeSet attrs) {
        this.mMenuBeingLongpressed = false;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IconMenuView, 0, 0);
        this.mRowHeight = a.getDimensionPixelSize(0, 64);
        this.mMaxRows = a.getInt(1, 2);
        this.mMaxItems = a.getInt(4, 6);
        this.mMaxItemsPerRow = a.getInt(2, 3);
        this.mMoreIcon = a.getDrawable(3);
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.MenuView, 0, 0);
        this.mItemBackground = a.getDrawable(5);
        this.mHorizontalDivider = a.getDrawable(2);
        this.mHorizontalDividerRects = new ArrayList();
        this.mVerticalDivider = a.getDrawable(3);
        this.mVerticalDividerRects = new ArrayList();
        this.mAnimations = a.getResourceId(0, 0);
        a.recycle();
        if (this.mHorizontalDivider != null) {
            this.mHorizontalDividerHeight = this.mHorizontalDivider.getIntrinsicHeight();
            if (this.mHorizontalDividerHeight == -1) {
                this.mHorizontalDividerHeight = 1;
            }
        }
        if (this.mVerticalDivider != null) {
            this.mVerticalDividerWidth = this.mVerticalDivider.getIntrinsicWidth();
            if (this.mVerticalDividerWidth == -1) {
                this.mVerticalDividerWidth = 1;
            }
        }
        this.mLayout = new int[this.mMaxRows];
        this.setWillNotDraw(false);
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
    }

    private final int $$robo$$com_android_internal_view_menu_IconMenuView$getMaxItems() {
        return this.mMaxItems;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$layoutItems(int width) {
        int numItems = this.getChildCount();
        if (numItems == 0) {
            this.mLayoutNumRows = 0;
            return;
        }
        for (int curNumRows = Math.min((int)Math.ceil((float)numItems / (float)this.mMaxItemsPerRow), this.mMaxRows); curNumRows <= this.mMaxRows; ++curNumRows) {
            this.layoutItemsUsingGravity(curNumRows, numItems);
            if (curNumRows >= numItems || this.doItemsFit()) break;
        }
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$layoutItemsUsingGravity(int numRows, int numItems) {
        int numBaseItemsPerRow = numItems / numRows;
        int numLeftoverItems = numItems % numRows;
        int rowsThatGetALeftoverItem = numRows - numLeftoverItems;
        int[] layout2 = this.mLayout;
        for (int i = 0; i < numRows; ++i) {
            layout2[i] = numBaseItemsPerRow;
            if (i < rowsThatGetALeftoverItem) continue;
            int n = i;
            layout2[n] = layout2[n] + 1;
        }
        this.mLayoutNumRows = numRows;
    }

    private final boolean $$robo$$com_android_internal_view_menu_IconMenuView$doItemsFit() {
        int itemPos = 0;
        int[] layout2 = this.mLayout;
        int numRows = this.mLayoutNumRows;
        for (int row = 0; row < numRows; ++row) {
            int numItemsOnRow = layout2[row];
            if (numItemsOnRow == 1) {
                ++itemPos;
                continue;
            }
            for (int itemsOnRowCounter = numItemsOnRow; itemsOnRowCounter > 0; --itemsOnRowCounter) {
                View child = this.getChildAt(itemPos++);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.maxNumItemsOnRow >= numItemsOnRow) continue;
                return false;
            }
        }
        return true;
    }

    private final Drawable $$robo$$com_android_internal_view_menu_IconMenuView$getItemBackgroundDrawable() {
        return this.mItemBackground.getConstantState().newDrawable(this.getContext().getResources());
    }

    private final IconMenuItemView $$robo$$com_android_internal_view_menu_IconMenuView$createMoreItemView() {
        Context context = this.getContext();
        LayoutInflater inflater = LayoutInflater.from(context);
        IconMenuItemView itemView = (IconMenuItemView)inflater.inflate(17367146, null);
        Resources r = context.getResources();
        itemView.initialize(r.getText(17040274), this.mMoreIcon);
        itemView.setOnClickListener(new View.OnClickListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ IconMenuView this$0;

            private void $$robo$$com_android_internal_view_menu_IconMenuView_1$__constructor__(IconMenuView this$0) {
            }

            private final void $$robo$$com_android_internal_view_menu_IconMenuView_1$onClick(View v) {
                this.this$0.mMenu.changeMenuMode();
            }

            private void __constructor__(IconMenuView iconMenuView) {
                this.$$robo$$com_android_internal_view_menu_IconMenuView_1$__constructor__(iconMenuView);
            }
            {
                this.this$0 = iconMenuView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuView_1$__constructor__(com.android.internal.view.menu.IconMenuView ), this, iconMenuView);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_view_menu_IconMenuView_1$onClick(android.view.View ), this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        return itemView;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$initialize(MenuBuilder menu2) {
        this.mMenu = menu2;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$positionChildren(int menuWidth, int menuHeight) {
        if (this.mHorizontalDivider != null) {
            this.mHorizontalDividerRects.clear();
        }
        if (this.mVerticalDivider != null) {
            this.mVerticalDividerRects.clear();
        }
        int numRows = this.mLayoutNumRows;
        int numRowsMinus1 = numRows - 1;
        int[] numItemsForRow = this.mLayout;
        int itemPos = 0;
        LayoutParams childLayoutParams = null;
        float itemTop = 0.0f;
        float itemHeight = (float)(menuHeight - this.mHorizontalDividerHeight * (numRows - 1)) / (float)numRows;
        for (int row = 0; row < numRows; ++row) {
            float itemLeft = 0.0f;
            float itemWidth = (float)(menuWidth - this.mVerticalDividerWidth * (numItemsForRow[row] - 1)) / (float)numItemsForRow[row];
            for (int itemPosOnRow = 0; itemPosOnRow < numItemsForRow[row]; ++itemPosOnRow) {
                View child = this.getChildAt(itemPos);
                child.measure(View.MeasureSpec.makeMeasureSpec((int)itemWidth, 0x40000000), View.MeasureSpec.makeMeasureSpec((int)itemHeight, 0x40000000));
                childLayoutParams = (LayoutParams)child.getLayoutParams();
                childLayoutParams.left = (int)itemLeft;
                childLayoutParams.right = (int)(itemLeft + itemWidth);
                childLayoutParams.top = (int)itemTop;
                childLayoutParams.bottom = (int)(itemTop + itemHeight);
                itemLeft += itemWidth;
                ++itemPos;
                if (this.mVerticalDivider != null) {
                    this.mVerticalDividerRects.add(new Rect((int)itemLeft, (int)itemTop, (int)(itemLeft + (float)this.mVerticalDividerWidth), (int)(itemTop + itemHeight)));
                }
                itemLeft += (float)this.mVerticalDividerWidth;
            }
            if (childLayoutParams != null) {
                childLayoutParams.right = menuWidth;
            }
            itemTop += itemHeight;
            if (this.mHorizontalDivider == null || row >= numRowsMinus1) continue;
            this.mHorizontalDividerRects.add(new Rect(0, (int)itemTop, menuWidth, (int)(itemTop + (float)this.mHorizontalDividerHeight)));
            itemTop += (float)this.mHorizontalDividerHeight;
        }
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = IconMenuView.resolveSize(Integer.MAX_VALUE, widthMeasureSpec);
        this.calculateItemFittingMetadata(measuredWidth);
        this.layoutItems(measuredWidth);
        int layoutNumRows = this.mLayoutNumRows;
        int desiredHeight = (this.mRowHeight + this.mHorizontalDividerHeight) * layoutNumRows - this.mHorizontalDividerHeight;
        this.setMeasuredDimension(measuredWidth, IconMenuView.resolveSize(desiredHeight, heightMeasureSpec));
        if (layoutNumRows > 0) {
            this.positionChildren(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$onLayout(boolean changed, int l, int t, int r, int b) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            LayoutParams childLayoutParams = (LayoutParams)child.getLayoutParams();
            child.layout(childLayoutParams.left, childLayoutParams.top, childLayoutParams.right, childLayoutParams.bottom);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$onDraw(Canvas canvas) {
        int i;
        ArrayList<Rect> rects;
        Drawable drawable2 = this.mHorizontalDivider;
        if (drawable2 != null) {
            rects = this.mHorizontalDividerRects;
            for (i = rects.size() - 1; i >= 0; --i) {
                drawable2.setBounds(rects.get(i));
                drawable2.draw(canvas);
            }
        }
        if ((drawable2 = this.mVerticalDivider) != null) {
            rects = this.mVerticalDividerRects;
            for (i = rects.size() - 1; i >= 0; --i) {
                drawable2.setBounds(rects.get(i));
                drawable2.draw(canvas);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_IconMenuView$invokeItem(MenuItemImpl item) {
        return this.mMenu.performItemAction(item, 0);
    }

    private final LayoutParams $$robo$$com_android_internal_view_menu_IconMenuView$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final boolean $$robo$$com_android_internal_view_menu_IconMenuView$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$markStaleChildren() {
        if (!this.mHasStaleChildren) {
            this.mHasStaleChildren = true;
            this.requestLayout();
        }
    }

    private final int $$robo$$com_android_internal_view_menu_IconMenuView$getNumActualItemsShown() {
        return this.mNumActualItemsShown;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$setNumActualItemsShown(int count) {
        this.mNumActualItemsShown = count;
    }

    private final int $$robo$$com_android_internal_view_menu_IconMenuView$getWindowAnimations() {
        return this.mAnimations;
    }

    private final int[] $$robo$$com_android_internal_view_menu_IconMenuView$getLayout() {
        return this.mLayout;
    }

    private final int $$robo$$com_android_internal_view_menu_IconMenuView$getLayoutNumRows() {
        return this.mLayoutNumRows;
    }

    private final boolean $$robo$$com_android_internal_view_menu_IconMenuView$dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 82) {
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                this.removeCallbacks(this);
                this.postDelayed(this, ViewConfiguration.getLongPressTimeout());
            } else if (event.getAction() == 1) {
                if (this.mMenuBeingLongpressed) {
                    this.setCycleShortcutCaptionMode(false);
                    return true;
                }
                this.removeCallbacks(this);
            }
        }
        return super.dispatchKeyEvent(event);
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.requestFocus();
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$onDetachedFromWindow() {
        this.setCycleShortcutCaptionMode(false);
        super.onDetachedFromWindow();
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$onWindowFocusChanged(boolean hasWindowFocus) {
        if (!hasWindowFocus) {
            this.setCycleShortcutCaptionMode(false);
        }
        super.onWindowFocusChanged(hasWindowFocus);
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$setCycleShortcutCaptionMode(boolean cycleShortcutAndNormal) {
        if (!cycleShortcutAndNormal) {
            this.removeCallbacks(this);
            this.setChildrenCaptionMode(false);
            this.mMenuBeingLongpressed = false;
        } else {
            this.setChildrenCaptionMode(true);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$run() {
        if (this.mMenuBeingLongpressed) {
            this.setChildrenCaptionMode(!this.mLastChildrenCaptionMode);
        } else {
            this.mMenuBeingLongpressed = true;
            this.setCycleShortcutCaptionMode(true);
        }
        this.postDelayed(this, 1000L);
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$setChildrenCaptionMode(boolean shortcut) {
        this.mLastChildrenCaptionMode = shortcut;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            ((IconMenuItemView)this.getChildAt(i)).setCaptionMode(shortcut);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$calculateItemFittingMetadata(int width) {
        int maxNumItemsPerRow = this.mMaxItemsPerRow;
        int numItems = this.getChildCount();
        block0: for (int i = 0; i < numItems; ++i) {
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            lp.maxNumItemsOnRow = 1;
            for (int curNumItemsPerRow = maxNumItemsPerRow; curNumItemsPerRow > 0; --curNumItemsPerRow) {
                if (lp.desiredWidth >= width / curNumItemsPerRow) continue;
                lp.maxNumItemsOnRow = curNumItemsPerRow;
                continue block0;
            }
        }
    }

    private final Parcelable $$robo$$com_android_internal_view_menu_IconMenuView$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        View focusedView = this.getFocusedChild();
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            if (this.getChildAt(i) != focusedView) continue;
            return new SavedState(superState, i);
        }
        return new SavedState(superState, -1);
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuView$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.focusedPosition >= this.getChildCount()) {
            return;
        }
        View v = this.getChildAt(ss.focusedPosition);
        if (v != null) {
            v.requestFocus();
        }
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_view_menu_IconMenuView$__constructor__(context, attributeSet);
    }

    public IconMenuView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    int getMaxItems() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxItems", $$robo$$com_android_internal_view_menu_IconMenuView$getMaxItems(), this);
    }

    private void layoutItems(int n) {
        InvokeDynamicSupport.bootstrap("layoutItems", $$robo$$com_android_internal_view_menu_IconMenuView$layoutItems(int ), this, n);
    }

    private void layoutItemsUsingGravity(int n, int n2) {
        InvokeDynamicSupport.bootstrap("layoutItemsUsingGravity", $$robo$$com_android_internal_view_menu_IconMenuView$layoutItemsUsingGravity(int int ), this, n, n2);
    }

    private boolean doItemsFit() {
        return (boolean)InvokeDynamicSupport.bootstrap("doItemsFit", $$robo$$com_android_internal_view_menu_IconMenuView$doItemsFit(), this);
    }

    Drawable getItemBackgroundDrawable() {
        return InvokeDynamicSupport.bootstrap("getItemBackgroundDrawable", $$robo$$com_android_internal_view_menu_IconMenuView$getItemBackgroundDrawable(), this);
    }

    IconMenuItemView createMoreItemView() {
        return InvokeDynamicSupport.bootstrap("createMoreItemView", $$robo$$com_android_internal_view_menu_IconMenuView$createMoreItemView(), this);
    }

    @Override
    public void initialize(MenuBuilder menuBuilder) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$com_android_internal_view_menu_IconMenuView$initialize(com.android.internal.view.menu.MenuBuilder ), this, menuBuilder);
    }

    private void positionChildren(int n, int n2) {
        InvokeDynamicSupport.bootstrap("positionChildren", $$robo$$com_android_internal_view_menu_IconMenuView$positionChildren(int int ), this, n, n2);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_view_menu_IconMenuView$onMeasure(int int ), this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_view_menu_IconMenuView$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_view_menu_IconMenuView$onDraw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    public boolean invokeItem(MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("invokeItem", $$robo$$com_android_internal_view_menu_IconMenuView$invokeItem(com.android.internal.view.menu.MenuItemImpl ), this, menuItemImpl);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_view_menu_IconMenuView$generateLayoutParams(android.util.AttributeSet ), this, attributeSet);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$com_android_internal_view_menu_IconMenuView$checkLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    void markStaleChildren() {
        InvokeDynamicSupport.bootstrap("markStaleChildren", $$robo$$com_android_internal_view_menu_IconMenuView$markStaleChildren(), this);
    }

    int getNumActualItemsShown() {
        return (int)InvokeDynamicSupport.bootstrap("getNumActualItemsShown", $$robo$$com_android_internal_view_menu_IconMenuView$getNumActualItemsShown(), this);
    }

    void setNumActualItemsShown(int n) {
        InvokeDynamicSupport.bootstrap("setNumActualItemsShown", $$robo$$com_android_internal_view_menu_IconMenuView$setNumActualItemsShown(int ), this, n);
    }

    @Override
    public int getWindowAnimations() {
        return (int)InvokeDynamicSupport.bootstrap("getWindowAnimations", $$robo$$com_android_internal_view_menu_IconMenuView$getWindowAnimations(), this);
    }

    public int[] getLayout() {
        return InvokeDynamicSupport.bootstrap("getLayout", $$robo$$com_android_internal_view_menu_IconMenuView$getLayout(), this);
    }

    public int getLayoutNumRows() {
        return (int)InvokeDynamicSupport.bootstrap("getLayoutNumRows", $$robo$$com_android_internal_view_menu_IconMenuView$getLayoutNumRows(), this);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$com_android_internal_view_menu_IconMenuView$dispatchKeyEvent(android.view.KeyEvent ), this, keyEvent);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_view_menu_IconMenuView$onAttachedToWindow(), this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_view_menu_IconMenuView$onDetachedFromWindow(), this);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onWindowFocusChanged", $$robo$$com_android_internal_view_menu_IconMenuView$onWindowFocusChanged(boolean ), this, bl);
    }

    private void setCycleShortcutCaptionMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCycleShortcutCaptionMode", $$robo$$com_android_internal_view_menu_IconMenuView$setCycleShortcutCaptionMode(boolean ), this, bl);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_view_menu_IconMenuView$run(), this);
    }

    private void setChildrenCaptionMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChildrenCaptionMode", $$robo$$com_android_internal_view_menu_IconMenuView$setChildrenCaptionMode(boolean ), this, bl);
    }

    private void calculateItemFittingMetadata(int n) {
        InvokeDynamicSupport.bootstrap("calculateItemFittingMetadata", $$robo$$com_android_internal_view_menu_IconMenuView$calculateItemFittingMetadata(int ), this, n);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$com_android_internal_view_menu_IconMenuView$onSaveInstanceState(), this);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_view_menu_IconMenuView$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    public /* synthetic */ IconMenuView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IconMenuView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int left;
        int top;
        int right;
        int bottom;
        int desiredWidth;
        int maxNumItemsOnRow;

        private void $$robo$$com_android_internal_view_menu_IconMenuView_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
        }

        private void $$robo$$com_android_internal_view_menu_IconMenuView_LayoutParams$__constructor__(int width, int height) {
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$com_android_internal_view_menu_IconMenuView_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuView_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_view_menu_IconMenuView_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuView_LayoutParams$__constructor__(int int ), this, n, n2);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int focusedPosition;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$com_android_internal_view_menu_IconMenuView_SavedState$__constructor__(Parcelable superState, int focusedPosition) {
            this.focusedPosition = focusedPosition;
        }

        private void $$robo$$com_android_internal_view_menu_IconMenuView_SavedState$__constructor__(Parcel in) {
            this.focusedPosition = in.readInt();
        }

        private final void $$robo$$com_android_internal_view_menu_IconMenuView_SavedState$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.focusedPosition);
        }

        private /* synthetic */ void $$robo$$com_android_internal_view_menu_IconMenuView_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$com_android_internal_view_menu_IconMenuView_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$com_android_internal_view_menu_IconMenuView_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in, null);
                }

                private final SavedState[] $$robo$$com_android_internal_view_menu_IconMenuView_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$com_android_internal_view_menu_IconMenuView_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuView_SavedState_1$__constructor__(), this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_view_menu_IconMenuView_SavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_view_menu_IconMenuView_SavedState_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable, int n) {
            this.$$robo$$com_android_internal_view_menu_IconMenuView_SavedState$__constructor__(parcelable, n);
        }

        public SavedState(Parcelable parcelable, int n) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuView_SavedState$__constructor__(android.os.Parcelable int ), this, parcelable, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$com_android_internal_view_menu_IconMenuView_SavedState$__constructor__(parcel);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuView_SavedState$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_view_menu_IconMenuView_SavedState$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$com_android_internal_view_menu_IconMenuView_SavedState$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ SavedState(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuView_SavedState$__constructor__(android.os.Parcel com.android.internal.view.menu.IconMenuView$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

