/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.android.internal.widget.RecyclerView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LinearSmoothScroller
extends RecyclerView.SmoothScroller
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "LinearSmoothScroller";
    private static boolean DEBUG = false;
    private static float MILLISECONDS_PER_INCH = 25.0f;
    private static int TARGET_SEEK_SCROLL_DISTANCE_PX = 10000;
    public static int SNAP_TO_START = -1;
    public static int SNAP_TO_END = 1;
    public static int SNAP_TO_ANY = 0;
    private static float TARGET_SEEK_EXTRA_SCROLL_RATIO = 1.2f;
    protected LinearInterpolator mLinearInterpolator;
    protected DecelerateInterpolator mDecelerateInterpolator;
    protected PointF mTargetVector;
    private float MILLISECONDS_PER_PX;
    protected int mInterimTargetDx;
    protected int mInterimTargetDy;

    private void $$robo$$com_android_internal_widget_LinearSmoothScroller$__constructor__(Context context) {
        this.mLinearInterpolator = new LinearInterpolator();
        this.mDecelerateInterpolator = new DecelerateInterpolator();
        this.mInterimTargetDx = 0;
        this.mInterimTargetDy = 0;
        this.MILLISECONDS_PER_PX = this.calculateSpeedPerPixel(context.getResources().getDisplayMetrics());
    }

    private final void $$robo$$com_android_internal_widget_LinearSmoothScroller$onStart() {
    }

    private final void $$robo$$com_android_internal_widget_LinearSmoothScroller$onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
        int dy;
        int dx = this.calculateDxToMakeVisible(targetView, this.getHorizontalSnapPreference());
        int distance = (int)Math.sqrt(dx * dx + (dy = this.calculateDyToMakeVisible(targetView, this.getVerticalSnapPreference())) * dy);
        int time = this.calculateTimeForDeceleration(distance);
        if (time > 0) {
            action.update(-dx, -dy, time, this.mDecelerateInterpolator);
        }
    }

    private final void $$robo$$com_android_internal_widget_LinearSmoothScroller$onSeekTargetStep(int dx, int dy, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
        if (this.getChildCount() == 0) {
            this.stop();
            return;
        }
        this.mInterimTargetDx = this.clampApplyScroll(this.mInterimTargetDx, dx);
        this.mInterimTargetDy = this.clampApplyScroll(this.mInterimTargetDy, dy);
        if (this.mInterimTargetDx == 0 && this.mInterimTargetDy == 0) {
            this.updateActionForInterimTarget(action);
        }
    }

    private final void $$robo$$com_android_internal_widget_LinearSmoothScroller$onStop() {
        this.mInterimTargetDy = 0;
        this.mInterimTargetDx = 0;
        this.mTargetVector = null;
    }

    private final float $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
        return 25.0f / (float)displayMetrics.densityDpi;
    }

    private final int $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateTimeForDeceleration(int dx) {
        return (int)Math.ceil((double)this.calculateTimeForScrolling(dx) / 0.3356);
    }

    private final int $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateTimeForScrolling(int dx) {
        return (int)Math.ceil((float)Math.abs(dx) * this.MILLISECONDS_PER_PX);
    }

    private final int $$robo$$com_android_internal_widget_LinearSmoothScroller$getHorizontalSnapPreference() {
        return this.mTargetVector == null || this.mTargetVector.x == 0.0f ? 0 : (this.mTargetVector.x > 0.0f ? 1 : -1);
    }

    private final int $$robo$$com_android_internal_widget_LinearSmoothScroller$getVerticalSnapPreference() {
        return this.mTargetVector == null || this.mTargetVector.y == 0.0f ? 0 : (this.mTargetVector.y > 0.0f ? 1 : -1);
    }

    private final void $$robo$$com_android_internal_widget_LinearSmoothScroller$updateActionForInterimTarget(RecyclerView.SmoothScroller.Action action) {
        PointF scrollVector = this.computeScrollVectorForPosition(this.getTargetPosition());
        if (scrollVector == null || scrollVector.x == 0.0f && scrollVector.y == 0.0f) {
            int target = this.getTargetPosition();
            action.jumpTo(target);
            this.stop();
            return;
        }
        this.normalize(scrollVector);
        this.mTargetVector = scrollVector;
        this.mInterimTargetDx = (int)(10000.0f * scrollVector.x);
        this.mInterimTargetDy = (int)(10000.0f * scrollVector.y);
        int time = this.calculateTimeForScrolling(10000);
        action.update((int)((float)this.mInterimTargetDx * 1.2f), (int)((float)this.mInterimTargetDy * 1.2f), (int)((float)time * 1.2f), this.mLinearInterpolator);
    }

    private final int $$robo$$com_android_internal_widget_LinearSmoothScroller$clampApplyScroll(int tmpDt, int dt) {
        int before = tmpDt;
        if (before * (tmpDt -= dt) <= 0) {
            return 0;
        }
        return tmpDt;
    }

    private final int $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateDtToFit(int viewStart, int viewEnd, int boxStart, int boxEnd, int snapPreference) {
        switch (snapPreference) {
            case -1: {
                return boxStart - viewStart;
            }
            case 1: {
                return boxEnd - viewEnd;
            }
            case 0: {
                int dtStart = boxStart - viewStart;
                if (dtStart > 0) {
                    return dtStart;
                }
                int dtEnd = boxEnd - viewEnd;
                if (dtEnd >= 0) break;
                return dtEnd;
            }
            default: {
                throw new IllegalArgumentException("snap preference should be one of the constants defined in SmoothScroller, starting with SNAP_");
            }
        }
        return 0;
    }

    private final int $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateDyToMakeVisible(View view, int snapPreference) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null || !layoutManager.canScrollVertically()) {
            return 0;
        }
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        int top = layoutManager.getDecoratedTop(view) - params.topMargin;
        int bottom = layoutManager.getDecoratedBottom(view) + params.bottomMargin;
        int start = layoutManager.getPaddingTop();
        int end = layoutManager.getHeight() - layoutManager.getPaddingBottom();
        return this.calculateDtToFit(top, bottom, start, end, snapPreference);
    }

    private final int $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateDxToMakeVisible(View view, int snapPreference) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null || !layoutManager.canScrollHorizontally()) {
            return 0;
        }
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        int left = layoutManager.getDecoratedLeft(view) - params.leftMargin;
        int right = layoutManager.getDecoratedRight(view) + params.rightMargin;
        int start = layoutManager.getPaddingLeft();
        int end = layoutManager.getWidth() - layoutManager.getPaddingRight();
        return this.calculateDtToFit(left, right, start, end, snapPreference);
    }

    private final PointF $$robo$$com_android_internal_widget_LinearSmoothScroller$computeScrollVectorForPosition(int targetPosition) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof RecyclerView.SmoothScroller.ScrollVectorProvider) {
            return ((RecyclerView.SmoothScroller.ScrollVectorProvider)((Object)layoutManager)).computeScrollVectorForPosition(targetPosition);
        }
        Log.w("LinearSmoothScroller", "You should override computeScrollVectorForPosition when the LayoutManager does not implement " + RecyclerView.SmoothScroller.ScrollVectorProvider.class.getCanonicalName());
        return null;
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_LinearSmoothScroller$__constructor__(context);
    }

    public LinearSmoothScroller(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LinearSmoothScroller$__constructor__(android.content.Context ), this, context);
    }

    @Override
    protected void onStart() {
        InvokeDynamicSupport.bootstrap("onStart", $$robo$$com_android_internal_widget_LinearSmoothScroller$onStart(), this);
    }

    @Override
    protected void onTargetFound(View view, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
        InvokeDynamicSupport.bootstrap("onTargetFound", $$robo$$com_android_internal_widget_LinearSmoothScroller$onTargetFound(android.view.View com.android.internal.widget.RecyclerView$State com.android.internal.widget.RecyclerView$SmoothScroller$Action ), this, view, state, action);
    }

    @Override
    protected void onSeekTargetStep(int n, int n2, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
        InvokeDynamicSupport.bootstrap("onSeekTargetStep", $$robo$$com_android_internal_widget_LinearSmoothScroller$onSeekTargetStep(int int com.android.internal.widget.RecyclerView$State com.android.internal.widget.RecyclerView$SmoothScroller$Action ), this, n, n2, state, action);
    }

    @Override
    protected void onStop() {
        InvokeDynamicSupport.bootstrap("onStop", $$robo$$com_android_internal_widget_LinearSmoothScroller$onStop(), this);
    }

    protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
        return (float)InvokeDynamicSupport.bootstrap("calculateSpeedPerPixel", $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateSpeedPerPixel(android.util.DisplayMetrics ), this, displayMetrics);
    }

    protected int calculateTimeForDeceleration(int n) {
        return (int)InvokeDynamicSupport.bootstrap("calculateTimeForDeceleration", $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateTimeForDeceleration(int ), this, n);
    }

    protected int calculateTimeForScrolling(int n) {
        return (int)InvokeDynamicSupport.bootstrap("calculateTimeForScrolling", $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateTimeForScrolling(int ), this, n);
    }

    protected int getHorizontalSnapPreference() {
        return (int)InvokeDynamicSupport.bootstrap("getHorizontalSnapPreference", $$robo$$com_android_internal_widget_LinearSmoothScroller$getHorizontalSnapPreference(), this);
    }

    protected int getVerticalSnapPreference() {
        return (int)InvokeDynamicSupport.bootstrap("getVerticalSnapPreference", $$robo$$com_android_internal_widget_LinearSmoothScroller$getVerticalSnapPreference(), this);
    }

    protected void updateActionForInterimTarget(RecyclerView.SmoothScroller.Action action) {
        InvokeDynamicSupport.bootstrap("updateActionForInterimTarget", $$robo$$com_android_internal_widget_LinearSmoothScroller$updateActionForInterimTarget(com.android.internal.widget.RecyclerView$SmoothScroller$Action ), this, action);
    }

    private int clampApplyScroll(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("clampApplyScroll", $$robo$$com_android_internal_widget_LinearSmoothScroller$clampApplyScroll(int int ), this, n, n2);
    }

    public int calculateDtToFit(int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("calculateDtToFit", $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateDtToFit(int int int int int ), this, n, n2, n3, n4, n5);
    }

    public int calculateDyToMakeVisible(View view, int n) {
        return (int)InvokeDynamicSupport.bootstrap("calculateDyToMakeVisible", $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateDyToMakeVisible(android.view.View int ), this, view, n);
    }

    public int calculateDxToMakeVisible(View view, int n) {
        return (int)InvokeDynamicSupport.bootstrap("calculateDxToMakeVisible", $$robo$$com_android_internal_widget_LinearSmoothScroller$calculateDxToMakeVisible(android.view.View int ), this, view, n);
    }

    public PointF computeScrollVectorForPosition(int n) {
        return InvokeDynamicSupport.bootstrap("computeScrollVectorForPosition", $$robo$$com_android_internal_widget_LinearSmoothScroller$computeScrollVectorForPosition(int ), this, n);
    }

    public /* synthetic */ LinearSmoothScroller() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LinearSmoothScroller)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

