/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.StateSet;
import android.view.KeyEvent;
import android.widget.TextView;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NumericTextView
extends TextView
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int RADIX = 10;
    private static double LOG_RADIX;
    private int mMinValue;
    private int mMaxValue;
    private int mMaxCount;
    private boolean mShowLeadingZeroes;
    private int mValue;
    private int mCount;
    private int mPreviousValue;
    private OnValueChangedListener mListener;

    private void $$robo$$com_android_internal_widget_NumericTextView$__constructor__(Context context, AttributeSet attrs) {
        this.mMinValue = 0;
        this.mMaxValue = 99;
        this.mMaxCount = 2;
        this.mShowLeadingZeroes = true;
        int textColorDisabled = this.getTextColors().getColorForState(StateSet.get(0), 0);
        this.setHintTextColor(textColorDisabled);
        this.setFocusable(true);
    }

    private final void $$robo$$com_android_internal_widget_NumericTextView$onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.mPreviousValue = this.mValue;
            this.mValue = 0;
            this.mCount = 0;
            this.setHint(this.getText());
            this.setText("");
        } else {
            if (this.mCount == 0) {
                this.mValue = this.mPreviousValue;
                this.setText(this.getHint());
                this.setHint("");
            }
            if (this.mValue < this.mMinValue) {
                this.mValue = this.mMinValue;
            }
            this.setValue(this.mValue);
            if (this.mListener != null) {
                this.mListener.onValueChanged(this, this.mValue, true, true);
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_NumericTextView$setValue(int value) {
        if (this.mValue != value) {
            this.mValue = value;
            this.updateDisplayedValue();
        }
    }

    private final int $$robo$$com_android_internal_widget_NumericTextView$getValue() {
        return this.mValue;
    }

    private final void $$robo$$com_android_internal_widget_NumericTextView$setRange(int minValue, int maxValue) {
        if (this.mMinValue != minValue) {
            this.mMinValue = minValue;
        }
        if (this.mMaxValue != maxValue) {
            this.mMaxValue = maxValue;
            this.mMaxCount = 1 + (int)(Math.log(maxValue) / LOG_RADIX);
            this.updateMinimumWidth();
            this.updateDisplayedValue();
        }
    }

    private final int $$robo$$com_android_internal_widget_NumericTextView$getRangeMinimum() {
        return this.mMinValue;
    }

    private final int $$robo$$com_android_internal_widget_NumericTextView$getRangeMaximum() {
        return this.mMaxValue;
    }

    private final void $$robo$$com_android_internal_widget_NumericTextView$setShowLeadingZeroes(boolean showLeadingZeroes) {
        if (this.mShowLeadingZeroes != showLeadingZeroes) {
            this.mShowLeadingZeroes = showLeadingZeroes;
            this.updateDisplayedValue();
        }
    }

    private final boolean $$robo$$com_android_internal_widget_NumericTextView$getShowLeadingZeroes() {
        return this.mShowLeadingZeroes;
    }

    private final void $$robo$$com_android_internal_widget_NumericTextView$updateDisplayedValue() {
        String format = this.mShowLeadingZeroes ? "%0" + this.mMaxCount + "d" : "%d";
        this.setText(String.format(format, this.mValue));
    }

    private final void $$robo$$com_android_internal_widget_NumericTextView$updateMinimumWidth() {
        CharSequence previousText = this.getText();
        int maxWidth = 0;
        for (int i = 0; i < this.mMaxValue; ++i) {
            this.setText(String.format("%0" + this.mMaxCount + "d", i));
            this.measure(0, 0);
            int width = this.getMeasuredWidth();
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        this.setText(previousText);
        this.setMinWidth(maxWidth);
        this.setMinimumWidth(maxWidth);
    }

    private final void $$robo$$com_android_internal_widget_NumericTextView$setOnDigitEnteredListener(OnValueChangedListener listener) {
        this.mListener = listener;
    }

    private final OnValueChangedListener $$robo$$com_android_internal_widget_NumericTextView$getOnDigitEnteredListener() {
        return this.mListener;
    }

    private final boolean $$robo$$com_android_internal_widget_NumericTextView$onKeyDown(int keyCode, KeyEvent event) {
        return NumericTextView.isKeyCodeNumeric(keyCode) || keyCode == 67 || super.onKeyDown(keyCode, event);
    }

    private final boolean $$robo$$com_android_internal_widget_NumericTextView$onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return NumericTextView.isKeyCodeNumeric(keyCode) || keyCode == 67 || super.onKeyMultiple(keyCode, repeatCount, event);
    }

    private final boolean $$robo$$com_android_internal_widget_NumericTextView$onKeyUp(int keyCode, KeyEvent event) {
        return this.handleKeyUp(keyCode) || super.onKeyUp(keyCode, event);
    }

    private final boolean $$robo$$com_android_internal_widget_NumericTextView$handleKeyUp(int keyCode) {
        if (keyCode == 67) {
            if (this.mCount > 0) {
                this.mValue /= 10;
                --this.mCount;
            }
        } else if (NumericTextView.isKeyCodeNumeric(keyCode)) {
            int keyValue;
            int newValue;
            if (this.mCount < this.mMaxCount && (newValue = this.mValue * 10 + (keyValue = NumericTextView.numericKeyCodeToInt(keyCode))) <= this.mMaxValue) {
                this.mValue = newValue;
                ++this.mCount;
            }
        } else {
            return false;
        }
        String formattedValue = this.mCount > 0 ? String.format("%0" + this.mCount + "d", this.mValue) : "";
        this.setText(formattedValue);
        if (this.mListener != null) {
            boolean isValid = this.mValue >= this.mMinValue;
            boolean isFinished = this.mCount >= this.mMaxCount || this.mValue * 10 > this.mMaxValue;
            this.mListener.onValueChanged(this, this.mValue, isValid, isFinished);
        }
        return true;
    }

    private static final boolean $$robo$$com_android_internal_widget_NumericTextView$isKeyCodeNumeric(int keyCode) {
        return keyCode == 7 || keyCode == 8 || keyCode == 9 || keyCode == 10 || keyCode == 11 || keyCode == 12 || keyCode == 13 || keyCode == 14 || keyCode == 15 || keyCode == 16;
    }

    private static final int $$robo$$com_android_internal_widget_NumericTextView$numericKeyCodeToInt(int keyCode) {
        return keyCode - 7;
    }

    static void __staticInitializer__() {
        LOG_RADIX = Math.log(10.0);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_NumericTextView$__constructor__(context, attributeSet);
    }

    public NumericTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_NumericTextView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("onFocusChanged", $$robo$$com_android_internal_widget_NumericTextView$onFocusChanged(boolean int android.graphics.Rect ), this, bl, n, rect);
    }

    public void setValue(int n) {
        InvokeDynamicSupport.bootstrap("setValue", $$robo$$com_android_internal_widget_NumericTextView$setValue(int ), this, n);
    }

    public int getValue() {
        return (int)InvokeDynamicSupport.bootstrap("getValue", $$robo$$com_android_internal_widget_NumericTextView$getValue(), this);
    }

    public void setRange(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setRange", $$robo$$com_android_internal_widget_NumericTextView$setRange(int int ), this, n, n2);
    }

    public int getRangeMinimum() {
        return (int)InvokeDynamicSupport.bootstrap("getRangeMinimum", $$robo$$com_android_internal_widget_NumericTextView$getRangeMinimum(), this);
    }

    public int getRangeMaximum() {
        return (int)InvokeDynamicSupport.bootstrap("getRangeMaximum", $$robo$$com_android_internal_widget_NumericTextView$getRangeMaximum(), this);
    }

    public void setShowLeadingZeroes(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowLeadingZeroes", $$robo$$com_android_internal_widget_NumericTextView$setShowLeadingZeroes(boolean ), this, bl);
    }

    public boolean getShowLeadingZeroes() {
        return (boolean)InvokeDynamicSupport.bootstrap("getShowLeadingZeroes", $$robo$$com_android_internal_widget_NumericTextView$getShowLeadingZeroes(), this);
    }

    private void updateDisplayedValue() {
        InvokeDynamicSupport.bootstrap("updateDisplayedValue", $$robo$$com_android_internal_widget_NumericTextView$updateDisplayedValue(), this);
    }

    private void updateMinimumWidth() {
        InvokeDynamicSupport.bootstrap("updateMinimumWidth", $$robo$$com_android_internal_widget_NumericTextView$updateMinimumWidth(), this);
    }

    public void setOnDigitEnteredListener(OnValueChangedListener onValueChangedListener) {
        InvokeDynamicSupport.bootstrap("setOnDigitEnteredListener", $$robo$$com_android_internal_widget_NumericTextView$setOnDigitEnteredListener(com.android.internal.widget.NumericTextView$OnValueChangedListener ), this, onValueChangedListener);
    }

    public OnValueChangedListener getOnDigitEnteredListener() {
        return InvokeDynamicSupport.bootstrap("getOnDigitEnteredListener", $$robo$$com_android_internal_widget_NumericTextView$getOnDigitEnteredListener(), this);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$com_android_internal_widget_NumericTextView$onKeyDown(int android.view.KeyEvent ), this, n, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyMultiple", $$robo$$com_android_internal_widget_NumericTextView$onKeyMultiple(int int android.view.KeyEvent ), this, n, n2, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$com_android_internal_widget_NumericTextView$onKeyUp(int android.view.KeyEvent ), this, n, keyEvent);
    }

    private boolean handleKeyUp(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleKeyUp", $$robo$$com_android_internal_widget_NumericTextView$handleKeyUp(int ), this, n);
    }

    private static boolean isKeyCodeNumeric(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isKeyCodeNumeric", $$robo$$com_android_internal_widget_NumericTextView$isKeyCodeNumeric(int ), (int)n);
    }

    private static int numericKeyCodeToInt(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("numericKeyCodeToInt", $$robo$$com_android_internal_widget_NumericTextView$numericKeyCodeToInt(int ), (int)n);
    }

    static {
        RobolectricInternals.classInitializing(NumericTextView.class);
    }

    public /* synthetic */ NumericTextView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NumericTextView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnValueChangedListener
    extends InstrumentedInterface {
        public void onValueChanged(NumericTextView var1, int var2, boolean var3, boolean var4);
    }
}

