/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt.ct;

import com.android.org.conscrypt.ct.CTLogInfo;
import com.android.org.conscrypt.ct.CTLogStore;
import com.android.org.conscrypt.ct.CTPolicy;
import com.android.org.conscrypt.ct.CTVerificationResult;
import com.android.org.conscrypt.ct.VerifiedSCT;
import java.security.cert.X509Certificate;
import java.util.HashSet;

public class CTPolicyImpl
implements CTPolicy {
    private final CTLogStore logStore;
    private final int minimumLogCount;

    public CTPolicyImpl(CTLogStore logStore, int minimumLogCount) {
        this.logStore = logStore;
        this.minimumLogCount = minimumLogCount;
    }

    @Override
    public boolean doesResultConformToPolicy(CTVerificationResult result, String hostname, X509Certificate[] chain) {
        HashSet<CTLogInfo> logSet = new HashSet<CTLogInfo>();
        for (VerifiedSCT verifiedSCT : result.getValidSCTs()) {
            CTLogInfo log = this.logStore.getKnownLog(verifiedSCT.sct.getLogID());
            if (log == null) continue;
            logSet.add(log);
        }
        return logSet.size() >= this.minimumLogCount;
    }
}

