/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.DropBoxManager;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Message;
import android.os.StatFs;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.format.Time;
import android.util.Slog;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import libcore.io.IoUtils;

public final class DropBoxManagerService
extends SystemService {
    private static final String TAG = "DropBoxManagerService";
    private static final int DEFAULT_AGE_SECONDS = 259200;
    private static final int DEFAULT_MAX_FILES = 1000;
    private static final int DEFAULT_QUOTA_KB = 5120;
    private static final int DEFAULT_QUOTA_PERCENT = 10;
    private static final int DEFAULT_RESERVE_PERCENT = 10;
    private static final int QUOTA_RESCAN_MILLIS = 5000;
    private static final int MSG_SEND_BROADCAST = 1;
    private static final boolean PROFILE_DUMP = false;
    private final ContentResolver mContentResolver;
    private final File mDropBoxDir;
    private FileList mAllFiles = null;
    private HashMap<String, FileList> mFilesByTag = null;
    private StatFs mStatFs = null;
    private int mBlockSize = 0;
    private int mCachedQuotaBlocks = 0;
    private long mCachedQuotaUptimeMillis = 0L;
    private volatile boolean mBooted = false;
    private final Handler mHandler;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            DropBoxManagerService.this.mCachedQuotaUptimeMillis = 0L;
            new Thread(){

                @Override
                public void run() {
                    try {
                        DropBoxManagerService.this.init();
                        DropBoxManagerService.this.trimToFit();
                    }
                    catch (IOException e) {
                        Slog.e(DropBoxManagerService.TAG, "Can't init", e);
                    }
                }
            }.start();
        }
    };
    private final IDropBoxManagerService.Stub mStub = new IDropBoxManagerService.Stub(){

        @Override
        public void add(DropBoxManager.Entry entry) {
            DropBoxManagerService.this.add(entry);
        }

        @Override
        public boolean isTagEnabled(String tag) {
            return DropBoxManagerService.this.isTagEnabled(tag);
        }

        @Override
        public DropBoxManager.Entry getNextEntry(String tag, long millis) {
            return DropBoxManagerService.this.getNextEntry(tag, millis);
        }

        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            DropBoxManagerService.this.dump(fd, pw, args);
        }
    };

    public DropBoxManagerService(Context context) {
        this(context, new File("/data/system/dropbox"));
    }

    public DropBoxManagerService(Context context, File path) {
        super(context);
        this.mDropBoxDir = path;
        this.mContentResolver = this.getContext().getContentResolver();
        this.mHandler = new Handler(){

            @Override
            public void handleMessage(Message msg) {
                if (msg.what == 1) {
                    DropBoxManagerService.this.getContext().sendBroadcastAsUser((Intent)msg.obj, UserHandle.SYSTEM, "android.permission.READ_LOGS");
                }
            }
        };
    }

    @Override
    public void onStart() {
        this.publishBinderService("dropbox", this.mStub);
    }

    @Override
    public void onBootPhase(int phase) {
        switch (phase) {
            case 500: {
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.intent.action.DEVICE_STORAGE_LOW");
                this.getContext().registerReceiver(this.mReceiver, filter);
                this.mContentResolver.registerContentObserver(Settings.Global.CONTENT_URI, true, new ContentObserver(new Handler()){

                    @Override
                    public void onChange(boolean selfChange) {
                        DropBoxManagerService.this.mReceiver.onReceive(DropBoxManagerService.this.getContext(), null);
                    }
                });
                break;
            }
            case 1000: {
                this.mBooted = true;
            }
        }
    }

    public IDropBoxManagerService getServiceStub() {
        return this.mStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DropBoxManager.Entry entry) {
        block19: {
            File temp = null;
            InputStream input = null;
            FilterOutputStream output = null;
            String tag = entry.getTag();
            try {
                int read;
                int n;
                int flags = entry.getFlags();
                if ((flags & 1) != 0) {
                    throw new IllegalArgumentException();
                }
                this.init();
                if (!this.isTagEnabled(tag)) {
                    return;
                }
                long max = this.trimToFit();
                long lastTrim = System.currentTimeMillis();
                byte[] buffer = new byte[this.mBlockSize];
                input = entry.getInputStream();
                for (read = 0; read < buffer.length && (n = input.read(buffer, read, buffer.length - read)) > 0; read += n) {
                }
                temp = new File(this.mDropBoxDir, "drop" + Thread.currentThread().getId() + ".tmp");
                int bufferSize = this.mBlockSize;
                if (bufferSize > 4096) {
                    bufferSize = 4096;
                }
                if (bufferSize < 512) {
                    bufferSize = 512;
                }
                FileOutputStream foutput = new FileOutputStream(temp);
                output = new BufferedOutputStream(foutput, bufferSize);
                if (read == buffer.length && (flags & 4) == 0) {
                    output = new GZIPOutputStream(output);
                    flags |= 4;
                }
                do {
                    ((OutputStream)output).write(buffer, 0, read);
                    long now = System.currentTimeMillis();
                    if (now - lastTrim > 30000L) {
                        max = this.trimToFit();
                        lastTrim = now;
                    }
                    if ((read = input.read(buffer)) <= 0) {
                        FileUtils.sync(foutput);
                        ((OutputStream)output).close();
                        output = null;
                    } else {
                        ((OutputStream)output).flush();
                    }
                    long len = temp.length();
                    if (len <= max) continue;
                    Slog.w(TAG, "Dropping: " + tag + " (" + temp.length() + " > " + max + " bytes)");
                    temp.delete();
                    temp = null;
                    break;
                } while (read > 0);
                long time = this.createEntry(temp, tag, flags);
                temp = null;
                Intent dropboxIntent = new Intent("android.intent.action.DROPBOX_ENTRY_ADDED");
                dropboxIntent.putExtra("tag", tag);
                dropboxIntent.putExtra("time", time);
                if (!this.mBooted) {
                    dropboxIntent.addFlags(0x40000000);
                }
                this.mHandler.sendMessage(this.mHandler.obtainMessage(1, dropboxIntent));
                IoUtils.closeQuietly(output);
            }
            catch (IOException e) {
                Slog.e(TAG, "Can't write: " + tag, e);
                break block19;
            }
            finally {
                IoUtils.closeQuietly(output);
                IoUtils.closeQuietly(input);
                entry.close();
                if (temp != null) {
                    temp.delete();
                }
            }
            IoUtils.closeQuietly(input);
            entry.close();
            if (temp != null) {
                temp.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTagEnabled(String tag) {
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = !"disabled".equals(Settings.Global.getString(this.mContentResolver, "dropbox:" + tag));
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public synchronized DropBoxManager.Entry getNextEntry(String tag, long millis) {
        FileList list;
        if (this.getContext().checkCallingOrSelfPermission("android.permission.READ_LOGS") != 0) {
            throw new SecurityException("READ_LOGS permission required");
        }
        try {
            this.init();
        }
        catch (IOException e) {
            Slog.e(TAG, "Can't init", e);
            return null;
        }
        FileList fileList = list = tag == null ? this.mAllFiles : this.mFilesByTag.get(tag);
        if (list == null) {
            return null;
        }
        for (EntryFile entry : list.contents.tailSet(new EntryFile(millis + 1L))) {
            if (entry.tag == null) continue;
            if ((entry.flags & 1) != 0) {
                return new DropBoxManager.Entry(entry.tag, entry.timestampMillis);
            }
            try {
                return new DropBoxManager.Entry(entry.tag, entry.timestampMillis, entry.file, entry.flags);
            }
            catch (IOException e) {
                Slog.e(TAG, "Can't read: " + entry.file, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.getContext(), TAG, pw)) {
            return;
        }
        try {
            this.init();
        }
        catch (IOException e) {
            pw.println("Can't initialize: " + e);
            Slog.e(TAG, "Can't init", e);
            return;
        }
        StringBuilder out = new StringBuilder();
        boolean doPrint = false;
        boolean doFile = false;
        ArrayList<String> searchArgs = new ArrayList<String>();
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-p") || args[i].equals("--print")) {
                doPrint = true;
                continue;
            }
            if (args[i].equals("-f") || args[i].equals("--file")) {
                doFile = true;
                continue;
            }
            if (args[i].equals("-h") || args[i].equals("--help")) {
                pw.println("Dropbox (dropbox) dump options:");
                pw.println("  [-h|--help] [-p|--print] [-f|--file] [timestamp]");
                pw.println("    -h|--help: print this help");
                pw.println("    -p|--print: print full contents of each entry");
                pw.println("    -f|--file: print path of each entry's file");
                pw.println("  [timestamp] optionally filters to only those entries.");
                return;
            }
            if (args[i].startsWith("-")) {
                out.append("Unknown argument: ").append(args[i]).append("\n");
                continue;
            }
            searchArgs.add(args[i]);
        }
        out.append("Drop box contents: ").append(this.mAllFiles.contents.size()).append(" entries\n");
        if (!searchArgs.isEmpty()) {
            out.append("Searching for:");
            for (String a : searchArgs) {
                out.append(" ").append(a);
            }
            out.append("\n");
        }
        int numFound = 0;
        int numArgs = searchArgs.size();
        Time time = new Time();
        out.append("\n");
        for (EntryFile entry : this.mAllFiles.contents) {
            time.set(entry.timestampMillis);
            String date = time.format("%Y-%m-%d %H:%M:%S");
            boolean match = true;
            for (int i = 0; i < numArgs && match; ++i) {
                String arg = (String)searchArgs.get(i);
                match = date.contains(arg) || arg.equals(entry.tag);
            }
            if (!match) continue;
            ++numFound;
            if (doPrint) {
                out.append("========================================\n");
            }
            out.append(date).append(" ").append(entry.tag == null ? "(no tag)" : entry.tag);
            if (entry.file == null) {
                out.append(" (no file)\n");
                continue;
            }
            if ((entry.flags & 1) != 0) {
                out.append(" (contents lost)\n");
                continue;
            }
            out.append(" (");
            if ((entry.flags & 4) != 0) {
                out.append("compressed ");
            }
            out.append((entry.flags & 2) != 0 ? "text" : "data");
            out.append(", ").append(entry.file.length()).append(" bytes)\n");
            if (doFile || doPrint && (entry.flags & 2) == 0) {
                if (!doPrint) {
                    out.append("    ");
                }
                out.append(entry.file.getPath()).append("\n");
            }
            if ((entry.flags & 2) != 0 && (doPrint || !doFile)) {
                DropBoxManager.Entry dbe = null;
                InputStreamReader isr = null;
                try {
                    dbe = new DropBoxManager.Entry(entry.tag, entry.timestampMillis, entry.file, entry.flags);
                    if (doPrint) {
                        int n;
                        isr = new InputStreamReader(dbe.getInputStream());
                        char[] buf = new char[4096];
                        boolean newline = false;
                        while ((n = isr.read(buf)) > 0) {
                            out.append(buf, 0, n);
                            boolean bl = newline = buf[n - 1] == '\n';
                            if (out.length() <= 65536) continue;
                            pw.write(out.toString());
                            out.setLength(0);
                        }
                        if (!newline) {
                            out.append("\n");
                        }
                    } else {
                        String text = dbe.getText(70);
                        out.append("    ");
                        if (text == null) {
                            out.append("[null]");
                        } else {
                            boolean truncated = text.length() == 70;
                            out.append(text.trim().replace('\n', '/'));
                            if (truncated) {
                                out.append(" ...");
                            }
                        }
                        out.append("\n");
                    }
                }
                catch (IOException e) {
                    out.append("*** ").append(e.toString()).append("\n");
                    Slog.e(TAG, "Can't read: " + entry.file, e);
                }
                finally {
                    if (dbe != null) {
                        dbe.close();
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (!doPrint) continue;
            out.append("\n");
        }
        if (numFound == 0) {
            out.append("(No entries found.)\n");
        }
        if (args == null || args.length == 0) {
            if (!doPrint) {
                out.append("\n");
            }
            out.append("Usage: dumpsys dropbox [--print|--file] [YYYY-mm-dd] [HH:MM:SS] [tag]\n");
        }
        pw.write(out.toString());
    }

    private synchronized void init() throws IOException {
        if (this.mStatFs == null) {
            if (!this.mDropBoxDir.isDirectory() && !this.mDropBoxDir.mkdirs()) {
                throw new IOException("Can't mkdir: " + this.mDropBoxDir);
            }
            try {
                this.mStatFs = new StatFs(this.mDropBoxDir.getPath());
                this.mBlockSize = this.mStatFs.getBlockSize();
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Can't statfs: " + this.mDropBoxDir);
            }
        }
        if (this.mAllFiles == null) {
            File[] files = this.mDropBoxDir.listFiles();
            if (files == null) {
                throw new IOException("Can't list files: " + this.mDropBoxDir);
            }
            this.mAllFiles = new FileList();
            this.mFilesByTag = new HashMap();
            for (File file : files) {
                if (file.getName().endsWith(".tmp")) {
                    Slog.i(TAG, "Cleaning temp file: " + file);
                    file.delete();
                    continue;
                }
                EntryFile entry = new EntryFile(file, this.mBlockSize);
                if (entry.tag == null) {
                    Slog.w(TAG, "Unrecognized file: " + file);
                    continue;
                }
                if (entry.timestampMillis == 0L) {
                    Slog.w(TAG, "Invalid filename: " + file);
                    file.delete();
                    continue;
                }
                this.enrollEntry(entry);
            }
        }
    }

    private synchronized void enrollEntry(EntryFile entry) {
        this.mAllFiles.contents.add(entry);
        this.mAllFiles.blocks += entry.blocks;
        if (entry.tag != null && entry.file != null && entry.blocks > 0) {
            FileList tagFiles = this.mFilesByTag.get(entry.tag);
            if (tagFiles == null) {
                tagFiles = new FileList();
                this.mFilesByTag.put(entry.tag, tagFiles);
            }
            tagFiles.contents.add(entry);
            tagFiles.blocks += entry.blocks;
        }
    }

    private synchronized long createEntry(File temp, String tag, int flags) throws IOException {
        long t = System.currentTimeMillis();
        SortedSet<EntryFile> tail = this.mAllFiles.contents.tailSet(new EntryFile(t + 10000L));
        EntryFile[] future = null;
        if (!tail.isEmpty()) {
            future = tail.toArray(new EntryFile[tail.size()]);
            tail.clear();
        }
        if (!this.mAllFiles.contents.isEmpty()) {
            t = Math.max(t, this.mAllFiles.contents.last().timestampMillis + 1L);
        }
        if (future != null) {
            for (EntryFile late : future) {
                this.mAllFiles.blocks -= late.blocks;
                FileList tagFiles = this.mFilesByTag.get(late.tag);
                if (tagFiles != null && tagFiles.contents.remove(late)) {
                    tagFiles.blocks -= late.blocks;
                }
                if ((late.flags & 1) == 0) {
                    this.enrollEntry(new EntryFile(late.file, this.mDropBoxDir, late.tag, t++, late.flags, this.mBlockSize));
                    continue;
                }
                this.enrollEntry(new EntryFile(this.mDropBoxDir, late.tag, t++));
            }
        }
        if (temp == null) {
            this.enrollEntry(new EntryFile(this.mDropBoxDir, tag, t));
        } else {
            this.enrollEntry(new EntryFile(temp, this.mDropBoxDir, tag, t, flags, this.mBlockSize));
        }
        return t;
    }

    private synchronized long trimToFit() throws IOException {
        long uptimeMillis;
        int ageSeconds = Settings.Global.getInt(this.mContentResolver, "dropbox_age_seconds", 259200);
        int maxFiles = Settings.Global.getInt(this.mContentResolver, "dropbox_max_files", 1000);
        long cutoffMillis = System.currentTimeMillis() - (long)(ageSeconds * 1000);
        while (!this.mAllFiles.contents.isEmpty()) {
            EntryFile entry = this.mAllFiles.contents.first();
            if (entry.timestampMillis > cutoffMillis && this.mAllFiles.contents.size() < maxFiles) break;
            FileList tag = this.mFilesByTag.get(entry.tag);
            if (tag != null && tag.contents.remove(entry)) {
                tag.blocks -= entry.blocks;
            }
            if (this.mAllFiles.contents.remove(entry)) {
                this.mAllFiles.blocks -= entry.blocks;
            }
            if (entry.file == null) continue;
            entry.file.delete();
        }
        if ((uptimeMillis = SystemClock.uptimeMillis()) > this.mCachedQuotaUptimeMillis + 5000L) {
            int quotaPercent = Settings.Global.getInt(this.mContentResolver, "dropbox_quota_percent", 10);
            int reservePercent = Settings.Global.getInt(this.mContentResolver, "dropbox_reserve_percent", 10);
            int quotaKb = Settings.Global.getInt(this.mContentResolver, "dropbox_quota_kb", 5120);
            String dirPath = this.mDropBoxDir.getPath();
            try {
                this.mStatFs.restat(dirPath);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Can't restat: " + this.mDropBoxDir);
            }
            int available = this.mStatFs.getAvailableBlocks();
            int nonreserved = available - this.mStatFs.getBlockCount() * reservePercent / 100;
            int maximum = quotaKb * 1024 / this.mBlockSize;
            this.mCachedQuotaBlocks = Math.min(maximum, Math.max(0, nonreserved * quotaPercent / 100));
            this.mCachedQuotaUptimeMillis = uptimeMillis;
        }
        if (this.mAllFiles.blocks > this.mCachedQuotaBlocks) {
            int unsqueezed = this.mAllFiles.blocks;
            int squeezed = 0;
            TreeSet<FileList> tags = new TreeSet<FileList>(this.mFilesByTag.values());
            for (FileList tag : tags) {
                if (squeezed > 0 && tag.blocks <= (this.mCachedQuotaBlocks - unsqueezed) / squeezed) break;
                unsqueezed -= tag.blocks;
                ++squeezed;
            }
            int tagQuota = (this.mCachedQuotaBlocks - unsqueezed) / squeezed;
            for (FileList tag : tags) {
                if (this.mAllFiles.blocks < this.mCachedQuotaBlocks) break;
                while (tag.blocks > tagQuota && !tag.contents.isEmpty()) {
                    EntryFile entry = tag.contents.first();
                    if (tag.contents.remove(entry)) {
                        tag.blocks -= entry.blocks;
                    }
                    if (this.mAllFiles.contents.remove(entry)) {
                        this.mAllFiles.blocks -= entry.blocks;
                    }
                    try {
                        if (entry.file != null) {
                            entry.file.delete();
                        }
                        this.enrollEntry(new EntryFile(this.mDropBoxDir, entry.tag, entry.timestampMillis));
                    }
                    catch (IOException e) {
                        Slog.e(TAG, "Can't write tombstone file", e);
                    }
                }
            }
        }
        return this.mCachedQuotaBlocks * this.mBlockSize;
    }

    private static final class EntryFile
    implements Comparable<EntryFile> {
        public final String tag;
        public final long timestampMillis;
        public final int flags;
        public final File file;
        public final int blocks;

        @Override
        public final int compareTo(EntryFile o) {
            if (this.timestampMillis < o.timestampMillis) {
                return -1;
            }
            if (this.timestampMillis > o.timestampMillis) {
                return 1;
            }
            if (this.file != null && o.file != null) {
                return this.file.compareTo(o.file);
            }
            if (o.file != null) {
                return -1;
            }
            if (this.file != null) {
                return 1;
            }
            if (this == o) {
                return 0;
            }
            if (this.hashCode() < o.hashCode()) {
                return -1;
            }
            if (this.hashCode() > o.hashCode()) {
                return 1;
            }
            return 0;
        }

        public EntryFile(File temp, File dir, String tag, long timestampMillis, int flags, int blockSize) throws IOException {
            if ((flags & 1) != 0) {
                throw new IllegalArgumentException();
            }
            this.tag = tag;
            this.timestampMillis = timestampMillis;
            this.flags = flags;
            this.file = new File(dir, Uri.encode(tag) + "@" + timestampMillis + ((flags & 2) != 0 ? ".txt" : ".dat") + ((flags & 4) != 0 ? ".gz" : ""));
            if (!temp.renameTo(this.file)) {
                throw new IOException("Can't rename " + temp + " to " + this.file);
            }
            this.blocks = (int)((this.file.length() + (long)blockSize - 1L) / (long)blockSize);
        }

        public EntryFile(File dir, String tag, long timestampMillis) throws IOException {
            this.tag = tag;
            this.timestampMillis = timestampMillis;
            this.flags = 1;
            this.file = new File(dir, Uri.encode(tag) + "@" + timestampMillis + ".lost");
            this.blocks = 0;
            new FileOutputStream(this.file).close();
        }

        public EntryFile(File file, int blockSize) {
            long millis;
            this.file = file;
            this.blocks = (int)((this.file.length() + (long)blockSize - 1L) / (long)blockSize);
            String name = file.getName();
            int at = name.lastIndexOf(64);
            if (at < 0) {
                this.tag = null;
                this.timestampMillis = 0L;
                this.flags = 1;
                return;
            }
            int flags = 0;
            this.tag = Uri.decode(name.substring(0, at));
            if (name.endsWith(".gz")) {
                flags |= 4;
                name = name.substring(0, name.length() - 3);
            }
            if (name.endsWith(".lost")) {
                flags |= 1;
                name = name.substring(at + 1, name.length() - 5);
            } else if (name.endsWith(".txt")) {
                flags |= 2;
                name = name.substring(at + 1, name.length() - 4);
            } else if (name.endsWith(".dat")) {
                name = name.substring(at + 1, name.length() - 4);
            } else {
                this.flags = 1;
                this.timestampMillis = 0L;
                return;
            }
            this.flags = flags;
            try {
                millis = Long.parseLong(name);
            }
            catch (NumberFormatException e) {
                millis = 0L;
            }
            this.timestampMillis = millis;
        }

        public EntryFile(long millis) {
            this.tag = null;
            this.timestampMillis = millis;
            this.flags = 1;
            this.file = null;
            this.blocks = 0;
        }
    }

    private static final class FileList
    implements Comparable<FileList> {
        public int blocks = 0;
        public final TreeSet<EntryFile> contents = new TreeSet();

        private FileList() {
        }

        @Override
        public final int compareTo(FileList o) {
            if (this.blocks != o.blocks) {
                return o.blocks - this.blocks;
            }
            if (this == o) {
                return 0;
            }
            if (this.hashCode() < o.hashCode()) {
                return -1;
            }
            if (this.hashCode() > o.hashCode()) {
                return 1;
            }
            return 0;
        }
    }
}

