/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.oemlock.IOemLockService;
import android.service.persistentdata.PersistentDataBlockManager;
import com.android.server.SystemService;

public class OemLockService
extends SystemService {
    private Context mContext;
    private final IBinder mService = new IOemLockService.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOemUnlockAllowedByCarrier(boolean allowed, byte[] signature) {
            OemLockService.this.enforceManageCarrierOemUnlockPermission();
            OemLockService.this.enforceUserIsAdmin();
            UserHandle userHandle = UserHandle.of(UserHandle.getCallingUserId());
            long token = Binder.clearCallingIdentity();
            try {
                UserManager.get(OemLockService.this.mContext).setUserRestriction("no_oem_unlock", !allowed, userHandle);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public boolean isOemUnlockAllowedByCarrier() {
            OemLockService.this.enforceManageCarrierOemUnlockPermission();
            return OemLockService.this.doIsOemUnlockAllowedByCarrier();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOemUnlockAllowedByUser(boolean allowedByUser) {
            if (ActivityManager.isUserAMonkey()) {
                return;
            }
            OemLockService.this.enforceManageUserOemUnlockPermission();
            OemLockService.this.enforceUserIsAdmin();
            PersistentDataBlockManager pdbm = (PersistentDataBlockManager)OemLockService.this.mContext.getSystemService("persistent_data_block");
            long token = Binder.clearCallingIdentity();
            try {
                pdbm.setOemUnlockEnabled(allowedByUser);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public boolean isOemUnlockAllowedByUser() {
            OemLockService.this.enforceManageUserOemUnlockPermission();
            return OemLockService.this.doIsOemUnlockAllowedByUser();
        }
    };

    public OemLockService(Context context) {
        super(context);
        this.mContext = context;
    }

    @Override
    public void onStart() {
        this.publishBinderService("oem_lock", this.mService);
    }

    private boolean doIsOemUnlockAllowedByCarrier() {
        return !UserManager.get(this.mContext).hasUserRestriction("no_oem_unlock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doIsOemUnlockAllowedByUser() {
        PersistentDataBlockManager pdbm = (PersistentDataBlockManager)this.mContext.getSystemService("persistent_data_block");
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = pdbm.getOemUnlockEnabled();
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void enforceManageCarrierOemUnlockPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_CARRIER_OEM_UNLOCK_STATE", "Can't manage OEM unlock allowed by carrier");
    }

    private void enforceManageUserOemUnlockPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USER_OEM_UNLOCK_STATE", "Can't manage OEM unlock allowed by user");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceUserIsAdmin() {
        int userId = UserHandle.getCallingUserId();
        long token = Binder.clearCallingIdentity();
        try {
            if (!UserManager.get(this.mContext).isUserAdmin(userId)) {
                throw new SecurityException("Must be an admin user");
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }
}

