/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.IRecoverySystem;
import android.os.IRecoverySystemProgressListener;
import android.os.PowerManager;
import android.os.RecoverySystem;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.server.SystemService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import libcore.io.IoUtils;

public final class RecoverySystemService
extends SystemService {
    private static final String TAG = "RecoverySystemService";
    private static final boolean DEBUG = false;
    private static final String UNCRYPT_SOCKET = "uncrypt";
    private static final String INIT_SERVICE_UNCRYPT = "init.svc.uncrypt";
    private static final String INIT_SERVICE_SETUP_BCB = "init.svc.setup-bcb";
    private static final String INIT_SERVICE_CLEAR_BCB = "init.svc.clear-bcb";
    private static final int SOCKET_CONNECTION_MAX_RETRY = 30;
    private static final Object sRequestLock = new Object();
    private Context mContext;

    public RecoverySystemService(Context context) {
        super(context);
        this.mContext = context;
    }

    @Override
    public void onStart() {
        this.publishBinderService("recovery", new BinderService());
    }

    private final class BinderService
    extends IRecoverySystem.Stub {
        private BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean uncrypt(String filename, IRecoverySystemProgressListener listener) {
            var3_3 = RecoverySystemService.access$100();
            synchronized (var3_3) {
                RecoverySystemService.access$200(RecoverySystemService.this).enforceCallingOrSelfPermission("android.permission.RECOVERY", null);
                available = this.checkAndWaitForUncryptService();
                if (!available) {
                    Slog.e("RecoverySystemService", "uncrypt service is unavailable.");
                    return false;
                }
                RecoverySystem.UNCRYPT_PACKAGE_FILE.delete();
                try {
                    uncryptFile = new FileWriter(RecoverySystem.UNCRYPT_PACKAGE_FILE);
                    var6_7 = null;
                    try {
                        uncryptFile.write(filename + "\n");
                    }
                    catch (Throwable var7_9) {
                        var6_7 = var7_9;
                        throw var7_9;
                    }
                    finally {
                        if (uncryptFile != null) {
                            if (var6_7 != null) {
                                try {
                                    uncryptFile.close();
                                }
                                catch (Throwable var7_8) {
                                    var6_7.addSuppressed(var7_8);
                                }
                            } else {
                                uncryptFile.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    Slog.e("RecoverySystemService", "IOException when writing \"" + RecoverySystem.UNCRYPT_PACKAGE_FILE + "\":", e);
                    return false;
                }
                SystemProperties.set("ctl.start", "uncrypt");
                socket = this.connectService();
                if (socket == null) {
                    Slog.e("RecoverySystemService", "Failed to connect to uncrypt socket");
                    return false;
                }
                dis = null;
                dos = null;
                try {
                    block29: {
                        dis = new DataInputStream(socket.getInputStream());
                        dos = new DataOutputStream(socket.getOutputStream());
                        lastStatus = -2147483648;
                        while (true) {
                            if ((status = dis.readInt()) == lastStatus && lastStatus != -2147483648) {
                                continue;
                            }
                            lastStatus = status;
                            if (status < 0 || status > 100) break block29;
                            Slog.i("RecoverySystemService", "uncrypt read status: " + status);
                            if (listener != null) {
                                try {
                                    listener.onProgress(status);
                                }
                                catch (RemoteException ignored) {
                                    Slog.w("RecoverySystemService", "RemoteException when posting progress");
                                }
                            }
                            if (status == 100) break;
                        }
                        Slog.i("RecoverySystemService", "uncrypt successfully finished.");
                        dos.writeInt(0);
                        ** GOTO lbl89
                    }
                    Slog.e("RecoverySystemService", "uncrypt failed with status: " + status);
                    dos.writeInt(0);
                    var10_17 = false;
                    ** GOTO lbl85
                }
                catch (IOException e) {
                    try {
                        Slog.e("RecoverySystemService", "IOException when reading status: ", e);
                        var9_15 = false;
                    }
                    catch (Throwable var11_18) {
                        IoUtils.closeQuietly(dis);
                        IoUtils.closeQuietly(dos);
                        IoUtils.closeQuietly(socket);
                        throw var11_18;
                    }
lbl85:
                    // 1 sources

                    IoUtils.closeQuietly(dis);
                    IoUtils.closeQuietly(dos);
                    IoUtils.closeQuietly(socket);
                    return var10_17;
lbl89:
                    // 1 sources

                    IoUtils.closeQuietly(dis);
                    IoUtils.closeQuietly(dos);
                    IoUtils.closeQuietly(socket);
                    return true;
                    IoUtils.closeQuietly(dis);
                    IoUtils.closeQuietly(dos);
                    IoUtils.closeQuietly(socket);
                    return var9_15;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean clearBcb() {
            Object object = sRequestLock;
            synchronized (object) {
                return this.setupOrClearBcb(false, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setupBcb(String command) {
            Object object = sRequestLock;
            synchronized (object) {
                return this.setupOrClearBcb(true, command);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rebootRecoveryWithCommand(String command) {
            Object object = sRequestLock;
            synchronized (object) {
                if (!this.setupOrClearBcb(true, command)) {
                    return;
                }
                PowerManager pm = (PowerManager)RecoverySystemService.this.mContext.getSystemService("power");
                pm.reboot("recovery");
            }
        }

        private boolean checkAndWaitForUncryptService() {
            for (int retry = 0; retry < 30; ++retry) {
                boolean busy;
                String uncryptService = SystemProperties.get(RecoverySystemService.INIT_SERVICE_UNCRYPT);
                String setupBcbService = SystemProperties.get(RecoverySystemService.INIT_SERVICE_SETUP_BCB);
                String clearBcbService = SystemProperties.get(RecoverySystemService.INIT_SERVICE_CLEAR_BCB);
                boolean bl = busy = "running".equals(uncryptService) || "running".equals(setupBcbService) || "running".equals(clearBcbService);
                if (!busy) {
                    return true;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Slog.w(RecoverySystemService.TAG, "Interrupted:", e);
                }
            }
            return false;
        }

        private LocalSocket connectService() {
            LocalSocket socket = new LocalSocket();
            boolean done = false;
            for (int retry = 0; retry < 30; ++retry) {
                try {
                    socket.connect(new LocalSocketAddress(RecoverySystemService.UNCRYPT_SOCKET, LocalSocketAddress.Namespace.RESERVED));
                    done = true;
                    break;
                }
                catch (IOException ignored) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Slog.w(RecoverySystemService.TAG, "Interrupted:", e);
                    }
                    continue;
                }
            }
            if (!done) {
                Slog.e(RecoverySystemService.TAG, "Timed out connecting to uncrypt socket");
                return null;
            }
            return socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setupOrClearBcb(boolean isSetup, String command) {
            DataOutputStream dos;
            DataInputStream dis;
            LocalSocket socket;
            block10: {
                boolean bl;
                RecoverySystemService.this.mContext.enforceCallingOrSelfPermission("android.permission.RECOVERY", null);
                boolean available = this.checkAndWaitForUncryptService();
                if (!available) {
                    Slog.e(RecoverySystemService.TAG, "uncrypt service is unavailable.");
                    return false;
                }
                if (isSetup) {
                    SystemProperties.set("ctl.start", "setup-bcb");
                } else {
                    SystemProperties.set("ctl.start", "clear-bcb");
                }
                socket = this.connectService();
                if (socket == null) {
                    Slog.e(RecoverySystemService.TAG, "Failed to connect to uncrypt socket");
                    return false;
                }
                dis = null;
                dos = null;
                try {
                    dis = new DataInputStream(socket.getInputStream());
                    dos = new DataOutputStream(socket.getOutputStream());
                    if (isSetup) {
                        dos.writeInt(command.length());
                        dos.writeBytes(command);
                        dos.flush();
                    }
                    int status = dis.readInt();
                    dos.writeInt(0);
                    if (status == 100) {
                        Slog.i(RecoverySystemService.TAG, "uncrypt " + (isSetup ? "setup" : "clear") + " bcb successfully finished.");
                        break block10;
                    }
                    Slog.e(RecoverySystemService.TAG, "uncrypt failed with status: " + status);
                    bl = false;
                }
                catch (IOException e) {
                    boolean bl2;
                    try {
                        Slog.e(RecoverySystemService.TAG, "IOException when communicating with uncrypt:", e);
                        bl2 = false;
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(dis);
                        IoUtils.closeQuietly(dos);
                        IoUtils.closeQuietly(socket);
                        throw throwable;
                    }
                    IoUtils.closeQuietly(dis);
                    IoUtils.closeQuietly(dos);
                    IoUtils.closeQuietly(socket);
                    return bl2;
                }
                IoUtils.closeQuietly(dis);
                IoUtils.closeQuietly(dos);
                IoUtils.closeQuietly(socket);
                return bl;
            }
            IoUtils.closeQuietly(dis);
            IoUtils.closeQuietly(dos);
            IoUtils.closeQuietly(socket);
            return true;
        }
    }
}

