/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.util.MathUtils;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accessibility.EventStreamTransformation;
import com.android.server.accessibility.GestureUtils;
import com.android.server.accessibility.MagnificationController;

class MagnificationGestureHandler
implements EventStreamTransformation {
    private static final String LOG_TAG = "MagnificationEventHandler";
    private static final boolean DEBUG_STATE_TRANSITIONS = false;
    private static final boolean DEBUG_DETECTING = false;
    private static final boolean DEBUG_PANNING = false;
    private static final int STATE_DELEGATING = 1;
    private static final int STATE_DETECTING = 2;
    private static final int STATE_VIEWPORT_DRAGGING = 3;
    private static final int STATE_MAGNIFIED_INTERACTION = 4;
    private static final float MIN_SCALE = 2.0f;
    private static final float MAX_SCALE = 5.0f;
    private final MagnificationController mMagnificationController;
    private final DetectingStateHandler mDetectingStateHandler;
    private final MagnifiedContentInteractionStateHandler mMagnifiedContentInteractionStateHandler;
    private final StateViewportDraggingHandler mStateViewportDraggingHandler;
    private final ScreenStateReceiver mScreenStateReceiver;
    private final boolean mDetectTripleTap;
    private final boolean mTriggerable;
    private EventStreamTransformation mNext;
    private int mCurrentState;
    private int mPreviousState;
    private boolean mTranslationEnabledBeforePan;
    private boolean mShortcutTriggered;
    private MotionEvent.PointerCoords[] mTempPointerCoords;
    private MotionEvent.PointerProperties[] mTempPointerProperties;
    private long mDelegatingStateDownTime;

    public MagnificationGestureHandler(Context context, AccessibilityManagerService ams, boolean detectTripleTap, boolean triggerable) {
        this.mMagnificationController = ams.getMagnificationController();
        this.mDetectingStateHandler = new DetectingStateHandler(context);
        this.mStateViewportDraggingHandler = new StateViewportDraggingHandler();
        this.mMagnifiedContentInteractionStateHandler = new MagnifiedContentInteractionStateHandler(context);
        this.mDetectTripleTap = detectTripleTap;
        this.mTriggerable = triggerable;
        if (triggerable) {
            this.mScreenStateReceiver = new ScreenStateReceiver(context, this);
            this.mScreenStateReceiver.register();
        } else {
            this.mScreenStateReceiver = null;
        }
        this.transitionToState(2);
    }

    @Override
    public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        if (!event.isFromSource(4098)) {
            if (this.mNext != null) {
                this.mNext.onMotionEvent(event, rawEvent, policyFlags);
            }
            return;
        }
        if (!this.mDetectTripleTap && !this.mTriggerable) {
            if (this.mNext != null) {
                this.dispatchTransformedEvent(event, rawEvent, policyFlags);
            }
            return;
        }
        this.mMagnifiedContentInteractionStateHandler.onMotionEvent(event, rawEvent, policyFlags);
        switch (this.mCurrentState) {
            case 1: {
                this.handleMotionEventStateDelegating(event, rawEvent, policyFlags);
                break;
            }
            case 2: {
                this.mDetectingStateHandler.onMotionEvent(event, rawEvent, policyFlags);
                break;
            }
            case 3: {
                this.mStateViewportDraggingHandler.onMotionEvent(event, rawEvent, policyFlags);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + this.mCurrentState);
            }
        }
    }

    @Override
    public void onKeyEvent(KeyEvent event, int policyFlags) {
        if (this.mNext != null) {
            this.mNext.onKeyEvent(event, policyFlags);
        }
    }

    @Override
    public void onAccessibilityEvent(AccessibilityEvent event) {
        if (this.mNext != null) {
            this.mNext.onAccessibilityEvent(event);
        }
    }

    @Override
    public void setNext(EventStreamTransformation next) {
        this.mNext = next;
    }

    @Override
    public void clearEvents(int inputSource) {
        if (inputSource == 4098) {
            this.clear();
        }
        if (this.mNext != null) {
            this.mNext.clearEvents(inputSource);
        }
    }

    @Override
    public void onDestroy() {
        if (this.mScreenStateReceiver != null) {
            this.mScreenStateReceiver.unregister();
        }
        this.clear();
    }

    void notifyShortcutTriggered() {
        if (this.mTriggerable) {
            if (this.mMagnificationController.resetIfNeeded(true)) {
                this.clear();
            } else {
                this.setMagnificationShortcutTriggered(!this.mShortcutTriggered);
            }
        }
    }

    private void setMagnificationShortcutTriggered(boolean state) {
        if (this.mShortcutTriggered == state) {
            return;
        }
        this.mShortcutTriggered = state;
        this.mMagnificationController.setForceShowMagnifiableBounds(state);
    }

    private void clear() {
        this.mCurrentState = 2;
        this.setMagnificationShortcutTriggered(false);
        this.mDetectingStateHandler.clear();
        this.mStateViewportDraggingHandler.clear();
        this.mMagnifiedContentInteractionStateHandler.clear();
    }

    private void handleMotionEventStateDelegating(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        switch (event.getActionMasked()) {
            case 0: {
                this.mDelegatingStateDownTime = event.getDownTime();
                break;
            }
            case 1: {
                if (this.mDetectingStateHandler.mDelayedEventQueue != null) break;
                this.transitionToState(2);
            }
        }
        if (this.mNext != null) {
            event.setDownTime(this.mDelegatingStateDownTime);
            this.dispatchTransformedEvent(event, rawEvent, policyFlags);
        }
    }

    private void dispatchTransformedEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        float eventX = event.getX();
        float eventY = event.getY();
        if (this.mMagnificationController.isMagnifying() && this.mMagnificationController.magnificationRegionContains(eventX, eventY)) {
            float scale = this.mMagnificationController.getScale();
            float scaledOffsetX = this.mMagnificationController.getOffsetX();
            float scaledOffsetY = this.mMagnificationController.getOffsetY();
            int pointerCount = event.getPointerCount();
            MotionEvent.PointerCoords[] coords = this.getTempPointerCoordsWithMinSize(pointerCount);
            MotionEvent.PointerProperties[] properties = this.getTempPointerPropertiesWithMinSize(pointerCount);
            for (int i = 0; i < pointerCount; ++i) {
                event.getPointerCoords(i, coords[i]);
                coords[i].x = (coords[i].x - scaledOffsetX) / scale;
                coords[i].y = (coords[i].y - scaledOffsetY) / scale;
                event.getPointerProperties(i, properties[i]);
            }
            event = MotionEvent.obtain(event.getDownTime(), event.getEventTime(), event.getAction(), pointerCount, properties, coords, 0, 0, 1.0f, 1.0f, event.getDeviceId(), 0, event.getSource(), event.getFlags());
        }
        this.mNext.onMotionEvent(event, rawEvent, policyFlags);
    }

    private MotionEvent.PointerCoords[] getTempPointerCoordsWithMinSize(int size) {
        int oldSize;
        int n = oldSize = this.mTempPointerCoords != null ? this.mTempPointerCoords.length : 0;
        if (oldSize < size) {
            MotionEvent.PointerCoords[] oldTempPointerCoords = this.mTempPointerCoords;
            this.mTempPointerCoords = new MotionEvent.PointerCoords[size];
            if (oldTempPointerCoords != null) {
                System.arraycopy(oldTempPointerCoords, 0, this.mTempPointerCoords, 0, oldSize);
            }
        }
        for (int i = oldSize; i < size; ++i) {
            this.mTempPointerCoords[i] = new MotionEvent.PointerCoords();
        }
        return this.mTempPointerCoords;
    }

    private MotionEvent.PointerProperties[] getTempPointerPropertiesWithMinSize(int size) {
        int oldSize;
        int n = oldSize = this.mTempPointerProperties != null ? this.mTempPointerProperties.length : 0;
        if (oldSize < size) {
            MotionEvent.PointerProperties[] oldTempPointerProperties = this.mTempPointerProperties;
            this.mTempPointerProperties = new MotionEvent.PointerProperties[size];
            if (oldTempPointerProperties != null) {
                System.arraycopy(oldTempPointerProperties, 0, this.mTempPointerProperties, 0, oldSize);
            }
        }
        for (int i = oldSize; i < size; ++i) {
            this.mTempPointerProperties[i] = new MotionEvent.PointerProperties();
        }
        return this.mTempPointerProperties;
    }

    private void transitionToState(int state) {
        this.mPreviousState = this.mCurrentState;
        this.mCurrentState = state;
    }

    private static class ScreenStateReceiver
    extends BroadcastReceiver {
        private final Context mContext;
        private final MagnificationGestureHandler mGestureHandler;

        public ScreenStateReceiver(Context context, MagnificationGestureHandler gestureHandler) {
            this.mContext = context;
            this.mGestureHandler = gestureHandler;
        }

        public void register() {
            this.mContext.registerReceiver(this, new IntentFilter("android.intent.action.SCREEN_OFF"));
        }

        public void unregister() {
            this.mContext.unregisterReceiver(this);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            this.mGestureHandler.setMagnificationShortcutTriggered(false);
        }
    }

    private static final class MotionEventInfo {
        private static final int MAX_POOL_SIZE = 10;
        private static final Object sLock = new Object();
        private static MotionEventInfo sPool;
        private static int sPoolSize;
        private MotionEventInfo mNext;
        private boolean mInPool;
        public MotionEvent mEvent;
        public MotionEvent mRawEvent;
        public int mPolicyFlags;

        private MotionEventInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static MotionEventInfo obtain(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            Object object = sLock;
            synchronized (object) {
                MotionEventInfo info;
                if (sPoolSize > 0) {
                    --sPoolSize;
                    info = sPool;
                    sPool = info.mNext;
                    info.mNext = null;
                    info.mInPool = false;
                } else {
                    info = new MotionEventInfo();
                }
                info.initialize(event, rawEvent, policyFlags);
                return info;
            }
        }

        private void initialize(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            this.mEvent = MotionEvent.obtain(event);
            this.mRawEvent = MotionEvent.obtain(rawEvent);
            this.mPolicyFlags = policyFlags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            Object object = sLock;
            synchronized (object) {
                if (this.mInPool) {
                    throw new IllegalStateException("Already recycled.");
                }
                this.clear();
                if (sPoolSize < 10) {
                    ++sPoolSize;
                    this.mNext = sPool;
                    sPool = this;
                    this.mInPool = true;
                }
            }
        }

        private void clear() {
            this.mEvent.recycle();
            this.mEvent = null;
            this.mRawEvent.recycle();
            this.mRawEvent = null;
            this.mPolicyFlags = 0;
        }
    }

    private final class DetectingStateHandler
    implements MotionEventHandler {
        private static final int MESSAGE_ON_ACTION_TAP_AND_HOLD = 1;
        private static final int MESSAGE_TRANSITION_TO_DELEGATING_STATE = 2;
        private static final int ACTION_TAP_COUNT = 3;
        private final int mTapTimeSlop = ViewConfiguration.getJumpTapTimeout();
        private final int mMultiTapTimeSlop;
        private final int mTapDistanceSlop;
        private final int mMultiTapDistanceSlop;
        private MotionEventInfo mDelayedEventQueue;
        private MotionEvent mLastDownEvent;
        private MotionEvent mLastTapUpEvent;
        private int mTapCount;
        private final Handler mHandler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                int type = message.what;
                switch (type) {
                    case 1: {
                        MotionEvent event = (MotionEvent)message.obj;
                        int policyFlags = message.arg1;
                        DetectingStateHandler.this.onActionTapAndHold(event, policyFlags);
                        break;
                    }
                    case 2: {
                        MagnificationGestureHandler.this.transitionToState(1);
                        DetectingStateHandler.this.sendDelayedMotionEvents();
                        DetectingStateHandler.this.clear();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown message type: " + type);
                    }
                }
            }
        };

        public DetectingStateHandler(Context context) {
            this.mMultiTapTimeSlop = ViewConfiguration.getDoubleTapTimeout() + context.getResources().getInteger(17694847);
            this.mTapDistanceSlop = ViewConfiguration.get(context).getScaledTouchSlop();
            this.mMultiTapDistanceSlop = ViewConfiguration.get(context).getScaledDoubleTapSlop();
        }

        @Override
        public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            this.cacheDelayedMotionEvent(event, rawEvent, policyFlags);
            int action = event.getActionMasked();
            switch (action) {
                case 0: {
                    this.mHandler.removeMessages(2);
                    if (!MagnificationGestureHandler.this.mMagnificationController.magnificationRegionContains(event.getX(), event.getY())) {
                        this.transitionToDelegatingState(!MagnificationGestureHandler.this.mShortcutTriggered);
                        return;
                    }
                    if (MagnificationGestureHandler.this.mShortcutTriggered) {
                        Message message = this.mHandler.obtainMessage(1, policyFlags, 0, event);
                        this.mHandler.sendMessageDelayed(message, ViewConfiguration.getLongPressTimeout());
                        return;
                    }
                    if (MagnificationGestureHandler.this.mDetectTripleTap) {
                        if (this.mTapCount == 2 && this.mLastDownEvent != null && GestureUtils.isMultiTap(this.mLastDownEvent, event, this.mMultiTapTimeSlop, this.mMultiTapDistanceSlop, 0)) {
                            Message message = this.mHandler.obtainMessage(1, policyFlags, 0, event);
                            this.mHandler.sendMessageDelayed(message, ViewConfiguration.getLongPressTimeout());
                        } else if (this.mTapCount < 3) {
                            Message message = this.mHandler.obtainMessage(2);
                            this.mHandler.sendMessageDelayed(message, this.mMultiTapTimeSlop);
                        }
                        this.clearLastDownEvent();
                        this.mLastDownEvent = MotionEvent.obtain(event);
                        break;
                    }
                    if (MagnificationGestureHandler.this.mMagnificationController.isMagnifying()) {
                        Message message = this.mHandler.obtainMessage(2);
                        this.mHandler.sendMessageDelayed(message, this.mMultiTapTimeSlop);
                        return;
                    }
                    this.transitionToDelegatingState(true);
                    return;
                }
                case 5: {
                    if (MagnificationGestureHandler.this.mMagnificationController.isMagnifying()) {
                        this.mHandler.removeMessages(2);
                        MagnificationGestureHandler.this.transitionToState(4);
                        this.clear();
                        break;
                    }
                    this.transitionToDelegatingState(true);
                    break;
                }
                case 2: {
                    double distance;
                    if (this.mLastDownEvent == null || this.mTapCount >= 2 || !(Math.abs(distance = GestureUtils.computeDistance(this.mLastDownEvent, event, 0)) > (double)this.mTapDistanceSlop)) break;
                    this.transitionToDelegatingState(true);
                    break;
                }
                case 1: {
                    if (!MagnificationGestureHandler.this.mMagnificationController.magnificationRegionContains(event.getX(), event.getY())) {
                        this.transitionToDelegatingState(!MagnificationGestureHandler.this.mShortcutTriggered);
                        return;
                    }
                    if (MagnificationGestureHandler.this.mShortcutTriggered) {
                        this.clear();
                        this.onActionTap(event, policyFlags);
                        return;
                    }
                    if (this.mLastDownEvent == null) {
                        return;
                    }
                    this.mHandler.removeMessages(1);
                    if (!GestureUtils.isTap(this.mLastDownEvent, event, this.mTapTimeSlop, this.mTapDistanceSlop, 0)) {
                        this.transitionToDelegatingState(true);
                        return;
                    }
                    if (this.mLastTapUpEvent != null && !GestureUtils.isMultiTap(this.mLastTapUpEvent, event, this.mMultiTapTimeSlop, this.mMultiTapDistanceSlop, 0)) {
                        this.transitionToDelegatingState(true);
                        return;
                    }
                    ++this.mTapCount;
                    if (this.mTapCount == 3) {
                        this.clear();
                        this.onActionTap(event, policyFlags);
                        return;
                    }
                    this.clearLastTapUpEvent();
                    this.mLastTapUpEvent = MotionEvent.obtain(event);
                    break;
                }
            }
        }

        @Override
        public void clear() {
            MagnificationGestureHandler.this.setMagnificationShortcutTriggered(false);
            this.mHandler.removeMessages(1);
            this.mHandler.removeMessages(2);
            this.clearTapDetectionState();
            this.clearDelayedMotionEvents();
        }

        private void clearTapDetectionState() {
            this.mTapCount = 0;
            this.clearLastTapUpEvent();
            this.clearLastDownEvent();
        }

        private void clearLastTapUpEvent() {
            if (this.mLastTapUpEvent != null) {
                this.mLastTapUpEvent.recycle();
                this.mLastTapUpEvent = null;
            }
        }

        private void clearLastDownEvent() {
            if (this.mLastDownEvent != null) {
                this.mLastDownEvent.recycle();
                this.mLastDownEvent = null;
            }
        }

        private void cacheDelayedMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            MotionEventInfo info = MotionEventInfo.obtain(event, rawEvent, policyFlags);
            if (this.mDelayedEventQueue == null) {
                this.mDelayedEventQueue = info;
            } else {
                MotionEventInfo tail = this.mDelayedEventQueue;
                while (tail.mNext != null) {
                    tail = tail.mNext;
                }
                tail.mNext = info;
            }
        }

        private void sendDelayedMotionEvents() {
            while (this.mDelayedEventQueue != null) {
                MotionEventInfo info = this.mDelayedEventQueue;
                this.mDelayedEventQueue = info.mNext;
                MagnificationGestureHandler.this.onMotionEvent(info.mEvent, info.mRawEvent, info.mPolicyFlags);
                info.recycle();
            }
        }

        private void clearDelayedMotionEvents() {
            while (this.mDelayedEventQueue != null) {
                MotionEventInfo info = this.mDelayedEventQueue;
                this.mDelayedEventQueue = info.mNext;
                info.recycle();
            }
        }

        private void transitionToDelegatingState(boolean andClear) {
            MagnificationGestureHandler.this.transitionToState(1);
            this.sendDelayedMotionEvents();
            if (andClear) {
                this.clear();
            }
        }

        private void onActionTap(MotionEvent up, int policyFlags) {
            if (!MagnificationGestureHandler.this.mMagnificationController.isMagnifying()) {
                float targetScale = MagnificationGestureHandler.this.mMagnificationController.getPersistedScale();
                float scale = MathUtils.constrain(targetScale, 2.0f, 5.0f);
                MagnificationGestureHandler.this.mMagnificationController.setScaleAndCenter(scale, up.getX(), up.getY(), true, 0);
            } else {
                MagnificationGestureHandler.this.mMagnificationController.reset(true);
            }
        }

        private void onActionTapAndHold(MotionEvent down, int policyFlags) {
            this.clear();
            MagnificationGestureHandler.this.mTranslationEnabledBeforePan = MagnificationGestureHandler.this.mMagnificationController.isMagnifying();
            float targetScale = MagnificationGestureHandler.this.mMagnificationController.getPersistedScale();
            float scale = MathUtils.constrain(targetScale, 2.0f, 5.0f);
            MagnificationGestureHandler.this.mMagnificationController.setScaleAndCenter(scale, down.getX(), down.getY(), true, 0);
            MagnificationGestureHandler.this.transitionToState(3);
        }
    }

    private final class StateViewportDraggingHandler
    implements MotionEventHandler {
        private boolean mLastMoveOutsideMagnifiedRegion;

        private StateViewportDraggingHandler() {
        }

        @Override
        public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            int action = event.getActionMasked();
            switch (action) {
                case 0: {
                    throw new IllegalArgumentException("Unexpected event type: ACTION_DOWN");
                }
                case 5: {
                    this.clear();
                    MagnificationGestureHandler.this.transitionToState(4);
                    break;
                }
                case 2: {
                    if (event.getPointerCount() != 1) {
                        throw new IllegalStateException("Should have one pointer down.");
                    }
                    float eventX = event.getX();
                    float eventY = event.getY();
                    if (MagnificationGestureHandler.this.mMagnificationController.magnificationRegionContains(eventX, eventY)) {
                        if (this.mLastMoveOutsideMagnifiedRegion) {
                            this.mLastMoveOutsideMagnifiedRegion = false;
                            MagnificationGestureHandler.this.mMagnificationController.setCenter(eventX, eventY, true, 0);
                            break;
                        }
                        MagnificationGestureHandler.this.mMagnificationController.setCenter(eventX, eventY, false, 0);
                        break;
                    }
                    this.mLastMoveOutsideMagnifiedRegion = true;
                    break;
                }
                case 1: {
                    if (!MagnificationGestureHandler.this.mTranslationEnabledBeforePan) {
                        MagnificationGestureHandler.this.mMagnificationController.reset(true);
                    }
                    this.clear();
                    MagnificationGestureHandler.this.transitionToState(2);
                    break;
                }
                case 6: {
                    throw new IllegalArgumentException("Unexpected event type: ACTION_POINTER_UP");
                }
            }
        }

        @Override
        public void clear() {
            this.mLastMoveOutsideMagnifiedRegion = false;
        }
    }

    private final class MagnifiedContentInteractionStateHandler
    extends GestureDetector.SimpleOnGestureListener
    implements ScaleGestureDetector.OnScaleGestureListener,
    MotionEventHandler {
        private final ScaleGestureDetector mScaleGestureDetector;
        private final GestureDetector mGestureDetector;
        private final float mScalingThreshold;
        private float mInitialScaleFactor = -1.0f;
        private boolean mScaling;

        public MagnifiedContentInteractionStateHandler(Context context) {
            TypedValue scaleValue = new TypedValue();
            context.getResources().getValue(17104958, scaleValue, false);
            this.mScalingThreshold = scaleValue.getFloat();
            this.mScaleGestureDetector = new ScaleGestureDetector(context, this);
            this.mScaleGestureDetector.setQuickScaleEnabled(false);
            this.mGestureDetector = new GestureDetector(context, this);
        }

        @Override
        public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            this.mScaleGestureDetector.onTouchEvent(event);
            this.mGestureDetector.onTouchEvent(event);
            if (MagnificationGestureHandler.this.mCurrentState != 4) {
                return;
            }
            if (event.getActionMasked() == 1) {
                this.clear();
                MagnificationGestureHandler.this.mMagnificationController.persistScale();
                if (MagnificationGestureHandler.this.mPreviousState == 3) {
                    MagnificationGestureHandler.this.transitionToState(3);
                } else {
                    MagnificationGestureHandler.this.transitionToState(2);
                }
            }
        }

        @Override
        public boolean onScroll(MotionEvent first, MotionEvent second, float distanceX, float distanceY) {
            if (MagnificationGestureHandler.this.mCurrentState != 4) {
                return true;
            }
            MagnificationGestureHandler.this.mMagnificationController.offsetMagnifiedRegion(distanceX, distanceY, 0);
            return true;
        }

        @Override
        public boolean onScale(ScaleGestureDetector detector) {
            if (!this.mScaling) {
                if (this.mInitialScaleFactor < 0.0f) {
                    this.mInitialScaleFactor = detector.getScaleFactor();
                } else {
                    float deltaScale = detector.getScaleFactor() - this.mInitialScaleFactor;
                    if (Math.abs(deltaScale) > this.mScalingThreshold) {
                        this.mScaling = true;
                        return true;
                    }
                }
                return false;
            }
            float initialScale = MagnificationGestureHandler.this.mMagnificationController.getScale();
            float targetScale = initialScale * detector.getScaleFactor();
            float scale = targetScale > 5.0f && targetScale > initialScale ? 5.0f : (targetScale < 2.0f && targetScale < initialScale ? 2.0f : targetScale);
            float pivotX = detector.getFocusX();
            float pivotY = detector.getFocusY();
            MagnificationGestureHandler.this.mMagnificationController.setScale(scale, pivotX, pivotY, false, 0);
            return true;
        }

        @Override
        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return MagnificationGestureHandler.this.mCurrentState == 4;
        }

        @Override
        public void onScaleEnd(ScaleGestureDetector detector) {
            this.clear();
        }

        @Override
        public void clear() {
            this.mInitialScaleFactor = -1.0f;
            this.mScaling = false;
        }
    }

    private static interface MotionEventHandler {
        public void onMotionEvent(MotionEvent var1, MotionEvent var2, int var3);

        public void clear();
    }
}

