/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.os.IBinder;
import android.os.RemoteException;
import android.os.Trace;
import android.util.Slog;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;

class KeyguardController {
    private static final String TAG = "ActivityManager";
    private final ActivityManagerService mService;
    private final ActivityStackSupervisor mStackSupervisor;
    private WindowManagerService mWindowManager;
    private boolean mKeyguardShowing;
    private boolean mKeyguardGoingAway;
    private boolean mOccluded;
    private boolean mDismissalRequested;
    private ActivityRecord mDismissingKeyguardActivity;
    private int mBeforeUnoccludeTransit;
    private int mVisibilityTransactionDepth;

    KeyguardController(ActivityManagerService service, ActivityStackSupervisor stackSupervisor) {
        this.mService = service;
        this.mStackSupervisor = stackSupervisor;
    }

    void setWindowManager(WindowManagerService windowManager) {
        this.mWindowManager = windowManager;
    }

    boolean isKeyguardShowing() {
        return this.mKeyguardShowing && !this.mKeyguardGoingAway && !this.mOccluded;
    }

    boolean isKeyguardLocked() {
        return this.mKeyguardShowing && !this.mKeyguardGoingAway;
    }

    void setKeyguardShown(boolean showing) {
        if (showing == this.mKeyguardShowing) {
            return;
        }
        this.mKeyguardShowing = showing;
        this.dismissDockedStackIfNeeded();
        if (showing) {
            this.setKeyguardGoingAway(false);
            this.mDismissalRequested = false;
        }
        this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
        this.mService.updateSleepIfNeededLocked();
    }

    void keyguardGoingAway(int flags) {
        if (!this.mKeyguardShowing) {
            return;
        }
        Trace.traceBegin(64L, "keyguardGoingAway");
        this.mWindowManager.deferSurfaceLayout();
        try {
            this.setKeyguardGoingAway(true);
            this.mWindowManager.prepareAppTransition(20, false, this.convertTransitFlags(flags), false);
            this.mService.updateSleepIfNeededLocked();
            this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
            this.mStackSupervisor.addStartingWindowsForVisibleActivities(true);
            this.mWindowManager.executeAppTransition();
        }
        finally {
            Trace.traceBegin(64L, "keyguardGoingAway: surfaceLayout");
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
            Trace.traceEnd(64L);
        }
    }

    void dismissKeyguard(IBinder token, IKeyguardDismissCallback callback) {
        ActivityRecord activityRecord = ActivityRecord.forTokenLocked(token);
        if (activityRecord == null || !activityRecord.visibleIgnoringKeyguard) {
            this.failCallback(callback);
            return;
        }
        this.mWindowManager.dismissKeyguard(callback);
    }

    private void setKeyguardGoingAway(boolean keyguardGoingAway) {
        this.mKeyguardGoingAway = keyguardGoingAway;
        this.mWindowManager.setKeyguardGoingAway(keyguardGoingAway);
    }

    private void failCallback(IKeyguardDismissCallback callback) {
        try {
            callback.onDismissError();
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to call callback", e);
        }
    }

    private int convertTransitFlags(int keyguardGoingAwayFlags) {
        int result = 0;
        if ((keyguardGoingAwayFlags & 1) != 0) {
            result |= 1;
        }
        if ((keyguardGoingAwayFlags & 2) != 0) {
            result |= 2;
        }
        if ((keyguardGoingAwayFlags & 4) != 0) {
            result |= 4;
        }
        return result;
    }

    void beginActivityVisibilityUpdate() {
        ++this.mVisibilityTransactionDepth;
    }

    void endActivityVisibilityUpdate() {
        --this.mVisibilityTransactionDepth;
        if (this.mVisibilityTransactionDepth == 0) {
            this.visibilitiesUpdated();
        }
    }

    boolean canShowActivityWhileKeyguardShowing(ActivityRecord r, boolean dismissKeyguard) {
        return dismissKeyguard && this.canDismissKeyguard() && (this.mDismissalRequested || r != this.mDismissingKeyguardActivity);
    }

    boolean canShowWhileOccluded(boolean dismissKeyguard, boolean showWhenLocked) {
        return showWhenLocked || dismissKeyguard && !this.mWindowManager.isKeyguardSecure();
    }

    private void visibilitiesUpdated() {
        boolean lastOccluded = this.mOccluded;
        ActivityRecord lastDismissingKeyguardActivity = this.mDismissingKeyguardActivity;
        this.mOccluded = false;
        this.mDismissingKeyguardActivity = null;
        ArrayList<ActivityStack> stacks = this.mStackSupervisor.getStacksOnDefaultDisplay();
        for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = stacks.get(stackNdx);
            if (this.mStackSupervisor.isFocusedStack(stack)) {
                ActivityRecord topDismissing = stack.getTopDismissingKeyguardActivity();
                boolean bl = this.mOccluded = stack.topActivityOccludesKeyguard() || topDismissing != null && stack.topRunningActivityLocked() == topDismissing && this.canShowWhileOccluded(true, false);
            }
            if (this.mDismissingKeyguardActivity != null || stack.getTopDismissingKeyguardActivity() == null) continue;
            this.mDismissingKeyguardActivity = stack.getTopDismissingKeyguardActivity();
        }
        this.mOccluded |= this.mWindowManager.isShowingDream();
        if (this.mOccluded != lastOccluded) {
            this.handleOccludedChanged();
        }
        if (this.mDismissingKeyguardActivity != lastDismissingKeyguardActivity) {
            this.handleDismissKeyguard();
        }
    }

    private void handleOccludedChanged() {
        this.mWindowManager.onKeyguardOccludedChanged(this.mOccluded);
        if (this.isKeyguardLocked()) {
            this.mWindowManager.deferSurfaceLayout();
            try {
                this.mWindowManager.prepareAppTransition(this.resolveOccludeTransit(), false, 0, true);
                this.mService.updateSleepIfNeededLocked();
                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
                this.mWindowManager.executeAppTransition();
            }
            finally {
                this.mWindowManager.continueSurfaceLayout();
            }
        }
        this.dismissDockedStackIfNeeded();
    }

    private void handleDismissKeyguard() {
        if (!this.mOccluded && this.mDismissingKeyguardActivity != null && this.mWindowManager.isKeyguardSecure()) {
            this.mWindowManager.dismissKeyguard(null);
            this.mDismissalRequested = true;
            if (this.mKeyguardShowing && this.canDismissKeyguard() && this.mWindowManager.getPendingAppTransition() == 23) {
                this.mWindowManager.prepareAppTransition(this.mBeforeUnoccludeTransit, false, 0, true);
                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
                this.mWindowManager.executeAppTransition();
            }
        }
    }

    boolean canDismissKeyguard() {
        return this.mWindowManager.isKeyguardTrusted() || !this.mWindowManager.isKeyguardSecure();
    }

    private int resolveOccludeTransit() {
        if (this.mBeforeUnoccludeTransit != -1 && this.mWindowManager.getPendingAppTransition() == 23 && this.mOccluded) {
            return this.mBeforeUnoccludeTransit;
        }
        if (!this.mOccluded) {
            this.mBeforeUnoccludeTransit = this.mWindowManager.getPendingAppTransition();
            return 23;
        }
        return 22;
    }

    private void dismissDockedStackIfNeeded() {
        if (this.mKeyguardShowing && this.mOccluded) {
            this.mStackSupervisor.moveTasksToFullscreenStackLocked(3, this.mStackSupervisor.mFocusedStack.getStackId() == 3);
        }
    }

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "KeyguardController:");
        pw.println(prefix + "  mKeyguardShowing=" + this.mKeyguardShowing);
        pw.println(prefix + "  mKeyguardGoingAway=" + this.mKeyguardGoingAway);
        pw.println(prefix + "  mOccluded=" + this.mOccluded);
        pw.println(prefix + "  mDismissingKeyguardActivity=" + this.mDismissingKeyguardActivity);
        pw.println(prefix + "  mDismissalRequested=" + this.mDismissalRequested);
        pw.println(prefix + "  mVisibilityTransactionDepth=" + this.mVisibilityTransactionDepth);
    }
}

