/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.widget.Toast;

public class LockTaskNotify {
    private static final String TAG = "LockTaskNotify";
    private final Context mContext;
    private final H mHandler;
    private Toast mLastToast;

    public LockTaskNotify(Context context) {
        this.mContext = context;
        this.mHandler = new H();
    }

    public void showToast(int lockTaskModeState) {
        this.mHandler.obtainMessage(3, lockTaskModeState, 0).sendToTarget();
    }

    public void handleShowToast(int lockTaskModeState) {
        String text = null;
        if (lockTaskModeState == 1) {
            text = this.mContext.getString(17040089);
        } else if (lockTaskModeState == 2) {
            text = this.mContext.getString(17040088);
        }
        if (text == null) {
            return;
        }
        if (this.mLastToast != null) {
            this.mLastToast.cancel();
        }
        this.mLastToast = this.makeAllUserToastAndShow(text);
    }

    public void show(boolean starting) {
        int showString = 17040086;
        if (starting) {
            showString = 17040087;
        }
        this.makeAllUserToastAndShow(this.mContext.getString(showString));
    }

    private Toast makeAllUserToastAndShow(String text) {
        Toast toast = Toast.makeText(this.mContext, text, 1);
        toast.getWindowParams().privateFlags |= 0x10;
        toast.show();
        return toast;
    }

    private final class H
    extends Handler {
        private static final int SHOW_TOAST = 3;

        private H() {
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    LockTaskNotify.this.handleShowToast(msg.arg1);
                }
            }
        }
    }
}

