/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill.ui;

import android.app.Dialog;
import android.content.Context;
import android.content.IntentSender;
import android.os.Handler;
import android.service.autofill.SaveInfo;
import android.text.Html;
import android.util.ArraySet;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.android.server.UiThread;
import com.android.server.autofill.Helper;
import com.android.server.autofill.ui.OverlayControl;
import java.io.PrintWriter;

final class SaveUi {
    private static final String TAG = "AutofillSaveUi";
    private final Handler mHandler = UiThread.getHandler();
    private final Dialog mDialog;
    private final OneTimeListener mListener;
    private final OverlayControl mOverlayControl;
    private final CharSequence mTitle;
    private final CharSequence mSubTitle;
    private boolean mDestroyed;

    SaveUi(Context context, CharSequence providerLabel, SaveInfo info, OverlayControl overlayControl, OnSaveListener listener) {
        this.mListener = new OneTimeListener(listener);
        this.mOverlayControl = overlayControl;
        LayoutInflater inflater = LayoutInflater.from(context);
        View view = inflater.inflate(17367101, null);
        TextView titleView = (TextView)view.findViewById(16908730);
        ArraySet<String> types = new ArraySet<String>(3);
        int type = info.getType();
        if ((type & 1) != 0) {
            types.add(context.getString(17039554));
        }
        if ((type & 2) != 0) {
            types.add(context.getString(17039551));
        }
        if ((type & 4) != 0) {
            types.add(context.getString(17039552));
        }
        if ((type & 8) != 0) {
            types.add(context.getString(17039555));
        }
        if ((type & 0x10) != 0) {
            types.add(context.getString(17039553));
        }
        switch (types.size()) {
            case 1: {
                this.mTitle = Html.fromHtml(context.getString(17039550, types.valueAt(0), providerLabel), 0);
                break;
            }
            case 2: {
                this.mTitle = Html.fromHtml(context.getString(17039548, types.valueAt(0), types.valueAt(1), providerLabel), 0);
                break;
            }
            case 3: {
                this.mTitle = Html.fromHtml(context.getString(17039549, types.valueAt(0), types.valueAt(1), types.valueAt(2), providerLabel), 0);
                break;
            }
            default: {
                this.mTitle = Html.fromHtml(context.getString(17039547, providerLabel), 0);
            }
        }
        titleView.setText(this.mTitle);
        this.mSubTitle = info.getDescription();
        if (this.mSubTitle != null) {
            TextView subTitleView = (TextView)view.findViewById(16908729);
            subTitleView.setText(this.mSubTitle);
            subTitleView.setVisibility(0);
        }
        if (Helper.sDebug) {
            Slog.d(TAG, "on constructor: title=" + this.mTitle + ", subTitle=" + this.mSubTitle);
        }
        TextView noButton = (TextView)view.findViewById(16908728);
        if (info.getNegativeActionStyle() == 1) {
            noButton.setText(17040729);
        } else {
            noButton.setText(17039546);
        }
        View.OnClickListener cancelListener = v -> this.mListener.onCancel(info.getNegativeActionListener());
        noButton.setOnClickListener(cancelListener);
        Object yesButton = view.findViewById(16908731);
        ((View)yesButton).setOnClickListener(v -> this.mListener.onSave());
        Object closeButton = view.findViewById(16908727);
        ((View)closeButton).setOnClickListener(cancelListener);
        this.mDialog = new Dialog(context, 16974139);
        this.mDialog.setContentView(view);
        Window window = this.mDialog.getWindow();
        window.setType(2038);
        window.addFlags(393256);
        window.addPrivateFlags(16);
        window.setSoftInputMode(32);
        window.setGravity(81);
        window.setCloseOnTouchOutside(true);
        WindowManager.LayoutParams params = window.getAttributes();
        params.width = -1;
        params.accessibilityTitle = context.getString(17039545);
        Slog.i(TAG, "Showing save dialog: " + this.mTitle);
        this.mDialog.show();
        this.mOverlayControl.hideOverlays();
    }

    void destroy() {
        try {
            if (Helper.sDebug) {
                Slog.d(TAG, "destroy()");
            }
            this.throwIfDestroyed();
            this.mListener.onDestroy();
            this.mHandler.removeCallbacksAndMessages(this.mListener);
            if (Helper.sVerbose) {
                Slog.v(TAG, "destroy(): dismissing dialog");
            }
            this.mDialog.dismiss();
            this.mDestroyed = true;
        }
        finally {
            this.mOverlayControl.showOverlays();
        }
    }

    private void throwIfDestroyed() {
        if (this.mDestroyed) {
            throw new IllegalStateException("cannot interact with a destroyed instance");
        }
    }

    public String toString() {
        return this.mTitle == null ? "NO TITLE" : this.mTitle.toString();
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("title: ");
        pw.println(this.mTitle);
        pw.print(prefix);
        pw.print("subtitle: ");
        pw.println(this.mSubTitle);
        View view = this.mDialog.getWindow().getDecorView();
        int[] loc = view.getLocationOnScreen();
        pw.print(prefix);
        pw.print("coordinates: ");
        pw.print('(');
        pw.print(loc[0]);
        pw.print(',');
        pw.print(loc[1]);
        pw.print(')');
        pw.print('(');
        pw.print(loc[0] + view.getWidth());
        pw.print(',');
        pw.print(loc[1] + view.getHeight());
        pw.println(')');
        pw.print(prefix);
        pw.print("destroyed: ");
        pw.println(this.mDestroyed);
    }

    private class OneTimeListener
    implements OnSaveListener {
        private final OnSaveListener mRealListener;
        private boolean mDone;

        OneTimeListener(OnSaveListener realListener) {
            this.mRealListener = realListener;
        }

        @Override
        public void onSave() {
            if (Helper.sDebug) {
                Slog.d(SaveUi.TAG, "OneTimeListener.onSave(): " + this.mDone);
            }
            if (this.mDone) {
                return;
            }
            this.mDone = true;
            this.mRealListener.onSave();
        }

        @Override
        public void onCancel(IntentSender listener) {
            if (Helper.sDebug) {
                Slog.d(SaveUi.TAG, "OneTimeListener.onCancel(): " + this.mDone);
            }
            if (this.mDone) {
                return;
            }
            this.mDone = true;
            this.mRealListener.onCancel(listener);
        }

        @Override
        public void onDestroy() {
            if (Helper.sDebug) {
                Slog.d(SaveUi.TAG, "OneTimeListener.onDestroy(): " + this.mDone);
            }
            if (this.mDone) {
                return;
            }
            this.mDone = true;
            this.mRealListener.onDestroy();
        }
    }

    public static interface OnSaveListener {
        public void onSave();

        public void onCancel(IntentSender var1);

        public void onDestroy();
    }
}

