/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.camera;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceProxy;
import android.nfc.INfcAdapter;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserManager;
import android.util.ArraySet;
import android.util.Slog;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import java.util.Collection;
import java.util.Set;

public class CameraServiceProxy
extends SystemService
implements Handler.Callback,
IBinder.DeathRecipient {
    private static final String TAG = "CameraService_proxy";
    private static final boolean DEBUG = false;
    private static final String CAMERA_SERVICE_BINDER_NAME = "media.camera";
    public static final String CAMERA_SERVICE_PROXY_BINDER_NAME = "media.camera.proxy";
    public static final int CAMERA_STATE_OPEN = 0;
    public static final int CAMERA_STATE_ACTIVE = 1;
    public static final int CAMERA_STATE_IDLE = 2;
    public static final int CAMERA_STATE_CLOSED = 3;
    public static final int DISABLE_POLLING_FLAGS = 4096;
    public static final int ENABLE_POLLING_FLAGS = 0;
    private static final int MSG_SWITCH_USER = 1;
    private static final int RETRY_DELAY_TIME = 20;
    private final Context mContext;
    private final ServiceThread mHandlerThread;
    private final Handler mHandler;
    private UserManager mUserManager;
    private final Object mLock = new Object();
    private Set<Integer> mEnabledCameraUsers;
    private int mLastUser;
    private ICameraService mCameraServiceRaw;
    private final ArraySet<String> mActiveCameraIds = new ArraySet();
    private static final String NFC_NOTIFICATION_PROP = "ro.camera.notify_nfc";
    private static final String NFC_SERVICE_BINDER_NAME = "nfc";
    private static final IBinder nfcInterfaceToken = new Binder();
    private final boolean mNotifyNfc;
    private int mActiveCameraCount = 0;
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            switch (action) {
                case "android.intent.action.USER_ADDED": 
                case "android.intent.action.USER_REMOVED": 
                case "android.intent.action.USER_INFO_CHANGED": 
                case "android.intent.action.MANAGED_PROFILE_ADDED": 
                case "android.intent.action.MANAGED_PROFILE_REMOVED": {
                    Object object = CameraServiceProxy.this.mLock;
                    synchronized (object) {
                        if (CameraServiceProxy.this.mEnabledCameraUsers == null) {
                            return;
                        }
                        CameraServiceProxy.this.switchUserLocked(CameraServiceProxy.this.mLastUser);
                        break;
                    }
                }
            }
        }
    };
    private final ICameraServiceProxy.Stub mCameraServiceProxy = new ICameraServiceProxy.Stub(){

        @Override
        public void pingForUserUpdate() {
            CameraServiceProxy.this.notifySwitchWithRetries(30);
        }

        @Override
        public void notifyCameraState(String cameraId, int newCameraState) {
            String state = CameraServiceProxy.cameraStateToString(newCameraState);
            CameraServiceProxy.this.updateActivityCount(cameraId, newCameraState);
        }
    };

    public CameraServiceProxy(Context context) {
        super(context);
        this.mContext = context;
        this.mHandlerThread = new ServiceThread(TAG, -4, false);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper(), this);
        this.mNotifyNfc = SystemProperties.getInt(NFC_NOTIFICATION_PROP, 0) > 0;
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.notifySwitchWithRetries(msg.arg1);
                break;
            }
            default: {
                Slog.e(TAG, "CameraServiceProxy error, invalid message: " + msg.what);
            }
        }
        return true;
    }

    @Override
    public void onStart() {
        this.mUserManager = UserManager.get(this.mContext);
        if (this.mUserManager == null) {
            throw new IllegalStateException("UserManagerService must start before CameraServiceProxy!");
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_ADDED");
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_INFO_CHANGED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_ADDED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_REMOVED");
        this.mContext.registerReceiver(this.mIntentReceiver, filter);
        this.publishBinderService(CAMERA_SERVICE_PROXY_BINDER_NAME, this.mCameraServiceProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStartUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabledCameraUsers == null) {
                this.switchUserLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.switchUserLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binderDied() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCameraServiceRaw = null;
            boolean wasEmpty = this.mActiveCameraIds.isEmpty();
            this.mActiveCameraIds.clear();
            if (this.mNotifyNfc && !wasEmpty) {
                this.notifyNfcService(true);
            }
        }
    }

    private void switchUserLocked(int userHandle) {
        Set<Integer> currentUserHandles = this.getEnabledUserHandles(userHandle);
        this.mLastUser = userHandle;
        if (this.mEnabledCameraUsers == null || !this.mEnabledCameraUsers.equals(currentUserHandles)) {
            this.mEnabledCameraUsers = currentUserHandles;
            this.notifyMediaserverLocked(1, currentUserHandles);
        }
    }

    private Set<Integer> getEnabledUserHandles(int currentUserHandle) {
        int[] userProfiles = this.mUserManager.getEnabledProfileIds(currentUserHandle);
        ArraySet<Integer> handles = new ArraySet<Integer>(userProfiles.length);
        for (int id2 : userProfiles) {
            handles.add(id2);
        }
        return handles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySwitchWithRetries(int retries) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabledCameraUsers == null) {
                return;
            }
            if (this.notifyMediaserverLocked(1, this.mEnabledCameraUsers)) {
                retries = 0;
            }
        }
        if (retries <= 0) {
            return;
        }
        Slog.i(TAG, "Could not notify camera service of user switch, retrying...");
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, retries - 1, 0, null), 20L);
    }

    private boolean notifyMediaserverLocked(int eventType, Set<Integer> updatedUserHandles) {
        if (this.mCameraServiceRaw == null) {
            IBinder cameraServiceBinder = this.getBinderService(CAMERA_SERVICE_BINDER_NAME);
            if (cameraServiceBinder == null) {
                Slog.w(TAG, "Could not notify mediaserver, camera service not available.");
                return false;
            }
            try {
                cameraServiceBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Could not link to death of native camera service");
                return false;
            }
            this.mCameraServiceRaw = ICameraService.Stub.asInterface(cameraServiceBinder);
        }
        try {
            this.mCameraServiceRaw.notifySystemEvent(eventType, CameraServiceProxy.toArray(updatedUserHandles));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Could not notify mediaserver, remote exception: " + e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActivityCount(String cameraId, int newCameraState) {
        Object object = this.mLock;
        synchronized (object) {
            boolean wasEmpty = this.mActiveCameraIds.isEmpty();
            switch (newCameraState) {
                case 0: {
                    break;
                }
                case 1: {
                    this.mActiveCameraIds.add(cameraId);
                    break;
                }
                case 2: 
                case 3: {
                    this.mActiveCameraIds.remove(cameraId);
                }
            }
            boolean isEmpty = this.mActiveCameraIds.isEmpty();
            if (this.mNotifyNfc && wasEmpty != isEmpty) {
                this.notifyNfcService(isEmpty);
            }
        }
    }

    private void notifyNfcService(boolean enablePolling) {
        IBinder nfcServiceBinder = this.getBinderService(NFC_SERVICE_BINDER_NAME);
        if (nfcServiceBinder == null) {
            Slog.w(TAG, "Could not connect to NFC service to notify it of camera state");
            return;
        }
        INfcAdapter nfcAdapterRaw = INfcAdapter.Stub.asInterface(nfcServiceBinder);
        int flags = enablePolling ? 0 : 4096;
        try {
            nfcAdapterRaw.setReaderMode(nfcInterfaceToken, null, flags, null);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Could not notify NFC service, remote exception: " + e);
        }
    }

    private static int[] toArray(Collection<Integer> c) {
        int len = c.size();
        int[] ret = new int[len];
        int idx = 0;
        for (Integer i : c) {
            ret[idx++] = i;
        }
        return ret;
    }

    private static String cameraStateToString(int newCameraState) {
        switch (newCameraState) {
            case 0: {
                return "CAMERA_STATE_OPEN";
            }
            case 1: {
                return "CAMERA_STATE_ACTIVE";
            }
            case 2: {
                return "CAMERA_STATE_IDLE";
            }
            case 3: {
                return "CAMERA_STATE_CLOSED";
            }
        }
        return "CAMERA_STATE_UNKNOWN";
    }
}

