/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.RemoteException;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.app.IBatteryStats;
import com.android.internal.telephony.IccCardConstants;
import com.android.server.am.BatteryStatsService;

public class DataConnectionStats
extends BroadcastReceiver {
    private static final String TAG = "DataConnectionStats";
    private static final boolean DEBUG = false;
    private final Context mContext;
    private final IBatteryStats mBatteryStats;
    private IccCardConstants.State mSimState = IccCardConstants.State.READY;
    private SignalStrength mSignalStrength;
    private ServiceState mServiceState;
    private int mDataState = 0;
    private final PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        @Override
        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            DataConnectionStats.this.mSignalStrength = signalStrength;
        }

        @Override
        public void onServiceStateChanged(ServiceState state) {
            DataConnectionStats.this.mServiceState = state;
            DataConnectionStats.this.notePhoneDataConnectionState();
        }

        @Override
        public void onDataConnectionStateChanged(int state, int networkType) {
            DataConnectionStats.this.mDataState = state;
            DataConnectionStats.this.notePhoneDataConnectionState();
        }

        @Override
        public void onDataActivity(int direction) {
            DataConnectionStats.this.notePhoneDataConnectionState();
        }
    };

    public DataConnectionStats(Context context) {
        this.mContext = context;
        this.mBatteryStats = BatteryStatsService.getService();
    }

    public void startMonitoring() {
        TelephonyManager phone = (TelephonyManager)this.mContext.getSystemService("phone");
        phone.listen(this.mPhoneStateListener, 449);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SIM_STATE_CHANGED");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("android.net.conn.INET_CONDITION_ACTION");
        this.mContext.registerReceiver(this, filter);
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action.equals("android.intent.action.SIM_STATE_CHANGED")) {
            this.updateSimState(intent);
            this.notePhoneDataConnectionState();
        } else if (action.equals("android.net.conn.CONNECTIVITY_CHANGE") || action.equals("android.net.conn.INET_CONDITION_ACTION")) {
            this.notePhoneDataConnectionState();
        }
    }

    private void notePhoneDataConnectionState() {
        if (this.mServiceState == null) {
            return;
        }
        boolean simReadyOrUnknown = this.mSimState == IccCardConstants.State.READY || this.mSimState == IccCardConstants.State.UNKNOWN;
        boolean visible = (simReadyOrUnknown || this.isCdma()) && this.hasService() && this.mDataState == 2;
        int networkType = this.mServiceState.getDataNetworkType();
        try {
            this.mBatteryStats.notePhoneDataConnectionState(networkType, visible);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error noting data connection state", e);
        }
    }

    private final void updateSimState(Intent intent) {
        String lockedReason;
        String stateExtra = intent.getStringExtra("ss");
        this.mSimState = "ABSENT".equals(stateExtra) ? IccCardConstants.State.ABSENT : ("READY".equals(stateExtra) ? IccCardConstants.State.READY : ("LOCKED".equals(stateExtra) ? ("PIN".equals(lockedReason = intent.getStringExtra("reason")) ? IccCardConstants.State.PIN_REQUIRED : ("PUK".equals(lockedReason) ? IccCardConstants.State.PUK_REQUIRED : IccCardConstants.State.NETWORK_LOCKED)) : IccCardConstants.State.UNKNOWN));
    }

    private boolean isCdma() {
        return this.mSignalStrength != null && !this.mSignalStrength.isGsm();
    }

    private boolean hasService() {
        return this.mServiceState != null && this.mServiceState.getState() != 1 && this.mServiceState.getState() != 3;
    }
}

