/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.opengl.Matrix;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import java.util.Arrays;

public class DisplayTransformManager {
    private static final String TAG = "DisplayTransformManager";
    public static final int LEVEL_COLOR_MATRIX_NIGHT_DISPLAY = 100;
    public static final int LEVEL_COLOR_MATRIX_GRAYSCALE = 200;
    public static final int LEVEL_COLOR_MATRIX_INVERT_COLOR = 300;
    @GuardedBy(value="mColorMatrix")
    private final SparseArray<float[]> mColorMatrix = new SparseArray(3);
    @GuardedBy(value="mColorMatrix")
    private final float[][] mTempColorMatrix = new float[2][16];
    private final Object mDaltonizerModeLock = new Object();
    @GuardedBy(value="mDaltonizerModeLock")
    private int mDaltonizerMode = -1;

    DisplayTransformManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getColorMatrix(int key) {
        SparseArray<float[]> sparseArray = this.mColorMatrix;
        synchronized (sparseArray) {
            float[] value = this.mColorMatrix.get(key);
            return value == null ? null : Arrays.copyOf(value, value.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorMatrix(int level, float[] value) {
        if (value != null && value.length != 16) {
            throw new IllegalArgumentException("Expected length: 16 (4x4 matrix), actual length: " + value.length);
        }
        SparseArray<float[]> sparseArray = this.mColorMatrix;
        synchronized (sparseArray) {
            float[] oldValue = this.mColorMatrix.get(level);
            if (!Arrays.equals(oldValue, value)) {
                if (value == null) {
                    this.mColorMatrix.remove(level);
                } else if (oldValue == null) {
                    this.mColorMatrix.put(level, Arrays.copyOf(value, value.length));
                } else {
                    System.arraycopy((float[])value, (int)0, (float[])oldValue, (int)0, (int)value.length);
                }
                DisplayTransformManager.applyColorMatrix(this.computeColorMatrixLocked());
            }
        }
    }

    @GuardedBy(value="mColorMatrix")
    private float[] computeColorMatrixLocked() {
        int count = this.mColorMatrix.size();
        if (count == 0) {
            return null;
        }
        float[][] result = this.mTempColorMatrix;
        Matrix.setIdentityM(result[0], 0);
        for (int i = 0; i < count; ++i) {
            float[] rhs = this.mColorMatrix.valueAt(i);
            Matrix.multiplyMM(result[(i + 1) % 2], 0, result[i % 2], 0, rhs, 0);
        }
        return result[count % 2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDaltonizerMode() {
        Object object = this.mDaltonizerModeLock;
        synchronized (object) {
            return this.mDaltonizerMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDaltonizerMode(int mode) {
        Object object = this.mDaltonizerModeLock;
        synchronized (object) {
            if (this.mDaltonizerMode != mode) {
                this.mDaltonizerMode = mode;
                DisplayTransformManager.applyDaltonizerMode(mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyColorMatrix(float[] m) {
        IBinder flinger = ServiceManager.getService("SurfaceFlinger");
        if (flinger != null) {
            Parcel data = Parcel.obtain();
            data.writeInterfaceToken("android.ui.ISurfaceComposer");
            if (m != null) {
                data.writeInt(1);
                for (int i = 0; i < 16; ++i) {
                    data.writeFloat(m[i]);
                }
            } else {
                data.writeInt(0);
            }
            try {
                flinger.transact(1015, data, null, 0);
            }
            catch (RemoteException ex) {
                Slog.e(TAG, "Failed to set color transform", ex);
            }
            finally {
                data.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyDaltonizerMode(int mode) {
        IBinder flinger = ServiceManager.getService("SurfaceFlinger");
        if (flinger != null) {
            Parcel data = Parcel.obtain();
            data.writeInterfaceToken("android.ui.ISurfaceComposer");
            data.writeInt(mode);
            try {
                flinger.transact(1014, data, null, 0);
            }
            catch (RemoteException ex) {
                Slog.e(TAG, "Failed to set Daltonizer mode", ex);
            }
            finally {
                data.recycle();
            }
        }
    }
}

