/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.AlarmManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.provider.Settings;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.util.MathUtils;
import android.util.Slog;
import android.view.animation.AnimationUtils;
import com.android.internal.app.NightDisplayController;
import com.android.server.SystemService;
import com.android.server.display.DisplayTransformManager;
import com.android.server.twilight.TwilightListener;
import com.android.server.twilight.TwilightManager;
import com.android.server.twilight.TwilightState;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NightDisplayService
extends SystemService
implements NightDisplayController.Callback {
    private static final String TAG = "NightDisplayService";
    private static final long TRANSITION_DURATION = 3000L;
    private static final float[] MATRIX_IDENTITY = new float[16];
    private static final ColorMatrixEvaluator COLOR_MATRIX_EVALUATOR;
    private final Handler mHandler;
    private final AtomicBoolean mIgnoreAllColorMatrixChanges = new AtomicBoolean();
    private final IVrStateCallbacks mVrStateCallbacks = new IVrStateCallbacks.Stub(){

        @Override
        public void onVrStateChanged(final boolean enabled) {
            NightDisplayService.this.mIgnoreAllColorMatrixChanges.set(enabled);
            NightDisplayService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (NightDisplayService.this.mColorMatrixAnimator != null) {
                        NightDisplayService.this.mColorMatrixAnimator.cancel();
                    }
                    DisplayTransformManager dtm = (DisplayTransformManager)NightDisplayService.this.getLocalService(DisplayTransformManager.class);
                    if (enabled) {
                        dtm.setColorMatrix(100, MATRIX_IDENTITY);
                    } else if (NightDisplayService.this.mController != null && NightDisplayService.this.mController.isActivated()) {
                        NightDisplayService.this.setMatrix(NightDisplayService.this.mController.getColorTemperature(), NightDisplayService.this.mMatrixNight);
                        dtm.setColorMatrix(100, NightDisplayService.this.mMatrixNight);
                    }
                }
            });
        }
    };
    private float[] mMatrixNight = new float[16];
    private static final float[] mColorTempCoefficients;
    private int mCurrentUser = -10000;
    private ContentObserver mUserSetupObserver;
    private boolean mBootCompleted;
    private NightDisplayController mController;
    private ValueAnimator mColorMatrixAnimator;
    private Boolean mIsActivated;
    private AutoMode mAutoMode;

    public NightDisplayService(Context context) {
        super(context);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onBootPhase(int phase) {
        IVrManager vrManager;
        if (phase >= 500 && (vrManager = IVrManager.Stub.asInterface(this.getBinderService("vrmanager"))) != null) {
            try {
                vrManager.registerListener(this.mVrStateCallbacks);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to register VR mode state listener: " + e);
            }
        }
        if (phase >= 1000) {
            this.mBootCompleted = true;
            if (this.mCurrentUser != -10000 && this.mUserSetupObserver == null) {
                this.setUp();
            }
        }
    }

    @Override
    public void onStartUser(int userHandle) {
        super.onStartUser(userHandle);
        if (this.mCurrentUser == -10000) {
            this.onUserChanged(userHandle);
        }
    }

    @Override
    public void onSwitchUser(int userHandle) {
        super.onSwitchUser(userHandle);
        this.onUserChanged(userHandle);
    }

    @Override
    public void onStopUser(int userHandle) {
        super.onStopUser(userHandle);
        if (this.mCurrentUser == userHandle) {
            this.onUserChanged(-10000);
        }
    }

    private void onUserChanged(int userHandle) {
        final ContentResolver cr = this.getContext().getContentResolver();
        if (this.mCurrentUser != -10000) {
            if (this.mUserSetupObserver != null) {
                cr.unregisterContentObserver(this.mUserSetupObserver);
                this.mUserSetupObserver = null;
            } else if (this.mBootCompleted) {
                this.tearDown();
            }
        }
        this.mCurrentUser = userHandle;
        if (this.mCurrentUser != -10000) {
            if (!NightDisplayService.isUserSetupCompleted(cr, this.mCurrentUser)) {
                this.mUserSetupObserver = new ContentObserver(this.mHandler){

                    @Override
                    public void onChange(boolean selfChange, Uri uri) {
                        if (NightDisplayService.isUserSetupCompleted(cr, NightDisplayService.this.mCurrentUser)) {
                            cr.unregisterContentObserver(this);
                            NightDisplayService.this.mUserSetupObserver = null;
                            if (NightDisplayService.this.mBootCompleted) {
                                NightDisplayService.this.setUp();
                            }
                        }
                    }
                };
                cr.registerContentObserver(Settings.Secure.getUriFor("user_setup_complete"), false, this.mUserSetupObserver, this.mCurrentUser);
            } else if (this.mBootCompleted) {
                this.setUp();
            }
        }
    }

    private static boolean isUserSetupCompleted(ContentResolver cr, int userHandle) {
        return Settings.Secure.getIntForUser(cr, "user_setup_complete", 0, userHandle) == 1;
    }

    private void setUp() {
        Slog.d(TAG, "setUp: currentUser=" + this.mCurrentUser);
        this.mController = new NightDisplayController(this.getContext(), this.mCurrentUser);
        this.mController.setListener(this);
        this.setMatrix(this.mController.getColorTemperature(), this.mMatrixNight);
        this.onAutoModeChanged(this.mController.getAutoMode());
        if (this.mIsActivated == null) {
            this.onActivated(this.mController.isActivated());
        }
        this.applyTint(false);
    }

    private void tearDown() {
        Slog.d(TAG, "tearDown: currentUser=" + this.mCurrentUser);
        if (this.mController != null) {
            this.mController.setListener(null);
            this.mController = null;
        }
        if (this.mAutoMode != null) {
            this.mAutoMode.onStop();
            this.mAutoMode = null;
        }
        if (this.mColorMatrixAnimator != null) {
            this.mColorMatrixAnimator.end();
            this.mColorMatrixAnimator = null;
        }
        this.mIsActivated = null;
    }

    @Override
    public void onActivated(boolean activated) {
        if (this.mIsActivated == null || this.mIsActivated != activated) {
            Slog.i(TAG, activated ? "Turning on night display" : "Turning off night display");
            this.mIsActivated = activated;
            if (this.mAutoMode != null) {
                this.mAutoMode.onActivated(activated);
            }
            this.applyTint(false);
        }
    }

    @Override
    public void onAutoModeChanged(int autoMode) {
        Slog.d(TAG, "onAutoModeChanged: autoMode=" + autoMode);
        if (this.mAutoMode != null) {
            this.mAutoMode.onStop();
            this.mAutoMode = null;
        }
        if (autoMode == 1) {
            this.mAutoMode = new CustomAutoMode();
        } else if (autoMode == 2) {
            this.mAutoMode = new TwilightAutoMode();
        }
        if (this.mAutoMode != null) {
            this.mAutoMode.onStart();
        }
    }

    @Override
    public void onCustomStartTimeChanged(NightDisplayController.LocalTime startTime) {
        Slog.d(TAG, "onCustomStartTimeChanged: startTime=" + startTime);
        if (this.mAutoMode != null) {
            this.mAutoMode.onCustomStartTimeChanged(startTime);
        }
    }

    @Override
    public void onCustomEndTimeChanged(NightDisplayController.LocalTime endTime) {
        Slog.d(TAG, "onCustomEndTimeChanged: endTime=" + endTime);
        if (this.mAutoMode != null) {
            this.mAutoMode.onCustomEndTimeChanged(endTime);
        }
    }

    @Override
    public void onColorTemperatureChanged(int colorTemperature) {
        this.setMatrix(colorTemperature, this.mMatrixNight);
        this.applyTint(true);
    }

    private void applyTint(boolean immediate) {
        float[] to;
        if (this.mColorMatrixAnimator != null) {
            this.mColorMatrixAnimator.cancel();
        }
        if (this.mIgnoreAllColorMatrixChanges.get()) {
            return;
        }
        final DisplayTransformManager dtm = this.getLocalService(DisplayTransformManager.class);
        float[] from = dtm.getColorMatrix(100);
        float[] fArray = to = this.mIsActivated != false ? this.mMatrixNight : MATRIX_IDENTITY;
        if (immediate) {
            dtm.setColorMatrix(100, to);
        } else {
            this.mColorMatrixAnimator = ValueAnimator.ofObject(COLOR_MATRIX_EVALUATOR, from == null ? MATRIX_IDENTITY : from, to);
            this.mColorMatrixAnimator.setDuration(3000L);
            this.mColorMatrixAnimator.setInterpolator(AnimationUtils.loadInterpolator(this.getContext(), 17563661));
            this.mColorMatrixAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                @Override
                public void onAnimationUpdate(ValueAnimator animator2) {
                    float[] value = (float[])animator2.getAnimatedValue();
                    dtm.setColorMatrix(100, value);
                }
            });
            this.mColorMatrixAnimator.addListener(new AnimatorListenerAdapter(){
                private boolean mIsCancelled;

                @Override
                public void onAnimationCancel(Animator animator2) {
                    this.mIsCancelled = true;
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    if (!this.mIsCancelled) {
                        dtm.setColorMatrix(100, to);
                    }
                    NightDisplayService.this.mColorMatrixAnimator = null;
                }
            });
            this.mColorMatrixAnimator.start();
        }
    }

    private void setMatrix(int colorTemperature, float[] outTemp) {
        if (outTemp.length != 16) {
            Slog.d(TAG, "The display transformation matrix must be 4x4");
            return;
        }
        Matrix.setIdentityM(this.mMatrixNight, 0);
        float squareTemperature = colorTemperature * colorTemperature;
        float red = squareTemperature * mColorTempCoefficients[0] + (float)colorTemperature * mColorTempCoefficients[3] + mColorTempCoefficients[6];
        float green = squareTemperature * mColorTempCoefficients[1] + (float)colorTemperature * mColorTempCoefficients[4] + mColorTempCoefficients[7];
        float blue = squareTemperature * mColorTempCoefficients[2] + (float)colorTemperature * mColorTempCoefficients[5] + mColorTempCoefficients[8];
        outTemp[0] = red;
        outTemp[5] = green;
        outTemp[10] = blue;
    }

    static {
        Matrix.setIdentityM(MATRIX_IDENTITY, 0);
        COLOR_MATRIX_EVALUATOR = new ColorMatrixEvaluator();
        mColorTempCoefficients = new float[]{0.0f, -9.623533E-9f, -1.8935904E-8f, 0.0f, 1.5304548E-4f, 3.024122E-4f, 1.0f, 0.39078277f, -0.1986509f};
    }

    private static class ColorMatrixEvaluator
    implements TypeEvaluator<float[]> {
        private final float[] mResultMatrix = new float[16];

        private ColorMatrixEvaluator() {
        }

        @Override
        public float[] evaluate(float fraction2, float[] startValue, float[] endValue) {
            for (int i = 0; i < this.mResultMatrix.length; ++i) {
                this.mResultMatrix[i] = MathUtils.lerp(startValue[i], endValue[i], fraction2);
            }
            return this.mResultMatrix;
        }
    }

    private class TwilightAutoMode
    extends AutoMode
    implements TwilightListener {
        private final TwilightManager mTwilightManager;

        TwilightAutoMode() {
            this.mTwilightManager = (TwilightManager)NightDisplayService.this.getLocalService(TwilightManager.class);
        }

        private void updateActivated(TwilightState state) {
            if (state == null) {
                return;
            }
            boolean activate = state.isNight();
            Calendar lastActivatedTime = NightDisplayService.this.mController.getLastActivatedTime();
            if (lastActivatedTime != null) {
                Calendar now = Calendar.getInstance();
                Calendar sunrise = state.sunrise();
                Calendar sunset = state.sunset();
                if (lastActivatedTime.before(now) && lastActivatedTime.after(sunrise) ^ lastActivatedTime.after(sunset)) {
                    activate = NightDisplayService.this.mController.isActivated();
                }
            }
            if (NightDisplayService.this.mIsActivated == null || NightDisplayService.this.mIsActivated != activate) {
                NightDisplayService.this.mController.setActivated(activate);
            }
        }

        @Override
        public void onStart() {
            this.mTwilightManager.registerListener(this, NightDisplayService.this.mHandler);
            this.updateActivated(this.mTwilightManager.getLastTwilightState());
        }

        @Override
        public void onStop() {
            this.mTwilightManager.unregisterListener(this);
        }

        @Override
        public void onActivated(boolean activated) {
        }

        @Override
        public void onTwilightStateChanged(TwilightState state) {
            Slog.d(NightDisplayService.TAG, "onTwilightStateChanged: isNight=" + (state == null ? null : Boolean.valueOf(state.isNight())));
            this.updateActivated(state);
        }
    }

    private class CustomAutoMode
    extends AutoMode
    implements AlarmManager.OnAlarmListener {
        private final AlarmManager mAlarmManager;
        private final BroadcastReceiver mTimeChangedReceiver;
        private NightDisplayController.LocalTime mStartTime;
        private NightDisplayController.LocalTime mEndTime;
        private Calendar mLastActivatedTime;

        CustomAutoMode() {
            this.mAlarmManager = (AlarmManager)NightDisplayService.this.getContext().getSystemService("alarm");
            this.mTimeChangedReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    CustomAutoMode.this.updateActivated();
                }
            };
        }

        private void updateActivated() {
            Calendar now = Calendar.getInstance();
            Calendar startTime = this.mStartTime.getDateTimeBefore(now);
            Calendar endTime = this.mEndTime.getDateTimeAfter(startTime);
            boolean activate = now.before(endTime);
            if (this.mLastActivatedTime != null) {
                TimeZone currentTimeZone = now.getTimeZone();
                if (!currentTimeZone.equals(this.mLastActivatedTime.getTimeZone())) {
                    int year = this.mLastActivatedTime.get(1);
                    int dayOfYear = this.mLastActivatedTime.get(6);
                    int hourOfDay = this.mLastActivatedTime.get(11);
                    int minute = this.mLastActivatedTime.get(12);
                    this.mLastActivatedTime.setTimeZone(currentTimeZone);
                    this.mLastActivatedTime.set(1, year);
                    this.mLastActivatedTime.set(6, dayOfYear);
                    this.mLastActivatedTime.set(11, hourOfDay);
                    this.mLastActivatedTime.set(12, minute);
                }
                if (this.mLastActivatedTime.before(now) && this.mLastActivatedTime.after(startTime) && (this.mLastActivatedTime.after(endTime) || now.before(endTime))) {
                    activate = NightDisplayService.this.mController.isActivated();
                }
            }
            if (NightDisplayService.this.mIsActivated == null || NightDisplayService.this.mIsActivated != activate) {
                NightDisplayService.this.mController.setActivated(activate);
            }
            this.updateNextAlarm(NightDisplayService.this.mIsActivated, now);
        }

        private void updateNextAlarm(Boolean activated, Calendar now) {
            if (activated != null) {
                Calendar next = activated != false ? this.mEndTime.getDateTimeAfter(now) : this.mStartTime.getDateTimeAfter(now);
                this.mAlarmManager.setExact(1, next.getTimeInMillis(), NightDisplayService.TAG, this, null);
            }
        }

        @Override
        public void onStart() {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            NightDisplayService.this.getContext().registerReceiver(this.mTimeChangedReceiver, intentFilter);
            this.mStartTime = NightDisplayService.this.mController.getCustomStartTime();
            this.mEndTime = NightDisplayService.this.mController.getCustomEndTime();
            this.mLastActivatedTime = NightDisplayService.this.mController.getLastActivatedTime();
            this.updateActivated();
        }

        @Override
        public void onStop() {
            NightDisplayService.this.getContext().unregisterReceiver(this.mTimeChangedReceiver);
            this.mAlarmManager.cancel(this);
            this.mLastActivatedTime = null;
        }

        @Override
        public void onActivated(boolean activated) {
            this.mLastActivatedTime = NightDisplayService.this.mController.getLastActivatedTime();
            this.updateNextAlarm(activated, Calendar.getInstance());
        }

        @Override
        public void onCustomStartTimeChanged(NightDisplayController.LocalTime startTime) {
            this.mStartTime = startTime;
            this.mLastActivatedTime = null;
            this.updateActivated();
        }

        @Override
        public void onCustomEndTimeChanged(NightDisplayController.LocalTime endTime) {
            this.mEndTime = endTime;
            this.mLastActivatedTime = null;
            this.updateActivated();
        }

        @Override
        public void onAlarm() {
            Slog.d(NightDisplayService.TAG, "onAlarm");
            this.updateActivated();
        }
    }

    private abstract class AutoMode
    implements NightDisplayController.Callback {
        private AutoMode() {
        }

        public abstract void onStart();

        public abstract void onStop();
    }
}

