/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.content.Context;
import android.hardware.fingerprint.Fingerprint;
import android.os.Vibrator;
import android.text.TextUtils;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.server.fingerprint.FingerprintsUserState;
import java.util.List;

public class FingerprintUtils {
    private static final long[] FP_ERROR_VIBRATE_PATTERN = new long[]{0L, 30L, 100L, 30L};
    private static final long[] FP_SUCCESS_VIBRATE_PATTERN = new long[]{0L, 30L};
    private static final Object sInstanceLock = new Object();
    private static FingerprintUtils sInstance;
    @GuardedBy(value="this")
    private final SparseArray<FingerprintsUserState> mUsers = new SparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FingerprintUtils getInstance() {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new FingerprintUtils();
            }
        }
        return sInstance;
    }

    private FingerprintUtils() {
    }

    public List<Fingerprint> getFingerprintsForUser(Context ctx, int userId) {
        return this.getStateForUser(ctx, userId).getFingerprints();
    }

    public void addFingerprintForUser(Context ctx, int fingerId, int userId) {
        this.getStateForUser(ctx, userId).addFingerprint(fingerId, userId);
    }

    public void removeFingerprintIdForUser(Context ctx, int fingerId, int userId) {
        this.getStateForUser(ctx, userId).removeFingerprint(fingerId);
    }

    public void renameFingerprintForUser(Context ctx, int fingerId, int userId, CharSequence name) {
        if (TextUtils.isEmpty(name)) {
            return;
        }
        this.getStateForUser(ctx, userId).renameFingerprint(fingerId, name);
    }

    public static void vibrateFingerprintError(Context context) {
        Vibrator vibrator = context.getSystemService(Vibrator.class);
        if (vibrator != null) {
            vibrator.vibrate(FP_ERROR_VIBRATE_PATTERN, -1);
        }
    }

    public static void vibrateFingerprintSuccess(Context context) {
        Vibrator vibrator = context.getSystemService(Vibrator.class);
        if (vibrator != null) {
            vibrator.vibrate(FP_SUCCESS_VIBRATE_PATTERN, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FingerprintsUserState getStateForUser(Context ctx, int userId) {
        FingerprintUtils fingerprintUtils = this;
        synchronized (fingerprintUtils) {
            FingerprintsUserState state = this.mUsers.get(userId);
            if (state == null) {
                state = new FingerprintsUserState(ctx, userId);
                this.mUsers.put(userId, state);
            }
            return state;
        }
    }
}

