/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.content.Context;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.IBinder;
import android.util.Slog;
import com.android.server.fingerprint.EnumerateClient;
import com.android.server.fingerprint.FingerprintUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class InternalEnumerateClient
extends EnumerateClient {
    private List<Fingerprint> mEnrolledList;
    private List<Fingerprint> mEnumeratedList = new ArrayList<Fingerprint>();

    public InternalEnumerateClient(Context context, long halDeviceId, IBinder token, IFingerprintServiceReceiver receiver, int groupId, int userId, boolean restricted, String owner, List<Fingerprint> enrolledList) {
        super(context, halDeviceId, token, receiver, userId, groupId, restricted, owner);
        this.mEnrolledList = enrolledList;
    }

    private void handleEnumeratedFingerprint(int fingerId, int groupId, int remaining) {
        boolean matched = false;
        for (int i = 0; i < this.mEnrolledList.size(); ++i) {
            if (this.mEnrolledList.get(i).getFingerId() != fingerId) continue;
            this.mEnrolledList.remove(i);
            matched = true;
            Slog.e("FingerprintService", "Matched fingerprint fid=" + fingerId);
            break;
        }
        if (!matched && fingerId != 0) {
            Fingerprint fingerprint = new Fingerprint("", groupId, fingerId, this.getHalDeviceId());
            this.mEnumeratedList.add(fingerprint);
        }
    }

    private void doFingerprintCleanup() {
        if (this.mEnrolledList == null) {
            return;
        }
        for (Fingerprint f : this.mEnrolledList) {
            Slog.e("FingerprintService", "Internal Enumerate: Removing dangling enrolled fingerprint: " + f.getName() + " " + f.getFingerId() + " " + f.getGroupId() + " " + f.getDeviceId());
            FingerprintUtils.getInstance().removeFingerprintIdForUser(this.getContext(), f.getFingerId(), this.getTargetUserId());
        }
        this.mEnrolledList.clear();
    }

    public List<Fingerprint> getEnumeratedList() {
        return this.mEnumeratedList;
    }

    @Override
    public boolean onEnumerationResult(int fingerId, int groupId, int remaining) {
        this.handleEnumeratedFingerprint(fingerId, groupId, remaining);
        if (remaining == 0) {
            this.doFingerprintCleanup();
        }
        return fingerId == 0;
    }
}

