/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.firewall;

import android.content.ComponentName;
import android.content.Intent;
import com.android.server.firewall.Filter;
import com.android.server.firewall.FilterFactory;
import com.android.server.firewall.IntentFirewall;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class SenderPermissionFilter
implements Filter {
    private static final String ATTR_NAME = "name";
    private final String mPermission;
    public static final FilterFactory FACTORY = new FilterFactory("sender-permission"){

        @Override
        public Filter newFilter(XmlPullParser parser) throws IOException, XmlPullParserException {
            String permission2 = parser.getAttributeValue(null, SenderPermissionFilter.ATTR_NAME);
            if (permission2 == null) {
                throw new XmlPullParserException("Permission name must be specified.", parser, null);
            }
            return new SenderPermissionFilter(permission2);
        }
    };

    private SenderPermissionFilter(String permission2) {
        this.mPermission = permission2;
    }

    @Override
    public boolean matches(IntentFirewall ifw, ComponentName resolvedComponent, Intent intent, int callerUid, int callerPid, String resolvedType, int receivingUid) {
        return ifw.checkComponentPermission(this.mPermission, callerPid, callerUid, receivingUid, true);
    }
}

