/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiUtils;
import java.io.UnsupportedEncodingException;

final class NewDeviceAction
extends HdmiCecFeatureAction {
    private static final String TAG = "NewDeviceAction";
    static final int STATE_WAITING_FOR_SET_OSD_NAME = 1;
    static final int STATE_WAITING_FOR_DEVICE_VENDOR_ID = 2;
    private final int mDeviceLogicalAddress;
    private final int mDevicePhysicalAddress;
    private final int mDeviceType;
    private int mVendorId;
    private String mDisplayName;
    private int mTimeoutRetry;

    NewDeviceAction(HdmiCecLocalDevice source, int deviceLogicalAddress, int devicePhysicalAddress, int deviceType) {
        super(source);
        this.mDeviceLogicalAddress = deviceLogicalAddress;
        this.mDevicePhysicalAddress = devicePhysicalAddress;
        this.mDeviceType = deviceType;
        this.mVendorId = 0xFFFFFF;
    }

    @Override
    public boolean start() {
        this.requestOsdName(true);
        return true;
    }

    private void requestOsdName(boolean firstTry) {
        if (firstTry) {
            this.mTimeoutRetry = 0;
        }
        this.mState = 1;
        if (this.mayProcessCommandIfCached(this.mDeviceLogicalAddress, 71)) {
            return;
        }
        this.sendCommand(HdmiCecMessageBuilder.buildGiveOsdNameCommand(this.getSourceAddress(), this.mDeviceLogicalAddress));
        this.addTimer(this.mState, 2000);
    }

    @Override
    public boolean processCommand(HdmiCecMessage cmd) {
        int opcode = cmd.getOpcode();
        int src = cmd.getSource();
        byte[] params = cmd.getParams();
        if (this.mDeviceLogicalAddress != src) {
            return false;
        }
        if (this.mState == 1) {
            int requestOpcode;
            if (opcode == 71) {
                try {
                    this.mDisplayName = new String(params, "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    Slog.e(TAG, "Failed to get OSD name: " + e.getMessage());
                }
                this.requestVendorId(true);
                return true;
            }
            if (opcode == 0 && (requestOpcode = params[0] & 0xFF) == 70) {
                this.requestVendorId(true);
                return true;
            }
        } else if (this.mState == 2) {
            int requestOpcode;
            if (opcode == 135) {
                this.mVendorId = HdmiUtils.threeBytesToInt(params);
                this.addDeviceInfo();
                this.finish();
                return true;
            }
            if (opcode == 0 && (requestOpcode = params[0] & 0xFF) == 140) {
                this.addDeviceInfo();
                this.finish();
                return true;
            }
        }
        return false;
    }

    private boolean mayProcessCommandIfCached(int destAddress, int opcode) {
        HdmiCecMessage message = this.getCecMessageCache().getMessage(destAddress, opcode);
        if (message != null) {
            return this.processCommand(message);
        }
        return false;
    }

    private void requestVendorId(boolean firstTry) {
        if (firstTry) {
            this.mTimeoutRetry = 0;
        }
        this.mState = 2;
        if (this.mayProcessCommandIfCached(this.mDeviceLogicalAddress, 135)) {
            return;
        }
        this.sendCommand(HdmiCecMessageBuilder.buildGiveDeviceVendorIdCommand(this.getSourceAddress(), this.mDeviceLogicalAddress));
        this.addTimer(this.mState, 2000);
    }

    private void addDeviceInfo() {
        if (!this.tv().isInDeviceList(this.mDeviceLogicalAddress, this.mDevicePhysicalAddress)) {
            Slog.w(TAG, String.format("Device not found (%02x, %04x)", this.mDeviceLogicalAddress, this.mDevicePhysicalAddress));
            return;
        }
        if (this.mDisplayName == null) {
            this.mDisplayName = HdmiUtils.getDefaultDeviceName(this.mDeviceLogicalAddress);
        }
        HdmiDeviceInfo deviceInfo = new HdmiDeviceInfo(this.mDeviceLogicalAddress, this.mDevicePhysicalAddress, this.tv().getPortId(this.mDevicePhysicalAddress), this.mDeviceType, this.mVendorId, this.mDisplayName);
        this.tv().addCecDevice(deviceInfo);
        this.tv().processDelayedMessages(this.mDeviceLogicalAddress);
        if (HdmiUtils.getTypeFromAddress(this.mDeviceLogicalAddress) == 5) {
            this.tv().onNewAvrAdded(deviceInfo);
        }
    }

    @Override
    public void handleTimerEvent(int state) {
        if (this.mState == 0 || this.mState != state) {
            return;
        }
        if (state == 1) {
            if (++this.mTimeoutRetry < 5) {
                this.requestOsdName(false);
                return;
            }
            this.requestVendorId(true);
        } else if (state == 2) {
            if (++this.mTimeoutRetry < 5) {
                this.requestVendorId(false);
                return;
            }
            this.addDeviceInfo();
            this.finish();
        }
    }

    boolean isActionOf(HdmiCecLocalDevice.ActiveSource activeSource) {
        return this.mDeviceLogicalAddress == activeSource.logicalAddress && this.mDevicePhysicalAddress == activeSource.physicalAddress;
    }
}

