/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiLogger;
import com.android.server.hdmi.HdmiUtils;
import com.android.server.hdmi.SystemAudioActionFromAvr;
import com.android.server.hdmi.SystemAudioActionFromTv;

final class SystemAudioAutoInitiationAction
extends HdmiCecFeatureAction {
    private final int mAvrAddress;
    private static final int STATE_WAITING_FOR_SYSTEM_AUDIO_MODE_STATUS = 1;

    SystemAudioAutoInitiationAction(HdmiCecLocalDevice source, int avrAddress) {
        super(source);
        this.mAvrAddress = avrAddress;
    }

    @Override
    boolean start() {
        this.mState = 1;
        this.addTimer(this.mState, 2000);
        this.sendGiveSystemAudioModeStatus();
        return true;
    }

    private void sendGiveSystemAudioModeStatus() {
        this.sendCommand(HdmiCecMessageBuilder.buildGiveSystemAudioModeStatus(this.getSourceAddress(), this.mAvrAddress), new HdmiControlService.SendMessageCallback(){

            @Override
            public void onSendCompleted(int error) {
                if (error != 0) {
                    SystemAudioAutoInitiationAction.this.tv().setSystemAudioMode(false);
                    SystemAudioAutoInitiationAction.this.finish();
                }
            }
        });
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1 || this.mAvrAddress != cmd.getSource()) {
            return false;
        }
        if (cmd.getOpcode() == 126) {
            this.handleSystemAudioModeStatusMessage(HdmiUtils.parseCommandParamSystemAudioStatus(cmd));
            return true;
        }
        return false;
    }

    private void handleSystemAudioModeStatusMessage(boolean currentSystemAudioMode) {
        if (!this.canChangeSystemAudio()) {
            HdmiLogger.debug("Cannot change system audio mode in auto initiation action.", new Object[0]);
            this.finish();
            return;
        }
        boolean targetSystemAudioMode = this.tv().isSystemAudioControlFeatureEnabled();
        if (currentSystemAudioMode != targetSystemAudioMode) {
            this.addAndStartAction(new SystemAudioActionFromTv(this.tv(), this.mAvrAddress, targetSystemAudioMode, null));
        } else {
            this.tv().setSystemAudioMode(targetSystemAudioMode);
        }
        this.finish();
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            return;
        }
        switch (this.mState) {
            case 1: {
                this.handleSystemAudioModeStatusTimeout();
            }
        }
    }

    private void handleSystemAudioModeStatusTimeout() {
        if (!this.canChangeSystemAudio()) {
            HdmiLogger.debug("Cannot change system audio mode in auto initiation action.", new Object[0]);
            this.finish();
            return;
        }
        this.addAndStartAction(new SystemAudioActionFromTv(this.tv(), this.mAvrAddress, this.tv().isSystemAudioControlFeatureEnabled(), null));
        this.finish();
    }

    private boolean canChangeSystemAudio() {
        return !this.tv().hasAction(SystemAudioActionFromTv.class) && !this.tv().hasAction(SystemAudioActionFromAvr.class);
    }
}

