/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.Notification;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.logging.MetricsLogger;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.RateEstimator;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NotificationUsageStats {
    private static final String TAG = "NotificationUsageStats";
    private static final boolean ENABLE_AGGREGATED_IN_MEMORY_STATS = true;
    private static final boolean ENABLE_SQLITE_LOG = true;
    private static final AggregatedStats[] EMPTY_AGGREGATED_STATS = new AggregatedStats[0];
    private static final String DEVICE_GLOBAL_STATS = "__global";
    private static final int MSG_EMIT = 1;
    private static final boolean DEBUG = false;
    public static final int TEN_SECONDS = 10000;
    public static final int FOUR_HOURS = 14400000;
    private static final long EMIT_PERIOD = 14400000L;
    private final Map<String, AggregatedStats> mStats = new HashMap<String, AggregatedStats>();
    private final ArrayDeque<AggregatedStats[]> mStatsArrays = new ArrayDeque();
    private ArraySet<String> mStatExpiredkeys = new ArraySet();
    private final SQLiteLog mSQLiteLog;
    private final Context mContext;
    private final Handler mHandler;
    private long mLastEmitTime;

    public NotificationUsageStats(Context context) {
        this.mContext = context;
        this.mLastEmitTime = SystemClock.elapsedRealtime();
        this.mSQLiteLog = new SQLiteLog(context);
        this.mHandler = new Handler(this.mContext.getMainLooper()){

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        NotificationUsageStats.this.emit();
                        break;
                    }
                    default: {
                        Log.wtf(NotificationUsageStats.TAG, "Unknown message type: " + msg.what);
                    }
                }
            }
        };
        this.mHandler.sendEmptyMessageDelayed(1, 14400000L);
    }

    public synchronized float getAppEnqueueRate(String packageName) {
        AggregatedStats stats = this.getOrCreateAggregatedStatsLocked(packageName);
        if (stats != null) {
            return stats.getEnqueueRate(SystemClock.elapsedRealtime());
        }
        return 0.0f;
    }

    public synchronized void registerEnqueuedByApp(String packageName) {
        AggregatedStats[] aggregatedStatsArray;
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(packageName)) {
            ++stats.numEnqueuedByApp;
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
    }

    public synchronized void registerPostedByApp(NotificationRecord notification) {
        AggregatedStats[] aggregatedStatsArray;
        long now;
        notification.stats.posttimeElapsedMs = now = SystemClock.elapsedRealtime();
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(notification)) {
            ++stats.numPostedByApp;
            stats.updateInterarrivalEstimate(now);
            stats.countApiUse(notification);
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
        this.mSQLiteLog.logPosted(notification);
    }

    public synchronized void registerUpdatedByApp(NotificationRecord notification, NotificationRecord old) {
        AggregatedStats[] aggregatedStatsArray;
        notification.stats.updateFrom(old.stats);
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(notification)) {
            ++stats.numUpdatedByApp;
            stats.updateInterarrivalEstimate(SystemClock.elapsedRealtime());
            stats.countApiUse(notification);
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
        this.mSQLiteLog.logPosted(notification);
    }

    public synchronized void registerRemovedByApp(NotificationRecord notification) {
        AggregatedStats[] aggregatedStatsArray;
        notification.stats.onRemoved();
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(notification)) {
            ++stats.numRemovedByApp;
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
        this.mSQLiteLog.logRemoved(notification);
    }

    public synchronized void registerDismissedByUser(NotificationRecord notification) {
        MetricsLogger.histogram(this.mContext, "note_dismiss_longevity", (int)(System.currentTimeMillis() - notification.getRankingTimeMs()) / 60000);
        notification.stats.onDismiss();
        this.mSQLiteLog.logDismissed(notification);
    }

    public synchronized void registerClickedByUser(NotificationRecord notification) {
        MetricsLogger.histogram(this.mContext, "note_click_longevity", (int)(System.currentTimeMillis() - notification.getRankingTimeMs()) / 60000);
        notification.stats.onClick();
        this.mSQLiteLog.logClicked(notification);
    }

    public synchronized void registerPeopleAffinity(NotificationRecord notification, boolean valid, boolean starred, boolean cached) {
        AggregatedStats[] aggregatedStatsArray;
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(notification)) {
            if (valid) {
                ++stats.numWithValidPeople;
            }
            if (starred) {
                ++stats.numWithStaredPeople;
            }
            if (cached) {
                ++stats.numPeopleCacheHit;
                continue;
            }
            ++stats.numPeopleCacheMiss;
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
    }

    public synchronized void registerBlocked(NotificationRecord notification) {
        AggregatedStats[] aggregatedStatsArray;
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(notification)) {
            ++stats.numBlocked;
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
    }

    public synchronized void registerSuspendedByAdmin(NotificationRecord notification) {
        AggregatedStats[] aggregatedStatsArray;
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(notification)) {
            ++stats.numSuspendedByAdmin;
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
    }

    public synchronized void registerOverRateQuota(String packageName) {
        AggregatedStats[] aggregatedStatsArray;
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(packageName)) {
            ++stats.numRateViolations;
        }
    }

    public synchronized void registerOverCountQuota(String packageName) {
        AggregatedStats[] aggregatedStatsArray;
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(packageName)) {
            ++stats.numQuotaViolations;
        }
    }

    private AggregatedStats[] getAggregatedStatsLocked(NotificationRecord record) {
        return this.getAggregatedStatsLocked(record.sbn.getPackageName());
    }

    private AggregatedStats[] getAggregatedStatsLocked(String packageName) {
        AggregatedStats[] array2 = this.mStatsArrays.poll();
        if (array2 == null) {
            array2 = new AggregatedStats[]{this.getOrCreateAggregatedStatsLocked(DEVICE_GLOBAL_STATS), this.getOrCreateAggregatedStatsLocked(packageName)};
        }
        return array2;
    }

    private void releaseAggregatedStatsLocked(AggregatedStats[] array2) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = null;
        }
        this.mStatsArrays.offer(array2);
    }

    private AggregatedStats getOrCreateAggregatedStatsLocked(String key) {
        AggregatedStats result = this.mStats.get(key);
        if (result == null) {
            result = new AggregatedStats(this.mContext, key);
            this.mStats.put(key, result);
        }
        result.mLastAccessTime = SystemClock.elapsedRealtime();
        return result;
    }

    public synchronized JSONObject dumpJson(NotificationManagerService.DumpFilter filter) {
        JSONObject dump = new JSONObject();
        try {
            JSONArray aggregatedStats = new JSONArray();
            for (AggregatedStats as : this.mStats.values()) {
                if (filter != null && !filter.matches(as.key)) continue;
                aggregatedStats.put(as.dumpJson());
            }
            dump.put("current", aggregatedStats);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            dump.put("historical", this.mSQLiteLog.dumpJson(filter));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return dump;
    }

    public synchronized void dump(PrintWriter pw, String indent, NotificationManagerService.DumpFilter filter) {
        for (AggregatedStats as : this.mStats.values()) {
            if (filter != null && !filter.matches(as.key)) continue;
            as.dump(pw, indent);
        }
        pw.println(indent + "mStatsArrays.size(): " + this.mStatsArrays.size());
        pw.println(indent + "mStats.size(): " + this.mStats.size());
        this.mSQLiteLog.dump(pw, indent, filter);
    }

    public synchronized void emit() {
        AggregatedStats stats = this.getOrCreateAggregatedStatsLocked(DEVICE_GLOBAL_STATS);
        stats.emit();
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, 14400000L);
        for (String key : this.mStats.keySet()) {
            if (this.mStats.get((Object)key).mLastAccessTime >= this.mLastEmitTime) continue;
            this.mStatExpiredkeys.add(key);
        }
        for (String key : this.mStatExpiredkeys) {
            this.mStats.remove(key);
        }
        this.mStatExpiredkeys.clear();
        this.mLastEmitTime = SystemClock.elapsedRealtime();
    }

    private static class SQLiteLog {
        private static final String TAG = "NotificationSQLiteLog";
        private static final int MSG_POST = 1;
        private static final int MSG_CLICK = 2;
        private static final int MSG_REMOVE = 3;
        private static final int MSG_DISMISS = 4;
        private static final String DB_NAME = "notification_log.db";
        private static final int DB_VERSION = 5;
        private static final long HORIZON_MS = 604800000L;
        private static final long PRUNE_MIN_DELAY_MS = 21600000L;
        private static final long PRUNE_MIN_WRITES = 1024L;
        private static final String TAB_LOG = "log";
        private static final String COL_EVENT_USER_ID = "event_user_id";
        private static final String COL_EVENT_TYPE = "event_type";
        private static final String COL_EVENT_TIME = "event_time_ms";
        private static final String COL_KEY = "key";
        private static final String COL_PKG = "pkg";
        private static final String COL_NOTIFICATION_ID = "nid";
        private static final String COL_TAG = "tag";
        private static final String COL_WHEN_MS = "when_ms";
        private static final String COL_DEFAULTS = "defaults";
        private static final String COL_FLAGS = "flags";
        private static final String COL_IMPORTANCE_REQ = "importance_request";
        private static final String COL_IMPORTANCE_FINAL = "importance_final";
        private static final String COL_NOISY = "noisy";
        private static final String COL_MUTED = "muted";
        private static final String COL_DEMOTED = "demoted";
        private static final String COL_CATEGORY = "category";
        private static final String COL_ACTION_COUNT = "action_count";
        private static final String COL_POSTTIME_MS = "posttime_ms";
        private static final String COL_AIRTIME_MS = "airtime_ms";
        private static final String COL_FIRST_EXPANSIONTIME_MS = "first_expansion_time_ms";
        private static final String COL_AIRTIME_EXPANDED_MS = "expansion_airtime_ms";
        private static final String COL_EXPAND_COUNT = "expansion_count";
        private static final int EVENT_TYPE_POST = 1;
        private static final int EVENT_TYPE_CLICK = 2;
        private static final int EVENT_TYPE_REMOVE = 3;
        private static final int EVENT_TYPE_DISMISS = 4;
        private static long sLastPruneMs;
        private static long sNumWrites;
        private final SQLiteOpenHelper mHelper;
        private final Handler mWriteHandler;
        private static final long DAY_MS = 86400000L;
        private static final String STATS_QUERY = "SELECT event_user_id, pkg, CAST(((%d - event_time_ms) / 86400000) AS int) AS day, COUNT(*) AS cnt, SUM(muted) as muted, SUM(noisy) as noisy, SUM(demoted) as demoted FROM log WHERE event_type=1 AND event_time_ms > %d  GROUP BY event_user_id, day, pkg";

        public SQLiteLog(Context context) {
            HandlerThread backgroundThread = new HandlerThread("notification-sqlite-log", 10);
            backgroundThread.start();
            this.mWriteHandler = new Handler(backgroundThread.getLooper()){

                @Override
                public void handleMessage(Message msg) {
                    NotificationRecord r = (NotificationRecord)msg.obj;
                    long nowMs = System.currentTimeMillis();
                    switch (msg.what) {
                        case 1: {
                            this.writeEvent(r.sbn.getPostTime(), 1, r);
                            break;
                        }
                        case 2: {
                            this.writeEvent(nowMs, 2, r);
                            break;
                        }
                        case 3: {
                            this.writeEvent(nowMs, 3, r);
                            break;
                        }
                        case 4: {
                            this.writeEvent(nowMs, 4, r);
                            break;
                        }
                        default: {
                            Log.wtf(SQLiteLog.TAG, "Unknown message type: " + msg.what);
                        }
                    }
                }
            };
            this.mHelper = new SQLiteOpenHelper(context, DB_NAME, null, 5){

                @Override
                public void onCreate(SQLiteDatabase db) {
                    db.execSQL("CREATE TABLE log (_id INTEGER PRIMARY KEY AUTOINCREMENT,event_user_id INT,event_type INT,event_time_ms INT,key TEXT,pkg TEXT,nid INT,tag TEXT,when_ms INT,defaults INT,flags INT,importance_request INT,importance_final INT,noisy INT,muted INT,demoted INT,category TEXT,action_count INT,posttime_ms INT,airtime_ms INT,first_expansion_time_ms INT,expansion_airtime_ms INT,expansion_count INT)");
                }

                @Override
                public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
                    if (oldVersion != newVersion) {
                        db.execSQL("DROP TABLE IF EXISTS log");
                        this.onCreate(db);
                    }
                }
            };
        }

        public void logPosted(NotificationRecord notification) {
            this.mWriteHandler.sendMessage(this.mWriteHandler.obtainMessage(1, notification));
        }

        public void logClicked(NotificationRecord notification) {
            this.mWriteHandler.sendMessage(this.mWriteHandler.obtainMessage(2, notification));
        }

        public void logRemoved(NotificationRecord notification) {
            this.mWriteHandler.sendMessage(this.mWriteHandler.obtainMessage(3, notification));
        }

        public void logDismissed(NotificationRecord notification) {
            this.mWriteHandler.sendMessage(this.mWriteHandler.obtainMessage(4, notification));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JSONArray jsonPostFrequencies(NotificationManagerService.DumpFilter filter) throws JSONException {
            JSONArray frequencies = new JSONArray();
            SQLiteDatabase db = this.mHelper.getReadableDatabase();
            long midnight = this.getMidnightMs();
            String q = String.format(STATS_QUERY, midnight, filter.since);
            try (Cursor cursor = db.rawQuery(q, null);){
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    int userId = cursor.getInt(0);
                    String pkg = cursor.getString(1);
                    if (filter == null || filter.matches(pkg)) {
                        int day = cursor.getInt(2);
                        int count = cursor.getInt(3);
                        int muted = cursor.getInt(4);
                        int noisy = cursor.getInt(5);
                        int demoted = cursor.getInt(6);
                        JSONObject row = new JSONObject();
                        row.put("user_id", userId);
                        row.put("package", pkg);
                        row.put("day", day);
                        row.put("count", count);
                        row.put(COL_NOISY, noisy);
                        row.put(COL_MUTED, muted);
                        row.put(COL_DEMOTED, demoted);
                        frequencies.put(row);
                    }
                    cursor.moveToNext();
                }
            }
            return frequencies;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printPostFrequencies(PrintWriter pw, String indent, NotificationManagerService.DumpFilter filter) {
            SQLiteDatabase db = this.mHelper.getReadableDatabase();
            long midnight = this.getMidnightMs();
            String q = String.format(STATS_QUERY, midnight, filter.since);
            try (Cursor cursor = db.rawQuery(q, null);){
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    int userId = cursor.getInt(0);
                    String pkg = cursor.getString(1);
                    if (filter == null || filter.matches(pkg)) {
                        int day = cursor.getInt(2);
                        int count = cursor.getInt(3);
                        int muted = cursor.getInt(4);
                        int noisy = cursor.getInt(5);
                        int demoted = cursor.getInt(6);
                        pw.println(indent + "post_frequency{user_id=" + userId + ",pkg=" + pkg + ",day=" + day + ",count=" + count + ",muted=" + muted + "/" + noisy + ",demoted=" + demoted + "}");
                    }
                    cursor.moveToNext();
                }
            }
        }

        private long getMidnightMs() {
            GregorianCalendar midnight = new GregorianCalendar();
            midnight.set(midnight.get(1), midnight.get(2), midnight.get(5), 23, 59, 59);
            return midnight.getTimeInMillis();
        }

        private void writeEvent(long eventTimeMs, int eventType, NotificationRecord r) {
            ContentValues cv = new ContentValues();
            cv.put(COL_EVENT_USER_ID, r.sbn.getUser().getIdentifier());
            cv.put(COL_EVENT_TIME, eventTimeMs);
            cv.put(COL_EVENT_TYPE, eventType);
            SQLiteLog.putNotificationIdentifiers(r, cv);
            if (eventType == 1) {
                SQLiteLog.putNotificationDetails(r, cv);
            } else {
                SQLiteLog.putPosttimeVisibility(r, cv);
            }
            SQLiteDatabase db = this.mHelper.getWritableDatabase();
            if (db.insert(TAB_LOG, null, cv) < 0L) {
                Log.wtf(TAG, "Error while trying to insert values: " + cv);
            }
            ++sNumWrites;
            this.pruneIfNecessary(db);
        }

        private void pruneIfNecessary(SQLiteDatabase db) {
            long nowMs = System.currentTimeMillis();
            if (sNumWrites > 1024L || nowMs - sLastPruneMs > 21600000L) {
                sNumWrites = 0L;
                sLastPruneMs = nowMs;
                long horizonStartMs = nowMs - 604800000L;
                int deletedRows = db.delete(TAB_LOG, "event_time_ms < ?", new String[]{String.valueOf(horizonStartMs)});
                Log.d(TAG, "Pruned event entries: " + deletedRows);
            }
        }

        private static void putNotificationIdentifiers(NotificationRecord r, ContentValues outCv) {
            outCv.put(COL_KEY, r.sbn.getKey());
            outCv.put(COL_PKG, r.sbn.getPackageName());
        }

        private static void putNotificationDetails(NotificationRecord r, ContentValues outCv) {
            outCv.put(COL_NOTIFICATION_ID, r.sbn.getId());
            if (r.sbn.getTag() != null) {
                outCv.put(COL_TAG, r.sbn.getTag());
            }
            outCv.put(COL_WHEN_MS, r.sbn.getPostTime());
            outCv.put(COL_FLAGS, r.getNotification().flags);
            int before = r.stats.requestedImportance;
            int after = r.getImportance();
            boolean noisy = r.stats.isNoisy;
            outCv.put(COL_IMPORTANCE_REQ, before);
            outCv.put(COL_IMPORTANCE_FINAL, after);
            outCv.put(COL_DEMOTED, after < before ? 1 : 0);
            outCv.put(COL_NOISY, noisy);
            if (noisy && after < 4) {
                outCv.put(COL_MUTED, 1);
            } else {
                outCv.put(COL_MUTED, 0);
            }
            if (r.getNotification().category != null) {
                outCv.put(COL_CATEGORY, r.getNotification().category);
            }
            outCv.put(COL_ACTION_COUNT, r.getNotification().actions != null ? r.getNotification().actions.length : 0);
        }

        private static void putPosttimeVisibility(NotificationRecord r, ContentValues outCv) {
            outCv.put(COL_POSTTIME_MS, r.stats.getCurrentPosttimeMs());
            outCv.put(COL_AIRTIME_MS, r.stats.getCurrentAirtimeMs());
            outCv.put(COL_EXPAND_COUNT, r.stats.userExpansionCount);
            outCv.put(COL_AIRTIME_EXPANDED_MS, r.stats.getCurrentAirtimeExpandedMs());
            outCv.put(COL_FIRST_EXPANSIONTIME_MS, r.stats.posttimeToFirstVisibleExpansionMs);
        }

        public void dump(PrintWriter pw, String indent, NotificationManagerService.DumpFilter filter) {
            this.printPostFrequencies(pw, indent, filter);
        }

        public JSONObject dumpJson(NotificationManagerService.DumpFilter filter) {
            JSONObject dump = new JSONObject();
            try {
                dump.put("post_frequency", this.jsonPostFrequencies(filter));
                dump.put("since", filter.since);
                dump.put("now", System.currentTimeMillis());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return dump;
        }
    }

    public static class Aggregate {
        long numSamples;
        double avg;
        double sum2;
        double var;

        public void addSample(long sample) {
            ++this.numSamples;
            double n = this.numSamples;
            double delta = (double)sample - this.avg;
            this.avg += 1.0 / n * delta;
            this.sum2 += (n - 1.0) / n * delta * delta;
            double divisor = this.numSamples == 1L ? 1.0 : n - 1.0;
            this.var = this.sum2 / divisor;
        }

        public String toString() {
            return "Aggregate{numSamples=" + this.numSamples + ", avg=" + this.avg + ", var=" + this.var + '}';
        }
    }

    public static class SingleNotificationStats {
        private boolean isVisible = false;
        private boolean isExpanded = false;
        public long posttimeElapsedMs = -1L;
        public long posttimeToFirstClickMs = -1L;
        public long posttimeToDismissMs = -1L;
        public long airtimeCount = 0L;
        public long posttimeToFirstAirtimeMs = -1L;
        public long currentAirtimeStartElapsedMs = -1L;
        public long airtimeMs = 0L;
        public long posttimeToFirstVisibleExpansionMs = -1L;
        public long currentAirtimeExpandedStartElapsedMs = -1L;
        public long airtimeExpandedMs = 0L;
        public long userExpansionCount = 0L;
        public int requestedImportance;
        public boolean isNoisy;
        public int naturalImportance;

        public long getCurrentPosttimeMs() {
            if (this.posttimeElapsedMs < 0L) {
                return 0L;
            }
            return SystemClock.elapsedRealtime() - this.posttimeElapsedMs;
        }

        public long getCurrentAirtimeMs() {
            long result = this.airtimeMs;
            if (this.currentAirtimeStartElapsedMs >= 0L) {
                result += SystemClock.elapsedRealtime() - this.currentAirtimeStartElapsedMs;
            }
            return result;
        }

        public long getCurrentAirtimeExpandedMs() {
            long result = this.airtimeExpandedMs;
            if (this.currentAirtimeExpandedStartElapsedMs >= 0L) {
                result += SystemClock.elapsedRealtime() - this.currentAirtimeExpandedStartElapsedMs;
            }
            return result;
        }

        public void onClick() {
            if (this.posttimeToFirstClickMs < 0L) {
                this.posttimeToFirstClickMs = SystemClock.elapsedRealtime() - this.posttimeElapsedMs;
            }
        }

        public void onDismiss() {
            if (this.posttimeToDismissMs < 0L) {
                this.posttimeToDismissMs = SystemClock.elapsedRealtime() - this.posttimeElapsedMs;
            }
            this.finish();
        }

        public void onCancel() {
            this.finish();
        }

        public void onRemoved() {
            this.finish();
        }

        public void onVisibilityChanged(boolean visible) {
            long elapsedNowMs = SystemClock.elapsedRealtime();
            boolean wasVisible = this.isVisible;
            this.isVisible = visible;
            if (visible) {
                if (this.currentAirtimeStartElapsedMs < 0L) {
                    ++this.airtimeCount;
                    this.currentAirtimeStartElapsedMs = elapsedNowMs;
                }
                if (this.posttimeToFirstAirtimeMs < 0L) {
                    this.posttimeToFirstAirtimeMs = elapsedNowMs - this.posttimeElapsedMs;
                }
            } else if (this.currentAirtimeStartElapsedMs >= 0L) {
                this.airtimeMs += elapsedNowMs - this.currentAirtimeStartElapsedMs;
                this.currentAirtimeStartElapsedMs = -1L;
            }
            if (wasVisible != this.isVisible) {
                this.updateVisiblyExpandedStats();
            }
        }

        public void onExpansionChanged(boolean userAction, boolean expanded) {
            this.isExpanded = expanded;
            if (this.isExpanded && userAction) {
                ++this.userExpansionCount;
            }
            this.updateVisiblyExpandedStats();
        }

        private void updateVisiblyExpandedStats() {
            long elapsedNowMs = SystemClock.elapsedRealtime();
            if (this.isExpanded && this.isVisible) {
                if (this.currentAirtimeExpandedStartElapsedMs < 0L) {
                    this.currentAirtimeExpandedStartElapsedMs = elapsedNowMs;
                }
                if (this.posttimeToFirstVisibleExpansionMs < 0L) {
                    this.posttimeToFirstVisibleExpansionMs = elapsedNowMs - this.posttimeElapsedMs;
                }
            } else if (this.currentAirtimeExpandedStartElapsedMs >= 0L) {
                this.airtimeExpandedMs += elapsedNowMs - this.currentAirtimeExpandedStartElapsedMs;
                this.currentAirtimeExpandedStartElapsedMs = -1L;
            }
        }

        public void finish() {
            this.onVisibilityChanged(false);
        }

        public String toString() {
            StringBuilder output = new StringBuilder();
            output.append("SingleNotificationStats{");
            output.append("posttimeElapsedMs=").append(this.posttimeElapsedMs).append(", ");
            output.append("posttimeToFirstClickMs=").append(this.posttimeToFirstClickMs).append(", ");
            output.append("posttimeToDismissMs=").append(this.posttimeToDismissMs).append(", ");
            output.append("airtimeCount=").append(this.airtimeCount).append(", ");
            output.append("airtimeMs=").append(this.airtimeMs).append(", ");
            output.append("currentAirtimeStartElapsedMs=").append(this.currentAirtimeStartElapsedMs).append(", ");
            output.append("airtimeExpandedMs=").append(this.airtimeExpandedMs).append(", ");
            output.append("posttimeToFirstVisibleExpansionMs=").append(this.posttimeToFirstVisibleExpansionMs).append(", ");
            output.append("currentAirtimeExpandedStartElapsedMs=").append(this.currentAirtimeExpandedStartElapsedMs).append(", ");
            output.append("requestedImportance=").append(this.requestedImportance).append(", ");
            output.append("naturalImportance=").append(this.naturalImportance).append(", ");
            output.append("isNoisy=").append(this.isNoisy);
            output.append('}');
            return output.toString();
        }

        public void updateFrom(SingleNotificationStats old) {
            this.posttimeElapsedMs = old.posttimeElapsedMs;
            this.posttimeToFirstClickMs = old.posttimeToFirstClickMs;
            this.airtimeCount = old.airtimeCount;
            this.posttimeToFirstAirtimeMs = old.posttimeToFirstAirtimeMs;
            this.currentAirtimeStartElapsedMs = old.currentAirtimeStartElapsedMs;
            this.airtimeMs = old.airtimeMs;
            this.posttimeToFirstVisibleExpansionMs = old.posttimeToFirstVisibleExpansionMs;
            this.currentAirtimeExpandedStartElapsedMs = old.currentAirtimeExpandedStartElapsedMs;
            this.airtimeExpandedMs = old.airtimeExpandedMs;
            this.userExpansionCount = old.userExpansionCount;
        }
    }

    private static class ImportanceHistogram {
        private static final int NUM_IMPORTANCES = 6;
        private static final String[] IMPORTANCE_NAMES = new String[]{"none", "min", "low", "default", "high", "max"};
        private final Context mContext;
        private final String[] mCounterNames;
        private final String mPrefix;
        private int[] mCount;

        ImportanceHistogram(Context context, String prefix) {
            this.mContext = context;
            this.mCount = new int[6];
            this.mCounterNames = new String[6];
            this.mPrefix = prefix;
            for (int i = 0; i < 6; ++i) {
                this.mCounterNames[i] = this.mPrefix + IMPORTANCE_NAMES[i];
            }
        }

        void increment(int imp) {
            int n = imp = imp < 0 ? 0 : (imp > 6 ? 6 : imp);
            this.mCount[n] = this.mCount[n] + 1;
        }

        void maybeCount(ImportanceHistogram prev) {
            for (int i = 0; i < 6; ++i) {
                int value = this.mCount[i] - prev.mCount[i];
                if (value <= 0) continue;
                MetricsLogger.count(this.mContext, this.mCounterNames[i], value);
            }
        }

        void update(ImportanceHistogram that) {
            for (int i = 0; i < 6; ++i) {
                this.mCount[i] = that.mCount[i];
            }
        }

        public void maybePut(JSONObject dump, ImportanceHistogram prev) throws JSONException {
            dump.put(this.mPrefix, new JSONArray(this.mCount));
        }

        public String toString() {
            StringBuilder output = new StringBuilder();
            output.append(this.mPrefix).append(": [");
            for (int i = 0; i < 6; ++i) {
                output.append(this.mCount[i]);
                if (i >= 5) continue;
                output.append(", ");
            }
            output.append("]");
            return output.toString();
        }
    }

    private static class AggregatedStats {
        private final Context mContext;
        public final String key;
        private final long mCreated;
        private AggregatedStats mPrevious;
        public int numEnqueuedByApp;
        public int numPostedByApp;
        public int numUpdatedByApp;
        public int numRemovedByApp;
        public int numPeopleCacheHit;
        public int numPeopleCacheMiss;
        public int numWithStaredPeople;
        public int numWithValidPeople;
        public int numBlocked;
        public int numSuspendedByAdmin;
        public int numWithActions;
        public int numPrivate;
        public int numSecret;
        public int numWithBigText;
        public int numWithBigPicture;
        public int numForegroundService;
        public int numOngoing;
        public int numAutoCancel;
        public int numWithLargeIcon;
        public int numWithInbox;
        public int numWithMediaSession;
        public int numWithTitle;
        public int numWithText;
        public int numWithSubText;
        public int numWithInfoText;
        public int numInterrupt;
        public ImportanceHistogram noisyImportance;
        public ImportanceHistogram quietImportance;
        public ImportanceHistogram finalImportance;
        public RateEstimator enqueueRate;
        public int numRateViolations;
        public int numQuotaViolations;
        public long mLastAccessTime;

        public AggregatedStats(Context context, String key) {
            this.key = key;
            this.mContext = context;
            this.mCreated = SystemClock.elapsedRealtime();
            this.noisyImportance = new ImportanceHistogram(context, "note_imp_noisy_");
            this.quietImportance = new ImportanceHistogram(context, "note_imp_quiet_");
            this.finalImportance = new ImportanceHistogram(context, "note_importance_");
            this.enqueueRate = new RateEstimator();
        }

        public AggregatedStats getPrevious() {
            if (this.mPrevious == null) {
                this.mPrevious = new AggregatedStats(this.mContext, this.key);
            }
            return this.mPrevious;
        }

        public void countApiUse(NotificationRecord record) {
            Notification n = record.getNotification();
            if (n.actions != null) {
                ++this.numWithActions;
            }
            if ((n.flags & 0x40) != 0) {
                ++this.numForegroundService;
            }
            if ((n.flags & 2) != 0) {
                ++this.numOngoing;
            }
            if ((n.flags & 0x10) != 0) {
                ++this.numAutoCancel;
            }
            if ((n.defaults & 1) != 0 || (n.defaults & 2) != 0 || n.sound != null || n.vibrate != null) {
                ++this.numInterrupt;
            }
            switch (n.visibility) {
                case 0: {
                    ++this.numPrivate;
                    break;
                }
                case -1: {
                    ++this.numSecret;
                }
            }
            if (record.stats.isNoisy) {
                this.noisyImportance.increment(record.stats.requestedImportance);
            } else {
                this.quietImportance.increment(record.stats.requestedImportance);
            }
            this.finalImportance.increment(record.getImportance());
            Set<String> names = n.extras.keySet();
            if (names.contains("android.bigText")) {
                ++this.numWithBigText;
            }
            if (names.contains("android.picture")) {
                ++this.numWithBigPicture;
            }
            if (names.contains("android.largeIcon")) {
                ++this.numWithLargeIcon;
            }
            if (names.contains("android.textLines")) {
                ++this.numWithInbox;
            }
            if (names.contains("android.mediaSession")) {
                ++this.numWithMediaSession;
            }
            if (names.contains("android.title") && !TextUtils.isEmpty(n.extras.getCharSequence("android.title"))) {
                ++this.numWithTitle;
            }
            if (names.contains("android.text") && !TextUtils.isEmpty(n.extras.getCharSequence("android.text"))) {
                ++this.numWithText;
            }
            if (names.contains("android.subText") && !TextUtils.isEmpty(n.extras.getCharSequence("android.subText"))) {
                ++this.numWithSubText;
            }
            if (names.contains("android.infoText") && !TextUtils.isEmpty(n.extras.getCharSequence("android.infoText"))) {
                ++this.numWithInfoText;
            }
        }

        public void emit() {
            AggregatedStats previous = this.getPrevious();
            this.maybeCount("note_enqueued", this.numEnqueuedByApp - previous.numEnqueuedByApp);
            this.maybeCount("note_post", this.numPostedByApp - previous.numPostedByApp);
            this.maybeCount("note_update", this.numUpdatedByApp - previous.numUpdatedByApp);
            this.maybeCount("note_remove", this.numRemovedByApp - previous.numRemovedByApp);
            this.maybeCount("note_with_people", this.numWithValidPeople - previous.numWithValidPeople);
            this.maybeCount("note_with_stars", this.numWithStaredPeople - previous.numWithStaredPeople);
            this.maybeCount("people_cache_hit", this.numPeopleCacheHit - previous.numPeopleCacheHit);
            this.maybeCount("people_cache_miss", this.numPeopleCacheMiss - previous.numPeopleCacheMiss);
            this.maybeCount("note_blocked", this.numBlocked - previous.numBlocked);
            this.maybeCount("note_suspended", this.numSuspendedByAdmin - previous.numSuspendedByAdmin);
            this.maybeCount("note_with_actions", this.numWithActions - previous.numWithActions);
            this.maybeCount("note_private", this.numPrivate - previous.numPrivate);
            this.maybeCount("note_secret", this.numSecret - previous.numSecret);
            this.maybeCount("note_interupt", this.numInterrupt - previous.numInterrupt);
            this.maybeCount("note_big_text", this.numWithBigText - previous.numWithBigText);
            this.maybeCount("note_big_pic", this.numWithBigPicture - previous.numWithBigPicture);
            this.maybeCount("note_fg", this.numForegroundService - previous.numForegroundService);
            this.maybeCount("note_ongoing", this.numOngoing - previous.numOngoing);
            this.maybeCount("note_auto", this.numAutoCancel - previous.numAutoCancel);
            this.maybeCount("note_large_icon", this.numWithLargeIcon - previous.numWithLargeIcon);
            this.maybeCount("note_inbox", this.numWithInbox - previous.numWithInbox);
            this.maybeCount("note_media", this.numWithMediaSession - previous.numWithMediaSession);
            this.maybeCount("note_title", this.numWithTitle - previous.numWithTitle);
            this.maybeCount("note_text", this.numWithText - previous.numWithText);
            this.maybeCount("note_sub_text", this.numWithSubText - previous.numWithSubText);
            this.maybeCount("note_info_text", this.numWithInfoText - previous.numWithInfoText);
            this.maybeCount("note_over_rate", this.numRateViolations - previous.numRateViolations);
            this.maybeCount("note_over_quota", this.numQuotaViolations - previous.numQuotaViolations);
            this.noisyImportance.maybeCount(previous.noisyImportance);
            this.quietImportance.maybeCount(previous.quietImportance);
            this.finalImportance.maybeCount(previous.finalImportance);
            previous.numEnqueuedByApp = this.numEnqueuedByApp;
            previous.numPostedByApp = this.numPostedByApp;
            previous.numUpdatedByApp = this.numUpdatedByApp;
            previous.numRemovedByApp = this.numRemovedByApp;
            previous.numPeopleCacheHit = this.numPeopleCacheHit;
            previous.numPeopleCacheMiss = this.numPeopleCacheMiss;
            previous.numWithStaredPeople = this.numWithStaredPeople;
            previous.numWithValidPeople = this.numWithValidPeople;
            previous.numBlocked = this.numBlocked;
            previous.numSuspendedByAdmin = this.numSuspendedByAdmin;
            previous.numWithActions = this.numWithActions;
            previous.numPrivate = this.numPrivate;
            previous.numSecret = this.numSecret;
            previous.numInterrupt = this.numInterrupt;
            previous.numWithBigText = this.numWithBigText;
            previous.numWithBigPicture = this.numWithBigPicture;
            previous.numForegroundService = this.numForegroundService;
            previous.numOngoing = this.numOngoing;
            previous.numAutoCancel = this.numAutoCancel;
            previous.numWithLargeIcon = this.numWithLargeIcon;
            previous.numWithInbox = this.numWithInbox;
            previous.numWithMediaSession = this.numWithMediaSession;
            previous.numWithTitle = this.numWithTitle;
            previous.numWithText = this.numWithText;
            previous.numWithSubText = this.numWithSubText;
            previous.numWithInfoText = this.numWithInfoText;
            previous.numRateViolations = this.numRateViolations;
            previous.numQuotaViolations = this.numQuotaViolations;
            this.noisyImportance.update(previous.noisyImportance);
            this.quietImportance.update(previous.quietImportance);
            this.finalImportance.update(previous.finalImportance);
        }

        void maybeCount(String name, int value) {
            if (value > 0) {
                MetricsLogger.count(this.mContext, name, value);
            }
        }

        public void dump(PrintWriter pw, String indent) {
            pw.println(this.toStringWithIndent(indent));
        }

        public String toString() {
            return this.toStringWithIndent("");
        }

        public float getEnqueueRate() {
            return this.getEnqueueRate(SystemClock.elapsedRealtime());
        }

        public float getEnqueueRate(long now) {
            return this.enqueueRate.getRate(now);
        }

        public void updateInterarrivalEstimate(long now) {
            this.enqueueRate.update(now);
        }

        private String toStringWithIndent(String indent) {
            StringBuilder output = new StringBuilder();
            output.append(indent).append("AggregatedStats{\n");
            String indentPlusTwo = indent + "  ";
            output.append(indentPlusTwo);
            output.append("key='").append(this.key).append("',\n");
            output.append(indentPlusTwo);
            output.append("numEnqueuedByApp=").append(this.numEnqueuedByApp).append(",\n");
            output.append(indentPlusTwo);
            output.append("numPostedByApp=").append(this.numPostedByApp).append(",\n");
            output.append(indentPlusTwo);
            output.append("numUpdatedByApp=").append(this.numUpdatedByApp).append(",\n");
            output.append(indentPlusTwo);
            output.append("numRemovedByApp=").append(this.numRemovedByApp).append(",\n");
            output.append(indentPlusTwo);
            output.append("numPeopleCacheHit=").append(this.numPeopleCacheHit).append(",\n");
            output.append(indentPlusTwo);
            output.append("numWithStaredPeople=").append(this.numWithStaredPeople).append(",\n");
            output.append(indentPlusTwo);
            output.append("numWithValidPeople=").append(this.numWithValidPeople).append(",\n");
            output.append(indentPlusTwo);
            output.append("numPeopleCacheMiss=").append(this.numPeopleCacheMiss).append(",\n");
            output.append(indentPlusTwo);
            output.append("numBlocked=").append(this.numBlocked).append(",\n");
            output.append(indentPlusTwo);
            output.append("numSuspendedByAdmin=").append(this.numSuspendedByAdmin).append(",\n");
            output.append(indentPlusTwo);
            output.append("numWithActions=").append(this.numWithActions).append(",\n");
            output.append(indentPlusTwo);
            output.append("numPrivate=").append(this.numPrivate).append(",\n");
            output.append(indentPlusTwo);
            output.append("numSecret=").append(this.numSecret).append(",\n");
            output.append(indentPlusTwo);
            output.append("numInterrupt=").append(this.numInterrupt).append(",\n");
            output.append(indentPlusTwo);
            output.append("numWithBigText=").append(this.numWithBigText).append(",\n");
            output.append(indentPlusTwo);
            output.append("numWithBigPicture=").append(this.numWithBigPicture).append("\n");
            output.append(indentPlusTwo);
            output.append("numForegroundService=").append(this.numForegroundService).append("\n");
            output.append(indentPlusTwo);
            output.append("numOngoing=").append(this.numOngoing).append("\n");
            output.append(indentPlusTwo);
            output.append("numAutoCancel=").append(this.numAutoCancel).append("\n");
            output.append(indentPlusTwo);
            output.append("numWithLargeIcon=").append(this.numWithLargeIcon).append("\n");
            output.append(indentPlusTwo);
            output.append("numWithInbox=").append(this.numWithInbox).append("\n");
            output.append(indentPlusTwo);
            output.append("numWithMediaSession=").append(this.numWithMediaSession).append("\n");
            output.append(indentPlusTwo);
            output.append("numWithTitle=").append(this.numWithTitle).append("\n");
            output.append(indentPlusTwo);
            output.append("numWithText=").append(this.numWithText).append("\n");
            output.append(indentPlusTwo);
            output.append("numWithSubText=").append(this.numWithSubText).append("\n");
            output.append(indentPlusTwo);
            output.append("numWithInfoText=").append(this.numWithInfoText).append("\n");
            output.append("numRateViolations=").append(this.numRateViolations).append("\n");
            output.append("numQuotaViolations=").append(this.numQuotaViolations).append("\n");
            output.append(indentPlusTwo).append(this.noisyImportance.toString()).append("\n");
            output.append(indentPlusTwo).append(this.quietImportance.toString()).append("\n");
            output.append(indentPlusTwo).append(this.finalImportance.toString()).append("\n");
            output.append(indent).append("}");
            return output.toString();
        }

        public JSONObject dumpJson() throws JSONException {
            AggregatedStats previous = this.getPrevious();
            JSONObject dump = new JSONObject();
            dump.put("key", this.key);
            dump.put("duration", SystemClock.elapsedRealtime() - this.mCreated);
            this.maybePut(dump, "numEnqueuedByApp", this.numEnqueuedByApp);
            this.maybePut(dump, "numPostedByApp", this.numPostedByApp);
            this.maybePut(dump, "numUpdatedByApp", this.numUpdatedByApp);
            this.maybePut(dump, "numRemovedByApp", this.numRemovedByApp);
            this.maybePut(dump, "numPeopleCacheHit", this.numPeopleCacheHit);
            this.maybePut(dump, "numPeopleCacheMiss", this.numPeopleCacheMiss);
            this.maybePut(dump, "numWithStaredPeople", this.numWithStaredPeople);
            this.maybePut(dump, "numWithValidPeople", this.numWithValidPeople);
            this.maybePut(dump, "numBlocked", this.numBlocked);
            this.maybePut(dump, "numSuspendedByAdmin", this.numSuspendedByAdmin);
            this.maybePut(dump, "numWithActions", this.numWithActions);
            this.maybePut(dump, "numPrivate", this.numPrivate);
            this.maybePut(dump, "numSecret", this.numSecret);
            this.maybePut(dump, "numInterrupt", this.numInterrupt);
            this.maybePut(dump, "numWithBigText", this.numWithBigText);
            this.maybePut(dump, "numWithBigPicture", this.numWithBigPicture);
            this.maybePut(dump, "numForegroundService", this.numForegroundService);
            this.maybePut(dump, "numOngoing", this.numOngoing);
            this.maybePut(dump, "numAutoCancel", this.numAutoCancel);
            this.maybePut(dump, "numWithLargeIcon", this.numWithLargeIcon);
            this.maybePut(dump, "numWithInbox", this.numWithInbox);
            this.maybePut(dump, "numWithMediaSession", this.numWithMediaSession);
            this.maybePut(dump, "numWithTitle", this.numWithTitle);
            this.maybePut(dump, "numWithText", this.numWithText);
            this.maybePut(dump, "numWithSubText", this.numWithSubText);
            this.maybePut(dump, "numWithInfoText", this.numWithInfoText);
            this.maybePut(dump, "numRateViolations", this.numRateViolations);
            this.maybePut(dump, "numQuotaLViolations", this.numQuotaViolations);
            this.maybePut(dump, "notificationEnqueueRate", this.getEnqueueRate());
            this.noisyImportance.maybePut(dump, previous.noisyImportance);
            this.quietImportance.maybePut(dump, previous.quietImportance);
            this.finalImportance.maybePut(dump, previous.finalImportance);
            return dump;
        }

        private void maybePut(JSONObject dump, String name, int value) throws JSONException {
            if (value > 0) {
                dump.put(name, value);
            }
        }

        private void maybePut(JSONObject dump, String name, float value) throws JSONException {
            if ((double)value > 0.0) {
                dump.put(name, value);
            }
        }
    }
}

