/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.om;

import android.content.om.IOverlayManager;
import android.content.om.OverlayInfo;
import android.os.RemoteException;
import android.os.ShellCommand;
import android.os.UserHandle;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

final class OverlayManagerShellCommand
extends ShellCommand {
    private final IOverlayManager mInterface;

    OverlayManagerShellCommand(IOverlayManager iom) {
        this.mInterface = iom;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter err = this.getErrPrintWriter();
        try {
            switch (cmd) {
                case "list": {
                    return this.runList();
                }
                case "enable": {
                    return this.runEnableDisable(true);
                }
                case "disable": {
                    return this.runEnableDisable(false);
                }
                case "set-priority": {
                    return this.runSetPriority();
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (IllegalArgumentException e) {
            err.println("Error: " + e.getMessage());
        }
        catch (RemoteException e) {
            err.println("Remote exception: " + e);
        }
        return -1;
    }

    @Override
    public void onHelp() {
        PrintWriter out = this.getOutPrintWriter();
        out.println("Overlay manager (overlay) commands:");
        out.println("  help");
        out.println("    Print this help text.");
        out.println("  dump [--verbose] [--user USER_ID] [PACKAGE [PACKAGE [...]]]");
        out.println("    Print debugging information about the overlay manager.");
        out.println("  list [--user USER_ID] [PACKAGE [PACKAGE [...]]]");
        out.println("    Print information about target and overlay packages.");
        out.println("    Overlay packages are printed in priority order. With optional");
        out.println("    parameters PACKAGEs, limit output to the specified packages");
        out.println("    but include more information about each package.");
        out.println("  enable [--user USER_ID] PACKAGE");
        out.println("    Enable overlay package PACKAGE.");
        out.println("  disable [--user USER_ID] PACKAGE");
        out.println("    Disable overlay package PACKAGE.");
        out.println("  set-priority [--user USER_ID] PACKAGE PARENT|lowest|highest");
        out.println("    Change the priority of the overlay PACKAGE to be just higher than");
        out.println("    the priority of PACKAGE_PARENT If PARENT is the special keyword");
        out.println("    'lowest', change priority of PACKAGE to the lowest priority.");
        out.println("    If PARENT is the special keyword 'highest', change priority of");
        out.println("    PACKAGE to the highest priority.");
    }

    private int runList() throws RemoteException {
        String opt;
        PrintWriter out = this.getOutPrintWriter();
        PrintWriter err = this.getErrPrintWriter();
        int userId = 0;
        block10: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "--user": {
                    userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue block10;
                }
            }
            err.println("Error: Unknown option: " + opt);
            return 1;
        }
        Map allOverlays = this.mInterface.getAllOverlays(userId);
        for (String targetPackageName : allOverlays.keySet()) {
            out.println(targetPackageName);
            List overlaysForTarget = (List)allOverlays.get(targetPackageName);
            int N = overlaysForTarget.size();
            for (int i = 0; i < N; ++i) {
                String status;
                OverlayInfo oi = (OverlayInfo)overlaysForTarget.get(i);
                switch (oi.state) {
                    case 3: {
                        status = "[x]";
                        break;
                    }
                    case 2: {
                        status = "[ ]";
                        break;
                    }
                    default: {
                        status = "---";
                    }
                }
                out.println(String.format("%s %s", status, oi.packageName));
            }
            out.println();
        }
        return 0;
    }

    private int runEnableDisable(boolean enable) throws RemoteException {
        String opt;
        PrintWriter err = this.getErrPrintWriter();
        int userId = 0;
        block6: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "--user": {
                    userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue block6;
                }
            }
            err.println("Error: Unknown option: " + opt);
            return 1;
        }
        String packageName = this.getNextArgRequired();
        return this.mInterface.setEnabled(packageName, enable, userId) ? 0 : 1;
    }

    private int runSetPriority() throws RemoteException {
        String opt;
        PrintWriter err = this.getErrPrintWriter();
        int userId = 0;
        block6: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "--user": {
                    userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue block6;
                }
            }
            err.println("Error: Unknown option: " + opt);
            return 1;
        }
        String packageName = this.getNextArgRequired();
        String newParentPackageName = this.getNextArgRequired();
        if ("highest".equals(newParentPackageName)) {
            return this.mInterface.setHighestPriority(packageName, userId) ? 0 : 1;
        }
        if ("lowest".equals(newParentPackageName)) {
            return this.mInterface.setLowestPriority(packageName, userId) ? 0 : 1;
        }
        return this.mInterface.setPriority(packageName, newParentPackageName, userId) ? 0 : 1;
    }
}

