/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.annotation.IntDef;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.SystemSensorManager;
import android.hardware.display.DisplayManagerInternal;
import android.metrics.LogMaker;
import android.net.Uri;
import android.os.BatteryManagerInternal;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.PowerSaveState;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.service.dreams.DreamManagerInternal;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.util.EventLog;
import android.util.KeyValueListParser;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.WindowManagerPolicy;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.internal.hardware.AmbientDisplayConfiguration;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.server.EventLogTags;
import com.android.server.LockGuard;
import com.android.server.RescueParty;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import com.android.server.UiThread;
import com.android.server.Watchdog;
import com.android.server.am.BatteryStatsService;
import com.android.server.lights.Light;
import com.android.server.lights.LightsManager;
import com.android.server.power.BatterySaverPolicy;
import com.android.server.power.Notifier;
import com.android.server.power.PowerManagerShellCommand;
import com.android.server.power.ShutdownThread;
import com.android.server.power.SuspendBlocker;
import com.android.server.power.WirelessChargerDetector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.util.Objects;

public final class PowerManagerService
extends SystemService
implements Watchdog.Monitor {
    private static final String TAG = "PowerManagerService";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_SPEW = false;
    private static final int MSG_USER_ACTIVITY_TIMEOUT = 1;
    private static final int MSG_SANDMAN = 2;
    private static final int MSG_SCREEN_BRIGHTNESS_BOOST_TIMEOUT = 3;
    private static final int MSG_CHECK_FOR_LONG_WAKELOCKS = 4;
    private static final int DIRTY_WAKE_LOCKS = 1;
    private static final int DIRTY_WAKEFULNESS = 2;
    private static final int DIRTY_USER_ACTIVITY = 4;
    private static final int DIRTY_ACTUAL_DISPLAY_POWER_STATE_UPDATED = 8;
    private static final int DIRTY_BOOT_COMPLETED = 16;
    private static final int DIRTY_SETTINGS = 32;
    private static final int DIRTY_IS_POWERED = 64;
    private static final int DIRTY_STAY_ON = 128;
    private static final int DIRTY_BATTERY_STATE = 256;
    private static final int DIRTY_PROXIMITY_POSITIVE = 512;
    private static final int DIRTY_DOCK_STATE = 1024;
    private static final int DIRTY_SCREEN_BRIGHTNESS_BOOST = 2048;
    private static final int DIRTY_QUIESCENT = 4096;
    private static final int DIRTY_VR_MODE_CHANGED = 8192;
    private static final int WAKE_LOCK_CPU = 1;
    private static final int WAKE_LOCK_SCREEN_BRIGHT = 2;
    private static final int WAKE_LOCK_SCREEN_DIM = 4;
    private static final int WAKE_LOCK_BUTTON_BRIGHT = 8;
    private static final int WAKE_LOCK_PROXIMITY_SCREEN_OFF = 16;
    private static final int WAKE_LOCK_STAY_AWAKE = 32;
    private static final int WAKE_LOCK_DOZE = 64;
    private static final int WAKE_LOCK_DRAW = 128;
    private static final int USER_ACTIVITY_SCREEN_BRIGHT = 1;
    private static final int USER_ACTIVITY_SCREEN_DIM = 2;
    private static final int USER_ACTIVITY_SCREEN_DREAM = 4;
    private static final int DEFAULT_SCREEN_OFF_TIMEOUT = 15000;
    private static final int DEFAULT_SLEEP_TIMEOUT = -1;
    private static final int SCREEN_BRIGHTNESS_BOOST_TIMEOUT = 5000;
    static final long MIN_LONG_WAKE_CHECK_INTERVAL = 60000L;
    private static final int POWER_FEATURE_DOUBLE_TAP_TO_WAKE = 1;
    private static final int DEFAULT_DOUBLE_TAP_TO_WAKE = 0;
    private static final String SYSTEM_PROPERTY_QUIESCENT = "ro.boot.quiescent";
    private static final String REASON_SHUTDOWN = "shutdown";
    private static final String REASON_REBOOT = "reboot";
    private static final String REASON_USERREQUESTED = "userrequested";
    private static final String REASON_THERMAL_SHUTDOWN = "thermal-shutdown";
    private static final String TRACE_SCREEN_ON = "Screen turning on";
    private static final int SCREEN_ON_LATENCY_WARNING_MS = 200;
    private static final int HALT_MODE_SHUTDOWN = 0;
    private static final int HALT_MODE_REBOOT = 1;
    private static final int HALT_MODE_REBOOT_SAFE_MODE = 2;
    private static final String LAST_REBOOT_LOCATION = "/data/misc/reboot/last_reboot_reason";
    private final Context mContext;
    private final ServiceThread mHandlerThread;
    private final PowerManagerHandler mHandler;
    private final AmbientDisplayConfiguration mAmbientDisplayConfiguration;
    private final BatterySaverPolicy mBatterySaverPolicy;
    private LightsManager mLightsManager;
    private BatteryManagerInternal mBatteryManagerInternal;
    private DisplayManagerInternal mDisplayManagerInternal;
    private IBatteryStats mBatteryStats;
    private IAppOpsService mAppOps;
    private WindowManagerPolicy mPolicy;
    private Notifier mNotifier;
    private WirelessChargerDetector mWirelessChargerDetector;
    private SettingsObserver mSettingsObserver;
    private DreamManagerInternal mDreamManager;
    private Light mAttentionLight;
    private final Object mLock = LockGuard.installNewLock(1);
    private int mDirty;
    private int mWakefulness;
    private boolean mWakefulnessChanging;
    private boolean mSandmanSummoned;
    private boolean mSandmanScheduled;
    private final ArrayList<SuspendBlocker> mSuspendBlockers = new ArrayList();
    private final ArrayList<WakeLock> mWakeLocks = new ArrayList();
    private int mWakeLockSummary;
    private long mNotifyLongScheduled;
    private long mNotifyLongDispatched;
    private long mNotifyLongNextCheck;
    private boolean mRequestWaitForNegativeProximity;
    private long mLastWakeTime;
    private long mLastSleepTime;
    private long mLastUserActivityTime;
    private long mLastUserActivityTimeNoChangeLights;
    private long mLastInteractivePowerHintTime;
    private long mLastScreenBrightnessBoostTime;
    private boolean mScreenBrightnessBoostInProgress;
    private int mUserActivitySummary;
    private final DisplayManagerInternal.DisplayPowerRequest mDisplayPowerRequest = new DisplayManagerInternal.DisplayPowerRequest();
    private boolean mDisplayReady;
    private final SuspendBlocker mWakeLockSuspendBlocker;
    private boolean mHoldingWakeLockSuspendBlocker;
    private final SuspendBlocker mDisplaySuspendBlocker;
    private boolean mHoldingDisplaySuspendBlocker;
    private boolean mSystemReady;
    private boolean mBootCompleted;
    private Runnable[] mBootCompletedRunnables;
    private boolean mHalAutoSuspendModeEnabled;
    private boolean mHalInteractiveModeEnabled;
    private boolean mIsPowered;
    private int mPlugType;
    private int mBatteryLevel;
    private int mBatteryLevelWhenDreamStarted;
    private int mDockState = 0;
    private boolean mDecoupleHalAutoSuspendModeFromDisplayConfig;
    private boolean mDecoupleHalInteractiveModeFromDisplayConfig;
    private boolean mWakeUpWhenPluggedOrUnpluggedConfig;
    private boolean mWakeUpWhenPluggedOrUnpluggedInTheaterModeConfig;
    private boolean mSuspendWhenScreenOffDueToProximityConfig;
    private boolean mDreamsSupportedConfig;
    private boolean mDreamsEnabledByDefaultConfig;
    private boolean mDreamsActivatedOnSleepByDefaultConfig;
    private boolean mDreamsActivatedOnDockByDefaultConfig;
    private boolean mDreamsEnabledOnBatteryConfig;
    private int mDreamsBatteryLevelMinimumWhenPoweredConfig;
    private int mDreamsBatteryLevelMinimumWhenNotPoweredConfig;
    private int mDreamsBatteryLevelDrainCutoffConfig;
    private boolean mDreamsEnabledSetting;
    private boolean mDreamsActivateOnSleepSetting;
    private boolean mDreamsActivateOnDockSetting;
    private boolean mDozeAfterScreenOffConfig;
    private int mMinimumScreenOffTimeoutConfig;
    private int mMaximumScreenDimDurationConfig;
    private float mMaximumScreenDimRatioConfig;
    private boolean mSupportsDoubleTapWakeConfig;
    private int mScreenOffTimeoutSetting;
    private int mSleepTimeoutSetting;
    private int mMaximumScreenOffTimeoutFromDeviceAdmin = Integer.MAX_VALUE;
    private int mStayOnWhilePluggedInSetting;
    private boolean mStayOn;
    private static boolean sQuiescent;
    private boolean mProximityPositive;
    private int mScreenBrightnessSettingMinimum;
    private int mScreenBrightnessSettingMaximum;
    private int mScreenBrightnessSettingDefault;
    private int mScreenBrightnessForVrSettingDefault;
    private int mScreenBrightnessSetting;
    private int mScreenBrightnessForVrSetting;
    private float mScreenAutoBrightnessAdjustmentSetting;
    private int mScreenBrightnessModeSetting;
    private int mScreenBrightnessOverrideFromWindowManager = -1;
    private boolean mUserInactiveOverrideFromWindowManager;
    private long mOverriddenTimeout = -1L;
    private long mUserActivityTimeoutOverrideFromWindowManager = -1L;
    private int mTemporaryScreenBrightnessSettingOverride = -1;
    private float mTemporaryScreenAutoBrightnessAdjustmentSettingOverride = Float.NaN;
    private int mDozeScreenStateOverrideFromDreamManager = 0;
    private int mDozeScreenBrightnessOverrideFromDreamManager = -1;
    private long mLastWarningAboutUserActivityPermission = Long.MIN_VALUE;
    private boolean mLowPowerModeEnabled;
    private boolean mLowPowerModeSetting;
    private boolean mAutoLowPowerModeConfigured;
    private boolean mAutoLowPowerModeSnoozing;
    private boolean mBatteryLevelLow;
    private boolean mDeviceIdleMode;
    private boolean mLightDeviceIdleMode;
    int[] mDeviceIdleWhitelist = new int[0];
    int[] mDeviceIdleTempWhitelist = new int[0];
    private final SparseArray<UidState> mUidState = new SparseArray();
    private boolean mUidsChanging;
    private boolean mUidsChanged;
    private boolean mTheaterModeEnabled;
    private boolean mAlwaysOnEnabled;
    private boolean mDoubleTapWakeEnabled;
    private final ArrayList<PowerManagerInternal.LowPowerModeListener> mLowPowerModeListeners = new ArrayList();
    private boolean mIsVrModeEnabled;
    final Constants mConstants;
    private final DisplayManagerInternal.DisplayPowerCallbacks mDisplayPowerCallbacks = new DisplayManagerInternal.DisplayPowerCallbacks(){
        private int mDisplayState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStateChanged() {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.mDirty = PowerManagerService.this.mDirty | 8;
                PowerManagerService.this.updatePowerStateLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProximityPositive() {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.mProximityPositive = true;
                PowerManagerService.this.mDirty = PowerManagerService.this.mDirty | 0x200;
                PowerManagerService.this.updatePowerStateLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProximityNegative() {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.mProximityPositive = false;
                PowerManagerService.this.mDirty = PowerManagerService.this.mDirty | 0x200;
                PowerManagerService.this.userActivityNoUpdateLocked(SystemClock.uptimeMillis(), 0, 0, 1000);
                PowerManagerService.this.updatePowerStateLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayStateChange(int state) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                if (this.mDisplayState != state) {
                    this.mDisplayState = state;
                    if (state == 1) {
                        if (!PowerManagerService.this.mDecoupleHalInteractiveModeFromDisplayConfig) {
                            PowerManagerService.this.setHalInteractiveModeLocked(false);
                        }
                        if (!PowerManagerService.this.mDecoupleHalAutoSuspendModeFromDisplayConfig) {
                            PowerManagerService.this.setHalAutoSuspendModeLocked(true);
                        }
                    } else {
                        if (!PowerManagerService.this.mDecoupleHalAutoSuspendModeFromDisplayConfig) {
                            PowerManagerService.this.setHalAutoSuspendModeLocked(false);
                        }
                        if (!PowerManagerService.this.mDecoupleHalInteractiveModeFromDisplayConfig) {
                            PowerManagerService.this.setHalInteractiveModeLocked(true);
                        }
                    }
                }
            }
        }

        @Override
        public void acquireSuspendBlocker() {
            PowerManagerService.this.mDisplaySuspendBlocker.acquire();
        }

        @Override
        public void releaseSuspendBlocker() {
            PowerManagerService.this.mDisplaySuspendBlocker.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            2 var1_1 = this;
            synchronized (var1_1) {
                return "state=" + Display.stateToString(this.mDisplayState);
            }
        }
    };
    private final IVrStateCallbacks mVrStateCallbacks = new IVrStateCallbacks.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVrStateChanged(boolean enabled) {
            PowerManagerService.this.powerHintInternal(7, enabled ? 1 : 0);
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                if (PowerManagerService.this.mIsVrModeEnabled != enabled) {
                    PowerManagerService.this.mIsVrModeEnabled = enabled;
                    PowerManagerService.this.mDirty = PowerManagerService.this.mDirty | 0x2000;
                    PowerManagerService.this.updatePowerStateLocked();
                }
            }
        }
    };

    private native void nativeInit();

    private static native void nativeAcquireSuspendBlocker(String var0);

    private static native void nativeReleaseSuspendBlocker(String var0);

    private static native void nativeSetInteractive(boolean var0);

    private static native void nativeSetAutoSuspend(boolean var0);

    private static native void nativeSendPowerHint(int var0, int var1);

    private static native void nativeSetFeature(int var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerManagerService(Context context) {
        super(context);
        this.mContext = context;
        this.mHandlerThread = new ServiceThread(TAG, -4, false);
        this.mHandlerThread.start();
        this.mHandler = new PowerManagerHandler(this.mHandlerThread.getLooper());
        this.mConstants = new Constants(this.mHandler);
        this.mAmbientDisplayConfiguration = new AmbientDisplayConfiguration(this.mContext);
        this.mBatterySaverPolicy = new BatterySaverPolicy(this.mHandler);
        Object object = this.mLock;
        synchronized (object) {
            this.mWakeLockSuspendBlocker = this.createSuspendBlockerLocked("PowerManagerService.WakeLocks");
            this.mDisplaySuspendBlocker = this.createSuspendBlockerLocked("PowerManagerService.Display");
            this.mDisplaySuspendBlocker.acquire();
            this.mHoldingDisplaySuspendBlocker = true;
            this.mHalAutoSuspendModeEnabled = false;
            this.mHalInteractiveModeEnabled = true;
            this.mWakefulness = 1;
            sQuiescent = SystemProperties.get(SYSTEM_PROPERTY_QUIESCENT, "0").equals("1");
            this.nativeInit();
            PowerManagerService.nativeSetAutoSuspend(false);
            PowerManagerService.nativeSetInteractive(true);
            PowerManagerService.nativeSetFeature(1, 0);
        }
    }

    PowerManagerService(Context context, BatterySaverPolicy batterySaverPolicy) {
        super(context);
        this.mBatterySaverPolicy = batterySaverPolicy;
        this.mContext = context;
        this.mHandlerThread = new ServiceThread(TAG, -4, false);
        this.mHandlerThread.start();
        this.mHandler = new PowerManagerHandler(this.mHandlerThread.getLooper());
        this.mConstants = new Constants(this.mHandler);
        this.mAmbientDisplayConfiguration = new AmbientDisplayConfiguration(this.mContext);
        this.mDisplaySuspendBlocker = null;
        this.mWakeLockSuspendBlocker = null;
    }

    @Override
    public void onStart() {
        this.publishBinderService("power", new BinderService());
        this.publishLocalService(PowerManagerInternal.class, new LocalService());
        Watchdog.getInstance().addMonitor(this);
        Watchdog.getInstance().addThread(this.mHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        Object object = this.mLock;
        synchronized (object) {
            if (phase == 600) {
                this.incrementBootCount();
            } else if (phase == 1000) {
                long now = SystemClock.uptimeMillis();
                this.mBootCompleted = true;
                this.mDirty |= 0x10;
                this.userActivityNoUpdateLocked(now, 0, 0, 1000);
                this.updatePowerStateLocked();
                if (!ArrayUtils.isEmpty(this.mBootCompletedRunnables)) {
                    Slog.d(TAG, "Posting " + this.mBootCompletedRunnables.length + " delayed runnables");
                    for (Runnable r : this.mBootCompletedRunnables) {
                        BackgroundThread.getHandler().post(r);
                    }
                }
                this.mBootCompletedRunnables = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(IAppOpsService appOps) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemReady = true;
            this.mAppOps = appOps;
            this.mDreamManager = this.getLocalService(DreamManagerInternal.class);
            this.mDisplayManagerInternal = this.getLocalService(DisplayManagerInternal.class);
            this.mPolicy = this.getLocalService(WindowManagerPolicy.class);
            this.mBatteryManagerInternal = this.getLocalService(BatteryManagerInternal.class);
            PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
            this.mScreenBrightnessSettingMinimum = pm.getMinimumScreenBrightnessSetting();
            this.mScreenBrightnessSettingMaximum = pm.getMaximumScreenBrightnessSetting();
            this.mScreenBrightnessSettingDefault = pm.getDefaultScreenBrightnessSetting();
            this.mScreenBrightnessForVrSettingDefault = pm.getDefaultScreenBrightnessForVrSetting();
            SystemSensorManager sensorManager = new SystemSensorManager(this.mContext, this.mHandler.getLooper());
            this.mBatteryStats = BatteryStatsService.getService();
            this.mNotifier = new Notifier(Looper.getMainLooper(), this.mContext, this.mBatteryStats, this.mAppOps, this.createSuspendBlockerLocked("PowerManagerService.Broadcasts"), this.mPolicy);
            this.mWirelessChargerDetector = new WirelessChargerDetector(sensorManager, this.createSuspendBlockerLocked("PowerManagerService.WirelessChargerDetector"), this.mHandler);
            this.mSettingsObserver = new SettingsObserver(this.mHandler);
            this.mLightsManager = this.getLocalService(LightsManager.class);
            this.mAttentionLight = this.mLightsManager.getLight(5);
            this.mDisplayManagerInternal.initPowerManagement(this.mDisplayPowerCallbacks, this.mHandler, sensorManager);
            this.readConfigurationLocked();
            this.updateSettingsLocked();
            this.mDirty |= 0x100;
            this.updatePowerStateLocked();
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        this.mConstants.start(resolver);
        this.mBatterySaverPolicy.start(resolver);
        resolver.registerContentObserver(Settings.Secure.getUriFor("screensaver_enabled"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.Secure.getUriFor("screensaver_activate_on_sleep"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.Secure.getUriFor("screensaver_activate_on_dock"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.System.getUriFor("screen_off_timeout"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.Secure.getUriFor("sleep_timeout"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.Global.getUriFor("stay_on_while_plugged_in"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.System.getUriFor("screen_brightness"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.System.getUriFor("screen_brightness_for_vr"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.System.getUriFor("screen_brightness_mode"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.System.getUriFor("screen_auto_brightness_adj"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.Global.getUriFor("low_power"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.Global.getUriFor("low_power_trigger_level"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.Global.getUriFor("theater_mode_on"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.Secure.getUriFor("doze_always_on"), false, this.mSettingsObserver, -1);
        resolver.registerContentObserver(Settings.Secure.getUriFor("double_tap_to_wake"), false, this.mSettingsObserver, -1);
        IVrManager vrManager = (IVrManager)((Object)this.getBinderService("vrmanager"));
        if (vrManager != null) {
            try {
                vrManager.registerListener(this.mVrStateCallbacks);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to register VR mode state listener: " + e);
            }
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BATTERY_CHANGED");
        filter.setPriority(1000);
        this.mContext.registerReceiver(new BatteryReceiver(), filter, null, this.mHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.DREAMING_STARTED");
        filter.addAction("android.intent.action.DREAMING_STOPPED");
        this.mContext.registerReceiver(new DreamReceiver(), filter, null, this.mHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_SWITCHED");
        this.mContext.registerReceiver(new UserSwitchedReceiver(), filter, null, this.mHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.DOCK_EVENT");
        this.mContext.registerReceiver(new DockReceiver(), filter, null, this.mHandler);
    }

    private void readConfigurationLocked() {
        Resources resources = this.mContext.getResources();
        this.mDecoupleHalAutoSuspendModeFromDisplayConfig = resources.getBoolean(17956982);
        this.mDecoupleHalInteractiveModeFromDisplayConfig = resources.getBoolean(17956983);
        this.mWakeUpWhenPluggedOrUnpluggedConfig = resources.getBoolean(17957027);
        this.mWakeUpWhenPluggedOrUnpluggedInTheaterModeConfig = resources.getBoolean(17956884);
        this.mSuspendWhenScreenOffDueToProximityConfig = resources.getBoolean(17957020);
        this.mDreamsSupportedConfig = resources.getBoolean(17956933);
        this.mDreamsEnabledByDefaultConfig = resources.getBoolean(17956931);
        this.mDreamsActivatedOnSleepByDefaultConfig = resources.getBoolean(17956930);
        this.mDreamsActivatedOnDockByDefaultConfig = resources.getBoolean(17956929);
        this.mDreamsEnabledOnBatteryConfig = resources.getBoolean(17956932);
        this.mDreamsBatteryLevelMinimumWhenPoweredConfig = resources.getInteger(17694781);
        this.mDreamsBatteryLevelMinimumWhenNotPoweredConfig = resources.getInteger(17694780);
        this.mDreamsBatteryLevelDrainCutoffConfig = resources.getInteger(17694779);
        this.mDozeAfterScreenOffConfig = resources.getBoolean(17956927);
        this.mMinimumScreenOffTimeoutConfig = resources.getInteger(17694809);
        this.mMaximumScreenDimDurationConfig = resources.getInteger(17694807);
        this.mMaximumScreenDimRatioConfig = resources.getFraction(18022402, 1, 1);
        this.mSupportsDoubleTapWakeConfig = resources.getBoolean(17957011);
    }

    private void updateSettingsLocked() {
        boolean autoLowPowerModeConfigured;
        ContentResolver resolver = this.mContext.getContentResolver();
        this.mDreamsEnabledSetting = Settings.Secure.getIntForUser(resolver, "screensaver_enabled", this.mDreamsEnabledByDefaultConfig ? 1 : 0, -2) != 0;
        this.mDreamsActivateOnSleepSetting = Settings.Secure.getIntForUser(resolver, "screensaver_activate_on_sleep", this.mDreamsActivatedOnSleepByDefaultConfig ? 1 : 0, -2) != 0;
        this.mDreamsActivateOnDockSetting = Settings.Secure.getIntForUser(resolver, "screensaver_activate_on_dock", this.mDreamsActivatedOnDockByDefaultConfig ? 1 : 0, -2) != 0;
        this.mScreenOffTimeoutSetting = Settings.System.getIntForUser(resolver, "screen_off_timeout", 15000, -2);
        this.mSleepTimeoutSetting = Settings.Secure.getIntForUser(resolver, "sleep_timeout", -1, -2);
        this.mStayOnWhilePluggedInSetting = Settings.Global.getInt(resolver, "stay_on_while_plugged_in", 1);
        this.mTheaterModeEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "theater_mode_on", 0) == 1;
        this.mAlwaysOnEnabled = this.mAmbientDisplayConfiguration.alwaysOnEnabled(-2);
        if (this.mSupportsDoubleTapWakeConfig) {
            boolean doubleTapWakeEnabled;
            boolean bl = doubleTapWakeEnabled = Settings.Secure.getIntForUser(resolver, "double_tap_to_wake", 0, -2) != 0;
            if (doubleTapWakeEnabled != this.mDoubleTapWakeEnabled) {
                this.mDoubleTapWakeEnabled = doubleTapWakeEnabled;
                PowerManagerService.nativeSetFeature(1, this.mDoubleTapWakeEnabled ? 1 : 0);
            }
        }
        int oldScreenBrightnessSetting = this.getCurrentBrightnessSettingLocked();
        this.mScreenBrightnessForVrSetting = Settings.System.getIntForUser(resolver, "screen_brightness_for_vr", this.mScreenBrightnessForVrSettingDefault, -2);
        this.mScreenBrightnessSetting = Settings.System.getIntForUser(resolver, "screen_brightness", this.mScreenBrightnessSettingDefault, -2);
        if (oldScreenBrightnessSetting != this.getCurrentBrightnessSettingLocked()) {
            this.mTemporaryScreenBrightnessSettingOverride = -1;
        }
        float oldScreenAutoBrightnessAdjustmentSetting = this.mScreenAutoBrightnessAdjustmentSetting;
        this.mScreenAutoBrightnessAdjustmentSetting = Settings.System.getFloatForUser(resolver, "screen_auto_brightness_adj", 0.0f, -2);
        if (oldScreenAutoBrightnessAdjustmentSetting != this.mScreenAutoBrightnessAdjustmentSetting) {
            this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride = Float.NaN;
        }
        this.mScreenBrightnessModeSetting = Settings.System.getIntForUser(resolver, "screen_brightness_mode", 0, -2);
        boolean lowPowerModeEnabled = Settings.Global.getInt(resolver, "low_power", 0) != 0;
        boolean bl = autoLowPowerModeConfigured = Settings.Global.getInt(resolver, "low_power_trigger_level", 0) != 0;
        if (lowPowerModeEnabled != this.mLowPowerModeSetting || autoLowPowerModeConfigured != this.mAutoLowPowerModeConfigured) {
            this.mLowPowerModeSetting = lowPowerModeEnabled;
            this.mAutoLowPowerModeConfigured = autoLowPowerModeConfigured;
            this.updateLowPowerModeLocked();
        }
        this.mDirty |= 0x20;
    }

    private int getCurrentBrightnessSettingLocked() {
        return this.mIsVrModeEnabled ? this.mScreenBrightnessForVrSetting : this.mScreenBrightnessSetting;
    }

    private void postAfterBootCompleted(Runnable r) {
        if (this.mBootCompleted) {
            BackgroundThread.getHandler().post(r);
        } else {
            Slog.d(TAG, "Delaying runnable until system is booted");
            this.mBootCompletedRunnables = ArrayUtils.appendElement(Runnable.class, this.mBootCompletedRunnables, r);
        }
    }

    private void updateLowPowerModeLocked() {
        boolean lowPowerModeEnabled;
        if ((this.mIsPowered || !this.mBatteryLevelLow && !this.mBootCompleted) && this.mLowPowerModeSetting) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "low_power", 0);
            this.mLowPowerModeSetting = false;
        }
        boolean autoLowPowerModeEnabled = !this.mIsPowered && this.mAutoLowPowerModeConfigured && !this.mAutoLowPowerModeSnoozing && this.mBatteryLevelLow;
        boolean bl = lowPowerModeEnabled = this.mLowPowerModeSetting || autoLowPowerModeEnabled;
        if (this.mLowPowerModeEnabled != lowPowerModeEnabled) {
            this.mLowPowerModeEnabled = lowPowerModeEnabled;
            this.powerHintInternal(5, lowPowerModeEnabled ? 1 : 0);
            this.postAfterBootCompleted(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList listeners;
                    Intent intent = new Intent("android.os.action.POWER_SAVE_MODE_CHANGING").putExtra("mode", PowerManagerService.this.mLowPowerModeEnabled).addFlags(0x40000000);
                    PowerManagerService.this.mContext.sendBroadcast(intent);
                    Object object = PowerManagerService.this.mLock;
                    synchronized (object) {
                        listeners = new ArrayList(PowerManagerService.this.mLowPowerModeListeners);
                    }
                    for (int i = 0; i < listeners.size(); ++i) {
                        PowerManagerInternal.LowPowerModeListener listener = (PowerManagerInternal.LowPowerModeListener)listeners.get(i);
                        PowerSaveState result = PowerManagerService.this.mBatterySaverPolicy.getBatterySaverPolicy(listener.getServiceType(), lowPowerModeEnabled);
                        listener.onLowPowerModeChanged(result);
                    }
                    intent = new Intent("android.os.action.POWER_SAVE_MODE_CHANGED");
                    intent.addFlags(0x40000000);
                    PowerManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
                    intent = new Intent("android.os.action.POWER_SAVE_MODE_CHANGED_INTERNAL");
                    intent.addFlags(0x40000000);
                    PowerManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.DEVICE_POWER");
                }
            });
        }
    }

    private void handleSettingsChangedLocked() {
        this.updateSettingsLocked();
        this.updatePowerStateLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireWakeLockInternal(IBinder lock, int flags, String tag, String packageName, WorkSource ws, String historyTag, int uid, int pid) {
        Object object = this.mLock;
        synchronized (object) {
            boolean notifyAcquire;
            WakeLock wakeLock;
            int index = this.findWakeLockIndexLocked(lock);
            if (index >= 0) {
                wakeLock = this.mWakeLocks.get(index);
                if (!wakeLock.hasSameProperties(flags, tag, ws, uid, pid)) {
                    this.notifyWakeLockChangingLocked(wakeLock, flags, tag, packageName, uid, pid, ws, historyTag);
                    wakeLock.updateProperties(flags, tag, packageName, ws, historyTag, uid, pid);
                }
                notifyAcquire = false;
            } else {
                UidState state = this.mUidState.get(uid);
                if (state == null) {
                    state = new UidState(uid);
                    state.mProcState = 18;
                    this.mUidState.put(uid, state);
                }
                ++state.mNumWakeLocks;
                wakeLock = new WakeLock(lock, flags, tag, packageName, ws, historyTag, uid, pid, state);
                try {
                    lock.linkToDeath(wakeLock, 0);
                }
                catch (RemoteException ex) {
                    throw new IllegalArgumentException("Wake lock is already dead.");
                }
                this.mWakeLocks.add(wakeLock);
                this.setWakeLockDisabledStateLocked(wakeLock);
                notifyAcquire = true;
            }
            this.applyWakeLockFlagsOnAcquireLocked(wakeLock, uid);
            this.mDirty |= 1;
            this.updatePowerStateLocked();
            if (notifyAcquire) {
                this.notifyWakeLockAcquiredLocked(wakeLock);
            }
        }
    }

    private static boolean isScreenLock(WakeLock wakeLock) {
        switch (wakeLock.mFlags & 0xFFFF) {
            case 6: 
            case 10: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    private void applyWakeLockFlagsOnAcquireLocked(WakeLock wakeLock, int uid) {
        if ((wakeLock.mFlags & 0x10000000) != 0 && PowerManagerService.isScreenLock(wakeLock)) {
            int opUid;
            String opPackageName;
            if (wakeLock.mWorkSource != null && wakeLock.mWorkSource.getName(0) != null) {
                opPackageName = wakeLock.mWorkSource.getName(0);
                opUid = wakeLock.mWorkSource.get(0);
            } else {
                opPackageName = wakeLock.mPackageName;
                opUid = wakeLock.mWorkSource != null ? wakeLock.mWorkSource.get(0) : wakeLock.mOwnerUid;
            }
            this.wakeUpNoUpdateLocked(SystemClock.uptimeMillis(), wakeLock.mTag, opUid, opPackageName, opUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakeLockInternal(IBinder lock, int flags) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findWakeLockIndexLocked(lock);
            if (index < 0) {
                return;
            }
            WakeLock wakeLock = this.mWakeLocks.get(index);
            if ((flags & 1) != 0) {
                this.mRequestWaitForNegativeProximity = true;
            }
            wakeLock.mLock.unlinkToDeath(wakeLock, 0);
            this.removeWakeLockLocked(wakeLock, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWakeLockDeath(WakeLock wakeLock) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mWakeLocks.indexOf(wakeLock);
            if (index < 0) {
                return;
            }
            this.removeWakeLockLocked(wakeLock, index);
        }
    }

    private void removeWakeLockLocked(WakeLock wakeLock, int index) {
        this.mWakeLocks.remove(index);
        UidState state = wakeLock.mUidState;
        --state.mNumWakeLocks;
        if (state.mNumWakeLocks <= 0 && state.mProcState == 18) {
            this.mUidState.remove(state.mUid);
        }
        this.notifyWakeLockReleasedLocked(wakeLock);
        this.applyWakeLockFlagsOnReleaseLocked(wakeLock);
        this.mDirty |= 1;
        this.updatePowerStateLocked();
    }

    private void applyWakeLockFlagsOnReleaseLocked(WakeLock wakeLock) {
        if ((wakeLock.mFlags & 0x20000000) != 0 && PowerManagerService.isScreenLock(wakeLock)) {
            this.userActivityNoUpdateLocked(SystemClock.uptimeMillis(), 0, 1, wakeLock.mOwnerUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWakeLockWorkSourceInternal(IBinder lock, WorkSource ws, String historyTag, int callingUid) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findWakeLockIndexLocked(lock);
            if (index < 0) {
                throw new IllegalArgumentException("Wake lock not active: " + lock + " from uid " + callingUid);
            }
            WakeLock wakeLock = this.mWakeLocks.get(index);
            if (!wakeLock.hasSameWorkSource(ws)) {
                this.notifyWakeLockChangingLocked(wakeLock, wakeLock.mFlags, wakeLock.mTag, wakeLock.mPackageName, wakeLock.mOwnerUid, wakeLock.mOwnerPid, ws, historyTag);
                wakeLock.mHistoryTag = historyTag;
                wakeLock.updateWorkSource(ws);
            }
        }
    }

    private int findWakeLockIndexLocked(IBinder lock) {
        int count = this.mWakeLocks.size();
        for (int i = 0; i < count; ++i) {
            if (this.mWakeLocks.get((int)i).mLock != lock) continue;
            return i;
        }
        return -1;
    }

    private void notifyWakeLockAcquiredLocked(WakeLock wakeLock) {
        if (this.mSystemReady && !wakeLock.mDisabled) {
            wakeLock.mNotifiedAcquired = true;
            this.mNotifier.onWakeLockAcquired(wakeLock.mFlags, wakeLock.mTag, wakeLock.mPackageName, wakeLock.mOwnerUid, wakeLock.mOwnerPid, wakeLock.mWorkSource, wakeLock.mHistoryTag);
            this.restartNofifyLongTimerLocked(wakeLock);
        }
    }

    private void enqueueNotifyLongMsgLocked(long time) {
        this.mNotifyLongScheduled = time;
        Message msg = this.mHandler.obtainMessage(4);
        msg.setAsynchronous(true);
        this.mHandler.sendMessageAtTime(msg, time);
    }

    private void restartNofifyLongTimerLocked(WakeLock wakeLock) {
        wakeLock.mAcquireTime = SystemClock.uptimeMillis();
        if ((wakeLock.mFlags & 0xFFFF) == 1 && this.mNotifyLongScheduled == 0L) {
            this.enqueueNotifyLongMsgLocked(wakeLock.mAcquireTime + 60000L);
        }
    }

    private void notifyWakeLockLongStartedLocked(WakeLock wakeLock) {
        if (this.mSystemReady && !wakeLock.mDisabled) {
            wakeLock.mNotifiedLong = true;
            this.mNotifier.onLongPartialWakeLockStart(wakeLock.mTag, wakeLock.mOwnerUid, wakeLock.mWorkSource, wakeLock.mHistoryTag);
        }
    }

    private void notifyWakeLockLongFinishedLocked(WakeLock wakeLock) {
        if (wakeLock.mNotifiedLong) {
            wakeLock.mNotifiedLong = false;
            this.mNotifier.onLongPartialWakeLockFinish(wakeLock.mTag, wakeLock.mOwnerUid, wakeLock.mWorkSource, wakeLock.mHistoryTag);
        }
    }

    private void notifyWakeLockChangingLocked(WakeLock wakeLock, int flags, String tag, String packageName, int uid, int pid, WorkSource ws, String historyTag) {
        if (this.mSystemReady && wakeLock.mNotifiedAcquired) {
            this.mNotifier.onWakeLockChanging(wakeLock.mFlags, wakeLock.mTag, wakeLock.mPackageName, wakeLock.mOwnerUid, wakeLock.mOwnerPid, wakeLock.mWorkSource, wakeLock.mHistoryTag, flags, tag, packageName, uid, pid, ws, historyTag);
            this.notifyWakeLockLongFinishedLocked(wakeLock);
            this.restartNofifyLongTimerLocked(wakeLock);
        }
    }

    private void notifyWakeLockReleasedLocked(WakeLock wakeLock) {
        if (this.mSystemReady && wakeLock.mNotifiedAcquired) {
            wakeLock.mNotifiedAcquired = false;
            wakeLock.mAcquireTime = 0L;
            this.mNotifier.onWakeLockReleased(wakeLock.mFlags, wakeLock.mTag, wakeLock.mPackageName, wakeLock.mOwnerUid, wakeLock.mOwnerPid, wakeLock.mWorkSource, wakeLock.mHistoryTag);
            this.notifyWakeLockLongFinishedLocked(wakeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWakeLockLevelSupportedInternal(int level) {
        Object object = this.mLock;
        synchronized (object) {
            switch (level) {
                case 1: 
                case 6: 
                case 10: 
                case 26: 
                case 64: 
                case 128: {
                    return true;
                }
                case 32: {
                    return this.mSystemReady && this.mDisplayManagerInternal.isProximitySensorAvailable();
                }
            }
            return false;
        }
    }

    private void userActivityFromNative(long eventTime, int event, int flags) {
        this.userActivityInternal(eventTime, event, flags, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userActivityInternal(long eventTime, int event, int flags, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.userActivityNoUpdateLocked(eventTime, event, flags, uid)) {
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userActivityNoUpdateLocked(long eventTime, int event, int flags, int uid) {
        if (eventTime < this.mLastSleepTime || eventTime < this.mLastWakeTime || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        Trace.traceBegin(131072L, "userActivity");
        try {
            if (eventTime > this.mLastInteractivePowerHintTime) {
                this.powerHintInternal(2, 0);
                this.mLastInteractivePowerHintTime = eventTime;
            }
            this.mNotifier.onUserActivity(event, uid);
            if (this.mUserInactiveOverrideFromWindowManager) {
                this.mUserInactiveOverrideFromWindowManager = false;
                this.mOverriddenTimeout = -1L;
            }
            if (this.mWakefulness == 0 || this.mWakefulness == 3 || (flags & 2) != 0) {
                boolean bl = false;
                return bl;
            }
            if ((flags & 1) != 0) {
                if (eventTime > this.mLastUserActivityTimeNoChangeLights && eventTime > this.mLastUserActivityTime) {
                    this.mLastUserActivityTimeNoChangeLights = eventTime;
                    this.mDirty |= 4;
                    if (event == 1) {
                        this.mDirty |= 0x1000;
                    }
                    boolean bl = true;
                    return bl;
                }
            } else if (eventTime > this.mLastUserActivityTime) {
                this.mLastUserActivityTime = eventTime;
                this.mDirty |= 4;
                if (event == 1) {
                    this.mDirty |= 0x1000;
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Trace.traceEnd(131072L);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpInternal(long eventTime, String reason, int uid, String opPackageName, int opUid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.wakeUpNoUpdateLocked(eventTime, reason, uid, opPackageName, opUid)) {
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wakeUpNoUpdateLocked(long eventTime, String reason, int reasonUid, String opPackageName, int opUid) {
        if (eventTime < this.mLastSleepTime || this.mWakefulness == 1 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        Trace.asyncTraceBegin(131072L, TRACE_SCREEN_ON, 0);
        Trace.traceBegin(131072L, "wakeUp");
        try {
            switch (this.mWakefulness) {
                case 0: {
                    Slog.i(TAG, "Waking up from sleep (uid " + reasonUid + ")...");
                    break;
                }
                case 2: {
                    Slog.i(TAG, "Waking up from dream (uid " + reasonUid + ")...");
                    break;
                }
                case 3: {
                    Slog.i(TAG, "Waking up from dozing (uid " + reasonUid + ")...");
                }
            }
            this.mLastWakeTime = eventTime;
            this.setWakefulnessLocked(1, 0);
            this.mNotifier.onWakeUp(reason, reasonUid, opPackageName, opUid);
            this.userActivityNoUpdateLocked(eventTime, 0, 0, reasonUid);
        }
        finally {
            Trace.traceEnd(131072L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goToSleepInternal(long eventTime, int reason, int flags, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.goToSleepNoUpdateLocked(eventTime, reason, flags, uid)) {
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean goToSleepNoUpdateLocked(long eventTime, int reason, int flags, int uid) {
        if (eventTime < this.mLastWakeTime || this.mWakefulness == 0 || this.mWakefulness == 3 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        Trace.traceBegin(131072L, "goToSleep");
        try {
            switch (reason) {
                case 1: {
                    Slog.i(TAG, "Going to sleep due to device administration policy (uid " + uid + ")...");
                    break;
                }
                case 2: {
                    Slog.i(TAG, "Going to sleep due to screen timeout (uid " + uid + ")...");
                    break;
                }
                case 3: {
                    Slog.i(TAG, "Going to sleep due to lid switch (uid " + uid + ")...");
                    break;
                }
                case 4: {
                    Slog.i(TAG, "Going to sleep due to power button (uid " + uid + ")...");
                    break;
                }
                case 6: {
                    Slog.i(TAG, "Going to sleep due to sleep button (uid " + uid + ")...");
                    break;
                }
                case 5: {
                    Slog.i(TAG, "Going to sleep due to HDMI standby (uid " + uid + ")...");
                    break;
                }
                default: {
                    Slog.i(TAG, "Going to sleep by application request (uid " + uid + ")...");
                    reason = 0;
                }
            }
            this.mLastSleepTime = eventTime;
            this.mSandmanSummoned = true;
            this.setWakefulnessLocked(3, reason);
            int numWakeLocksCleared = 0;
            int numWakeLocks = this.mWakeLocks.size();
            for (int i = 0; i < numWakeLocks; ++i) {
                WakeLock wakeLock = this.mWakeLocks.get(i);
                switch (wakeLock.mFlags & 0xFFFF) {
                    case 6: 
                    case 10: 
                    case 26: {
                        ++numWakeLocksCleared;
                    }
                }
            }
            EventLog.writeEvent(2724, numWakeLocksCleared);
            if ((flags & 1) != 0) {
                this.reallyGoToSleepNoUpdateLocked(eventTime, uid);
            }
        }
        finally {
            Trace.traceEnd(131072L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void napInternal(long eventTime, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.napNoUpdateLocked(eventTime, uid)) {
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean napNoUpdateLocked(long eventTime, int uid) {
        if (eventTime < this.mLastWakeTime || this.mWakefulness != 1 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        Trace.traceBegin(131072L, "nap");
        try {
            Slog.i(TAG, "Nap time (uid " + uid + ")...");
            this.mSandmanSummoned = true;
            this.setWakefulnessLocked(2, 0);
        }
        finally {
            Trace.traceEnd(131072L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reallyGoToSleepNoUpdateLocked(long eventTime, int uid) {
        if (eventTime < this.mLastWakeTime || this.mWakefulness == 0 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        Trace.traceBegin(131072L, "reallyGoToSleep");
        try {
            Slog.i(TAG, "Sleeping (uid " + uid + ")...");
            this.setWakefulnessLocked(0, 2);
        }
        finally {
            Trace.traceEnd(131072L);
        }
        return true;
    }

    private void setWakefulnessLocked(int wakefulness, int reason) {
        if (this.mWakefulness != wakefulness) {
            this.mWakefulness = wakefulness;
            this.mWakefulnessChanging = true;
            this.mDirty |= 2;
            this.mNotifier.onWakefulnessChangeStarted(wakefulness, reason);
        }
    }

    private void logSleepTimeoutRecapturedLocked() {
        long now = SystemClock.uptimeMillis();
        long savedWakeTimeMs = this.mOverriddenTimeout - now;
        if (savedWakeTimeMs >= 0L) {
            EventLog.writeEvent(2731, savedWakeTimeMs);
            this.mOverriddenTimeout = -1L;
        }
    }

    private void logScreenOn() {
        Trace.asyncTraceEnd(131072L, TRACE_SCREEN_ON, 0);
        int latencyMs = (int)(SystemClock.uptimeMillis() - this.mLastWakeTime);
        LogMaker log = new LogMaker(198);
        log.setType(1);
        log.setSubtype(0);
        log.setLatency(latencyMs);
        MetricsLogger.action(log);
        EventLogTags.writePowerScreenState(1, 0, 0L, 0, latencyMs);
        if (latencyMs >= 200) {
            Slog.w(TAG, "Screen on took " + latencyMs + " ms");
        }
    }

    private void finishWakefulnessChangeIfNeededLocked() {
        if (this.mWakefulnessChanging && this.mDisplayReady) {
            if (this.mWakefulness == 3 && (this.mWakeLockSummary & 0x40) == 0) {
                return;
            }
            if (this.mWakefulness == 3 || this.mWakefulness == 0) {
                this.logSleepTimeoutRecapturedLocked();
            }
            if (this.mWakefulness == 1) {
                this.logScreenOn();
            }
            this.mWakefulnessChanging = false;
            this.mNotifier.onWakefulnessChangeFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePowerStateLocked() {
        if (!this.mSystemReady || this.mDirty == 0) {
            return;
        }
        if (!Thread.holdsLock(this.mLock)) {
            Slog.wtf(TAG, "Power manager lock was not held when calling updatePowerStateLocked");
        }
        Trace.traceBegin(131072L, "updatePowerState");
        try {
            int dirtyPhase1;
            this.updateIsPoweredLocked(this.mDirty);
            this.updateStayOnLocked(this.mDirty);
            this.updateScreenBrightnessBoostLocked(this.mDirty);
            long now = SystemClock.uptimeMillis();
            int dirtyPhase2 = 0;
            do {
                dirtyPhase1 = this.mDirty;
                dirtyPhase2 |= dirtyPhase1;
                this.mDirty = 0;
                this.updateWakeLockSummaryLocked(dirtyPhase1);
                this.updateUserActivitySummaryLocked(now, dirtyPhase1);
            } while (this.updateWakefulnessLocked(dirtyPhase1));
            boolean displayBecameReady = this.updateDisplayPowerStateLocked(dirtyPhase2);
            this.updateDreamLocked(dirtyPhase2, displayBecameReady);
            this.finishWakefulnessChangeIfNeededLocked();
            this.updateSuspendBlockerLocked();
        }
        finally {
            Trace.traceEnd(131072L);
        }
    }

    private void updateIsPoweredLocked(int dirty) {
        if ((dirty & 0x100) != 0) {
            boolean wasPowered = this.mIsPowered;
            int oldPlugType = this.mPlugType;
            boolean oldLevelLow = this.mBatteryLevelLow;
            this.mIsPowered = this.mBatteryManagerInternal.isPowered(7);
            this.mPlugType = this.mBatteryManagerInternal.getPlugType();
            this.mBatteryLevel = this.mBatteryManagerInternal.getBatteryLevel();
            this.mBatteryLevelLow = this.mBatteryManagerInternal.getBatteryLevelLow();
            if (wasPowered != this.mIsPowered || oldPlugType != this.mPlugType) {
                this.mDirty |= 0x40;
                boolean dockedOnWirelessCharger = this.mWirelessChargerDetector.update(this.mIsPowered, this.mPlugType, this.mBatteryLevel);
                long now = SystemClock.uptimeMillis();
                if (this.shouldWakeUpWhenPluggedOrUnpluggedLocked(wasPowered, oldPlugType, dockedOnWirelessCharger)) {
                    this.wakeUpNoUpdateLocked(now, "android.server.power:POWER", 1000, this.mContext.getOpPackageName(), 1000);
                }
                this.userActivityNoUpdateLocked(now, 0, 0, 1000);
                if (dockedOnWirelessCharger) {
                    this.mNotifier.onWirelessChargingStarted();
                }
            }
            if (wasPowered != this.mIsPowered || oldLevelLow != this.mBatteryLevelLow) {
                if (oldLevelLow != this.mBatteryLevelLow && !this.mBatteryLevelLow) {
                    this.mAutoLowPowerModeSnoozing = false;
                }
                this.updateLowPowerModeLocked();
            }
        }
    }

    private boolean shouldWakeUpWhenPluggedOrUnpluggedLocked(boolean wasPowered, int oldPlugType, boolean dockedOnWirelessCharger) {
        if (!this.mWakeUpWhenPluggedOrUnpluggedConfig) {
            return false;
        }
        if (wasPowered && !this.mIsPowered && oldPlugType == 4) {
            return false;
        }
        if (!wasPowered && this.mIsPowered && this.mPlugType == 4 && !dockedOnWirelessCharger) {
            return false;
        }
        if (this.mIsPowered && this.mWakefulness == 2) {
            return false;
        }
        if (this.mTheaterModeEnabled && !this.mWakeUpWhenPluggedOrUnpluggedInTheaterModeConfig) {
            return false;
        }
        return !this.mAlwaysOnEnabled || this.mWakefulness != 3;
    }

    private void updateStayOnLocked(int dirty) {
        if ((dirty & 0x120) != 0) {
            boolean wasStayOn = this.mStayOn;
            this.mStayOn = this.mStayOnWhilePluggedInSetting != 0 && !this.isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked() ? this.mBatteryManagerInternal.isPowered(this.mStayOnWhilePluggedInSetting) : false;
            if (this.mStayOn != wasStayOn) {
                this.mDirty |= 0x80;
            }
        }
    }

    private void updateWakeLockSummaryLocked(int dirty) {
        if ((dirty & 3) != 0) {
            this.mWakeLockSummary = 0;
            int numWakeLocks = this.mWakeLocks.size();
            block9: for (int i = 0; i < numWakeLocks; ++i) {
                WakeLock wakeLock = this.mWakeLocks.get(i);
                switch (wakeLock.mFlags & 0xFFFF) {
                    case 1: {
                        if (wakeLock.mDisabled) continue block9;
                        this.mWakeLockSummary |= 1;
                        continue block9;
                    }
                    case 26: {
                        this.mWakeLockSummary |= 0xA;
                        continue block9;
                    }
                    case 10: {
                        this.mWakeLockSummary |= 2;
                        continue block9;
                    }
                    case 6: {
                        this.mWakeLockSummary |= 4;
                        continue block9;
                    }
                    case 32: {
                        this.mWakeLockSummary |= 0x10;
                        continue block9;
                    }
                    case 64: {
                        this.mWakeLockSummary |= 0x40;
                        continue block9;
                    }
                    case 128: {
                        this.mWakeLockSummary |= 0x80;
                    }
                }
            }
            if (this.mWakefulness != 3) {
                this.mWakeLockSummary &= 0xFFFFFF3F;
            }
            if (this.mWakefulness == 0 || (this.mWakeLockSummary & 0x40) != 0) {
                this.mWakeLockSummary &= 0xFFFFFFF1;
                if (this.mWakefulness == 0) {
                    this.mWakeLockSummary &= 0xFFFFFFEF;
                }
            }
            if ((this.mWakeLockSummary & 6) != 0) {
                if (this.mWakefulness == 1) {
                    this.mWakeLockSummary |= 0x21;
                } else if (this.mWakefulness == 2) {
                    this.mWakeLockSummary |= 1;
                }
            }
            if ((this.mWakeLockSummary & 0x80) != 0) {
                this.mWakeLockSummary |= 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForLongWakeLocks() {
        Object object = this.mLock;
        synchronized (object) {
            long now;
            this.mNotifyLongDispatched = now = SystemClock.uptimeMillis();
            long when = now - 60000L;
            long nextCheckTime = Long.MAX_VALUE;
            int numWakeLocks = this.mWakeLocks.size();
            for (int i = 0; i < numWakeLocks; ++i) {
                WakeLock wakeLock = this.mWakeLocks.get(i);
                if ((wakeLock.mFlags & 0xFFFF) != 1 || !wakeLock.mNotifiedAcquired || wakeLock.mNotifiedLong) continue;
                if (wakeLock.mAcquireTime < when) {
                    this.notifyWakeLockLongStartedLocked(wakeLock);
                    continue;
                }
                long checkTime = wakeLock.mAcquireTime + 60000L;
                if (checkTime >= nextCheckTime) continue;
                nextCheckTime = checkTime;
            }
            this.mNotifyLongScheduled = 0L;
            this.mHandler.removeMessages(4);
            if (nextCheckTime != Long.MAX_VALUE) {
                this.mNotifyLongNextCheck = nextCheckTime;
                this.enqueueNotifyLongMsgLocked(nextCheckTime);
            } else {
                this.mNotifyLongNextCheck = 0L;
            }
        }
    }

    private void updateUserActivitySummaryLocked(long now, int dirty) {
        if ((dirty & 0x27) != 0) {
            this.mHandler.removeMessages(1);
            long nextTimeout = 0L;
            if (this.mWakefulness == 1 || this.mWakefulness == 2 || this.mWakefulness == 3) {
                int sleepTimeout = this.getSleepTimeoutLocked();
                int screenOffTimeout = this.getScreenOffTimeoutLocked(sleepTimeout);
                int screenDimDuration = this.getScreenDimDurationLocked(screenOffTimeout);
                boolean userInactiveOverride = this.mUserInactiveOverrideFromWindowManager;
                this.mUserActivitySummary = 0;
                if (this.mLastUserActivityTime >= this.mLastWakeTime) {
                    nextTimeout = this.mLastUserActivityTime + (long)screenOffTimeout - (long)screenDimDuration;
                    if (now < nextTimeout) {
                        this.mUserActivitySummary = 1;
                    } else {
                        nextTimeout = this.mLastUserActivityTime + (long)screenOffTimeout;
                        if (now < nextTimeout) {
                            this.mUserActivitySummary = 2;
                        }
                    }
                }
                if (this.mUserActivitySummary == 0 && this.mLastUserActivityTimeNoChangeLights >= this.mLastWakeTime && now < (nextTimeout = this.mLastUserActivityTimeNoChangeLights + (long)screenOffTimeout)) {
                    if (this.mDisplayPowerRequest.policy == 3 || this.mDisplayPowerRequest.policy == 4) {
                        this.mUserActivitySummary = 1;
                    } else if (this.mDisplayPowerRequest.policy == 2) {
                        this.mUserActivitySummary = 2;
                    }
                }
                if (this.mUserActivitySummary == 0) {
                    if (sleepTimeout >= 0) {
                        long anyUserActivity = Math.max(this.mLastUserActivityTime, this.mLastUserActivityTimeNoChangeLights);
                        if (anyUserActivity >= this.mLastWakeTime && now < (nextTimeout = anyUserActivity + (long)sleepTimeout)) {
                            this.mUserActivitySummary = 4;
                        }
                    } else {
                        this.mUserActivitySummary = 4;
                        nextTimeout = -1L;
                    }
                }
                if (this.mUserActivitySummary != 4 && userInactiveOverride) {
                    if ((this.mUserActivitySummary & 3) != 0 && nextTimeout >= now && this.mOverriddenTimeout == -1L) {
                        this.mOverriddenTimeout = nextTimeout;
                    }
                    this.mUserActivitySummary = 4;
                    nextTimeout = -1L;
                }
                if (this.mUserActivitySummary != 0 && nextTimeout >= 0L) {
                    Message msg = this.mHandler.obtainMessage(1);
                    msg.setAsynchronous(true);
                    this.mHandler.sendMessageAtTime(msg, nextTimeout);
                }
            } else {
                this.mUserActivitySummary = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUserActivityTimeout() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDirty |= 4;
            this.updatePowerStateLocked();
        }
    }

    private int getSleepTimeoutLocked() {
        int timeout = this.mSleepTimeoutSetting;
        if (timeout <= 0) {
            return -1;
        }
        return Math.max(timeout, this.mMinimumScreenOffTimeoutConfig);
    }

    private int getScreenOffTimeoutLocked(int sleepTimeout) {
        int timeout = this.mScreenOffTimeoutSetting;
        if (this.isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked()) {
            timeout = Math.min(timeout, this.mMaximumScreenOffTimeoutFromDeviceAdmin);
        }
        if (this.mUserActivityTimeoutOverrideFromWindowManager >= 0L) {
            timeout = (int)Math.min((long)timeout, this.mUserActivityTimeoutOverrideFromWindowManager);
        }
        if (sleepTimeout >= 0) {
            timeout = Math.min(timeout, sleepTimeout);
        }
        return Math.max(timeout, this.mMinimumScreenOffTimeoutConfig);
    }

    private int getScreenDimDurationLocked(int screenOffTimeout) {
        return Math.min(this.mMaximumScreenDimDurationConfig, (int)((float)screenOffTimeout * this.mMaximumScreenDimRatioConfig));
    }

    private boolean updateWakefulnessLocked(int dirty) {
        boolean changed = false;
        if ((dirty & 0x697) != 0 && this.mWakefulness == 1 && this.isItBedTimeYetLocked()) {
            long time = SystemClock.uptimeMillis();
            changed = this.shouldNapAtBedTimeLocked() ? this.napNoUpdateLocked(time, 1000) : this.goToSleepNoUpdateLocked(time, 2, 0, 1000);
        }
        return changed;
    }

    private boolean shouldNapAtBedTimeLocked() {
        return this.mDreamsActivateOnSleepSetting || this.mDreamsActivateOnDockSetting && this.mDockState != 0;
    }

    private boolean isItBedTimeYetLocked() {
        return this.mBootCompleted && !this.isBeingKeptAwakeLocked();
    }

    private boolean isBeingKeptAwakeLocked() {
        return this.mStayOn || this.mProximityPositive || (this.mWakeLockSummary & 0x20) != 0 || (this.mUserActivitySummary & 3) != 0 || this.mScreenBrightnessBoostInProgress;
    }

    private void updateDreamLocked(int dirty, boolean displayBecameReady) {
        if (((dirty & 0x3F7) != 0 || displayBecameReady) && this.mDisplayReady) {
            this.scheduleSandmanLocked();
        }
    }

    private void scheduleSandmanLocked() {
        if (!this.mSandmanScheduled) {
            this.mSandmanScheduled = true;
            Message msg = this.mHandler.obtainMessage(2);
            msg.setAsynchronous(true);
            this.mHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSandman() {
        boolean isDreaming;
        boolean startDreaming;
        int wakefulness;
        Object object = this.mLock;
        synchronized (object) {
            this.mSandmanScheduled = false;
            wakefulness = this.mWakefulness;
            if (this.mSandmanSummoned && this.mDisplayReady) {
                startDreaming = this.canDreamLocked() || this.canDozeLocked();
                this.mSandmanSummoned = false;
            } else {
                startDreaming = false;
            }
        }
        if (this.mDreamManager != null) {
            if (startDreaming) {
                this.mDreamManager.stopDream(false);
                this.mDreamManager.startDream(wakefulness == 3);
            }
            isDreaming = this.mDreamManager.isDreaming();
        } else {
            isDreaming = false;
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            if (startDreaming && isDreaming) {
                this.mBatteryLevelWhenDreamStarted = this.mBatteryLevel;
                if (wakefulness == 3) {
                    Slog.i(TAG, "Dozing...");
                } else {
                    Slog.i(TAG, "Dreaming...");
                }
            }
            if (this.mSandmanSummoned || this.mWakefulness != wakefulness) {
                return;
            }
            if (wakefulness == 2) {
                if (isDreaming && this.canDreamLocked()) {
                    if (this.mDreamsBatteryLevelDrainCutoffConfig >= 0 && this.mBatteryLevel < this.mBatteryLevelWhenDreamStarted - this.mDreamsBatteryLevelDrainCutoffConfig && !this.isBeingKeptAwakeLocked()) {
                        Slog.i(TAG, "Stopping dream because the battery appears to be draining faster than it is charging.  Battery level when dream started: " + this.mBatteryLevelWhenDreamStarted + "%.  Battery level now: " + this.mBatteryLevel + "%.");
                    } else {
                        return;
                    }
                }
                if (this.isItBedTimeYetLocked()) {
                    this.goToSleepNoUpdateLocked(SystemClock.uptimeMillis(), 2, 0, 1000);
                    this.updatePowerStateLocked();
                } else {
                    this.wakeUpNoUpdateLocked(SystemClock.uptimeMillis(), "android.server.power:DREAM", 1000, this.mContext.getOpPackageName(), 1000);
                    this.updatePowerStateLocked();
                }
            } else if (wakefulness == 3) {
                if (isDreaming) {
                    return;
                }
                this.reallyGoToSleepNoUpdateLocked(SystemClock.uptimeMillis(), 1000);
                this.updatePowerStateLocked();
            }
        }
        if (isDreaming) {
            this.mDreamManager.stopDream(false);
        }
    }

    private boolean canDreamLocked() {
        if (!(this.mWakefulness == 2 && this.mDreamsSupportedConfig && this.mDreamsEnabledSetting && this.mDisplayPowerRequest.isBrightOrDim() && !this.mDisplayPowerRequest.isVr() && (this.mUserActivitySummary & 7) != 0 && this.mBootCompleted)) {
            return false;
        }
        if (!this.isBeingKeptAwakeLocked()) {
            if (!this.mIsPowered && !this.mDreamsEnabledOnBatteryConfig) {
                return false;
            }
            if (!this.mIsPowered && this.mDreamsBatteryLevelMinimumWhenNotPoweredConfig >= 0 && this.mBatteryLevel < this.mDreamsBatteryLevelMinimumWhenNotPoweredConfig) {
                return false;
            }
            if (this.mIsPowered && this.mDreamsBatteryLevelMinimumWhenPoweredConfig >= 0 && this.mBatteryLevel < this.mDreamsBatteryLevelMinimumWhenPoweredConfig) {
                return false;
            }
        }
        return true;
    }

    private boolean canDozeLocked() {
        return this.mWakefulness == 3;
    }

    private boolean updateDisplayPowerStateLocked(int dirty) {
        boolean oldDisplayReady = this.mDisplayReady;
        if ((dirty & 0x383F) != 0) {
            boolean autoBrightness;
            this.mDisplayPowerRequest.policy = this.getDesiredScreenPolicyLocked();
            boolean brightnessSetByUser = true;
            int screenBrightness = this.mScreenBrightnessSettingDefault;
            float screenAutoBrightnessAdjustment = 0.0f;
            boolean bl = autoBrightness = this.mScreenBrightnessModeSetting == 1;
            if (!this.mBootCompleted) {
                autoBrightness = false;
                brightnessSetByUser = false;
            } else if (this.mIsVrModeEnabled) {
                screenBrightness = this.mScreenBrightnessForVrSetting;
                autoBrightness = false;
            } else if (PowerManagerService.isValidBrightness(this.mScreenBrightnessOverrideFromWindowManager)) {
                screenBrightness = this.mScreenBrightnessOverrideFromWindowManager;
                autoBrightness = false;
                brightnessSetByUser = false;
            } else if (PowerManagerService.isValidBrightness(this.mTemporaryScreenBrightnessSettingOverride)) {
                screenBrightness = this.mTemporaryScreenBrightnessSettingOverride;
            } else if (PowerManagerService.isValidBrightness(this.mScreenBrightnessSetting)) {
                screenBrightness = this.mScreenBrightnessSetting;
            }
            if (autoBrightness) {
                screenBrightness = this.mScreenBrightnessSettingDefault;
                if (PowerManagerService.isValidAutoBrightnessAdjustment(this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride)) {
                    screenAutoBrightnessAdjustment = this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride;
                } else if (PowerManagerService.isValidAutoBrightnessAdjustment(this.mScreenAutoBrightnessAdjustmentSetting)) {
                    screenAutoBrightnessAdjustment = this.mScreenAutoBrightnessAdjustmentSetting;
                }
            }
            screenBrightness = Math.max(Math.min(screenBrightness, this.mScreenBrightnessSettingMaximum), this.mScreenBrightnessSettingMinimum);
            screenAutoBrightnessAdjustment = Math.max(Math.min(screenAutoBrightnessAdjustment, 1.0f), -1.0f);
            this.mDisplayPowerRequest.screenBrightness = screenBrightness;
            this.mDisplayPowerRequest.screenAutoBrightnessAdjustment = screenAutoBrightnessAdjustment;
            this.mDisplayPowerRequest.brightnessSetByUser = brightnessSetByUser;
            this.mDisplayPowerRequest.useAutoBrightness = autoBrightness;
            this.mDisplayPowerRequest.useProximitySensor = this.shouldUseProximitySensorLocked();
            this.mDisplayPowerRequest.boostScreenBrightness = this.shouldBoostScreenBrightness();
            this.updatePowerRequestFromBatterySaverPolicy(this.mDisplayPowerRequest);
            if (this.mDisplayPowerRequest.policy == 1) {
                this.mDisplayPowerRequest.dozeScreenState = this.mDozeScreenStateOverrideFromDreamManager;
                if (this.mDisplayPowerRequest.dozeScreenState == 4 && (this.mWakeLockSummary & 0x80) != 0) {
                    this.mDisplayPowerRequest.dozeScreenState = 3;
                }
                this.mDisplayPowerRequest.dozeScreenBrightness = this.mDozeScreenBrightnessOverrideFromDreamManager;
            } else {
                this.mDisplayPowerRequest.dozeScreenState = 0;
                this.mDisplayPowerRequest.dozeScreenBrightness = -1;
            }
            this.mDisplayReady = this.mDisplayManagerInternal.requestPowerState(this.mDisplayPowerRequest, this.mRequestWaitForNegativeProximity);
            this.mRequestWaitForNegativeProximity = false;
            if ((dirty & 0x1000) != 0) {
                sQuiescent = false;
            }
        }
        return this.mDisplayReady && !oldDisplayReady;
    }

    private void updateScreenBrightnessBoostLocked(int dirty) {
        if ((dirty & 0x800) != 0 && this.mScreenBrightnessBoostInProgress) {
            long boostTimeout;
            long now = SystemClock.uptimeMillis();
            this.mHandler.removeMessages(3);
            if (this.mLastScreenBrightnessBoostTime > this.mLastSleepTime && (boostTimeout = this.mLastScreenBrightnessBoostTime + 5000L) > now) {
                Message msg = this.mHandler.obtainMessage(3);
                msg.setAsynchronous(true);
                this.mHandler.sendMessageAtTime(msg, boostTimeout);
                return;
            }
            this.mScreenBrightnessBoostInProgress = false;
            this.mNotifier.onScreenBrightnessBoostChanged();
            this.userActivityNoUpdateLocked(now, 0, 0, 1000);
        }
    }

    private boolean shouldBoostScreenBrightness() {
        return !this.mIsVrModeEnabled && this.mScreenBrightnessBoostInProgress;
    }

    private static boolean isValidBrightness(int value) {
        return value >= 0 && value <= 255;
    }

    private static boolean isValidAutoBrightnessAdjustment(float value) {
        return value >= -1.0f && value <= 1.0f;
    }

    private int getDesiredScreenPolicyLocked() {
        if (this.mIsVrModeEnabled) {
            return 4;
        }
        if (this.mWakefulness == 0 || sQuiescent) {
            return 0;
        }
        if (this.mWakefulness == 3) {
            if ((this.mWakeLockSummary & 0x40) != 0) {
                return 1;
            }
            if (this.mDozeAfterScreenOffConfig) {
                return 0;
            }
        }
        if ((this.mWakeLockSummary & 2) != 0 || (this.mUserActivitySummary & 1) != 0 || !this.mBootCompleted || this.mScreenBrightnessBoostInProgress) {
            return 3;
        }
        return 2;
    }

    private boolean shouldUseProximitySensorLocked() {
        return !this.mIsVrModeEnabled && (this.mWakeLockSummary & 0x10) != 0;
    }

    private void updateSuspendBlockerLocked() {
        boolean needWakeLockSuspendBlocker = (this.mWakeLockSummary & 1) != 0;
        boolean needDisplaySuspendBlocker = this.needDisplaySuspendBlockerLocked();
        boolean autoSuspend = !needDisplaySuspendBlocker;
        boolean interactive = this.mDisplayPowerRequest.isBrightOrDim();
        if (!autoSuspend && this.mDecoupleHalAutoSuspendModeFromDisplayConfig) {
            this.setHalAutoSuspendModeLocked(false);
        }
        if (needWakeLockSuspendBlocker && !this.mHoldingWakeLockSuspendBlocker) {
            this.mWakeLockSuspendBlocker.acquire();
            this.mHoldingWakeLockSuspendBlocker = true;
        }
        if (needDisplaySuspendBlocker && !this.mHoldingDisplaySuspendBlocker) {
            this.mDisplaySuspendBlocker.acquire();
            this.mHoldingDisplaySuspendBlocker = true;
        }
        if (this.mDecoupleHalInteractiveModeFromDisplayConfig && (interactive || this.mDisplayReady)) {
            this.setHalInteractiveModeLocked(interactive);
        }
        if (!needWakeLockSuspendBlocker && this.mHoldingWakeLockSuspendBlocker) {
            this.mWakeLockSuspendBlocker.release();
            this.mHoldingWakeLockSuspendBlocker = false;
        }
        if (!needDisplaySuspendBlocker && this.mHoldingDisplaySuspendBlocker) {
            this.mDisplaySuspendBlocker.release();
            this.mHoldingDisplaySuspendBlocker = false;
        }
        if (autoSuspend && this.mDecoupleHalAutoSuspendModeFromDisplayConfig) {
            this.setHalAutoSuspendModeLocked(true);
        }
    }

    private boolean needDisplaySuspendBlockerLocked() {
        if (!this.mDisplayReady) {
            return true;
        }
        if (!(!this.mDisplayPowerRequest.isBrightOrDim() || this.mDisplayPowerRequest.useProximitySensor && this.mProximityPositive && this.mSuspendWhenScreenOffDueToProximityConfig)) {
            return true;
        }
        return this.mScreenBrightnessBoostInProgress;
    }

    private void setHalAutoSuspendModeLocked(boolean enable) {
        if (enable != this.mHalAutoSuspendModeEnabled) {
            this.mHalAutoSuspendModeEnabled = enable;
            Trace.traceBegin(131072L, "setHalAutoSuspend(" + enable + ")");
            try {
                PowerManagerService.nativeSetAutoSuspend(enable);
            }
            finally {
                Trace.traceEnd(131072L);
            }
        }
    }

    private void setHalInteractiveModeLocked(boolean enable) {
        if (enable != this.mHalInteractiveModeEnabled) {
            this.mHalInteractiveModeEnabled = enable;
            Trace.traceBegin(131072L, "setHalInteractive(" + enable + ")");
            try {
                PowerManagerService.nativeSetInteractive(enable);
            }
            finally {
                Trace.traceEnd(131072L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInteractiveInternal() {
        Object object = this.mLock;
        synchronized (object) {
            return PowerManagerInternal.isInteractive(this.mWakefulness);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLowPowerModeInternal() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLowPowerModeEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setLowPowerModeInternal(boolean mode) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsPowered) {
                return false;
            }
            Settings.Global.putInt(this.mContext.getContentResolver(), "low_power", mode ? 1 : 0);
            this.mLowPowerModeSetting = mode;
            if (this.mAutoLowPowerModeConfigured && this.mBatteryLevelLow) {
                if (mode && this.mAutoLowPowerModeSnoozing) {
                    this.mAutoLowPowerModeSnoozing = false;
                } else if (!mode && !this.mAutoLowPowerModeSnoozing) {
                    this.mAutoLowPowerModeSnoozing = true;
                }
            }
            this.updateLowPowerModeLocked();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDeviceIdleModeInternal() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDeviceIdleMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLightDeviceIdleModeInternal() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLightDeviceIdleMode;
        }
    }

    private void handleBatteryStateChangedLocked() {
        this.mDirty |= 0x100;
        this.updatePowerStateLocked();
    }

    private void shutdownOrRebootInternal(final int haltMode, final boolean confirm, final String reason, boolean wait) {
        if (this.mHandler == null || !this.mSystemReady) {
            if (RescueParty.isAttemptingFactoryReset()) {
                PowerManagerService.lowLevelReboot(reason);
            } else {
                throw new IllegalStateException("Too early to call shutdown() or reboot()");
            }
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    if (haltMode == 2) {
                        ShutdownThread.rebootSafeMode(PowerManagerService.this.getUiContext(), confirm);
                    } else if (haltMode == 1) {
                        ShutdownThread.reboot(PowerManagerService.this.getUiContext(), reason, confirm);
                    } else {
                        ShutdownThread.shutdown(PowerManagerService.this.getUiContext(), reason, confirm);
                    }
                }
            }
        };
        Message msg = Message.obtain(UiThread.getHandler(), runnable);
        msg.setAsynchronous(true);
        UiThread.getHandler().sendMessage(msg);
        if (wait) {
            Runnable runnable2 = runnable;
            synchronized (runnable2) {
                while (true) {
                    try {
                        while (true) {
                            runnable.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private void crashInternal(final String message) {
        Thread t = new Thread("PowerManagerService.crash()"){

            @Override
            public void run() {
                throw new RuntimeException(message);
            }
        };
        try {
            t.start();
            t.join();
        }
        catch (InterruptedException e) {
            Slog.wtf(TAG, e);
        }
    }

    void updatePowerRequestFromBatterySaverPolicy(DisplayManagerInternal.DisplayPowerRequest displayPowerRequest) {
        PowerSaveState state = this.mBatterySaverPolicy.getBatterySaverPolicy(7, this.mLowPowerModeEnabled);
        displayPowerRequest.lowPowerMode = state.batterySaverEnabled;
        displayPowerRequest.screenLowPowerBrightnessFactor = state.brightnessFactor;
    }

    void setStayOnSettingInternal(int val) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "stay_on_while_plugged_in", val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaximumScreenOffTimeoutFromDeviceAdminInternal(int timeMs) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMaximumScreenOffTimeoutFromDeviceAdmin = timeMs;
            this.mDirty |= 0x20;
            this.updatePowerStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setDeviceIdleModeInternal(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDeviceIdleMode == enabled) {
                return false;
            }
            this.mDeviceIdleMode = enabled;
            this.updateWakeLockDisabledStatesLocked();
        }
        if (enabled) {
            EventLogTags.writeDeviceIdleOnPhase("power");
        } else {
            EventLogTags.writeDeviceIdleOffPhase("power");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setLightDeviceIdleModeInternal(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLightDeviceIdleMode != enabled) {
                this.mLightDeviceIdleMode = enabled;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDeviceIdleWhitelistInternal(int[] appids) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDeviceIdleWhitelist = appids;
            if (this.mDeviceIdleMode) {
                this.updateWakeLockDisabledStatesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDeviceIdleTempWhitelistInternal(int[] appids) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDeviceIdleTempWhitelist = appids;
            if (this.mDeviceIdleMode) {
                this.updateWakeLockDisabledStatesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startUidChangesInternal() {
        Object object = this.mLock;
        synchronized (object) {
            this.mUidsChanging = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUidChangesInternal() {
        Object object = this.mLock;
        synchronized (object) {
            this.mUidsChanging = false;
            if (this.mUidsChanged) {
                this.updateWakeLockDisabledStatesLocked();
                this.mUidsChanged = false;
            }
        }
    }

    private void handleUidStateChangeLocked() {
        if (this.mUidsChanging) {
            this.mUidsChanged = true;
        } else {
            this.updateWakeLockDisabledStatesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUidProcStateInternal(int uid, int procState) {
        Object object = this.mLock;
        synchronized (object) {
            UidState state = this.mUidState.get(uid);
            if (state == null) {
                state = new UidState(uid);
                this.mUidState.put(uid, state);
            }
            boolean oldShouldAllow = state.mProcState <= 12;
            state.mProcState = procState;
            if (state.mNumWakeLocks > 0) {
                if (this.mDeviceIdleMode) {
                    this.handleUidStateChangeLocked();
                } else if (!state.mActive && oldShouldAllow != procState <= 12) {
                    this.handleUidStateChangeLocked();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uidGoneInternal(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mUidState.indexOfKey(uid);
            if (index >= 0) {
                UidState state = this.mUidState.valueAt(index);
                state.mProcState = 18;
                state.mActive = false;
                this.mUidState.removeAt(index);
                if (this.mDeviceIdleMode && state.mNumWakeLocks > 0) {
                    this.handleUidStateChangeLocked();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uidActiveInternal(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            UidState state = this.mUidState.get(uid);
            if (state == null) {
                state = new UidState(uid);
                state.mProcState = 17;
                this.mUidState.put(uid, state);
            }
            state.mActive = true;
            if (state.mNumWakeLocks > 0) {
                this.handleUidStateChangeLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uidIdleInternal(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            UidState state = this.mUidState.get(uid);
            if (state != null) {
                state.mActive = false;
                if (state.mNumWakeLocks > 0) {
                    this.handleUidStateChangeLocked();
                }
            }
        }
    }

    private void updateWakeLockDisabledStatesLocked() {
        boolean changed = false;
        int numWakeLocks = this.mWakeLocks.size();
        for (int i = 0; i < numWakeLocks; ++i) {
            WakeLock wakeLock = this.mWakeLocks.get(i);
            if ((wakeLock.mFlags & 0xFFFF) != 1 || !this.setWakeLockDisabledStateLocked(wakeLock)) continue;
            changed = true;
            if (wakeLock.mDisabled) {
                this.notifyWakeLockReleasedLocked(wakeLock);
                continue;
            }
            this.notifyWakeLockAcquiredLocked(wakeLock);
        }
        if (changed) {
            this.mDirty |= 1;
            this.updatePowerStateLocked();
        }
    }

    private boolean setWakeLockDisabledStateLocked(WakeLock wakeLock) {
        if ((wakeLock.mFlags & 0xFFFF) == 1) {
            boolean disabled = false;
            int appid = UserHandle.getAppId(wakeLock.mOwnerUid);
            if (appid >= 10000) {
                if (this.mDeviceIdleMode) {
                    UidState state = wakeLock.mUidState;
                    if (Arrays.binarySearch(this.mDeviceIdleWhitelist, appid) < 0 && Arrays.binarySearch(this.mDeviceIdleTempWhitelist, appid) < 0 && state.mProcState != 18 && state.mProcState > 4) {
                        disabled = true;
                    }
                } else if (this.mConstants.NO_CACHED_WAKE_LOCKS) {
                    boolean bl = disabled = !wakeLock.mUidState.mActive && wakeLock.mUidState.mProcState != 18 && wakeLock.mUidState.mProcState > 12;
                }
            }
            if (wakeLock.mDisabled != disabled) {
                wakeLock.mDisabled = disabled;
                return true;
            }
        }
        return false;
    }

    private boolean isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked() {
        return this.mMaximumScreenOffTimeoutFromDeviceAdmin >= 0 && this.mMaximumScreenOffTimeoutFromDeviceAdmin < Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttentionLightInternal(boolean on, int color2) {
        Light light;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mSystemReady) {
                return;
            }
            light = this.mAttentionLight;
        }
        light.setFlashing(color2, 2, on ? 3 : 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void boostScreenBrightnessInternal(long eventTime, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mSystemReady || this.mWakefulness == 0 || eventTime < this.mLastScreenBrightnessBoostTime) {
                return;
            }
            Slog.i(TAG, "Brightness boost activated (uid " + uid + ")...");
            this.mLastScreenBrightnessBoostTime = eventTime;
            if (!this.mScreenBrightnessBoostInProgress) {
                this.mScreenBrightnessBoostInProgress = true;
                this.mNotifier.onScreenBrightnessBoostChanged();
            }
            this.mDirty |= 0x800;
            this.userActivityNoUpdateLocked(eventTime, 0, 0, uid);
            this.updatePowerStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isScreenBrightnessBoostedInternal() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mScreenBrightnessBoostInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleScreenBrightnessBoostTimeout() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDirty |= 0x800;
            this.updatePowerStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScreenBrightnessOverrideFromWindowManagerInternal(int brightness) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mScreenBrightnessOverrideFromWindowManager != brightness) {
                this.mScreenBrightnessOverrideFromWindowManager = brightness;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserInactiveOverrideFromWindowManagerInternal() {
        Object object = this.mLock;
        synchronized (object) {
            this.mUserInactiveOverrideFromWindowManager = true;
            this.mDirty |= 4;
            this.updatePowerStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserActivityTimeoutOverrideFromWindowManagerInternal(long timeoutMillis) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserActivityTimeoutOverrideFromWindowManager != timeoutMillis) {
                this.mUserActivityTimeoutOverrideFromWindowManager = timeoutMillis;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTemporaryScreenBrightnessSettingOverrideInternal(int brightness) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTemporaryScreenBrightnessSettingOverride != brightness) {
                this.mTemporaryScreenBrightnessSettingOverride = brightness;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTemporaryScreenAutoBrightnessAdjustmentSettingOverrideInternal(float adj) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride != adj) {
                this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride = adj;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDozeOverrideFromDreamManagerInternal(int screenState, int screenBrightness) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDozeScreenStateOverrideFromDreamManager != screenState || this.mDozeScreenBrightnessOverrideFromDreamManager != screenBrightness) {
                this.mDozeScreenStateOverrideFromDreamManager = screenState;
                this.mDozeScreenBrightnessOverrideFromDreamManager = screenBrightness;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    private void powerHintInternal(int hintId, int data) {
        PowerManagerService.nativeSendPowerHint(hintId, data);
    }

    public static void lowLevelShutdown(String reason) {
        if (reason == null) {
            reason = "";
        }
        SystemProperties.set("sys.powerctl", "shutdown," + reason);
    }

    public static void lowLevelReboot(String reason) {
        if (reason == null) {
            reason = "";
        }
        if (reason.equals("quiescent")) {
            sQuiescent = true;
            reason = "";
        } else if (reason.endsWith(",quiescent")) {
            sQuiescent = true;
            reason = reason.substring(0, reason.length() - "quiescent".length() - 1);
        }
        if (reason.equals("recovery") || reason.equals("recovery-update")) {
            reason = "recovery";
        }
        if (sQuiescent) {
            reason = reason + ",quiescent";
        }
        SystemProperties.set("sys.powerctl", "reboot," + reason);
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Slog.wtf(TAG, "Unexpected return from lowLevelReboot!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        Object object = this.mLock;
        synchronized (object) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInternal(PrintWriter pw) {
        WirelessChargerDetector wcd;
        pw.println("POWER MANAGER (dumpsys power)\n");
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Power Manager State:");
            this.mConstants.dump(pw);
            pw.println("  mDirty=0x" + Integer.toHexString(this.mDirty));
            pw.println("  mWakefulness=" + PowerManagerInternal.wakefulnessToString(this.mWakefulness));
            pw.println("  mWakefulnessChanging=" + this.mWakefulnessChanging);
            pw.println("  mIsPowered=" + this.mIsPowered);
            pw.println("  mPlugType=" + this.mPlugType);
            pw.println("  mBatteryLevel=" + this.mBatteryLevel);
            pw.println("  mBatteryLevelWhenDreamStarted=" + this.mBatteryLevelWhenDreamStarted);
            pw.println("  mDockState=" + this.mDockState);
            pw.println("  mStayOn=" + this.mStayOn);
            pw.println("  mProximityPositive=" + this.mProximityPositive);
            pw.println("  mBootCompleted=" + this.mBootCompleted);
            pw.println("  mSystemReady=" + this.mSystemReady);
            pw.println("  mHalAutoSuspendModeEnabled=" + this.mHalAutoSuspendModeEnabled);
            pw.println("  mHalInteractiveModeEnabled=" + this.mHalInteractiveModeEnabled);
            pw.println("  mWakeLockSummary=0x" + Integer.toHexString(this.mWakeLockSummary));
            pw.print("  mNotifyLongScheduled=");
            if (this.mNotifyLongScheduled == 0L) {
                pw.print("(none)");
            } else {
                TimeUtils.formatDuration(this.mNotifyLongScheduled, SystemClock.uptimeMillis(), pw);
            }
            pw.println();
            pw.print("  mNotifyLongDispatched=");
            if (this.mNotifyLongDispatched == 0L) {
                pw.print("(none)");
            } else {
                TimeUtils.formatDuration(this.mNotifyLongDispatched, SystemClock.uptimeMillis(), pw);
            }
            pw.println();
            pw.print("  mNotifyLongNextCheck=");
            if (this.mNotifyLongNextCheck == 0L) {
                pw.print("(none)");
            } else {
                TimeUtils.formatDuration(this.mNotifyLongNextCheck, SystemClock.uptimeMillis(), pw);
            }
            pw.println();
            pw.println("  mUserActivitySummary=0x" + Integer.toHexString(this.mUserActivitySummary));
            pw.println("  mRequestWaitForNegativeProximity=" + this.mRequestWaitForNegativeProximity);
            pw.println("  mSandmanScheduled=" + this.mSandmanScheduled);
            pw.println("  mSandmanSummoned=" + this.mSandmanSummoned);
            pw.println("  mLowPowerModeEnabled=" + this.mLowPowerModeEnabled);
            pw.println("  mBatteryLevelLow=" + this.mBatteryLevelLow);
            pw.println("  mLightDeviceIdleMode=" + this.mLightDeviceIdleMode);
            pw.println("  mDeviceIdleMode=" + this.mDeviceIdleMode);
            pw.println("  mDeviceIdleWhitelist=" + Arrays.toString(this.mDeviceIdleWhitelist));
            pw.println("  mDeviceIdleTempWhitelist=" + Arrays.toString(this.mDeviceIdleTempWhitelist));
            pw.println("  mLastWakeTime=" + TimeUtils.formatUptime(this.mLastWakeTime));
            pw.println("  mLastSleepTime=" + TimeUtils.formatUptime(this.mLastSleepTime));
            pw.println("  mLastUserActivityTime=" + TimeUtils.formatUptime(this.mLastUserActivityTime));
            pw.println("  mLastUserActivityTimeNoChangeLights=" + TimeUtils.formatUptime(this.mLastUserActivityTimeNoChangeLights));
            pw.println("  mLastInteractivePowerHintTime=" + TimeUtils.formatUptime(this.mLastInteractivePowerHintTime));
            pw.println("  mLastScreenBrightnessBoostTime=" + TimeUtils.formatUptime(this.mLastScreenBrightnessBoostTime));
            pw.println("  mScreenBrightnessBoostInProgress=" + this.mScreenBrightnessBoostInProgress);
            pw.println("  mDisplayReady=" + this.mDisplayReady);
            pw.println("  mHoldingWakeLockSuspendBlocker=" + this.mHoldingWakeLockSuspendBlocker);
            pw.println("  mHoldingDisplaySuspendBlocker=" + this.mHoldingDisplaySuspendBlocker);
            pw.println();
            pw.println("Settings and Configuration:");
            pw.println("  mDecoupleHalAutoSuspendModeFromDisplayConfig=" + this.mDecoupleHalAutoSuspendModeFromDisplayConfig);
            pw.println("  mDecoupleHalInteractiveModeFromDisplayConfig=" + this.mDecoupleHalInteractiveModeFromDisplayConfig);
            pw.println("  mWakeUpWhenPluggedOrUnpluggedConfig=" + this.mWakeUpWhenPluggedOrUnpluggedConfig);
            pw.println("  mWakeUpWhenPluggedOrUnpluggedInTheaterModeConfig=" + this.mWakeUpWhenPluggedOrUnpluggedInTheaterModeConfig);
            pw.println("  mTheaterModeEnabled=" + this.mTheaterModeEnabled);
            pw.println("  mSuspendWhenScreenOffDueToProximityConfig=" + this.mSuspendWhenScreenOffDueToProximityConfig);
            pw.println("  mDreamsSupportedConfig=" + this.mDreamsSupportedConfig);
            pw.println("  mDreamsEnabledByDefaultConfig=" + this.mDreamsEnabledByDefaultConfig);
            pw.println("  mDreamsActivatedOnSleepByDefaultConfig=" + this.mDreamsActivatedOnSleepByDefaultConfig);
            pw.println("  mDreamsActivatedOnDockByDefaultConfig=" + this.mDreamsActivatedOnDockByDefaultConfig);
            pw.println("  mDreamsEnabledOnBatteryConfig=" + this.mDreamsEnabledOnBatteryConfig);
            pw.println("  mDreamsBatteryLevelMinimumWhenPoweredConfig=" + this.mDreamsBatteryLevelMinimumWhenPoweredConfig);
            pw.println("  mDreamsBatteryLevelMinimumWhenNotPoweredConfig=" + this.mDreamsBatteryLevelMinimumWhenNotPoweredConfig);
            pw.println("  mDreamsBatteryLevelDrainCutoffConfig=" + this.mDreamsBatteryLevelDrainCutoffConfig);
            pw.println("  mDreamsEnabledSetting=" + this.mDreamsEnabledSetting);
            pw.println("  mDreamsActivateOnSleepSetting=" + this.mDreamsActivateOnSleepSetting);
            pw.println("  mDreamsActivateOnDockSetting=" + this.mDreamsActivateOnDockSetting);
            pw.println("  mDozeAfterScreenOffConfig=" + this.mDozeAfterScreenOffConfig);
            pw.println("  mLowPowerModeSetting=" + this.mLowPowerModeSetting);
            pw.println("  mAutoLowPowerModeConfigured=" + this.mAutoLowPowerModeConfigured);
            pw.println("  mAutoLowPowerModeSnoozing=" + this.mAutoLowPowerModeSnoozing);
            pw.println("  mMinimumScreenOffTimeoutConfig=" + this.mMinimumScreenOffTimeoutConfig);
            pw.println("  mMaximumScreenDimDurationConfig=" + this.mMaximumScreenDimDurationConfig);
            pw.println("  mMaximumScreenDimRatioConfig=" + this.mMaximumScreenDimRatioConfig);
            pw.println("  mScreenOffTimeoutSetting=" + this.mScreenOffTimeoutSetting);
            pw.println("  mSleepTimeoutSetting=" + this.mSleepTimeoutSetting);
            pw.println("  mMaximumScreenOffTimeoutFromDeviceAdmin=" + this.mMaximumScreenOffTimeoutFromDeviceAdmin + " (enforced=" + this.isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked() + ")");
            pw.println("  mStayOnWhilePluggedInSetting=" + this.mStayOnWhilePluggedInSetting);
            pw.println("  mScreenBrightnessSetting=" + this.mScreenBrightnessSetting);
            pw.println("  mScreenAutoBrightnessAdjustmentSetting=" + this.mScreenAutoBrightnessAdjustmentSetting);
            pw.println("  mScreenBrightnessModeSetting=" + this.mScreenBrightnessModeSetting);
            pw.println("  mScreenBrightnessOverrideFromWindowManager=" + this.mScreenBrightnessOverrideFromWindowManager);
            pw.println("  mUserActivityTimeoutOverrideFromWindowManager=" + this.mUserActivityTimeoutOverrideFromWindowManager);
            pw.println("  mUserInactiveOverrideFromWindowManager=" + this.mUserInactiveOverrideFromWindowManager);
            pw.println("  mTemporaryScreenBrightnessSettingOverride=" + this.mTemporaryScreenBrightnessSettingOverride);
            pw.println("  mTemporaryScreenAutoBrightnessAdjustmentSettingOverride=" + this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride);
            pw.println("  mDozeScreenStateOverrideFromDreamManager=" + this.mDozeScreenStateOverrideFromDreamManager);
            pw.println("  mDozeScreenBrightnessOverrideFromDreamManager=" + this.mDozeScreenBrightnessOverrideFromDreamManager);
            pw.println("  mScreenBrightnessSettingMinimum=" + this.mScreenBrightnessSettingMinimum);
            pw.println("  mScreenBrightnessSettingMaximum=" + this.mScreenBrightnessSettingMaximum);
            pw.println("  mScreenBrightnessSettingDefault=" + this.mScreenBrightnessSettingDefault);
            pw.println("  mScreenBrightnessForVrSettingDefault=" + this.mScreenBrightnessForVrSettingDefault);
            pw.println("  mScreenBrightnessForVrSetting=" + this.mScreenBrightnessForVrSetting);
            pw.println("  mDoubleTapWakeEnabled=" + this.mDoubleTapWakeEnabled);
            pw.println("  mIsVrModeEnabled=" + this.mIsVrModeEnabled);
            int sleepTimeout = this.getSleepTimeoutLocked();
            int screenOffTimeout = this.getScreenOffTimeoutLocked(sleepTimeout);
            int screenDimDuration = this.getScreenDimDurationLocked(screenOffTimeout);
            pw.println();
            pw.println("Sleep timeout: " + sleepTimeout + " ms");
            pw.println("Screen off timeout: " + screenOffTimeout + " ms");
            pw.println("Screen dim duration: " + screenDimDuration + " ms");
            pw.println();
            pw.print("UID states (changing=");
            pw.print(this.mUidsChanging);
            pw.print(" changed=");
            pw.print(this.mUidsChanged);
            pw.println("):");
            for (int i = 0; i < this.mUidState.size(); ++i) {
                UidState state = this.mUidState.valueAt(i);
                pw.print("  UID ");
                UserHandle.formatUid(pw, this.mUidState.keyAt(i));
                pw.print(": ");
                if (state.mActive) {
                    pw.print("  ACTIVE ");
                } else {
                    pw.print("INACTIVE ");
                }
                pw.print(" count=");
                pw.print(state.mNumWakeLocks);
                pw.print(" state=");
                pw.println(state.mProcState);
            }
            pw.println();
            pw.println("Looper state:");
            this.mHandler.getLooper().dump(new PrintWriterPrinter(pw), "  ");
            pw.println();
            pw.println("Wake Locks: size=" + this.mWakeLocks.size());
            for (WakeLock wl : this.mWakeLocks) {
                pw.println("  " + wl);
            }
            pw.println();
            pw.println("Suspend Blockers: size=" + this.mSuspendBlockers.size());
            for (SuspendBlocker sb : this.mSuspendBlockers) {
                pw.println("  " + sb);
            }
            pw.println();
            pw.println("Display Power: " + this.mDisplayPowerCallbacks);
            this.mBatterySaverPolicy.dump(pw);
            wcd = this.mWirelessChargerDetector;
        }
        if (wcd != null) {
            wcd.dump(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpProto(FileDescriptor fd) {
        WirelessChargerDetector wcd;
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        Object object = this.mLock;
        synchronized (object) {
            this.mConstants.dumpProto(proto);
            proto.write(1112396529666L, this.mDirty);
            proto.write(0x11000000003L, this.mWakefulness);
            proto.write(1155346202628L, this.mWakefulnessChanging);
            proto.write(1155346202629L, this.mIsPowered);
            proto.write(0x11000000006L, this.mPlugType);
            proto.write(1112396529671L, this.mBatteryLevel);
            proto.write(1112396529672L, this.mBatteryLevelWhenDreamStarted);
            proto.write(0x11000000009L, this.mDockState);
            proto.write(1155346202634L, this.mStayOn);
            proto.write(1155346202635L, this.mProximityPositive);
            proto.write(1155346202636L, this.mBootCompleted);
            proto.write(0x10D0000000DL, this.mSystemReady);
            proto.write(1155346202638L, this.mHalAutoSuspendModeEnabled);
            proto.write(1155346202639L, this.mHalInteractiveModeEnabled);
            long activeWakeLocksToken = proto.start(0x11100000010L);
            proto.write(0x10D00000001L, (this.mWakeLockSummary & 1) != 0);
            proto.write(1155346202626L, (this.mWakeLockSummary & 2) != 0);
            proto.write(1155346202627L, (this.mWakeLockSummary & 4) != 0);
            proto.write(1155346202628L, (this.mWakeLockSummary & 8) != 0);
            proto.write(1155346202629L, (this.mWakeLockSummary & 0x10) != 0);
            proto.write(1155346202630L, (this.mWakeLockSummary & 0x20) != 0);
            proto.write(1155346202631L, (this.mWakeLockSummary & 0x40) != 0);
            proto.write(1155346202632L, (this.mWakeLockSummary & 0x80) != 0);
            proto.end(activeWakeLocksToken);
            proto.write(0x10400000011L, this.mNotifyLongScheduled);
            proto.write(1116691496978L, this.mNotifyLongDispatched);
            proto.write(1116691496979L, this.mNotifyLongNextCheck);
            long userActivityToken = proto.start(0x11100000014L);
            proto.write(0x10D00000001L, (this.mUserActivitySummary & 1) != 0);
            proto.write(1155346202626L, (this.mUserActivitySummary & 2) != 0);
            proto.write(1155346202627L, (this.mUserActivitySummary & 4) != 0);
            proto.end(userActivityToken);
            proto.write(1155346202645L, this.mRequestWaitForNegativeProximity);
            proto.write(1155346202646L, this.mSandmanScheduled);
            proto.write(1155346202647L, this.mSandmanSummoned);
            proto.write(1155346202648L, this.mLowPowerModeEnabled);
            proto.write(1155346202649L, this.mBatteryLevelLow);
            proto.write(1155346202650L, this.mLightDeviceIdleMode);
            proto.write(1155346202651L, this.mDeviceIdleMode);
            for (int id2 : this.mDeviceIdleWhitelist) {
                proto.write(2211908157468L, id2);
            }
            for (int id2 : this.mDeviceIdleTempWhitelist) {
                proto.write(2211908157469L, id2);
            }
            proto.write(1116691496990L, this.mLastWakeTime);
            proto.write(1116691496991L, this.mLastSleepTime);
            proto.write(1116691496992L, this.mLastUserActivityTime);
            proto.write(1116691496993L, this.mLastUserActivityTimeNoChangeLights);
            proto.write(1116691496994L, this.mLastInteractivePowerHintTime);
            proto.write(1116691496995L, this.mLastScreenBrightnessBoostTime);
            proto.write(1155346202660L, this.mScreenBrightnessBoostInProgress);
            proto.write(1155346202661L, this.mDisplayReady);
            proto.write(1155346202662L, this.mHoldingWakeLockSuspendBlocker);
            proto.write(1155346202663L, this.mHoldingDisplaySuspendBlocker);
            long settingsAndConfigurationToken = proto.start(1172526071848L);
            proto.write(0x10D00000001L, this.mDecoupleHalAutoSuspendModeFromDisplayConfig);
            proto.write(1155346202626L, this.mDecoupleHalInteractiveModeFromDisplayConfig);
            proto.write(1155346202627L, this.mWakeUpWhenPluggedOrUnpluggedConfig);
            proto.write(1155346202628L, this.mWakeUpWhenPluggedOrUnpluggedInTheaterModeConfig);
            proto.write(1155346202629L, this.mTheaterModeEnabled);
            proto.write(1155346202630L, this.mSuspendWhenScreenOffDueToProximityConfig);
            proto.write(1155346202631L, this.mDreamsSupportedConfig);
            proto.write(1155346202632L, this.mDreamsEnabledByDefaultConfig);
            proto.write(1155346202633L, this.mDreamsActivatedOnSleepByDefaultConfig);
            proto.write(1155346202634L, this.mDreamsActivatedOnDockByDefaultConfig);
            proto.write(1155346202635L, this.mDreamsEnabledOnBatteryConfig);
            proto.write(1129576398860L, this.mDreamsBatteryLevelMinimumWhenPoweredConfig);
            proto.write(1129576398861L, this.mDreamsBatteryLevelMinimumWhenNotPoweredConfig);
            proto.write(1129576398862L, this.mDreamsBatteryLevelDrainCutoffConfig);
            proto.write(1155346202639L, this.mDreamsEnabledSetting);
            proto.write(0x10D00000010L, this.mDreamsActivateOnSleepSetting);
            proto.write(0x10D00000011L, this.mDreamsActivateOnDockSetting);
            proto.write(1155346202642L, this.mDozeAfterScreenOffConfig);
            proto.write(1155346202643L, this.mLowPowerModeSetting);
            proto.write(1155346202644L, this.mAutoLowPowerModeConfigured);
            proto.write(1155346202645L, this.mAutoLowPowerModeSnoozing);
            proto.write(1112396529686L, this.mMinimumScreenOffTimeoutConfig);
            proto.write(1112396529687L, this.mMaximumScreenDimDurationConfig);
            proto.write(1108101562392L, this.mMaximumScreenDimRatioConfig);
            proto.write(1112396529689L, this.mScreenOffTimeoutSetting);
            proto.write(1129576398874L, this.mSleepTimeoutSetting);
            proto.write(1112396529691L, this.mMaximumScreenOffTimeoutFromDeviceAdmin);
            proto.write(1155346202652L, this.isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked());
            long stayOnWhilePluggedInToken = proto.start(0x1110000001DL);
            proto.write(0x10D00000001L, (this.mStayOnWhilePluggedInSetting & 1) != 0);
            proto.write(1155346202626L, (this.mStayOnWhilePluggedInSetting & 2) != 0);
            proto.write(1155346202627L, (this.mStayOnWhilePluggedInSetting & 4) != 0);
            proto.end(stayOnWhilePluggedInToken);
            proto.write(1129576398878L, this.mScreenBrightnessSetting);
            proto.write(1108101562399L, this.mScreenAutoBrightnessAdjustmentSetting);
            proto.write(0x11000000020L, this.mScreenBrightnessModeSetting);
            proto.write(1129576398881L, this.mScreenBrightnessOverrideFromWindowManager);
            proto.write(1133871366178L, this.mUserActivityTimeoutOverrideFromWindowManager);
            proto.write(1155346202659L, this.mUserInactiveOverrideFromWindowManager);
            proto.write(1129576398884L, this.mTemporaryScreenBrightnessSettingOverride);
            proto.write(1108101562405L, this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride);
            proto.write(1168231104550L, this.mDozeScreenStateOverrideFromDreamManager);
            proto.write(1108101562407L, this.mDozeScreenBrightnessOverrideFromDreamManager);
            long screenBrightnessSettingLimitsToken = proto.start(1172526071848L);
            proto.write(0x10300000001L, this.mScreenBrightnessSettingMinimum);
            proto.write(1112396529666L, this.mScreenBrightnessSettingMaximum);
            proto.write(0x10300000003L, this.mScreenBrightnessSettingDefault);
            proto.write(1112396529668L, this.mScreenBrightnessForVrSettingDefault);
            proto.end(screenBrightnessSettingLimitsToken);
            proto.write(1112396529705L, this.mScreenBrightnessForVrSetting);
            proto.write(1155346202666L, this.mDoubleTapWakeEnabled);
            proto.write(1155346202667L, this.mIsVrModeEnabled);
            proto.end(settingsAndConfigurationToken);
            int sleepTimeout = this.getSleepTimeoutLocked();
            int screenOffTimeout = this.getScreenOffTimeoutLocked(sleepTimeout);
            int screenDimDuration = this.getScreenDimDurationLocked(screenOffTimeout);
            proto.write(1129576398889L, sleepTimeout);
            proto.write(1112396529706L, screenOffTimeout);
            proto.write(1112396529707L, screenDimDuration);
            proto.write(1155346202668L, this.mUidsChanging);
            proto.write(1155346202669L, this.mUidsChanged);
            for (int i = 0; i < this.mUidState.size(); ++i) {
                UidState state = this.mUidState.valueAt(i);
                long uIDToken = proto.start(2272037699630L);
                int uid = this.mUidState.keyAt(i);
                proto.write(0x10300000001L, uid);
                proto.write(1159641169922L, UserHandle.formatUid(uid));
                proto.write(1155346202627L, state.mActive);
                proto.write(1112396529668L, state.mNumWakeLocks);
                if (state.mProcState == -1) {
                    proto.write(1155346202629L, true);
                } else {
                    proto.write(0x11000000006L, state.mProcState);
                }
                proto.end(uIDToken);
            }
            this.mHandler.getLooper().writeToProto(proto, 1172526071855L);
            for (WakeLock wl : this.mWakeLocks) {
                wl.writeToProto(proto, 2272037699632L);
            }
            for (SuspendBlocker sb : this.mSuspendBlockers) {
                sb.writeToProto(proto, 2272037699633L);
            }
            wcd = this.mWirelessChargerDetector;
        }
        if (wcd != null) {
            wcd.writeToProto(proto, 1172526071858L);
        }
        proto.flush();
    }

    private SuspendBlocker createSuspendBlockerLocked(String name) {
        SuspendBlockerImpl suspendBlocker = new SuspendBlockerImpl(name);
        this.mSuspendBlockers.add(suspendBlocker);
        return suspendBlocker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementBootCount() {
        Object object = this.mLock;
        synchronized (object) {
            int count;
            try {
                count = Settings.Global.getInt(this.getContext().getContentResolver(), "boot_count");
            }
            catch (Settings.SettingNotFoundException e) {
                count = 0;
            }
            Settings.Global.putInt(this.getContext().getContentResolver(), "boot_count", count + 1);
        }
    }

    private static WorkSource copyWorkSource(WorkSource workSource) {
        return workSource != null ? new WorkSource(workSource) : null;
    }

    int getLastShutdownReasonInternal(File lastRebootReason) {
        String line = "";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(lastRebootReason));){
            line = bufferedReader.readLine();
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read last_reboot_reason file", e);
        }
        if (line == null) {
            return 0;
        }
        switch (line) {
            case "shutdown": {
                return 1;
            }
            case "reboot": {
                return 2;
            }
            case "userrequested": {
                return 3;
            }
            case "thermal-shutdown": {
                return 4;
            }
        }
        return 0;
    }

    private final class LocalService
    extends PowerManagerInternal {
        private LocalService() {
        }

        @Override
        public void setScreenBrightnessOverrideFromWindowManager(int screenBrightness) {
            if (screenBrightness < -1 || screenBrightness > 255) {
                screenBrightness = -1;
            }
            PowerManagerService.this.setScreenBrightnessOverrideFromWindowManagerInternal(screenBrightness);
        }

        @Override
        public void setDozeOverrideFromDreamManager(int screenState, int screenBrightness) {
            switch (screenState) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    screenState = 0;
                }
            }
            if (screenBrightness < -1 || screenBrightness > 255) {
                screenBrightness = -1;
            }
            PowerManagerService.this.setDozeOverrideFromDreamManagerInternal(screenState, screenBrightness);
        }

        @Override
        public void setUserInactiveOverrideFromWindowManager() {
            PowerManagerService.this.setUserInactiveOverrideFromWindowManagerInternal();
        }

        @Override
        public void setUserActivityTimeoutOverrideFromWindowManager(long timeoutMillis) {
            PowerManagerService.this.setUserActivityTimeoutOverrideFromWindowManagerInternal(timeoutMillis);
        }

        @Override
        public void setMaximumScreenOffTimeoutFromDeviceAdmin(int timeMs) {
            PowerManagerService.this.setMaximumScreenOffTimeoutFromDeviceAdminInternal(timeMs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PowerSaveState getLowPowerState(int serviceType) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                return PowerManagerService.this.mBatterySaverPolicy.getBatterySaverPolicy(serviceType, PowerManagerService.this.mLowPowerModeEnabled);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerLowPowerModeObserver(PowerManagerInternal.LowPowerModeListener listener) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.mLowPowerModeListeners.add(listener);
            }
        }

        @Override
        public boolean setDeviceIdleMode(boolean enabled) {
            return PowerManagerService.this.setDeviceIdleModeInternal(enabled);
        }

        @Override
        public boolean setLightDeviceIdleMode(boolean enabled) {
            return PowerManagerService.this.setLightDeviceIdleModeInternal(enabled);
        }

        @Override
        public void setDeviceIdleWhitelist(int[] appids) {
            PowerManagerService.this.setDeviceIdleWhitelistInternal(appids);
        }

        @Override
        public void setDeviceIdleTempWhitelist(int[] appids) {
            PowerManagerService.this.setDeviceIdleTempWhitelistInternal(appids);
        }

        @Override
        public void startUidChanges() {
            PowerManagerService.this.startUidChangesInternal();
        }

        @Override
        public void finishUidChanges() {
            PowerManagerService.this.finishUidChangesInternal();
        }

        @Override
        public void updateUidProcState(int uid, int procState) {
            PowerManagerService.this.updateUidProcStateInternal(uid, procState);
        }

        @Override
        public void uidGone(int uid) {
            PowerManagerService.this.uidGoneInternal(uid);
        }

        @Override
        public void uidActive(int uid) {
            PowerManagerService.this.uidActiveInternal(uid);
        }

        @Override
        public void uidIdle(int uid) {
            PowerManagerService.this.uidIdleInternal(uid);
        }

        @Override
        public void powerHint(int hintId, int data) {
            PowerManagerService.this.powerHintInternal(hintId, data);
        }
    }

    private final class BinderService
    extends IPowerManager.Stub {
        private BinderService() {
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new PowerManagerShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
        }

        @Override
        public void acquireWakeLockWithUid(IBinder lock, int flags, String tag, String packageName, int uid) {
            if (uid < 0) {
                uid = Binder.getCallingUid();
            }
            this.acquireWakeLock(lock, flags, tag, packageName, new WorkSource(uid), null);
        }

        @Override
        public void powerHint(int hintId, int data) {
            if (!PowerManagerService.this.mSystemReady) {
                return;
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            PowerManagerService.this.powerHintInternal(hintId, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acquireWakeLock(IBinder lock, int flags, String tag, String packageName, WorkSource ws, String historyTag) {
            if (lock == null) {
                throw new IllegalArgumentException("lock must not be null");
            }
            if (packageName == null) {
                throw new IllegalArgumentException("packageName must not be null");
            }
            PowerManager.validateWakeLockParameters(flags, tag);
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
            if ((flags & 0x40) != 0) {
                PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            }
            if (ws != null && ws.size() != 0) {
                PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.UPDATE_DEVICE_STATS", null);
            } else {
                ws = null;
            }
            int uid = Binder.getCallingUid();
            int pid = Binder.getCallingPid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.acquireWakeLockInternal(lock, flags, tag, packageName, ws, historyTag, uid, pid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseWakeLock(IBinder lock, int flags) {
            if (lock == null) {
                throw new IllegalArgumentException("lock must not be null");
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.releaseWakeLockInternal(lock, flags);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public void updateWakeLockUids(IBinder lock, int[] uids) {
            WorkSource ws = null;
            if (uids != null) {
                ws = new WorkSource();
                for (int i = 0; i < uids.length; ++i) {
                    ws.add(uids[i]);
                }
            }
            this.updateWakeLockWorkSource(lock, ws, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateWakeLockWorkSource(IBinder lock, WorkSource ws, String historyTag) {
            if (lock == null) {
                throw new IllegalArgumentException("lock must not be null");
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
            if (ws != null && ws.size() != 0) {
                PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.UPDATE_DEVICE_STATS", null);
            } else {
                ws = null;
            }
            int callingUid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.updateWakeLockWorkSourceInternal(lock, ws, historyTag, callingUid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isWakeLockLevelSupported(int level) {
            long ident = Binder.clearCallingIdentity();
            try {
                boolean bl = PowerManagerService.this.isWakeLockLevelSupportedInternal(level);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void userActivity(long eventTime, int event, int flags) {
            long now = SystemClock.uptimeMillis();
            if (PowerManagerService.this.mContext.checkCallingOrSelfPermission("android.permission.DEVICE_POWER") != 0 && PowerManagerService.this.mContext.checkCallingOrSelfPermission("android.permission.USER_ACTIVITY") != 0) {
                Object object = PowerManagerService.this.mLock;
                synchronized (object) {
                    if (now >= PowerManagerService.this.mLastWarningAboutUserActivityPermission + 300000L) {
                        PowerManagerService.this.mLastWarningAboutUserActivityPermission = now;
                        Slog.w(PowerManagerService.TAG, "Ignoring call to PowerManager.userActivity() because the caller does not have DEVICE_POWER or USER_ACTIVITY permission.  Please fix your app!   pid=" + Binder.getCallingPid() + " uid=" + Binder.getCallingUid());
                    }
                }
                return;
            }
            if (eventTime > now) {
                throw new IllegalArgumentException("event time must not be in the future");
            }
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.userActivityInternal(eventTime, event, flags, uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void wakeUp(long eventTime, String reason, String opPackageName) {
            if (eventTime > SystemClock.uptimeMillis()) {
                throw new IllegalArgumentException("event time must not be in the future");
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.wakeUpInternal(eventTime, reason, uid, opPackageName, uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goToSleep(long eventTime, int reason, int flags) {
            if (eventTime > SystemClock.uptimeMillis()) {
                throw new IllegalArgumentException("event time must not be in the future");
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.goToSleepInternal(eventTime, reason, flags, uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nap(long eventTime) {
            if (eventTime > SystemClock.uptimeMillis()) {
                throw new IllegalArgumentException("event time must not be in the future");
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.napInternal(eventTime, uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isInteractive() {
            long ident = Binder.clearCallingIdentity();
            try {
                boolean bl = PowerManagerService.this.isInteractiveInternal();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPowerSaveMode() {
            long ident = Binder.clearCallingIdentity();
            try {
                boolean bl = PowerManagerService.this.isLowPowerModeInternal();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PowerSaveState getPowerSaveState(int serviceType) {
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = PowerManagerService.this.mLock;
                synchronized (object) {
                    PowerSaveState powerSaveState = PowerManagerService.this.mBatterySaverPolicy.getBatterySaverPolicy(serviceType, PowerManagerService.this.isLowPowerModeInternal());
                    return powerSaveState;
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setPowerSaveMode(boolean mode) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                boolean bl = PowerManagerService.this.setLowPowerModeInternal(mode);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDeviceIdleMode() {
            long ident = Binder.clearCallingIdentity();
            try {
                boolean bl = PowerManagerService.this.isDeviceIdleModeInternal();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isLightDeviceIdleMode() {
            long ident = Binder.clearCallingIdentity();
            try {
                boolean bl = PowerManagerService.this.isLightDeviceIdleModeInternal();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getLastShutdownReason() {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                int n = PowerManagerService.this.getLastShutdownReasonInternal(new File(PowerManagerService.LAST_REBOOT_LOCATION));
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reboot(boolean confirm, String reason, boolean wait) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
            if ("recovery".equals(reason) || "recovery-update".equals(reason)) {
                PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.RECOVERY", null);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.shutdownOrRebootInternal(1, confirm, reason, wait);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rebootSafeMode(boolean confirm, boolean wait) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.shutdownOrRebootInternal(2, confirm, "safemode", wait);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown(boolean confirm, String reason, boolean wait) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.shutdownOrRebootInternal(0, confirm, reason, wait);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void crash(String message) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.crashInternal(message);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStayOnSetting(int val) {
            int uid = Binder.getCallingUid();
            if (uid != 0 && !Settings.checkAndNoteWriteSettingsOperation(PowerManagerService.this.mContext, uid, Settings.getPackageNameForUid(PowerManagerService.this.mContext, uid), true)) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.setStayOnSettingInternal(val);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTemporaryScreenBrightnessSettingOverride(int brightness) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.setTemporaryScreenBrightnessSettingOverrideInternal(brightness);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTemporaryScreenAutoBrightnessAdjustmentSettingOverride(float adj) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.setTemporaryScreenAutoBrightnessAdjustmentSettingOverrideInternal(adj);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttentionLight(boolean on, int color2) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.setAttentionLightInternal(on, color2);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void boostScreenBrightness(long eventTime) {
            if (eventTime > SystemClock.uptimeMillis()) {
                throw new IllegalArgumentException("event time must not be in the future");
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.boostScreenBrightnessInternal(eventTime, uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isScreenBrightnessBoosted() {
            long ident = Binder.clearCallingIdentity();
            try {
                boolean bl = PowerManagerService.this.isScreenBrightnessBoostedInternal();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(PowerManagerService.this.mContext, PowerManagerService.TAG, pw)) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            boolean isDumpProto = false;
            for (String arg : args) {
                if (!arg.equals("--proto")) continue;
                isDumpProto = true;
            }
            try {
                if (isDumpProto) {
                    PowerManagerService.this.dumpProto(fd);
                } else {
                    PowerManagerService.this.dumpInternal(pw);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    static final class UidState {
        final int mUid;
        int mNumWakeLocks;
        int mProcState;
        boolean mActive;

        UidState(int uid) {
            this.mUid = uid;
        }
    }

    private final class SuspendBlockerImpl
    implements SuspendBlocker {
        private final String mName;
        private final String mTraceName;
        private int mReferenceCount;

        public SuspendBlockerImpl(String name) {
            this.mName = name;
            this.mTraceName = "SuspendBlocker (" + name + ")";
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mReferenceCount != 0) {
                    Slog.wtf(PowerManagerService.TAG, "Suspend blocker \"" + this.mName + "\" was finalized without being released!");
                    this.mReferenceCount = 0;
                    PowerManagerService.nativeReleaseSuspendBlocker(this.mName);
                    Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                }
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acquire() {
            SuspendBlockerImpl suspendBlockerImpl = this;
            synchronized (suspendBlockerImpl) {
                ++this.mReferenceCount;
                if (this.mReferenceCount == 1) {
                    Trace.asyncTraceBegin(131072L, this.mTraceName, 0);
                    PowerManagerService.nativeAcquireSuspendBlocker(this.mName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            SuspendBlockerImpl suspendBlockerImpl = this;
            synchronized (suspendBlockerImpl) {
                --this.mReferenceCount;
                if (this.mReferenceCount == 0) {
                    PowerManagerService.nativeReleaseSuspendBlocker(this.mName);
                    Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                } else if (this.mReferenceCount < 0) {
                    Slog.wtf(PowerManagerService.TAG, "Suspend blocker \"" + this.mName + "\" was released without being acquired!", new Throwable());
                    this.mReferenceCount = 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            SuspendBlockerImpl suspendBlockerImpl = this;
            synchronized (suspendBlockerImpl) {
                return this.mName + ": ref count=" + this.mReferenceCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeToProto(ProtoOutputStream proto, long fieldId) {
            long sbToken = proto.start(fieldId);
            SuspendBlockerImpl suspendBlockerImpl = this;
            synchronized (suspendBlockerImpl) {
                proto.write(0x10E00000001L, this.mName);
                proto.write(1112396529666L, this.mReferenceCount);
            }
            proto.end(sbToken);
        }
    }

    private final class WakeLock
    implements IBinder.DeathRecipient {
        public final IBinder mLock;
        public int mFlags;
        public String mTag;
        public final String mPackageName;
        public WorkSource mWorkSource;
        public String mHistoryTag;
        public final int mOwnerUid;
        public final int mOwnerPid;
        public final UidState mUidState;
        public long mAcquireTime;
        public boolean mNotifiedAcquired;
        public boolean mNotifiedLong;
        public boolean mDisabled;

        public WakeLock(IBinder lock, int flags, String tag, String packageName, WorkSource workSource, String historyTag, int ownerUid, int ownerPid, UidState uidState) {
            this.mLock = lock;
            this.mFlags = flags;
            this.mTag = tag;
            this.mPackageName = packageName;
            this.mWorkSource = PowerManagerService.copyWorkSource(workSource);
            this.mHistoryTag = historyTag;
            this.mOwnerUid = ownerUid;
            this.mOwnerPid = ownerPid;
            this.mUidState = uidState;
        }

        @Override
        public void binderDied() {
            PowerManagerService.this.handleWakeLockDeath(this);
        }

        public boolean hasSameProperties(int flags, String tag, WorkSource workSource, int ownerUid, int ownerPid) {
            return this.mFlags == flags && this.mTag.equals(tag) && this.hasSameWorkSource(workSource) && this.mOwnerUid == ownerUid && this.mOwnerPid == ownerPid;
        }

        public void updateProperties(int flags, String tag, String packageName, WorkSource workSource, String historyTag, int ownerUid, int ownerPid) {
            if (!this.mPackageName.equals(packageName)) {
                throw new IllegalStateException("Existing wake lock package name changed: " + this.mPackageName + " to " + packageName);
            }
            if (this.mOwnerUid != ownerUid) {
                throw new IllegalStateException("Existing wake lock uid changed: " + this.mOwnerUid + " to " + ownerUid);
            }
            if (this.mOwnerPid != ownerPid) {
                throw new IllegalStateException("Existing wake lock pid changed: " + this.mOwnerPid + " to " + ownerPid);
            }
            this.mFlags = flags;
            this.mTag = tag;
            this.updateWorkSource(workSource);
            this.mHistoryTag = historyTag;
        }

        public boolean hasSameWorkSource(WorkSource workSource) {
            return Objects.equal(this.mWorkSource, workSource);
        }

        public void updateWorkSource(WorkSource workSource) {
            this.mWorkSource = PowerManagerService.copyWorkSource(workSource);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getLockLevelString());
            sb.append(" '");
            sb.append(this.mTag);
            sb.append("'");
            sb.append(this.getLockFlagsString());
            if (this.mDisabled) {
                sb.append(" DISABLED");
            }
            if (this.mNotifiedAcquired) {
                sb.append(" ACQ=");
                TimeUtils.formatDuration(this.mAcquireTime - SystemClock.uptimeMillis(), sb);
            }
            if (this.mNotifiedLong) {
                sb.append(" LONG");
            }
            sb.append(" (uid=");
            sb.append(this.mOwnerUid);
            if (this.mOwnerPid != 0) {
                sb.append(" pid=");
                sb.append(this.mOwnerPid);
            }
            if (this.mWorkSource != null) {
                sb.append(" ws=");
                sb.append(this.mWorkSource);
            }
            sb.append(")");
            return sb.toString();
        }

        public void writeToProto(ProtoOutputStream proto, long fieldId) {
            long wakeLockToken = proto.start(fieldId);
            proto.write(0x11000000001L, this.mFlags & 0xFFFF);
            proto.write(1159641169922L, this.mTag);
            long wakeLockFlagsToken = proto.start(0x11100000003L);
            proto.write(0x10D00000001L, (this.mFlags & 0x10000000) != 0);
            proto.write(1155346202626L, (this.mFlags & 0x20000000) != 0);
            proto.end(wakeLockFlagsToken);
            proto.write(1155346202628L, this.mDisabled);
            if (this.mNotifiedAcquired) {
                proto.write(1116691496965L, this.mAcquireTime);
            }
            proto.write(1155346202630L, this.mNotifiedLong);
            proto.write(1112396529671L, this.mOwnerUid);
            proto.write(1112396529672L, this.mOwnerPid);
            if (this.mWorkSource != null) {
                this.mWorkSource.writeToProto(proto, 0x11100000009L);
            }
            proto.end(wakeLockToken);
        }

        private String getLockLevelString() {
            switch (this.mFlags & 0xFFFF) {
                case 26: {
                    return "FULL_WAKE_LOCK                ";
                }
                case 10: {
                    return "SCREEN_BRIGHT_WAKE_LOCK       ";
                }
                case 6: {
                    return "SCREEN_DIM_WAKE_LOCK          ";
                }
                case 1: {
                    return "PARTIAL_WAKE_LOCK             ";
                }
                case 32: {
                    return "PROXIMITY_SCREEN_OFF_WAKE_LOCK";
                }
                case 64: {
                    return "DOZE_WAKE_LOCK                ";
                }
                case 128: {
                    return "DRAW_WAKE_LOCK                ";
                }
            }
            return "???                           ";
        }

        private String getLockFlagsString() {
            String result = "";
            if ((this.mFlags & 0x10000000) != 0) {
                result = result + " ACQUIRE_CAUSES_WAKEUP";
            }
            if ((this.mFlags & 0x20000000) != 0) {
                result = result + " ON_AFTER_RELEASE";
            }
            return result;
        }
    }

    private final class PowerManagerHandler
    extends Handler {
        public PowerManagerHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PowerManagerService.this.handleUserActivityTimeout();
                    break;
                }
                case 2: {
                    PowerManagerService.this.handleSandman();
                    break;
                }
                case 3: {
                    PowerManagerService.this.handleScreenBrightnessBoostTimeout();
                    break;
                }
                case 4: {
                    PowerManagerService.this.checkForLongWakeLocks();
                }
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.handleSettingsChangedLocked();
            }
        }
    }

    private final class DockReceiver
    extends BroadcastReceiver {
        private DockReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                int dockState = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                if (PowerManagerService.this.mDockState != dockState) {
                    PowerManagerService.this.mDockState = dockState;
                    PowerManagerService.this.mDirty = PowerManagerService.this.mDirty | 0x400;
                    PowerManagerService.this.updatePowerStateLocked();
                }
            }
        }
    }

    private final class UserSwitchedReceiver
    extends BroadcastReceiver {
        private UserSwitchedReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.handleSettingsChangedLocked();
            }
        }
    }

    private final class DreamReceiver
    extends BroadcastReceiver {
        private DreamReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.scheduleSandmanLocked();
            }
        }
    }

    private final class BatteryReceiver
    extends BroadcastReceiver {
        private BatteryReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.handleBatteryStateChangedLocked();
            }
        }
    }

    private final class Constants
    extends ContentObserver {
        private static final String KEY_NO_CACHED_WAKE_LOCKS = "no_cached_wake_locks";
        private static final boolean DEFAULT_NO_CACHED_WAKE_LOCKS = true;
        public boolean NO_CACHED_WAKE_LOCKS;
        private ContentResolver mResolver;
        private final KeyValueListParser mParser;

        public Constants(Handler handler) {
            super(handler);
            this.NO_CACHED_WAKE_LOCKS = true;
            this.mParser = new KeyValueListParser(',');
        }

        public void start(ContentResolver resolver) {
            this.mResolver = resolver;
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("power_manager_constants"), false, this);
            this.updateConstants();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConstants() {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                try {
                    this.mParser.setString(Settings.Global.getString(this.mResolver, "power_manager_constants"));
                }
                catch (IllegalArgumentException e) {
                    Slog.e(PowerManagerService.TAG, "Bad alarm manager settings", e);
                }
                this.NO_CACHED_WAKE_LOCKS = this.mParser.getBoolean(KEY_NO_CACHED_WAKE_LOCKS, true);
            }
        }

        void dump(PrintWriter pw) {
            pw.println("  Settings power_manager_constants:");
            pw.print("    ");
            pw.print(KEY_NO_CACHED_WAKE_LOCKS);
            pw.print("=");
            pw.println(this.NO_CACHED_WAKE_LOCKS);
        }

        void dumpProto(ProtoOutputStream proto) {
            long constantsToken = proto.start(0x11100000001L);
            proto.write(0x10D00000001L, this.NO_CACHED_WAKE_LOCKS);
            proto.end(constantsToken);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    public static @interface HaltMode {
    }
}

