/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.utils;

import java.io.FileDescriptor;
import java.io.PrintWriter;

public final class PriorityDump {
    public static final String PRIORITY_ARG = "--dump_priority";

    private PriorityDump() {
        throw new UnsupportedOperationException();
    }

    public static void dump(PriorityDumper dumper, FileDescriptor fd, PrintWriter pw, String[] args) {
        if (args != null && args.length >= 2 && args[0].equals(PRIORITY_ARG)) {
            String priority;
            switch (priority = args[1]) {
                case "CRITICAL": {
                    dumper.dumpCritical(fd, pw, PriorityDump.getStrippedArgs(args));
                    return;
                }
                case "HIGH": {
                    dumper.dumpHigh(fd, pw, PriorityDump.getStrippedArgs(args));
                    return;
                }
                case "NORMAL": {
                    dumper.dumpNormal(fd, pw, PriorityDump.getStrippedArgs(args));
                    return;
                }
            }
        }
        dumper.dump(fd, pw, args);
    }

    private static String[] getStrippedArgs(String[] args) {
        String[] stripped = new String[args.length - 2];
        System.arraycopy(args, 2, stripped, 0, stripped.length);
        return stripped;
    }

    public static interface PriorityDumper {
        default public void dumpCritical(FileDescriptor fd, PrintWriter pw, String[] args) {
        }

        default public void dumpHigh(FileDescriptor fd, PrintWriter pw, String[] args) {
        }

        default public void dumpNormal(FileDescriptor fd, PrintWriter pw, String[] args) {
        }

        default public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            this.dumpCritical(fd, pw, args);
            this.dumpHigh(fd, pw, args);
            this.dumpNormal(fd, pw, args);
        }
    }
}

