/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructGroupReq;
import android.system.StructGroupSourceReq;
import android.system.StructLinger;
import android.system.StructPollfd;
import android.system.StructTimeval;
import android.util.MutableInt;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.BindException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import libcore.io.AsynchronousCloseMonitor;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class IoBridge
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int JAVA_MCAST_JOIN_GROUP = 19;
    public static int JAVA_MCAST_LEAVE_GROUP = 20;
    public static int JAVA_MCAST_JOIN_SOURCE_GROUP = 21;
    public static int JAVA_MCAST_LEAVE_SOURCE_GROUP = 22;
    public static int JAVA_MCAST_BLOCK_SOURCE = 23;
    public static int JAVA_MCAST_UNBLOCK_SOURCE = 24;
    public static int JAVA_IP_MULTICAST_TTL = 17;
    public static int JAVA_IP_TTL = 25;

    private void $$robo$$libcore_io_IoBridge$__constructor__() {
    }

    private static final int $$robo$$libcore_io_IoBridge$available(FileDescriptor fd) throws IOException {
        try {
            MutableInt available = new MutableInt(0);
            Libcore.os.ioctlInt(fd, OsConstants.FIONREAD, available);
            if (available.value < 0) {
                available.value = 0;
            }
            return available.value;
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.ENOTTY) {
                return 0;
            }
            throw errnoException.rethrowAsIOException();
        }
    }

    private static final void $$robo$$libcore_io_IoBridge$bind(FileDescriptor fd, InetAddress address, int port) throws SocketException {
        Inet6Address inet6Address;
        if (address instanceof Inet6Address && (inet6Address = (Inet6Address)address).getScopeId() == 0 && inet6Address.isLinkLocalAddress()) {
            NetworkInterface nif = NetworkInterface.getByInetAddress(address);
            if (nif == null) {
                throw new SocketException("Can't bind to a link-local address without a scope id: " + address);
            }
            try {
                address = Inet6Address.getByAddress(address.getHostName(), address.getAddress(), nif.getIndex());
            }
            catch (UnknownHostException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        try {
            Libcore.os.bind(fd, address, port);
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.EADDRINUSE || errnoException.errno == OsConstants.EADDRNOTAVAIL || errnoException.errno == OsConstants.EPERM || errnoException.errno == OsConstants.EACCES) {
                throw new BindException(errnoException.getMessage(), (Throwable)errnoException);
            }
            throw new SocketException(errnoException.getMessage(), errnoException);
        }
    }

    private static final void $$robo$$libcore_io_IoBridge$connect(FileDescriptor fd, InetAddress inetAddress, int port) throws SocketException {
        try {
            IoBridge.connect(fd, inetAddress, port, 0);
        }
        catch (SocketTimeoutException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static final void $$robo$$libcore_io_IoBridge$connect(FileDescriptor fd, InetAddress inetAddress, int port, int timeoutMs) throws SocketException, SocketTimeoutException {
        try {
            IoBridge.connectErrno(fd, inetAddress, port, timeoutMs);
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.EHOSTUNREACH) {
                throw new NoRouteToHostException("Host unreachable");
            }
            if (errnoException.errno == OsConstants.EADDRNOTAVAIL) {
                throw new NoRouteToHostException("Address not available");
            }
            throw new ConnectException(IoBridge.connectDetail(fd, inetAddress, port, timeoutMs, errnoException), (Throwable)errnoException);
        }
        catch (SocketException ex) {
            throw ex;
        }
        catch (SocketTimeoutException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
    }

    private static final void $$robo$$libcore_io_IoBridge$connectErrno(FileDescriptor fd, InetAddress inetAddress, int port, int timeoutMs) throws ErrnoException, IOException {
        if (timeoutMs <= 0) {
            Libcore.os.connect(fd, inetAddress, port);
            return;
        }
        IoUtils.setBlocking(fd, false);
        reference var4_4 = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System") + TimeUnit.MILLISECONDS.toNanos(timeoutMs);
        try {
            Libcore.os.connect(fd, inetAddress, port);
            IoUtils.setBlocking(fd, true);
            return;
        }
        catch (ErrnoException errnoException) {
            int remainingTimeoutMs;
            if (errnoException.errno != OsConstants.EINPROGRESS) {
                throw errnoException;
            }
            do {
                if ((remainingTimeoutMs = (int)TimeUnit.NANOSECONDS.toMillis((long)(var4_4 - InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System")))) > 0) continue;
                throw new SocketTimeoutException(IoBridge.connectDetail(fd, inetAddress, port, timeoutMs, null));
            } while (!IoBridge.isConnected(fd, inetAddress, port, timeoutMs, remainingTimeoutMs));
            IoUtils.setBlocking(fd, true);
            return;
        }
    }

    private static final String $$robo$$libcore_io_IoBridge$connectDetail(FileDescriptor fd, InetAddress inetAddress, int port, int timeoutMs, Exception cause) {
        InetSocketAddress localAddress = null;
        try {
            localAddress = IoBridge.getLocalInetSocketAddress(fd);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder("failed to connect").append(" to ").append(inetAddress).append(" (port ").append(port).append(")");
        if (localAddress != null) {
            sb.append(" from ").append(localAddress.getAddress()).append(" (port ").append(localAddress.getPort()).append(")");
        }
        if (timeoutMs > 0) {
            sb.append(" after ").append(timeoutMs).append("ms");
        }
        if (cause != null) {
            sb.append(": ").append(cause.getMessage());
        }
        return sb.toString();
    }

    private static final void $$robo$$libcore_io_IoBridge$closeAndSignalBlockedThreads(FileDescriptor fd) throws IOException {
        if (fd == null || !fd.valid()) {
            return;
        }
        CallSite intFd = InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)fd);
        InvokeDynamicSupport.bootstrapIntrinsic("setInt$", "java.io.FileDescriptor", (FileDescriptor)fd, (int)-1);
        FileDescriptor oldFd = new FileDescriptor();
        InvokeDynamicSupport.bootstrapIntrinsic("setInt$", "java.io.FileDescriptor", (FileDescriptor)oldFd, (int)intFd);
        AsynchronousCloseMonitor.signalBlockedThreads(oldFd);
        try {
            Libcore.os.close(oldFd);
        }
        catch (ErrnoException errnoException) {
            // empty catch block
        }
    }

    private static final boolean $$robo$$libcore_io_IoBridge$isConnected(FileDescriptor fd, InetAddress inetAddress, int port, int timeoutMs, int remainingTimeoutMs) throws IOException {
        try {
            StructPollfd[] pollFds = new StructPollfd[]{new StructPollfd()};
            pollFds[0].fd = fd;
            pollFds[0].events = (short)OsConstants.POLLOUT;
            int rc = Libcore.os.poll(pollFds, remainingTimeoutMs);
            if (rc == 0) {
                return false;
            }
            int connectError = Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_ERROR);
            if (connectError == 0) {
                return true;
            }
            throw new ErrnoException("isConnected", connectError);
        }
        catch (ErrnoException errnoException) {
            if (!fd.valid()) {
                throw new SocketException("Socket closed");
            }
            ErrnoException cause = errnoException;
            String detail = IoBridge.connectDetail(fd, inetAddress, port, timeoutMs, cause);
            if (cause.errno == OsConstants.ETIMEDOUT) {
                throw new SocketTimeoutException(detail, (Throwable)cause);
            }
            throw new ConnectException(detail, (Throwable)cause);
        }
    }

    private static final Object $$robo$$libcore_io_IoBridge$getSocketOption(FileDescriptor fd, int option) throws SocketException {
        try {
            return IoBridge.getSocketOptionErrno(fd, option);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    private static final Object $$robo$$libcore_io_IoBridge$getSocketOptionErrno(FileDescriptor fd, int option) throws ErrnoException, SocketException {
        switch (option) {
            case 16: 
            case 31: {
                return Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_IF);
            }
            case 18: {
                return !IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_LOOP));
            }
            case 17: {
                return Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_HOPS);
            }
            case 25: {
                return Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_UNICAST_HOPS);
            }
            case 3: {
                return Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_TCLASS);
            }
            case 32: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_BROADCAST));
            }
            case 8: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_KEEPALIVE));
            }
            case 128: {
                StructLinger linger = Libcore.os.getsockoptLinger(fd, OsConstants.SOL_SOCKET, OsConstants.SO_LINGER);
                if (!linger.isOn()) {
                    return false;
                }
                return linger.l_linger;
            }
            case 4099: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_OOBINLINE));
            }
            case 4098: {
                return Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF);
            }
            case 4: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_REUSEADDR));
            }
            case 4097: {
                return Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDBUF);
            }
            case 4102: {
                return (int)Libcore.os.getsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO).toMillis();
            }
            case 1: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_TCP, OsConstants.TCP_NODELAY));
            }
            case 15: {
                return ((InetSocketAddress)Libcore.os.getsockname(fd)).getAddress();
            }
        }
        throw new SocketException("Unknown socket option: " + option);
    }

    private static final boolean $$robo$$libcore_io_IoBridge$booleanFromInt(int i) {
        return i != 0;
    }

    private static final int $$robo$$libcore_io_IoBridge$booleanToInt(boolean b) {
        return b ? 1 : 0;
    }

    private static final void $$robo$$libcore_io_IoBridge$setSocketOption(FileDescriptor fd, int option, Object value) throws SocketException {
        try {
            IoBridge.setSocketOptionErrno(fd, option, value);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    private static final void $$robo$$libcore_io_IoBridge$setSocketOptionErrno(FileDescriptor fd, int option, Object value) throws ErrnoException, SocketException {
        switch (option) {
            case 16: {
                NetworkInterface nif = NetworkInterface.getByInetAddress((InetAddress)value);
                if (nif == null) {
                    throw new SocketException("bad argument for IP_MULTICAST_IF : address not bound to any interface");
                }
                Libcore.os.setsockoptIpMreqn(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_IF, nif.getIndex());
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_IF, nif.getIndex());
                return;
            }
            case 31: {
                Libcore.os.setsockoptIpMreqn(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_IF, (Integer)value);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_IF, (Integer)value);
                return;
            }
            case 18: {
                int enable = IoBridge.booleanToInt((Boolean)value == false);
                Libcore.os.setsockoptByte(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_LOOP, enable);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_LOOP, enable);
                return;
            }
            case 17: {
                Libcore.os.setsockoptByte(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_TTL, (Integer)value);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_HOPS, (Integer)value);
                return;
            }
            case 25: {
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IP, OsConstants.IP_TTL, (Integer)value);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_UNICAST_HOPS, (Integer)value);
                return;
            }
            case 3: {
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IP, OsConstants.IP_TOS, (Integer)value);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_TCLASS, (Integer)value);
                return;
            }
            case 32: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_BROADCAST, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 8: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_KEEPALIVE, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 128: {
                boolean on = false;
                int seconds = 0;
                if (value instanceof Integer) {
                    on = true;
                    seconds = Math.min((Integer)value, 65535);
                }
                StructLinger linger = new StructLinger(IoBridge.booleanToInt(on), seconds);
                Libcore.os.setsockoptLinger(fd, OsConstants.SOL_SOCKET, OsConstants.SO_LINGER, linger);
                return;
            }
            case 4099: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_OOBINLINE, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 4098: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF, (Integer)value);
                return;
            }
            case 4: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_REUSEADDR, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 4097: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDBUF, (Integer)value);
                return;
            }
            case 4102: {
                int millis = (Integer)value;
                StructTimeval tv = StructTimeval.fromMillis(millis);
                Libcore.os.setsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO, tv);
                return;
            }
            case 1: {
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_TCP, OsConstants.TCP_NODELAY, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 19: 
            case 20: {
                StructGroupReq groupReq = (StructGroupReq)value;
                int level = groupReq.gr_group instanceof Inet4Address ? OsConstants.IPPROTO_IP : OsConstants.IPPROTO_IPV6;
                int op = option == 19 ? OsConstants.MCAST_JOIN_GROUP : OsConstants.MCAST_LEAVE_GROUP;
                Libcore.os.setsockoptGroupReq(fd, level, op, groupReq);
                return;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                StructGroupSourceReq groupSourceReq = (StructGroupSourceReq)value;
                int level = groupSourceReq.gsr_group instanceof Inet4Address ? OsConstants.IPPROTO_IP : OsConstants.IPPROTO_IPV6;
                int op = IoBridge.getGroupSourceReqOp(option);
                Libcore.os.setsockoptGroupSourceReq(fd, level, op, groupSourceReq);
                return;
            }
        }
        throw new SocketException("Unknown socket option: " + option);
    }

    private static final int $$robo$$libcore_io_IoBridge$getGroupSourceReqOp(int javaValue) {
        switch (javaValue) {
            case 21: {
                return OsConstants.MCAST_JOIN_SOURCE_GROUP;
            }
            case 22: {
                return OsConstants.MCAST_LEAVE_SOURCE_GROUP;
            }
            case 23: {
                return OsConstants.MCAST_BLOCK_SOURCE;
            }
            case 24: {
                return OsConstants.MCAST_UNBLOCK_SOURCE;
            }
        }
        throw new AssertionError((Object)("Unknown java value for setsocketopt op lookup: " + javaValue));
    }

    private static final FileDescriptor $$robo$$libcore_io_IoBridge$open(String path, int flags) throws FileNotFoundException {
        FileDescriptor fd = null;
        try {
            int mode = (flags & OsConstants.O_ACCMODE) == OsConstants.O_RDONLY ? 0 : 384;
            fd = Libcore.os.open(path, flags, mode);
            if (OsConstants.S_ISDIR(Libcore.os.fstat((FileDescriptor)fd).st_mode)) {
                throw new ErrnoException("open", OsConstants.EISDIR);
            }
            return fd;
        }
        catch (ErrnoException errnoException) {
            try {
                if (fd != null) {
                    IoUtils.close(fd);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileNotFoundException ex = new FileNotFoundException(path + ": " + errnoException.getMessage());
            ex.initCause(errnoException);
            throw ex;
        }
    }

    private static final int $$robo$$libcore_io_IoBridge$read(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws IOException {
        Arrays.checkOffsetAndCount((int)bytes.length, (int)byteOffset, (int)byteCount);
        if (byteCount == 0) {
            return 0;
        }
        try {
            int readCount = Libcore.os.read(fd, bytes, byteOffset, byteCount);
            if (readCount == 0) {
                return -1;
            }
            return readCount;
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.EAGAIN) {
                return 0;
            }
            throw errnoException.rethrowAsIOException();
        }
    }

    private static final void $$robo$$libcore_io_IoBridge$write(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws IOException {
        Arrays.checkOffsetAndCount((int)bytes.length, (int)byteOffset, (int)byteCount);
        if (byteCount == 0) {
            return;
        }
        try {
            while (byteCount > 0) {
                int bytesWritten = Libcore.os.write(fd, bytes, byteOffset, byteCount);
                byteCount -= bytesWritten;
                byteOffset += bytesWritten;
            }
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    private static final int $$robo$$libcore_io_IoBridge$sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetAddress inetAddress, int port) throws IOException {
        int result;
        boolean isDatagram;
        boolean bl = isDatagram = inetAddress != null;
        if (!isDatagram && byteCount <= 0) {
            return 0;
        }
        try {
            result = Libcore.os.sendto(fd, bytes, byteOffset, byteCount, flags, inetAddress, port);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterSendto(isDatagram, errnoException);
        }
        return result;
    }

    private static final int $$robo$$libcore_io_IoBridge$sendto(FileDescriptor fd, ByteBuffer buffer, int flags, InetAddress inetAddress, int port) throws IOException {
        int result;
        boolean isDatagram;
        boolean bl = isDatagram = inetAddress != null;
        if (!isDatagram && buffer.remaining() == 0) {
            return 0;
        }
        try {
            result = Libcore.os.sendto(fd, buffer, flags, inetAddress, port);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterSendto(isDatagram, errnoException);
        }
        return result;
    }

    private static final int $$robo$$libcore_io_IoBridge$maybeThrowAfterSendto(boolean isDatagram, ErrnoException errnoException) throws IOException {
        if (isDatagram) {
            if (errnoException.errno == OsConstants.ECONNREFUSED) {
                throw new PortUnreachableException("ICMP Port Unreachable");
            }
        } else if (errnoException.errno == OsConstants.EAGAIN) {
            return 0;
        }
        throw errnoException.rethrowAsIOException();
    }

    private static final int $$robo$$libcore_io_IoBridge$recvfrom(boolean isRead, FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, DatagramPacket packet, boolean isConnected) throws IOException {
        int result;
        try {
            InetSocketAddress srcAddress = packet != null ? new InetSocketAddress() : null;
            result = Libcore.os.recvfrom(fd, bytes, byteOffset, byteCount, flags, srcAddress);
            result = IoBridge.postRecvfrom(isRead, packet, srcAddress, result);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterRecvfrom(isRead, isConnected, errnoException);
        }
        return result;
    }

    private static final int $$robo$$libcore_io_IoBridge$recvfrom(boolean isRead, FileDescriptor fd, ByteBuffer buffer, int flags, DatagramPacket packet, boolean isConnected) throws IOException {
        int result;
        try {
            InetSocketAddress srcAddress = packet != null ? new InetSocketAddress() : null;
            result = Libcore.os.recvfrom(fd, buffer, flags, srcAddress);
            result = IoBridge.postRecvfrom(isRead, packet, srcAddress, result);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterRecvfrom(isRead, isConnected, errnoException);
        }
        return result;
    }

    private static final int $$robo$$libcore_io_IoBridge$postRecvfrom(boolean isRead, DatagramPacket packet, InetSocketAddress srcAddress, int byteCount) {
        if (isRead && byteCount == 0) {
            return -1;
        }
        if (packet != null) {
            packet.setReceivedLength(byteCount);
            packet.setPort(srcAddress.getPort());
            if (!srcAddress.getAddress().equals(packet.getAddress())) {
                packet.setAddress(srcAddress.getAddress());
            }
        }
        return byteCount;
    }

    private static final int $$robo$$libcore_io_IoBridge$maybeThrowAfterRecvfrom(boolean isRead, boolean isConnected, ErrnoException errnoException) throws SocketException, SocketTimeoutException {
        if (isRead) {
            if (errnoException.errno == OsConstants.EAGAIN) {
                return 0;
            }
            throw errnoException.rethrowAsSocketException();
        }
        if (isConnected && errnoException.errno == OsConstants.ECONNREFUSED) {
            throw new PortUnreachableException("ICMP Port Unreachable", (Throwable)errnoException);
        }
        if (errnoException.errno == OsConstants.EAGAIN) {
            throw new SocketTimeoutException((Throwable)errnoException);
        }
        throw errnoException.rethrowAsSocketException();
    }

    private static final FileDescriptor $$robo$$libcore_io_IoBridge$socket(int domain, int type, int protocol) throws SocketException {
        try {
            FileDescriptor fd = Libcore.os.socket(domain, type, protocol);
            return fd;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    private static final void $$robo$$libcore_io_IoBridge$poll(FileDescriptor fd, int events, int timeout) throws SocketException, SocketTimeoutException {
        StructPollfd[] pollFds = new StructPollfd[]{new StructPollfd()};
        pollFds[0].fd = fd;
        pollFds[0].events = (short)events;
        try {
            int ret = Os.poll(pollFds, timeout);
            if (ret == 0) {
                throw new SocketTimeoutException("Poll timed out");
            }
        }
        catch (ErrnoException e) {
            e.rethrowAsSocketException();
        }
    }

    private static final InetSocketAddress $$robo$$libcore_io_IoBridge$getLocalInetSocketAddress(FileDescriptor fd) throws SocketException {
        try {
            return (InetSocketAddress)Libcore.os.getsockname(fd);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    private void __constructor__() {
        this.$$robo$$libcore_io_IoBridge$__constructor__();
    }

    public IoBridge() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_IoBridge$__constructor__(), this);
    }

    public static int available(FileDescriptor fileDescriptor) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("available", $$robo$$libcore_io_IoBridge$available(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    public static void bind(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws SocketException {
        InvokeDynamicSupport.bootstrapStatic("bind", $$robo$$libcore_io_IoBridge$bind(java.io.FileDescriptor java.net.InetAddress int ), (FileDescriptor)fileDescriptor, (InetAddress)inetAddress, (int)n);
    }

    public static void connect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws SocketException {
        InvokeDynamicSupport.bootstrapStatic("connect", $$robo$$libcore_io_IoBridge$connect(java.io.FileDescriptor java.net.InetAddress int ), (FileDescriptor)fileDescriptor, (InetAddress)inetAddress, (int)n);
    }

    public static void connect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n, int n2) throws SocketException, SocketTimeoutException {
        InvokeDynamicSupport.bootstrapStatic("connect", $$robo$$libcore_io_IoBridge$connect(java.io.FileDescriptor java.net.InetAddress int int ), (FileDescriptor)fileDescriptor, (InetAddress)inetAddress, (int)n, (int)n2);
    }

    private static void connectErrno(FileDescriptor fileDescriptor, InetAddress inetAddress, int n, int n2) throws ErrnoException, IOException {
        InvokeDynamicSupport.bootstrapStatic("connectErrno", $$robo$$libcore_io_IoBridge$connectErrno(java.io.FileDescriptor java.net.InetAddress int int ), (FileDescriptor)fileDescriptor, (InetAddress)inetAddress, (int)n, (int)n2);
    }

    private static String connectDetail(FileDescriptor fileDescriptor, InetAddress inetAddress, int n, int n2, Exception exception) {
        return InvokeDynamicSupport.bootstrapStatic("connectDetail", $$robo$$libcore_io_IoBridge$connectDetail(java.io.FileDescriptor java.net.InetAddress int int java.lang.Exception ), (FileDescriptor)fileDescriptor, (InetAddress)inetAddress, (int)n, (int)n2, (Exception)exception);
    }

    public static void closeAndSignalBlockedThreads(FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("closeAndSignalBlockedThreads", $$robo$$libcore_io_IoBridge$closeAndSignalBlockedThreads(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    public static boolean isConnected(FileDescriptor fileDescriptor, InetAddress inetAddress, int n, int n2, int n3) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isConnected", $$robo$$libcore_io_IoBridge$isConnected(java.io.FileDescriptor java.net.InetAddress int int int ), (FileDescriptor)fileDescriptor, (InetAddress)inetAddress, (int)n, (int)n2, (int)n3);
    }

    public static Object getSocketOption(FileDescriptor fileDescriptor, int n) throws SocketException {
        return InvokeDynamicSupport.bootstrapStatic("getSocketOption", $$robo$$libcore_io_IoBridge$getSocketOption(java.io.FileDescriptor int ), (FileDescriptor)fileDescriptor, (int)n);
    }

    private static Object getSocketOptionErrno(FileDescriptor fileDescriptor, int n) throws ErrnoException, SocketException {
        return InvokeDynamicSupport.bootstrapStatic("getSocketOptionErrno", $$robo$$libcore_io_IoBridge$getSocketOptionErrno(java.io.FileDescriptor int ), (FileDescriptor)fileDescriptor, (int)n);
    }

    private static boolean booleanFromInt(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("booleanFromInt", $$robo$$libcore_io_IoBridge$booleanFromInt(int ), (int)n);
    }

    private static int booleanToInt(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("booleanToInt", $$robo$$libcore_io_IoBridge$booleanToInt(boolean ), (boolean)bl);
    }

    public static void setSocketOption(FileDescriptor fileDescriptor, int n, Object object) throws SocketException {
        InvokeDynamicSupport.bootstrapStatic("setSocketOption", $$robo$$libcore_io_IoBridge$setSocketOption(java.io.FileDescriptor int java.lang.Object ), (FileDescriptor)fileDescriptor, (int)n, (Object)object);
    }

    private static void setSocketOptionErrno(FileDescriptor fileDescriptor, int n, Object object) throws ErrnoException, SocketException {
        InvokeDynamicSupport.bootstrapStatic("setSocketOptionErrno", $$robo$$libcore_io_IoBridge$setSocketOptionErrno(java.io.FileDescriptor int java.lang.Object ), (FileDescriptor)fileDescriptor, (int)n, (Object)object);
    }

    private static int getGroupSourceReqOp(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGroupSourceReqOp", $$robo$$libcore_io_IoBridge$getGroupSourceReqOp(int ), (int)n);
    }

    public static FileDescriptor open(String string2, int n) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("open", $$robo$$libcore_io_IoBridge$open(java.lang.String int ), (String)string2, (int)n);
    }

    public static int read(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("read", $$robo$$libcore_io_IoBridge$read(java.io.FileDescriptor byte[] int int ), (FileDescriptor)fileDescriptor, (byte[])byArray, (int)n, (int)n2);
    }

    public static void write(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("write", $$robo$$libcore_io_IoBridge$write(java.io.FileDescriptor byte[] int int ), (FileDescriptor)fileDescriptor, (byte[])byArray, (int)n, (int)n2);
    }

    public static int sendto(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, int n3, InetAddress inetAddress, int n4) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("sendto", $$robo$$libcore_io_IoBridge$sendto(java.io.FileDescriptor byte[] int int int java.net.InetAddress int ), (FileDescriptor)fileDescriptor, (byte[])byArray, (int)n, (int)n2, (int)n3, (InetAddress)inetAddress, (int)n4);
    }

    public static int sendto(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, int n, InetAddress inetAddress, int n2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("sendto", $$robo$$libcore_io_IoBridge$sendto(java.io.FileDescriptor java.nio.ByteBuffer int java.net.InetAddress int ), (FileDescriptor)fileDescriptor, (ByteBuffer)byteBuffer, (int)n, (InetAddress)inetAddress, (int)n2);
    }

    private static int maybeThrowAfterSendto(boolean bl, ErrnoException errnoException) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("maybeThrowAfterSendto", $$robo$$libcore_io_IoBridge$maybeThrowAfterSendto(boolean android.system.ErrnoException ), (boolean)bl, (ErrnoException)errnoException);
    }

    public static int recvfrom(boolean bl, FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, int n3, DatagramPacket datagramPacket, boolean bl2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("recvfrom", $$robo$$libcore_io_IoBridge$recvfrom(boolean java.io.FileDescriptor byte[] int int int java.net.DatagramPacket boolean ), (boolean)bl, (FileDescriptor)fileDescriptor, (byte[])byArray, (int)n, (int)n2, (int)n3, (DatagramPacket)datagramPacket, (boolean)bl2);
    }

    public static int recvfrom(boolean bl, FileDescriptor fileDescriptor, ByteBuffer byteBuffer, int n, DatagramPacket datagramPacket, boolean bl2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("recvfrom", $$robo$$libcore_io_IoBridge$recvfrom(boolean java.io.FileDescriptor java.nio.ByteBuffer int java.net.DatagramPacket boolean ), (boolean)bl, (FileDescriptor)fileDescriptor, (ByteBuffer)byteBuffer, (int)n, (DatagramPacket)datagramPacket, (boolean)bl2);
    }

    private static int postRecvfrom(boolean bl, DatagramPacket datagramPacket, InetSocketAddress inetSocketAddress, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("postRecvfrom", $$robo$$libcore_io_IoBridge$postRecvfrom(boolean java.net.DatagramPacket java.net.InetSocketAddress int ), (boolean)bl, (DatagramPacket)datagramPacket, (InetSocketAddress)inetSocketAddress, (int)n);
    }

    private static int maybeThrowAfterRecvfrom(boolean bl, boolean bl2, ErrnoException errnoException) throws SocketException, SocketTimeoutException {
        return (int)InvokeDynamicSupport.bootstrapStatic("maybeThrowAfterRecvfrom", $$robo$$libcore_io_IoBridge$maybeThrowAfterRecvfrom(boolean boolean android.system.ErrnoException ), (boolean)bl, (boolean)bl2, (ErrnoException)errnoException);
    }

    public static FileDescriptor socket(int n, int n2, int n3) throws SocketException {
        return InvokeDynamicSupport.bootstrapStatic("socket", $$robo$$libcore_io_IoBridge$socket(int int int ), (int)n, (int)n2, (int)n3);
    }

    public static void poll(FileDescriptor fileDescriptor, int n, int n2) throws SocketException, SocketTimeoutException {
        InvokeDynamicSupport.bootstrapStatic("poll", $$robo$$libcore_io_IoBridge$poll(java.io.FileDescriptor int int ), (FileDescriptor)fileDescriptor, (int)n, (int)n2);
    }

    public static InetSocketAddress getLocalInetSocketAddress(FileDescriptor fileDescriptor) throws SocketException {
        return InvokeDynamicSupport.bootstrapStatic("getLocalInetSocketAddress", $$robo$$libcore_io_IoBridge$getLocalInetSocketAddress(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IoBridge)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

