/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.shared2;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.tzdata.shared2.DistroException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DistroVersion
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int CURRENT_FORMAT_MAJOR_VERSION = 1;
    public static int CURRENT_FORMAT_MINOR_VERSION = 1;
    private static String FULL_CURRENT_FORMAT_VERSION_STRING;
    private static int FORMAT_VERSION_STRING_LENGTH;
    private static Pattern FORMAT_VERSION_PATTERN;
    private static Pattern RULES_VERSION_PATTERN;
    private static int RULES_VERSION_LENGTH = 5;
    private static Pattern REVISION_PATTERN;
    private static int REVISION_LENGTH = 3;
    public static int DISTRO_VERSION_FILE_LENGTH;
    private static Pattern DISTRO_VERSION_PATTERN;
    public int formatMajorVersion;
    public int formatMinorVersion;
    public String rulesVersion;
    public int revision;

    private void $$robo$$libcore_tzdata_shared2_DistroVersion$__constructor__(int formatMajorVersion, int formatMinorVersion, String rulesVersion, int revision) throws DistroException {
        this.formatMajorVersion = DistroVersion.validate3DigitVersion(formatMajorVersion);
        this.formatMinorVersion = DistroVersion.validate3DigitVersion(formatMinorVersion);
        if (!RULES_VERSION_PATTERN.matcher(rulesVersion).matches()) {
            throw new DistroException("Invalid rulesVersion: " + rulesVersion);
        }
        this.rulesVersion = rulesVersion;
        this.revision = DistroVersion.validate3DigitVersion(revision);
    }

    private static final DistroVersion $$robo$$libcore_tzdata_shared2_DistroVersion$fromBytes(byte[] bytes) throws DistroException {
        String distroVersion = new String(bytes, StandardCharsets.US_ASCII);
        try {
            Matcher matcher = DISTRO_VERSION_PATTERN.matcher(distroVersion);
            if (!matcher.matches()) {
                throw new DistroException("Invalid distro version string: " + distroVersion);
            }
            String formatMajorVersion = matcher.group(1);
            String formatMinorVersion = matcher.group(2);
            String rulesVersion = matcher.group(3);
            String revision = matcher.group(4);
            return new DistroVersion(DistroVersion.from3DigitVersionString(formatMajorVersion), DistroVersion.from3DigitVersionString(formatMinorVersion), rulesVersion, DistroVersion.from3DigitVersionString(revision));
        }
        catch (IndexOutOfBoundsException e) {
            throw new DistroException("Distro version string too short:" + distroVersion);
        }
    }

    private final byte[] $$robo$$libcore_tzdata_shared2_DistroVersion$toBytes() {
        return DistroVersion.toBytes(this.formatMajorVersion, this.formatMinorVersion, this.rulesVersion, this.revision);
    }

    private static final byte[] $$robo$$libcore_tzdata_shared2_DistroVersion$toBytes(int majorFormatVersion, int minorFormatVerison, String rulesVersion, int revision) {
        return (DistroVersion.toFormatVersionString(majorFormatVersion, minorFormatVerison) + "|" + rulesVersion + "|" + DistroVersion.to3DigitVersionString(revision)).getBytes(StandardCharsets.US_ASCII);
    }

    private static final boolean $$robo$$libcore_tzdata_shared2_DistroVersion$isCompatibleWithThisDevice(DistroVersion distroVersion) {
        return 1 == distroVersion.formatMajorVersion && 1 <= distroVersion.formatMinorVersion;
    }

    private final boolean $$robo$$libcore_tzdata_shared2_DistroVersion$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistroVersion that = (DistroVersion)o;
        if (this.formatMajorVersion != that.formatMajorVersion) {
            return false;
        }
        if (this.formatMinorVersion != that.formatMinorVersion) {
            return false;
        }
        if (this.revision != that.revision) {
            return false;
        }
        return this.rulesVersion.equals(that.rulesVersion);
    }

    private final int $$robo$$libcore_tzdata_shared2_DistroVersion$hashCode() {
        int result = this.formatMajorVersion;
        result = 31 * result + this.formatMinorVersion;
        result = 31 * result + this.rulesVersion.hashCode();
        result = 31 * result + this.revision;
        return result;
    }

    private final String $$robo$$libcore_tzdata_shared2_DistroVersion$toString() {
        return "DistroVersion{formatMajorVersion=" + this.formatMajorVersion + ", formatMinorVersion=" + this.formatMinorVersion + ", rulesVersion='" + this.rulesVersion + '\'' + ", revision=" + this.revision + '}';
    }

    private static final String $$robo$$libcore_tzdata_shared2_DistroVersion$to3DigitVersionString(int version) {
        try {
            return String.format(Locale.ROOT, "%03d", DistroVersion.validate3DigitVersion(version));
        }
        catch (DistroException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static final int $$robo$$libcore_tzdata_shared2_DistroVersion$from3DigitVersionString(String versionString) throws DistroException {
        String parseErrorMessage = "versionString must be a zero padded, 3 digit, positive decimal integer";
        if (versionString.length() != 3) {
            throw new DistroException("versionString must be a zero padded, 3 digit, positive decimal integer");
        }
        try {
            int version = Integer.parseInt(versionString);
            return DistroVersion.validate3DigitVersion(version);
        }
        catch (NumberFormatException e) {
            throw new DistroException("versionString must be a zero padded, 3 digit, positive decimal integer", e);
        }
    }

    private static final int $$robo$$libcore_tzdata_shared2_DistroVersion$validate3DigitVersion(int value) throws DistroException {
        if (value < 0 || value > 999) {
            throw new DistroException("Expected 0 <= value <= 999, was " + value);
        }
        return value;
    }

    private static final String $$robo$$libcore_tzdata_shared2_DistroVersion$toFormatVersionString(int majorFormatVersion, int minorFormatVersion) {
        return DistroVersion.to3DigitVersionString(majorFormatVersion) + "." + DistroVersion.to3DigitVersionString(minorFormatVersion);
    }

    static void __staticInitializer__() {
        FULL_CURRENT_FORMAT_VERSION_STRING = DistroVersion.toFormatVersionString(1, 1);
        FORMAT_VERSION_STRING_LENGTH = FULL_CURRENT_FORMAT_VERSION_STRING.length();
        FORMAT_VERSION_PATTERN = Pattern.compile("(\\d{3})\\.(\\d{3})");
        RULES_VERSION_PATTERN = Pattern.compile("(\\d{4}\\w)");
        REVISION_PATTERN = Pattern.compile("(\\d{3})");
        DISTRO_VERSION_FILE_LENGTH = FORMAT_VERSION_STRING_LENGTH + 1 + 5 + 1 + 3;
        DISTRO_VERSION_PATTERN = Pattern.compile(FORMAT_VERSION_PATTERN.pattern() + "\\|" + RULES_VERSION_PATTERN.pattern() + "\\|" + REVISION_PATTERN.pattern() + ".*");
    }

    private void __constructor__(int n, int n2, String string2, int n3) throws DistroException {
        this.$$robo$$libcore_tzdata_shared2_DistroVersion$__constructor__(n, n2, string2, n3);
    }

    public DistroVersion(int n, int n2, String string2, int n3) throws DistroException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_tzdata_shared2_DistroVersion$__constructor__(int int java.lang.String int ), this, n, n2, string2, n3);
    }

    public static DistroVersion fromBytes(byte[] byArray) throws DistroException {
        return InvokeDynamicSupport.bootstrapStatic("fromBytes", $$robo$$libcore_tzdata_shared2_DistroVersion$fromBytes(byte[] ), (byte[])byArray);
    }

    public byte[] toBytes() {
        return InvokeDynamicSupport.bootstrap("toBytes", $$robo$$libcore_tzdata_shared2_DistroVersion$toBytes(), this);
    }

    public static byte[] toBytes(int n, int n2, String string2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("toBytes", $$robo$$libcore_tzdata_shared2_DistroVersion$toBytes(int int java.lang.String int ), (int)n, (int)n2, (String)string2, (int)n3);
    }

    public static boolean isCompatibleWithThisDevice(DistroVersion distroVersion) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCompatibleWithThisDevice", $$robo$$libcore_tzdata_shared2_DistroVersion$isCompatibleWithThisDevice(libcore.tzdata.shared2.DistroVersion ), (DistroVersion)distroVersion);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$libcore_tzdata_shared2_DistroVersion$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$libcore_tzdata_shared2_DistroVersion$hashCode(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$libcore_tzdata_shared2_DistroVersion$toString(), this);
    }

    private static String to3DigitVersionString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("to3DigitVersionString", $$robo$$libcore_tzdata_shared2_DistroVersion$to3DigitVersionString(int ), (int)n);
    }

    private static int from3DigitVersionString(String string2) throws DistroException {
        return (int)InvokeDynamicSupport.bootstrapStatic("from3DigitVersionString", $$robo$$libcore_tzdata_shared2_DistroVersion$from3DigitVersionString(java.lang.String ), (String)string2);
    }

    private static int validate3DigitVersion(int n) throws DistroException {
        return (int)InvokeDynamicSupport.bootstrapStatic("validate3DigitVersion", $$robo$$libcore_tzdata_shared2_DistroVersion$validate3DigitVersion(int ), (int)n);
    }

    private static String toFormatVersionString(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("toFormatVersionString", $$robo$$libcore_tzdata_shared2_DistroVersion$toFormatVersionString(int int ), (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(DistroVersion.class);
    }

    public /* synthetic */ DistroVersion() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DistroVersion)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

