/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.shared2;

import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import libcore.tzdata.shared2.DistroException;
import libcore.tzdata.shared2.DistroVersion;
import libcore.tzdata.shared2.FileUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TimeZoneDistro
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String TZDATA_FILE_NAME = "tzdata";
    public static String ICU_DATA_FILE_NAME = "icu/icu_tzdata.dat";
    public static String TZLOOKUP_FILE_NAME = "tzlookup.xml";
    public static String DISTRO_VERSION_FILE_NAME = "distro_version";
    private static int BUFFER_SIZE = 8192;
    private static long MAX_GET_ENTRY_CONTENTS_SIZE = 131072L;
    private byte[] bytes;

    private void $$robo$$libcore_tzdata_shared2_TimeZoneDistro$__constructor__(byte[] bytes) {
        this.bytes = bytes;
    }

    private final byte[] $$robo$$libcore_tzdata_shared2_TimeZoneDistro$getBytes() {
        return this.bytes;
    }

    private final DistroVersion $$robo$$libcore_tzdata_shared2_TimeZoneDistro$getDistroVersion() throws DistroException, IOException {
        byte[] contents = TimeZoneDistro.getEntryContents(new ByteArrayInputStream(this.bytes), "distro_version");
        if (contents == null) {
            throw new DistroException("Distro version file entry not found");
        }
        return DistroVersion.fromBytes(contents);
    }

    private static final byte[] $$robo$$libcore_tzdata_shared2_TimeZoneDistro$getEntryContents(InputStream is, String entryName) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String name = entry.getName();
                if (!entryName.equals(name)) continue;
                if (entry.getSize() > 131072L) {
                    throw new IOException("Entry " + entryName + " too large: " + entry.getSize());
                }
                byte[] buffer = new byte[8192];
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    int count;
                    while ((count = zipInputStream.read(buffer)) != -1) {
                        baos.write(buffer, 0, count);
                    }
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    private final void $$robo$$libcore_tzdata_shared2_TimeZoneDistro$extractTo(File targetDir) throws IOException {
        TimeZoneDistro.extractZipSafely(new ByteArrayInputStream(this.bytes), targetDir, true);
    }

    private static final void $$robo$$libcore_tzdata_shared2_TimeZoneDistro$extractZipSafely(InputStream is, File targetDir, boolean makeWorldReadable) throws IOException {
        FileUtils.ensureDirectoriesExist(targetDir, makeWorldReadable);
        try (ZipInputStream zipInputStream = new ZipInputStream(is);){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String name = entry.getName();
                File entryFile = FileUtils.createSubFile(targetDir, name);
                if (entry.isDirectory()) {
                    FileUtils.ensureDirectoriesExist(entryFile, makeWorldReadable);
                    continue;
                }
                if (!entryFile.getParentFile().exists()) {
                    FileUtils.ensureDirectoriesExist(entryFile.getParentFile(), makeWorldReadable);
                }
                try (FileOutputStream fos = new FileOutputStream(entryFile);){
                    int count;
                    while ((count = zipInputStream.read(buffer)) != -1) {
                        fos.write(buffer, 0, count);
                    }
                    fos.getFD().sync();
                }
                if (!makeWorldReadable) continue;
                FileUtils.makeWorldReadable(entryFile);
            }
        }
    }

    private final boolean $$robo$$libcore_tzdata_shared2_TimeZoneDistro$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZoneDistro that = (TimeZoneDistro)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    private void __constructor__(byte[] byArray) {
        this.$$robo$$libcore_tzdata_shared2_TimeZoneDistro$__constructor__(byArray);
    }

    public TimeZoneDistro(byte[] byArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_tzdata_shared2_TimeZoneDistro$__constructor__(byte[] ), this, byArray);
    }

    public byte[] getBytes() {
        return InvokeDynamicSupport.bootstrap("getBytes", $$robo$$libcore_tzdata_shared2_TimeZoneDistro$getBytes(), this);
    }

    public DistroVersion getDistroVersion() throws DistroException, IOException {
        return InvokeDynamicSupport.bootstrap("getDistroVersion", $$robo$$libcore_tzdata_shared2_TimeZoneDistro$getDistroVersion(), this);
    }

    private static byte[] getEntryContents(InputStream inputStream, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("getEntryContents", $$robo$$libcore_tzdata_shared2_TimeZoneDistro$getEntryContents(java.io.InputStream java.lang.String ), (InputStream)inputStream, (String)string2);
    }

    public void extractTo(File file) throws IOException {
        InvokeDynamicSupport.bootstrap("extractTo", $$robo$$libcore_tzdata_shared2_TimeZoneDistro$extractTo(java.io.File ), this, file);
    }

    static void extractZipSafely(InputStream inputStream, File file, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("extractZipSafely", $$robo$$libcore_tzdata_shared2_TimeZoneDistro$extractZipSafely(java.io.InputStream java.io.File boolean ), (InputStream)inputStream, (File)file, (boolean)bl);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$libcore_tzdata_shared2_TimeZoneDistro$equals(java.lang.Object ), this, object);
    }

    public /* synthetic */ TimeZoneDistro() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZoneDistro)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

