/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public class BasicLruCache<K, V> {
    public /* synthetic */ Object __robo_data__;
    private LinkedHashMap<K, V> map;
    private int maxSize;

    private void $$robo$$libcore_util_BasicLruCache$__constructor__(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V $$robo$$libcore_util_BasicLruCache$get(K key) {
        V result;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        BasicLruCache basicLruCache = this;
        synchronized (basicLruCache) {
            result = this.map.get(key);
            if (result != null) {
                return result;
            }
        }
        result = this.create(key);
        basicLruCache = this;
        synchronized (basicLruCache) {
            if (result != null) {
                this.map.put(key, result);
                this.trimToSize(this.maxSize);
            }
        }
        return result;
    }

    private final synchronized V $$robo$$libcore_util_BasicLruCache$put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        V previous = this.map.put(key, value);
        this.trimToSize(this.maxSize);
        return previous;
    }

    private final void $$robo$$libcore_util_BasicLruCache$trimToSize(int maxSize) {
        while (this.map.size() > maxSize) {
            CallSite toEvict = InvokeDynamicSupport.bootstrapIntrinsic("eldest", "java.util.LinkedHashMap", this.map);
            Object key = toEvict.getKey();
            Object value = toEvict.getValue();
            this.map.remove(key);
            this.entryEvicted(key, value);
        }
    }

    private final void $$robo$$libcore_util_BasicLruCache$entryEvicted(K key, V value) {
    }

    private final V $$robo$$libcore_util_BasicLruCache$create(K key) {
        return null;
    }

    private final synchronized Map<K, V> $$robo$$libcore_util_BasicLruCache$snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    private final synchronized void $$robo$$libcore_util_BasicLruCache$evictAll() {
        this.trimToSize(0);
    }

    private void __constructor__(int n) {
        this.$$robo$$libcore_util_BasicLruCache$__constructor__(n);
    }

    public BasicLruCache(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_BasicLruCache$__constructor__(int ), this, n);
    }

    public V get(K k) {
        return (V)InvokeDynamicSupport.bootstrap("get", $$robo$$libcore_util_BasicLruCache$get(K ), this, k);
    }

    public synchronized V put(K k, V v) {
        return (V)InvokeDynamicSupport.bootstrap("put", $$robo$$libcore_util_BasicLruCache$put(K V ), this, k, v);
    }

    private void trimToSize(int n) {
        InvokeDynamicSupport.bootstrap("trimToSize", $$robo$$libcore_util_BasicLruCache$trimToSize(int ), this, n);
    }

    protected void entryEvicted(K k, V v) {
        InvokeDynamicSupport.bootstrap("entryEvicted", $$robo$$libcore_util_BasicLruCache$entryEvicted(K V ), this, k, v);
    }

    protected V create(K k) {
        return (V)InvokeDynamicSupport.bootstrap("create", $$robo$$libcore_util_BasicLruCache$create(K ), this, k);
    }

    public synchronized Map<K, V> snapshot() {
        return InvokeDynamicSupport.bootstrap("snapshot", $$robo$$libcore_util_BasicLruCache$snapshot(), this);
    }

    public synchronized void evictAll() {
        InvokeDynamicSupport.bootstrap("evictAll", $$robo$$libcore_util_BasicLruCache$evictAll(), this);
    }

    public /* synthetic */ BasicLruCache() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicLruCache)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

