/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@Deprecated
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AndroidDistinguishedNameParser
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private String dn;
    private int length;
    private int pos;
    private int beg;
    private int end;
    private int cur;
    private char[] chars;

    private void $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$__constructor__(X500Principal principal) {
        this.dn = principal.getName("RFC2253");
        this.length = this.dn.length();
    }

    private final String $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$nextAT() {
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (this.pos == this.length) {
            return null;
        }
        this.beg = this.pos++;
        while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] != ' ') {
            ++this.pos;
        }
        if (this.pos >= this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        this.end = this.pos;
        if (this.chars[this.pos] == ' ') {
            while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] == ' ') {
                ++this.pos;
            }
            if (this.chars[this.pos] != '=' || this.pos == this.length) {
                throw new IllegalStateException("Unexpected end of DN: " + this.dn);
            }
        }
        ++this.pos;
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (!(this.end - this.beg <= 4 || this.chars[this.beg + 3] != '.' || this.chars[this.beg] != 'O' && this.chars[this.beg] != 'o' || this.chars[this.beg + 1] != 'I' && this.chars[this.beg + 1] != 'i' || this.chars[this.beg + 2] != 'D' && this.chars[this.beg + 2] != 'd')) {
            this.beg += 4;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private final String $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$quotedAV() {
        ++this.pos;
        this.end = this.beg = this.pos;
        while (true) {
            if (this.pos == this.length) {
                throw new IllegalStateException("Unexpected end of DN: " + this.dn);
            }
            if (this.chars[this.pos] == '\"') {
                ++this.pos;
                break;
            }
            this.chars[this.end] = this.chars[this.pos] == '\\' ? this.getEscaped() : this.chars[this.pos];
            ++this.pos;
            ++this.end;
        }
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private final String $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$hexAV() {
        if (this.pos + 4 >= this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        this.beg = this.pos++;
        while (true) {
            if (this.pos == this.length || this.chars[this.pos] == '+' || this.chars[this.pos] == ',' || this.chars[this.pos] == ';') {
                this.end = this.pos;
                break;
            }
            if (this.chars[this.pos] == ' ') {
                this.end = this.pos++;
                while (this.pos < this.length && this.chars[this.pos] == ' ') {
                    ++this.pos;
                }
                break;
            }
            if (this.chars[this.pos] >= 'A' && this.chars[this.pos] <= 'F') {
                int n = this.pos;
                this.chars[n] = (char)(this.chars[n] + 32);
            }
            ++this.pos;
        }
        int hexLen = this.end - this.beg;
        if (hexLen < 5 || (hexLen & 1) == 0) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        byte[] encoded = new byte[hexLen / 2];
        int p = this.beg + 1;
        for (int i = 0; i < encoded.length; ++i) {
            encoded[i] = (byte)this.getByte(p);
            p += 2;
        }
        return new String(this.chars, this.beg, hexLen);
    }

    private final String $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$escapedAV() {
        this.beg = this.pos;
        this.end = this.pos;
        block5: while (this.pos < this.length) {
            switch (this.chars[this.pos]) {
                case '+': 
                case ',': 
                case ';': {
                    return new String(this.chars, this.beg, this.end - this.beg);
                }
                case '\\': {
                    this.chars[this.end++] = this.getEscaped();
                    ++this.pos;
                    continue block5;
                }
                case ' ': {
                    this.cur = this.end;
                    ++this.pos;
                    this.chars[this.end++] = 32;
                    while (this.pos < this.length && this.chars[this.pos] == ' ') {
                        this.chars[this.end++] = 32;
                        ++this.pos;
                    }
                    if (this.pos != this.length && this.chars[this.pos] != ',' && this.chars[this.pos] != '+' && this.chars[this.pos] != ';') continue block5;
                    return new String(this.chars, this.beg, this.cur - this.beg);
                }
            }
            this.chars[this.end++] = this.chars[this.pos];
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private final char $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$getEscaped() {
        ++this.pos;
        if (this.pos == this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        switch (this.chars[this.pos]) {
            case ' ': 
            case '\"': 
            case '#': 
            case '%': 
            case '*': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '\\': 
            case '_': {
                return this.chars[this.pos];
            }
        }
        return this.getUTF8();
    }

    private final char $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$getUTF8() {
        int res = this.getByte(this.pos);
        ++this.pos;
        if (res < 128) {
            return (char)res;
        }
        if (res >= 192 && res <= 247) {
            int count;
            if (res <= 223) {
                count = 1;
                res &= 0x1F;
            } else if (res <= 239) {
                count = 2;
                res &= 0xF;
            } else {
                count = 3;
                res &= 7;
            }
            for (int i = 0; i < count; ++i) {
                ++this.pos;
                if (this.pos == this.length || this.chars[this.pos] != '\\') {
                    return '?';
                }
                ++this.pos;
                int b = this.getByte(this.pos);
                ++this.pos;
                if ((b & 0xC0) != 128) {
                    return '?';
                }
                res = (res << 6) + (b & 0x3F);
            }
            return (char)res;
        }
        return '?';
    }

    private final int $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$getByte(int position) {
        if (position + 1 >= this.length) {
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        int b1 = this.chars[position];
        if (b1 >= 48 && b1 <= 57) {
            b1 -= 48;
        } else if (b1 >= 97 && b1 <= 102) {
            b1 -= 87;
        } else if (b1 >= 65 && b1 <= 70) {
            b1 -= 55;
        } else {
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        int b2 = this.chars[position + 1];
        if (b2 >= 48 && b2 <= 57) {
            b2 -= 48;
        } else if (b2 >= 97 && b2 <= 102) {
            b2 -= 87;
        } else if (b2 >= 65 && b2 <= 70) {
            b2 -= 55;
        } else {
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        return (b1 << 4) + b2;
    }

    private final String $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$findMostSpecific(String attributeType) {
        this.pos = 0;
        this.beg = 0;
        this.end = 0;
        this.cur = 0;
        this.chars = this.dn.toCharArray();
        String attType = this.nextAT();
        if (attType == null) {
            return null;
        }
        do {
            String attValue = "";
            if (this.pos == this.length) {
                return null;
            }
            switch (this.chars[this.pos]) {
                case '\"': {
                    attValue = this.quotedAV();
                    break;
                }
                case '#': {
                    attValue = this.hexAV();
                    break;
                }
                case '+': 
                case ',': 
                case ';': {
                    break;
                }
                default: {
                    attValue = this.escapedAV();
                }
            }
            if (attributeType.equalsIgnoreCase(attType)) {
                return attValue;
            }
            if (this.pos >= this.length) {
                return null;
            }
            if (this.chars[this.pos] != ',' && this.chars[this.pos] != ';' && this.chars[this.pos] != '+') {
                throw new IllegalStateException("Malformed DN: " + this.dn);
            }
            ++this.pos;
        } while ((attType = this.nextAT()) != null);
        throw new IllegalStateException("Malformed DN: " + this.dn);
    }

    private final List<String> $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$getAllMostSpecificFirst(String attributeType) {
        this.pos = 0;
        this.beg = 0;
        this.end = 0;
        this.cur = 0;
        this.chars = this.dn.toCharArray();
        List<String> result = Collections.emptyList();
        String attType = this.nextAT();
        if (attType == null) {
            return result;
        }
        while (this.pos < this.length) {
            String attValue = "";
            switch (this.chars[this.pos]) {
                case '\"': {
                    attValue = this.quotedAV();
                    break;
                }
                case '#': {
                    attValue = this.hexAV();
                    break;
                }
                case '+': 
                case ',': 
                case ';': {
                    break;
                }
                default: {
                    attValue = this.escapedAV();
                }
            }
            if (attributeType.equalsIgnoreCase(attType)) {
                if (result.isEmpty()) {
                    result = new ArrayList<String>();
                }
                result.add(attValue);
            }
            if (this.pos >= this.length) break;
            if (this.chars[this.pos] != ',' && this.chars[this.pos] != ';' && this.chars[this.pos] != '+') {
                throw new IllegalStateException("Malformed DN: " + this.dn);
            }
            ++this.pos;
            attType = this.nextAT();
            if (attType != null) continue;
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        return result;
    }

    private void __constructor__(X500Principal x500Principal) {
        this.$$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$__constructor__(x500Principal);
    }

    public AndroidDistinguishedNameParser(X500Principal x500Principal) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$__constructor__(javax.security.auth.x500.X500Principal ), this, x500Principal);
    }

    private String nextAT() {
        return InvokeDynamicSupport.bootstrap("nextAT", $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$nextAT(), this);
    }

    private String quotedAV() {
        return InvokeDynamicSupport.bootstrap("quotedAV", $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$quotedAV(), this);
    }

    private String hexAV() {
        return InvokeDynamicSupport.bootstrap("hexAV", $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$hexAV(), this);
    }

    private String escapedAV() {
        return InvokeDynamicSupport.bootstrap("escapedAV", $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$escapedAV(), this);
    }

    private char getEscaped() {
        return (char)InvokeDynamicSupport.bootstrap("getEscaped", $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$getEscaped(), this);
    }

    private char getUTF8() {
        return (char)InvokeDynamicSupport.bootstrap("getUTF8", $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$getUTF8(), this);
    }

    private int getByte(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getByte", $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$getByte(int ), this, n);
    }

    public String findMostSpecific(String string2) {
        return InvokeDynamicSupport.bootstrap("findMostSpecific", $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$findMostSpecific(java.lang.String ), this, string2);
    }

    public List<String> getAllMostSpecificFirst(String string2) {
        return InvokeDynamicSupport.bootstrap("getAllMostSpecificFirst", $$robo$$org_apache_http_conn_ssl_AndroidDistinguishedNameParser$getAllMostSpecificFirst(java.lang.String ), this, string2);
    }

    public /* synthetic */ AndroidDistinguishedNameParser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidDistinguishedNameParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

