/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActionBar;
import android.app.Activity;
import android.app.SearchManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.app.WindowDecorActionBar;
import com.android.internal.policy.PhoneWindow;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Dialog
implements DialogInterface,
Window.Callback,
KeyEvent.Callback,
View.OnCreateContextMenuListener,
Window.OnWindowDismissedCallback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Dialog";
    private Activity mOwnerActivity;
    private WindowManager mWindowManager;
    Context mContext;
    Window mWindow;
    View mDecor;
    private ActionBar mActionBar;
    protected boolean mCancelable;
    private String mCancelAndDismissTaken;
    private Message mCancelMessage;
    private Message mDismissMessage;
    private Message mShowMessage;
    private DialogInterface.OnKeyListener mOnKeyListener;
    private boolean mCreated;
    private boolean mShowing;
    private boolean mCanceled;
    private Handler mHandler;
    private static int DISMISS = 67;
    private static int CANCEL = 68;
    private static int SHOW = 69;
    private Handler mListenersHandler;
    private SearchEvent mSearchEvent;
    private ActionMode mActionMode;
    private int mActionModeTypeStarting;
    private Runnable mDismissAction;
    private static String DIALOG_SHOWING_TAG = "android:dialogShowing";
    private static String DIALOG_HIERARCHY_TAG = "android:dialogHierarchy";

    private void $$robo$$android_app_Dialog$__constructor__(Context context) {
    }

    private void $$robo$$android_app_Dialog$__constructor__(Context context, int themeResId) {
    }

    private void $$robo$$android_app_Dialog$__constructor__(Context context, int themeResId, boolean createContextThemeWrapper) {
        this.mCancelable = true;
        this.mCreated = false;
        this.mShowing = false;
        this.mCanceled = false;
        this.mHandler = new Handler();
        this.mActionModeTypeStarting = 0;
        this.mDismissAction = this::dismissDialog;
        if (createContextThemeWrapper) {
            if (themeResId == 0) {
                TypedValue outValue = new TypedValue();
                context.getTheme().resolveAttribute(16843528, outValue, true);
                themeResId = outValue.resourceId;
            }
            this.mContext = new ContextThemeWrapper(context, themeResId);
        } else {
            this.mContext = context;
        }
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        PhoneWindow w = new PhoneWindow(this.mContext);
        this.mWindow = w;
        w.setCallback(this);
        w.setOnWindowDismissedCallback(this);
        w.setOnWindowSwipeDismissedCallback(() -> {
            if (this.mCancelable) {
                this.cancel();
            }
        });
        w.setWindowManager(this.mWindowManager, null, null);
        w.setGravity(17);
        this.mListenersHandler = new ListenersHandler(this);
    }

    @Deprecated
    private void $$robo$$android_app_Dialog$__constructor__(Context context, boolean cancelable, Message cancelCallback) {
        this.mCancelable = cancelable;
        this.updateWindowForCancelable();
        this.mCancelMessage = cancelCallback;
    }

    private void $$robo$$android_app_Dialog$__constructor__(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        this.mCancelable = cancelable;
        this.updateWindowForCancelable();
        this.setOnCancelListener(cancelListener);
    }

    private final Context $$robo$$android_app_Dialog$getContext() {
        return this.mContext;
    }

    private final ActionBar $$robo$$android_app_Dialog$getActionBar() {
        return this.mActionBar;
    }

    private final void $$robo$$android_app_Dialog$setOwnerActivity(Activity activity) {
        this.mOwnerActivity = activity;
        this.getWindow().setVolumeControlStream(this.mOwnerActivity.getVolumeControlStream());
    }

    private final Activity $$robo$$android_app_Dialog$getOwnerActivity() {
        return this.mOwnerActivity;
    }

    private final boolean $$robo$$android_app_Dialog$isShowing() {
        return this.mShowing;
    }

    private final void $$robo$$android_app_Dialog$create() {
        if (!this.mCreated) {
            this.dispatchOnCreate(null);
        }
    }

    private final void $$robo$$android_app_Dialog$show() {
        if (this.mShowing) {
            if (this.mDecor != null) {
                if (this.mWindow.hasFeature(8)) {
                    this.mWindow.invalidatePanelMenu(8);
                }
                this.mDecor.setVisibility(0);
            }
            return;
        }
        this.mCanceled = false;
        if (!this.mCreated) {
            this.dispatchOnCreate(null);
        } else {
            Configuration config = this.mContext.getResources().getConfiguration();
            this.mWindow.getDecorView().dispatchConfigurationChanged(config);
        }
        this.onStart();
        this.mDecor = this.mWindow.getDecorView();
        if (this.mActionBar == null && this.mWindow.hasFeature(8)) {
            ApplicationInfo info = this.mContext.getApplicationInfo();
            this.mWindow.setDefaultIcon(info.icon);
            this.mWindow.setDefaultLogo(info.logo);
            this.mActionBar = new WindowDecorActionBar(this);
        }
        WindowManager.LayoutParams l = this.mWindow.getAttributes();
        if ((l.softInputMode & 0x100) == 0) {
            WindowManager.LayoutParams nl = new WindowManager.LayoutParams();
            nl.copyFrom(l);
            nl.softInputMode |= 0x100;
            l = nl;
        }
        this.mWindowManager.addView(this.mDecor, l);
        this.mShowing = true;
        this.sendShowMessage();
    }

    private final void $$robo$$android_app_Dialog$hide() {
        if (this.mDecor != null) {
            this.mDecor.setVisibility(8);
        }
    }

    private final void $$robo$$android_app_Dialog$dismiss() {
        if (Looper.myLooper() == this.mHandler.getLooper()) {
            this.dismissDialog();
        } else {
            this.mHandler.post(this.mDismissAction);
        }
    }

    private final void $$robo$$android_app_Dialog$dismissDialog() {
        if (this.mDecor == null || !this.mShowing) {
            return;
        }
        if (this.mWindow.isDestroyed()) {
            Log.e("Dialog", "Tried to dismissDialog() but the Dialog's window was already destroyed!");
            return;
        }
        try {
            this.mWindowManager.removeViewImmediate(this.mDecor);
        }
        finally {
            if (this.mActionMode != null) {
                this.mActionMode.finish();
            }
            this.mDecor = null;
            this.mWindow.closeAllPanels();
            this.onStop();
            this.mShowing = false;
            this.sendDismissMessage();
        }
    }

    private final void $$robo$$android_app_Dialog$sendDismissMessage() {
        if (this.mDismissMessage != null) {
            Message.obtain(this.mDismissMessage).sendToTarget();
        }
    }

    private final void $$robo$$android_app_Dialog$sendShowMessage() {
        if (this.mShowMessage != null) {
            Message.obtain(this.mShowMessage).sendToTarget();
        }
    }

    private final void $$robo$$android_app_Dialog$dispatchOnCreate(Bundle savedInstanceState) {
        if (!this.mCreated) {
            this.onCreate(savedInstanceState);
            this.mCreated = true;
        }
    }

    private final void $$robo$$android_app_Dialog$onCreate(Bundle savedInstanceState) {
    }

    private final void $$robo$$android_app_Dialog$onStart() {
        if (this.mActionBar != null) {
            this.mActionBar.setShowHideAnimationEnabled(true);
        }
    }

    private final void $$robo$$android_app_Dialog$onStop() {
        if (this.mActionBar != null) {
            this.mActionBar.setShowHideAnimationEnabled(false);
        }
    }

    private final Bundle $$robo$$android_app_Dialog$onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("android:dialogShowing", this.mShowing);
        if (this.mCreated) {
            bundle.putBundle("android:dialogHierarchy", this.mWindow.saveHierarchyState());
        }
        return bundle;
    }

    private final void $$robo$$android_app_Dialog$onRestoreInstanceState(Bundle savedInstanceState) {
        Bundle dialogHierarchyState = savedInstanceState.getBundle("android:dialogHierarchy");
        if (dialogHierarchyState == null) {
            return;
        }
        this.dispatchOnCreate(savedInstanceState);
        this.mWindow.restoreHierarchyState(dialogHierarchyState);
        if (savedInstanceState.getBoolean("android:dialogShowing")) {
            this.show();
        }
    }

    private final Window $$robo$$android_app_Dialog$getWindow() {
        return this.mWindow;
    }

    private final View $$robo$$android_app_Dialog$getCurrentFocus() {
        return this.mWindow != null ? this.mWindow.getCurrentFocus() : null;
    }

    private final <T extends View> T $$robo$$android_app_Dialog$findViewById(int id2) {
        return this.mWindow.findViewById(id2);
    }

    private final void $$robo$$android_app_Dialog$setContentView(int layoutResID) {
        this.mWindow.setContentView(layoutResID);
    }

    private final void $$robo$$android_app_Dialog$setContentView(View view) {
        this.mWindow.setContentView(view);
    }

    private final void $$robo$$android_app_Dialog$setContentView(View view, ViewGroup.LayoutParams params) {
        this.mWindow.setContentView(view, params);
    }

    private final void $$robo$$android_app_Dialog$addContentView(View view, ViewGroup.LayoutParams params) {
        this.mWindow.addContentView(view, params);
    }

    private final void $$robo$$android_app_Dialog$setTitle(CharSequence title) {
        this.mWindow.setTitle(title);
        this.mWindow.getAttributes().setTitle(title);
    }

    private final void $$robo$$android_app_Dialog$setTitle(int titleId) {
        this.setTitle(this.mContext.getText(titleId));
    }

    private final boolean $$robo$$android_app_Dialog$onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            event.startTracking();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_app_Dialog$onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    private final boolean $$robo$$android_app_Dialog$onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.isTracking() && !event.isCanceled()) {
            this.onBackPressed();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_app_Dialog$onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return false;
    }

    private final void $$robo$$android_app_Dialog$onBackPressed() {
        if (this.mCancelable) {
            this.cancel();
        }
    }

    private final boolean $$robo$$android_app_Dialog$onKeyShortcut(int keyCode, KeyEvent event) {
        return false;
    }

    private final boolean $$robo$$android_app_Dialog$onTouchEvent(MotionEvent event) {
        if (this.mCancelable && this.mShowing && this.mWindow.shouldCloseOnTouch(this.mContext, event)) {
            this.cancel();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_app_Dialog$onTrackballEvent(MotionEvent event) {
        return false;
    }

    private final boolean $$robo$$android_app_Dialog$onGenericMotionEvent(MotionEvent event) {
        return false;
    }

    private final void $$robo$$android_app_Dialog$onWindowAttributesChanged(WindowManager.LayoutParams params) {
        if (this.mDecor != null) {
            this.mWindowManager.updateViewLayout(this.mDecor, params);
        }
    }

    private final void $$robo$$android_app_Dialog$onContentChanged() {
    }

    private final void $$robo$$android_app_Dialog$onWindowFocusChanged(boolean hasFocus) {
    }

    private final void $$robo$$android_app_Dialog$onAttachedToWindow() {
    }

    private final void $$robo$$android_app_Dialog$onDetachedFromWindow() {
    }

    private final void $$robo$$android_app_Dialog$onWindowDismissed(boolean finishTask, boolean suppressWindowTransition) {
        this.dismiss();
    }

    private final boolean $$robo$$android_app_Dialog$dispatchKeyEvent(KeyEvent event) {
        if (this.mOnKeyListener != null && this.mOnKeyListener.onKey(this, event.getKeyCode(), event)) {
            return true;
        }
        if (this.mWindow.superDispatchKeyEvent(event)) {
            return true;
        }
        return event.dispatch(this, this.mDecor != null ? this.mDecor.getKeyDispatcherState() : null, this);
    }

    private final boolean $$robo$$android_app_Dialog$dispatchKeyShortcutEvent(KeyEvent event) {
        if (this.mWindow.superDispatchKeyShortcutEvent(event)) {
            return true;
        }
        return this.onKeyShortcut(event.getKeyCode(), event);
    }

    private final boolean $$robo$$android_app_Dialog$dispatchTouchEvent(MotionEvent ev) {
        if (this.mWindow.superDispatchTouchEvent(ev)) {
            return true;
        }
        return this.onTouchEvent(ev);
    }

    private final boolean $$robo$$android_app_Dialog$dispatchTrackballEvent(MotionEvent ev) {
        if (this.mWindow.superDispatchTrackballEvent(ev)) {
            return true;
        }
        return this.onTrackballEvent(ev);
    }

    private final boolean $$robo$$android_app_Dialog$dispatchGenericMotionEvent(MotionEvent ev) {
        if (this.mWindow.superDispatchGenericMotionEvent(ev)) {
            return true;
        }
        return this.onGenericMotionEvent(ev);
    }

    private final boolean $$robo$$android_app_Dialog$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName(this.getClass().getName());
        event.setPackageName(this.mContext.getPackageName());
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        boolean isFullScreen = params.width == -1 && params.height == -1;
        event.setFullScreen(isFullScreen);
        return false;
    }

    private final View $$robo$$android_app_Dialog$onCreatePanelView(int featureId) {
        return null;
    }

    private final boolean $$robo$$android_app_Dialog$onCreatePanelMenu(int featureId, Menu menu2) {
        if (featureId == 0) {
            return this.onCreateOptionsMenu(menu2);
        }
        return false;
    }

    private final boolean $$robo$$android_app_Dialog$onPreparePanel(int featureId, View view, Menu menu2) {
        if (featureId == 0 && menu2 != null) {
            return this.onPrepareOptionsMenu(menu2) && menu2.hasVisibleItems();
        }
        return true;
    }

    private final boolean $$robo$$android_app_Dialog$onMenuOpened(int featureId, Menu menu2) {
        if (featureId == 8) {
            this.mActionBar.dispatchMenuVisibilityChanged(true);
        }
        return true;
    }

    private final boolean $$robo$$android_app_Dialog$onMenuItemSelected(int featureId, MenuItem item) {
        return false;
    }

    private final void $$robo$$android_app_Dialog$onPanelClosed(int featureId, Menu menu2) {
        if (featureId == 8) {
            this.mActionBar.dispatchMenuVisibilityChanged(false);
        }
    }

    private final boolean $$robo$$android_app_Dialog$onCreateOptionsMenu(Menu menu2) {
        return true;
    }

    private final boolean $$robo$$android_app_Dialog$onPrepareOptionsMenu(Menu menu2) {
        return true;
    }

    private final boolean $$robo$$android_app_Dialog$onOptionsItemSelected(MenuItem item) {
        return false;
    }

    private final void $$robo$$android_app_Dialog$onOptionsMenuClosed(Menu menu2) {
    }

    private final void $$robo$$android_app_Dialog$openOptionsMenu() {
        if (this.mWindow.hasFeature(0)) {
            this.mWindow.openPanel(0, null);
        }
    }

    private final void $$robo$$android_app_Dialog$closeOptionsMenu() {
        if (this.mWindow.hasFeature(0)) {
            this.mWindow.closePanel(0);
        }
    }

    private final void $$robo$$android_app_Dialog$invalidateOptionsMenu() {
        if (this.mWindow.hasFeature(0)) {
            this.mWindow.invalidatePanelMenu(0);
        }
    }

    private final void $$robo$$android_app_Dialog$onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
    }

    private final void $$robo$$android_app_Dialog$registerForContextMenu(View view) {
        view.setOnCreateContextMenuListener(this);
    }

    private final void $$robo$$android_app_Dialog$unregisterForContextMenu(View view) {
        view.setOnCreateContextMenuListener(null);
    }

    private final void $$robo$$android_app_Dialog$openContextMenu(View view) {
        view.showContextMenu();
    }

    private final boolean $$robo$$android_app_Dialog$onContextItemSelected(MenuItem item) {
        return false;
    }

    private final void $$robo$$android_app_Dialog$onContextMenuClosed(Menu menu2) {
    }

    private final boolean $$robo$$android_app_Dialog$onSearchRequested(SearchEvent searchEvent) {
        this.mSearchEvent = searchEvent;
        return this.onSearchRequested();
    }

    private final boolean $$robo$$android_app_Dialog$onSearchRequested() {
        SearchManager searchManager = (SearchManager)this.mContext.getSystemService("search");
        ComponentName appName = this.getAssociatedActivity();
        if (appName != null && searchManager.getSearchableInfo(appName) != null) {
            searchManager.startSearch(null, false, appName, null, false);
            this.dismiss();
            return true;
        }
        return false;
    }

    private final SearchEvent $$robo$$android_app_Dialog$getSearchEvent() {
        return this.mSearchEvent;
    }

    private final ActionMode $$robo$$android_app_Dialog$onWindowStartingActionMode(ActionMode.Callback callback) {
        if (this.mActionBar != null && this.mActionModeTypeStarting == 0) {
            return this.mActionBar.startActionMode(callback);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ActionMode $$robo$$android_app_Dialog$onWindowStartingActionMode(ActionMode.Callback callback, int type) {
        try {
            this.mActionModeTypeStarting = type;
            ActionMode actionMode = this.onWindowStartingActionMode(callback);
            return actionMode;
        }
        finally {
            this.mActionModeTypeStarting = 0;
        }
    }

    private final void $$robo$$android_app_Dialog$onActionModeStarted(ActionMode mode) {
        this.mActionMode = mode;
    }

    private final void $$robo$$android_app_Dialog$onActionModeFinished(ActionMode mode) {
        if (mode == this.mActionMode) {
            this.mActionMode = null;
        }
    }

    private final ComponentName $$robo$$android_app_Dialog$getAssociatedActivity() {
        Activity activity = this.mOwnerActivity;
        Context context = this.getContext();
        while (activity == null && context != null) {
            if (context instanceof Activity) {
                activity = (Activity)context;
                continue;
            }
            context = context instanceof ContextWrapper ? ((ContextWrapper)context).getBaseContext() : null;
        }
        return activity == null ? null : activity.getComponentName();
    }

    private final void $$robo$$android_app_Dialog$takeKeyEvents(boolean get) {
        this.mWindow.takeKeyEvents(get);
    }

    private final boolean $$robo$$android_app_Dialog$requestWindowFeature(int featureId) {
        return this.getWindow().requestFeature(featureId);
    }

    private final void $$robo$$android_app_Dialog$setFeatureDrawableResource(int featureId, int resId) {
        this.getWindow().setFeatureDrawableResource(featureId, resId);
    }

    private final void $$robo$$android_app_Dialog$setFeatureDrawableUri(int featureId, Uri uri) {
        this.getWindow().setFeatureDrawableUri(featureId, uri);
    }

    private final void $$robo$$android_app_Dialog$setFeatureDrawable(int featureId, Drawable drawable2) {
        this.getWindow().setFeatureDrawable(featureId, drawable2);
    }

    private final void $$robo$$android_app_Dialog$setFeatureDrawableAlpha(int featureId, int alpha) {
        this.getWindow().setFeatureDrawableAlpha(featureId, alpha);
    }

    private final LayoutInflater $$robo$$android_app_Dialog$getLayoutInflater() {
        return this.getWindow().getLayoutInflater();
    }

    private final void $$robo$$android_app_Dialog$setCancelable(boolean flag) {
        this.mCancelable = flag;
        this.updateWindowForCancelable();
    }

    private final void $$robo$$android_app_Dialog$setCanceledOnTouchOutside(boolean cancel) {
        if (cancel && !this.mCancelable) {
            this.mCancelable = true;
            this.updateWindowForCancelable();
        }
        this.mWindow.setCloseOnTouchOutside(cancel);
    }

    private final void $$robo$$android_app_Dialog$cancel() {
        if (!this.mCanceled && this.mCancelMessage != null) {
            this.mCanceled = true;
            Message.obtain(this.mCancelMessage).sendToTarget();
        }
        this.dismiss();
    }

    private final void $$robo$$android_app_Dialog$setOnCancelListener(DialogInterface.OnCancelListener listener) {
        if (this.mCancelAndDismissTaken != null) {
            throw new IllegalStateException("OnCancelListener is already taken by " + this.mCancelAndDismissTaken + " and can not be replaced.");
        }
        this.mCancelMessage = listener != null ? this.mListenersHandler.obtainMessage(68, listener) : null;
    }

    private final void $$robo$$android_app_Dialog$setCancelMessage(Message msg) {
        this.mCancelMessage = msg;
    }

    private final void $$robo$$android_app_Dialog$setOnDismissListener(DialogInterface.OnDismissListener listener) {
        if (this.mCancelAndDismissTaken != null) {
            throw new IllegalStateException("OnDismissListener is already taken by " + this.mCancelAndDismissTaken + " and can not be replaced.");
        }
        this.mDismissMessage = listener != null ? this.mListenersHandler.obtainMessage(67, listener) : null;
    }

    private final void $$robo$$android_app_Dialog$setOnShowListener(DialogInterface.OnShowListener listener) {
        this.mShowMessage = listener != null ? this.mListenersHandler.obtainMessage(69, listener) : null;
    }

    private final void $$robo$$android_app_Dialog$setDismissMessage(Message msg) {
        this.mDismissMessage = msg;
    }

    private final boolean $$robo$$android_app_Dialog$takeCancelAndDismissListeners(String msg, DialogInterface.OnCancelListener cancel, DialogInterface.OnDismissListener dismiss) {
        if (this.mCancelAndDismissTaken != null) {
            this.mCancelAndDismissTaken = null;
        } else if (this.mCancelMessage != null || this.mDismissMessage != null) {
            return false;
        }
        this.setOnCancelListener(cancel);
        this.setOnDismissListener(dismiss);
        this.mCancelAndDismissTaken = msg;
        return true;
    }

    private final void $$robo$$android_app_Dialog$setVolumeControlStream(int streamType) {
        this.getWindow().setVolumeControlStream(streamType);
    }

    private final int $$robo$$android_app_Dialog$getVolumeControlStream() {
        return this.getWindow().getVolumeControlStream();
    }

    private final void $$robo$$android_app_Dialog$setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        this.mOnKeyListener = onKeyListener;
    }

    private final void $$robo$$android_app_Dialog$updateWindowForCancelable() {
        this.mWindow.setCloseOnSwipeEnabled(this.mCancelable);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_Dialog$__constructor__(context);
    }

    public Dialog(Context context) {
        this(context, 0, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Dialog$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$android_app_Dialog$__constructor__(context, n);
    }

    public Dialog(Context context, int n) {
        this(context, n, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Dialog$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    private void __constructor__(Context context, int n, boolean bl) {
        this.$$robo$$android_app_Dialog$__constructor__(context, n, bl);
    }

    Dialog(Context context, int n, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Dialog$__constructor__(android.content.Context int boolean ), 0, this, context, n, bl);
    }

    private void __constructor__(Context context, boolean bl, Message message) {
        this.$$robo$$android_app_Dialog$__constructor__(context, bl, message);
    }

    protected Dialog(Context context, boolean bl, Message message) {
        this(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Dialog$__constructor__(android.content.Context boolean android.os.Message ), 0, this, context, bl, message);
    }

    private void __constructor__(Context context, boolean bl, DialogInterface.OnCancelListener onCancelListener) {
        this.$$robo$$android_app_Dialog$__constructor__(context, bl, onCancelListener);
    }

    protected Dialog(Context context, boolean bl, DialogInterface.OnCancelListener onCancelListener) {
        this(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Dialog$__constructor__(android.content.Context boolean android.content.DialogInterface$OnCancelListener ), 0, this, context, bl, onCancelListener);
    }

    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_app_Dialog$getContext(), 0, this);
    }

    public ActionBar getActionBar() {
        return InvokeDynamicSupport.bootstrap("getActionBar", $$robo$$android_app_Dialog$getActionBar(), 0, this);
    }

    public void setOwnerActivity(Activity activity) {
        InvokeDynamicSupport.bootstrap("setOwnerActivity", $$robo$$android_app_Dialog$setOwnerActivity(android.app.Activity ), 0, this, activity);
    }

    public Activity getOwnerActivity() {
        return InvokeDynamicSupport.bootstrap("getOwnerActivity", $$robo$$android_app_Dialog$getOwnerActivity(), 0, this);
    }

    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$android_app_Dialog$isShowing(), 0, this);
    }

    public void create() {
        InvokeDynamicSupport.bootstrap("create", $$robo$$android_app_Dialog$create(), 0, this);
    }

    public void show() {
        InvokeDynamicSupport.bootstrap("show", $$robo$$android_app_Dialog$show(), 0, this);
    }

    public void hide() {
        InvokeDynamicSupport.bootstrap("hide", $$robo$$android_app_Dialog$hide(), 0, this);
    }

    @Override
    public void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$android_app_Dialog$dismiss(), 0, this);
    }

    void dismissDialog() {
        InvokeDynamicSupport.bootstrap("dismissDialog", $$robo$$android_app_Dialog$dismissDialog(), 0, this);
    }

    private void sendDismissMessage() {
        InvokeDynamicSupport.bootstrap("sendDismissMessage", $$robo$$android_app_Dialog$sendDismissMessage(), 0, this);
    }

    private void sendShowMessage() {
        InvokeDynamicSupport.bootstrap("sendShowMessage", $$robo$$android_app_Dialog$sendShowMessage(), 0, this);
    }

    void dispatchOnCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchOnCreate", $$robo$$android_app_Dialog$dispatchOnCreate(android.os.Bundle ), 0, this, bundle);
    }

    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_app_Dialog$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    protected void onStart() {
        InvokeDynamicSupport.bootstrap("onStart", $$robo$$android_app_Dialog$onStart(), 0, this);
    }

    protected void onStop() {
        InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_app_Dialog$onStop(), 0, this);
    }

    public Bundle onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_app_Dialog$onSaveInstanceState(), 0, this);
    }

    public void onRestoreInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_app_Dialog$onRestoreInstanceState(android.os.Bundle ), 0, this, bundle);
    }

    public Window getWindow() {
        return InvokeDynamicSupport.bootstrap("getWindow", $$robo$$android_app_Dialog$getWindow(), 0, this);
    }

    public View getCurrentFocus() {
        return InvokeDynamicSupport.bootstrap("getCurrentFocus", $$robo$$android_app_Dialog$getCurrentFocus(), 0, this);
    }

    public <T extends View> T findViewById(int n) {
        return (T)InvokeDynamicSupport.bootstrap("findViewById", $$robo$$android_app_Dialog$findViewById(int ), 0, this, n);
    }

    public void setContentView(int n) {
        InvokeDynamicSupport.bootstrap("setContentView", $$robo$$android_app_Dialog$setContentView(int ), 0, this, n);
    }

    public void setContentView(View view) {
        InvokeDynamicSupport.bootstrap("setContentView", $$robo$$android_app_Dialog$setContentView(android.view.View ), 0, this, view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("setContentView", $$robo$$android_app_Dialog$setContentView(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addContentView", $$robo$$android_app_Dialog$addContentView(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_app_Dialog$setTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setTitle(int n) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_app_Dialog$setTitle(int ), 0, this, n);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_app_Dialog$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyLongPress", $$robo$$android_app_Dialog$onKeyLongPress(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_app_Dialog$onKeyUp(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyMultiple", $$robo$$android_app_Dialog$onKeyMultiple(int int android.view.KeyEvent ), 0, this, n, n2, keyEvent);
    }

    public void onBackPressed() {
        InvokeDynamicSupport.bootstrap("onBackPressed", $$robo$$android_app_Dialog$onBackPressed(), 0, this);
    }

    public boolean onKeyShortcut(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyShortcut", $$robo$$android_app_Dialog$onKeyShortcut(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_app_Dialog$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTrackballEvent", $$robo$$android_app_Dialog$onTrackballEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_app_Dialog$onGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public void onWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("onWindowAttributesChanged", $$robo$$android_app_Dialog$onWindowAttributesChanged(android.view.WindowManager$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    public void onContentChanged() {
        InvokeDynamicSupport.bootstrap("onContentChanged", $$robo$$android_app_Dialog$onContentChanged(), 0, this);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onWindowFocusChanged", $$robo$$android_app_Dialog$onWindowFocusChanged(boolean ), 0, this, bl);
    }

    @Override
    public void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_app_Dialog$onAttachedToWindow(), 0, this);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_app_Dialog$onDetachedFromWindow(), 0, this);
    }

    @Override
    public void onWindowDismissed(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("onWindowDismissed", $$robo$$android_app_Dialog$onWindowDismissed(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_app_Dialog$dispatchKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyShortcutEvent", $$robo$$android_app_Dialog$dispatchKeyShortcutEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$android_app_Dialog$dispatchTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTrackballEvent", $$robo$$android_app_Dialog$dispatchTrackballEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchGenericMotionEvent", $$robo$$android_app_Dialog$dispatchGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_app_Dialog$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public View onCreatePanelView(int n) {
        return InvokeDynamicSupport.bootstrap("onCreatePanelView", $$robo$$android_app_Dialog$onCreatePanelView(int ), 0, this, n);
    }

    @Override
    public boolean onCreatePanelMenu(int n, Menu menu2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onCreatePanelMenu", $$robo$$android_app_Dialog$onCreatePanelMenu(int android.view.Menu ), 0, this, n, menu2);
    }

    @Override
    public boolean onPreparePanel(int n, View view, Menu menu2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onPreparePanel", $$robo$$android_app_Dialog$onPreparePanel(int android.view.View android.view.Menu ), 0, this, n, view, menu2);
    }

    @Override
    public boolean onMenuOpened(int n, Menu menu2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onMenuOpened", $$robo$$android_app_Dialog$onMenuOpened(int android.view.Menu ), 0, this, n, menu2);
    }

    @Override
    public boolean onMenuItemSelected(int n, MenuItem menuItem) {
        return (boolean)InvokeDynamicSupport.bootstrap("onMenuItemSelected", $$robo$$android_app_Dialog$onMenuItemSelected(int android.view.MenuItem ), 0, this, n, menuItem);
    }

    @Override
    public void onPanelClosed(int n, Menu menu2) {
        InvokeDynamicSupport.bootstrap("onPanelClosed", $$robo$$android_app_Dialog$onPanelClosed(int android.view.Menu ), 0, this, n, menu2);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onCreateOptionsMenu", $$robo$$android_app_Dialog$onCreateOptionsMenu(android.view.Menu ), 0, this, menu2);
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onPrepareOptionsMenu", $$robo$$android_app_Dialog$onPrepareOptionsMenu(android.view.Menu ), 0, this, menu2);
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return (boolean)InvokeDynamicSupport.bootstrap("onOptionsItemSelected", $$robo$$android_app_Dialog$onOptionsItemSelected(android.view.MenuItem ), 0, this, menuItem);
    }

    public void onOptionsMenuClosed(Menu menu2) {
        InvokeDynamicSupport.bootstrap("onOptionsMenuClosed", $$robo$$android_app_Dialog$onOptionsMenuClosed(android.view.Menu ), 0, this, menu2);
    }

    public void openOptionsMenu() {
        InvokeDynamicSupport.bootstrap("openOptionsMenu", $$robo$$android_app_Dialog$openOptionsMenu(), 0, this);
    }

    public void closeOptionsMenu() {
        InvokeDynamicSupport.bootstrap("closeOptionsMenu", $$robo$$android_app_Dialog$closeOptionsMenu(), 0, this);
    }

    public void invalidateOptionsMenu() {
        InvokeDynamicSupport.bootstrap("invalidateOptionsMenu", $$robo$$android_app_Dialog$invalidateOptionsMenu(), 0, this);
    }

    @Override
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        InvokeDynamicSupport.bootstrap("onCreateContextMenu", $$robo$$android_app_Dialog$onCreateContextMenu(android.view.ContextMenu android.view.View android.view.ContextMenu$ContextMenuInfo ), 0, this, contextMenu, view, contextMenuInfo);
    }

    public void registerForContextMenu(View view) {
        InvokeDynamicSupport.bootstrap("registerForContextMenu", $$robo$$android_app_Dialog$registerForContextMenu(android.view.View ), 0, this, view);
    }

    public void unregisterForContextMenu(View view) {
        InvokeDynamicSupport.bootstrap("unregisterForContextMenu", $$robo$$android_app_Dialog$unregisterForContextMenu(android.view.View ), 0, this, view);
    }

    public void openContextMenu(View view) {
        InvokeDynamicSupport.bootstrap("openContextMenu", $$robo$$android_app_Dialog$openContextMenu(android.view.View ), 0, this, view);
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        return (boolean)InvokeDynamicSupport.bootstrap("onContextItemSelected", $$robo$$android_app_Dialog$onContextItemSelected(android.view.MenuItem ), 0, this, menuItem);
    }

    public void onContextMenuClosed(Menu menu2) {
        InvokeDynamicSupport.bootstrap("onContextMenuClosed", $$robo$$android_app_Dialog$onContextMenuClosed(android.view.Menu ), 0, this, menu2);
    }

    @Override
    public boolean onSearchRequested(SearchEvent searchEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSearchRequested", $$robo$$android_app_Dialog$onSearchRequested(android.view.SearchEvent ), 0, this, searchEvent);
    }

    @Override
    public boolean onSearchRequested() {
        return (boolean)InvokeDynamicSupport.bootstrap("onSearchRequested", $$robo$$android_app_Dialog$onSearchRequested(), 0, this);
    }

    public SearchEvent getSearchEvent() {
        return InvokeDynamicSupport.bootstrap("getSearchEvent", $$robo$$android_app_Dialog$getSearchEvent(), 0, this);
    }

    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        return InvokeDynamicSupport.bootstrap("onWindowStartingActionMode", $$robo$$android_app_Dialog$onWindowStartingActionMode(android.view.ActionMode$Callback ), 0, this, callback);
    }

    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback, int n) {
        return InvokeDynamicSupport.bootstrap("onWindowStartingActionMode", $$robo$$android_app_Dialog$onWindowStartingActionMode(android.view.ActionMode$Callback int ), 0, this, callback, n);
    }

    @Override
    public void onActionModeStarted(ActionMode actionMode) {
        InvokeDynamicSupport.bootstrap("onActionModeStarted", $$robo$$android_app_Dialog$onActionModeStarted(android.view.ActionMode ), 0, this, actionMode);
    }

    @Override
    public void onActionModeFinished(ActionMode actionMode) {
        InvokeDynamicSupport.bootstrap("onActionModeFinished", $$robo$$android_app_Dialog$onActionModeFinished(android.view.ActionMode ), 0, this, actionMode);
    }

    private ComponentName getAssociatedActivity() {
        return InvokeDynamicSupport.bootstrap("getAssociatedActivity", $$robo$$android_app_Dialog$getAssociatedActivity(), 0, this);
    }

    public void takeKeyEvents(boolean bl) {
        InvokeDynamicSupport.bootstrap("takeKeyEvents", $$robo$$android_app_Dialog$takeKeyEvents(boolean ), 0, this, bl);
    }

    public boolean requestWindowFeature(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestWindowFeature", $$robo$$android_app_Dialog$requestWindowFeature(int ), 0, this, n);
    }

    public void setFeatureDrawableResource(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setFeatureDrawableResource", $$robo$$android_app_Dialog$setFeatureDrawableResource(int int ), 0, this, n, n2);
    }

    public void setFeatureDrawableUri(int n, Uri uri) {
        InvokeDynamicSupport.bootstrap("setFeatureDrawableUri", $$robo$$android_app_Dialog$setFeatureDrawableUri(int android.net.Uri ), 0, this, n, uri);
    }

    public void setFeatureDrawable(int n, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setFeatureDrawable", $$robo$$android_app_Dialog$setFeatureDrawable(int android.graphics.drawable.Drawable ), 0, this, n, drawable2);
    }

    public void setFeatureDrawableAlpha(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setFeatureDrawableAlpha", $$robo$$android_app_Dialog$setFeatureDrawableAlpha(int int ), 0, this, n, n2);
    }

    public LayoutInflater getLayoutInflater() {
        return InvokeDynamicSupport.bootstrap("getLayoutInflater", $$robo$$android_app_Dialog$getLayoutInflater(), 0, this);
    }

    public void setCancelable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCancelable", $$robo$$android_app_Dialog$setCancelable(boolean ), 0, this, bl);
    }

    public void setCanceledOnTouchOutside(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCanceledOnTouchOutside", $$robo$$android_app_Dialog$setCanceledOnTouchOutside(boolean ), 0, this, bl);
    }

    @Override
    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_app_Dialog$cancel(), 0, this);
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        InvokeDynamicSupport.bootstrap("setOnCancelListener", $$robo$$android_app_Dialog$setOnCancelListener(android.content.DialogInterface$OnCancelListener ), 0, this, onCancelListener);
    }

    public void setCancelMessage(Message message) {
        InvokeDynamicSupport.bootstrap("setCancelMessage", $$robo$$android_app_Dialog$setCancelMessage(android.os.Message ), 0, this, message);
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissListener", $$robo$$android_app_Dialog$setOnDismissListener(android.content.DialogInterface$OnDismissListener ), 0, this, onDismissListener);
    }

    public void setOnShowListener(DialogInterface.OnShowListener onShowListener) {
        InvokeDynamicSupport.bootstrap("setOnShowListener", $$robo$$android_app_Dialog$setOnShowListener(android.content.DialogInterface$OnShowListener ), 0, this, onShowListener);
    }

    public void setDismissMessage(Message message) {
        InvokeDynamicSupport.bootstrap("setDismissMessage", $$robo$$android_app_Dialog$setDismissMessage(android.os.Message ), 0, this, message);
    }

    public boolean takeCancelAndDismissListeners(String string2, DialogInterface.OnCancelListener onCancelListener, DialogInterface.OnDismissListener onDismissListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("takeCancelAndDismissListeners", $$robo$$android_app_Dialog$takeCancelAndDismissListeners(java.lang.String android.content.DialogInterface$OnCancelListener android.content.DialogInterface$OnDismissListener ), 0, this, string2, onCancelListener, onDismissListener);
    }

    public void setVolumeControlStream(int n) {
        InvokeDynamicSupport.bootstrap("setVolumeControlStream", $$robo$$android_app_Dialog$setVolumeControlStream(int ), 0, this, n);
    }

    public int getVolumeControlStream() {
        return (int)InvokeDynamicSupport.bootstrap("getVolumeControlStream", $$robo$$android_app_Dialog$getVolumeControlStream(), 0, this);
    }

    public void setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        InvokeDynamicSupport.bootstrap("setOnKeyListener", $$robo$$android_app_Dialog$setOnKeyListener(android.content.DialogInterface$OnKeyListener ), 0, this, onKeyListener);
    }

    private void updateWindowForCancelable() {
        InvokeDynamicSupport.bootstrap("updateWindowForCancelable", $$robo$$android_app_Dialog$updateWindowForCancelable(), 0, this);
    }

    public /* synthetic */ Dialog() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Dialog)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ListenersHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<DialogInterface> mDialog;

        private void $$robo$$android_app_Dialog_ListenersHandler$__constructor__(Dialog dialog) {
            this.mDialog = new WeakReference<Dialog>(dialog);
        }

        private final void $$robo$$android_app_Dialog_ListenersHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 67: {
                    ((DialogInterface.OnDismissListener)msg.obj).onDismiss((DialogInterface)this.mDialog.get());
                    break;
                }
                case 68: {
                    ((DialogInterface.OnCancelListener)msg.obj).onCancel((DialogInterface)this.mDialog.get());
                    break;
                }
                case 69: {
                    ((DialogInterface.OnShowListener)msg.obj).onShow((DialogInterface)this.mDialog.get());
                }
            }
        }

        private void __constructor__(Dialog dialog) {
            this.$$robo$$android_app_Dialog_ListenersHandler$__constructor__(dialog);
        }

        public ListenersHandler(Dialog dialog) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Dialog_ListenersHandler$__constructor__(android.app.Dialog ), 0, this, dialog);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_Dialog_ListenersHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ ListenersHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListenersHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

