/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.app.IUiAutomationConnection;
import android.content.pm.IPackageManager;
import android.graphics.Bitmap;
import android.hardware.input.InputManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.view.IWindowManager;
import android.view.InputEvent;
import android.view.SurfaceControl;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import android.view.accessibility.IAccessibilityManager;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UiAutomationConnection
extends IUiAutomationConnection.Stub
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int INITIAL_FROZEN_ROTATION_UNSPECIFIED = -1;
    private IWindowManager mWindowManager;
    private IAccessibilityManager mAccessibilityManager;
    private IPackageManager mPackageManager;
    private Object mLock;
    private Binder mToken;
    private int mInitialFrozenRotation;
    private IAccessibilityServiceClient mClient;
    private boolean mIsShutdown;
    private int mOwningUid;

    private void $$robo$$android_app_UiAutomationConnection$__constructor__() {
        this.mWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        this.mAccessibilityManager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        this.mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        this.mLock = new Object();
        this.mToken = new Binder();
        this.mInitialFrozenRotation = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$connect(IAccessibilityServiceClient client, int flags) {
        if (client == null) {
            throw new IllegalArgumentException("Client cannot be null!");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfShutdownLocked();
            if (this.isConnectedLocked()) {
                throw new IllegalStateException("Already connected.");
            }
            this.mOwningUid = Binder.getCallingUid();
            this.registerUiTestAutomationServiceLocked(client, flags);
            this.storeRotationStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            if (!this.isConnectedLocked()) {
                throw new IllegalStateException("Already disconnected.");
            }
            this.mOwningUid = -1;
            this.unregisterUiTestAutomationServiceLocked();
            this.restoreRotationStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_UiAutomationConnection$injectInputEvent(InputEvent event, boolean sync) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        int mode = sync ? 2 : 0;
        long identity = Binder.clearCallingIdentity();
        try {
            boolean bl = InputManager.getInstance().injectInputEvent(event, mode);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_UiAutomationConnection$setRotation(int rotation) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            if (rotation == -2) {
                this.mWindowManager.thawRotation();
            } else {
                this.mWindowManager.freezeRotation(rotation);
            }
            boolean bl = true;
            return bl;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap $$robo$$android_app_UiAutomationConnection$takeScreenshot(int width, int height) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Bitmap bitmap = SurfaceControl.screenshot(width, height);
            return bitmap;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_UiAutomationConnection$clearWindowContentFrameStats(int windowId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        int callingUserId = UserHandle.getCallingUserId();
        long identity = Binder.clearCallingIdentity();
        try {
            IBinder token = this.mAccessibilityManager.getWindowToken(windowId, callingUserId);
            if (token == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mWindowManager.clearWindowContentFrameStats(token);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WindowContentFrameStats $$robo$$android_app_UiAutomationConnection$getWindowContentFrameStats(int windowId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        int callingUserId = UserHandle.getCallingUserId();
        long identity = Binder.clearCallingIdentity();
        try {
            IBinder token = this.mAccessibilityManager.getWindowToken(windowId, callingUserId);
            if (token == null) {
                WindowContentFrameStats windowContentFrameStats = null;
                return windowContentFrameStats;
            }
            WindowContentFrameStats windowContentFrameStats = this.mWindowManager.getWindowContentFrameStats(token);
            return windowContentFrameStats;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$clearWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            SurfaceControl.clearAnimationFrameStats();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WindowAnimationFrameStats $$robo$$android_app_UiAutomationConnection$getWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            WindowAnimationFrameStats stats = new WindowAnimationFrameStats();
            SurfaceControl.getAnimationFrameStats(stats);
            WindowAnimationFrameStats windowAnimationFrameStats = stats;
            return windowAnimationFrameStats;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$grantRuntimePermission(String packageName, String permission2, int userId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.mPackageManager.grantRuntimePermission(packageName, permission2, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$revokeRuntimePermission(String packageName, String permission2, int userId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.mPackageManager.revokeRuntimePermission(packageName, permission2, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$executeShellCommand(String command, ParcelFileDescriptor sink) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        ShadowedObject streamReader = new ShadowedObject(this, command, sink){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$command;
            /* synthetic */ ParcelFileDescriptor val$sink;
            /* synthetic */ UiAutomationConnection this$0;

            private void $$robo$$android_app_UiAutomationConnection_1$__constructor__(UiAutomationConnection this$0, String string2, ParcelFileDescriptor parcelFileDescriptor) {
            }

            private final void $$robo$$android_app_UiAutomationConnection_1$run() {
                InputStream in = null;
                FileOutputStream out = null;
                Process process = null;
                try {
                    int readByteCount;
                    process = Runtime.getRuntime().exec(this.val$command);
                    in = process.getInputStream();
                    out = new FileOutputStream(this.val$sink.getFileDescriptor());
                    byte[] buffer = new byte[8192];
                    while ((readByteCount = in.read(buffer)) >= 0) {
                        ((OutputStream)out).write(buffer, 0, readByteCount);
                    }
                    if (process != null) {
                        process.destroy();
                    }
                }
                catch (IOException ioe) {
                    try {
                        throw new RuntimeException("Error running shell command", ioe);
                    }
                    catch (Throwable throwable) {
                        if (process != null) {
                            process.destroy();
                        }
                        IoUtils.closeQuietly(out);
                        IoUtils.closeQuietly(this.val$sink);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(out);
                IoUtils.closeQuietly(this.val$sink);
            }

            private void __constructor__(UiAutomationConnection uiAutomationConnection, String string2, ParcelFileDescriptor parcelFileDescriptor) {
                this.$$robo$$android_app_UiAutomationConnection_1$__constructor__(uiAutomationConnection, string2, parcelFileDescriptor);
            }
            {
                this.this$0 = uiAutomationConnection;
                this.val$command = string2;
                this.val$sink = parcelFileDescriptor;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_UiAutomationConnection_1$__constructor__(android.app.UiAutomationConnection java.lang.String android.os.ParcelFileDescriptor ), 0, this, uiAutomationConnection, string2, parcelFileDescriptor);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_UiAutomationConnection_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        streamReader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$shutdown() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isConnectedLocked()) {
                this.throwIfCalledByNotTrustedUidLocked();
            }
            this.throwIfShutdownLocked();
            this.mIsShutdown = true;
            if (this.isConnectedLocked()) {
                this.disconnect();
            }
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$registerUiTestAutomationServiceLocked(IAccessibilityServiceClient client, int flags) {
        IAccessibilityManager manager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        AccessibilityServiceInfo info = new AccessibilityServiceInfo();
        info.eventTypes = -1;
        info.feedbackType = 16;
        info.flags |= 0x10012;
        info.setCapabilities(15);
        try {
            manager.registerUiTestAutomationService(this.mToken, client, info, flags);
            this.mClient = client;
        }
        catch (RemoteException re) {
            throw new IllegalStateException("Error while registering UiTestAutomationService.", re);
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$unregisterUiTestAutomationServiceLocked() {
        IAccessibilityManager manager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        try {
            manager.unregisterUiTestAutomationService(this.mClient);
            this.mClient = null;
        }
        catch (RemoteException re) {
            throw new IllegalStateException("Error while unregistering UiTestAutomationService", re);
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$storeRotationStateLocked() {
        try {
            if (this.mWindowManager.isRotationFrozen()) {
                this.mInitialFrozenRotation = this.mWindowManager.getDefaultDisplayRotation();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$restoreRotationStateLocked() {
        try {
            if (this.mInitialFrozenRotation != -1) {
                this.mWindowManager.freezeRotation(this.mInitialFrozenRotation);
            } else {
                this.mWindowManager.thawRotation();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_app_UiAutomationConnection$isConnectedLocked() {
        return this.mClient != null;
    }

    private final void $$robo$$android_app_UiAutomationConnection$throwIfShutdownLocked() {
        if (this.mIsShutdown) {
            throw new IllegalStateException("Connection shutdown!");
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$throwIfNotConnectedLocked() {
        if (!this.isConnectedLocked()) {
            throw new IllegalStateException("Not connected!");
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$throwIfCalledByNotTrustedUidLocked() {
        int callingUid = Binder.getCallingUid();
        if (callingUid != this.mOwningUid && this.mOwningUid != 1000 && callingUid != 0) {
            throw new SecurityException("Calling from not trusted UID!");
        }
    }

    private void __constructor__() {
        this.$$robo$$android_app_UiAutomationConnection$__constructor__();
    }

    public UiAutomationConnection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_UiAutomationConnection$__constructor__(), 0, this);
    }

    @Override
    public void connect(IAccessibilityServiceClient iAccessibilityServiceClient, int n) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_app_UiAutomationConnection$connect(android.accessibilityservice.IAccessibilityServiceClient int ), 0, this, iAccessibilityServiceClient, n);
    }

    @Override
    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_app_UiAutomationConnection$disconnect(), 0, this);
    }

    @Override
    public boolean injectInputEvent(InputEvent inputEvent, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("injectInputEvent", $$robo$$android_app_UiAutomationConnection$injectInputEvent(android.view.InputEvent boolean ), 0, this, inputEvent, bl);
    }

    @Override
    public boolean setRotation(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRotation", $$robo$$android_app_UiAutomationConnection$setRotation(int ), 0, this, n);
    }

    @Override
    public Bitmap takeScreenshot(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("takeScreenshot", $$robo$$android_app_UiAutomationConnection$takeScreenshot(int int ), 0, this, n, n2);
    }

    @Override
    public boolean clearWindowContentFrameStats(int n) throws RemoteException {
        return (boolean)InvokeDynamicSupport.bootstrap("clearWindowContentFrameStats", $$robo$$android_app_UiAutomationConnection$clearWindowContentFrameStats(int ), 0, this, n);
    }

    @Override
    public WindowContentFrameStats getWindowContentFrameStats(int n) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getWindowContentFrameStats", $$robo$$android_app_UiAutomationConnection$getWindowContentFrameStats(int ), 0, this, n);
    }

    @Override
    public void clearWindowAnimationFrameStats() {
        InvokeDynamicSupport.bootstrap("clearWindowAnimationFrameStats", $$robo$$android_app_UiAutomationConnection$clearWindowAnimationFrameStats(), 0, this);
    }

    @Override
    public WindowAnimationFrameStats getWindowAnimationFrameStats() {
        return InvokeDynamicSupport.bootstrap("getWindowAnimationFrameStats", $$robo$$android_app_UiAutomationConnection$getWindowAnimationFrameStats(), 0, this);
    }

    @Override
    public void grantRuntimePermission(String string2, String string3, int n) throws RemoteException {
        InvokeDynamicSupport.bootstrap("grantRuntimePermission", $$robo$$android_app_UiAutomationConnection$grantRuntimePermission(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    @Override
    public void revokeRuntimePermission(String string2, String string3, int n) throws RemoteException {
        InvokeDynamicSupport.bootstrap("revokeRuntimePermission", $$robo$$android_app_UiAutomationConnection$revokeRuntimePermission(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    @Override
    public void executeShellCommand(String string2, ParcelFileDescriptor parcelFileDescriptor) throws RemoteException {
        InvokeDynamicSupport.bootstrap("executeShellCommand", $$robo$$android_app_UiAutomationConnection$executeShellCommand(java.lang.String android.os.ParcelFileDescriptor ), 0, this, string2, parcelFileDescriptor);
    }

    @Override
    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_app_UiAutomationConnection$shutdown(), 0, this);
    }

    private void registerUiTestAutomationServiceLocked(IAccessibilityServiceClient iAccessibilityServiceClient, int n) {
        InvokeDynamicSupport.bootstrap("registerUiTestAutomationServiceLocked", $$robo$$android_app_UiAutomationConnection$registerUiTestAutomationServiceLocked(android.accessibilityservice.IAccessibilityServiceClient int ), 0, this, iAccessibilityServiceClient, n);
    }

    private void unregisterUiTestAutomationServiceLocked() {
        InvokeDynamicSupport.bootstrap("unregisterUiTestAutomationServiceLocked", $$robo$$android_app_UiAutomationConnection$unregisterUiTestAutomationServiceLocked(), 0, this);
    }

    private void storeRotationStateLocked() {
        InvokeDynamicSupport.bootstrap("storeRotationStateLocked", $$robo$$android_app_UiAutomationConnection$storeRotationStateLocked(), 0, this);
    }

    private void restoreRotationStateLocked() {
        InvokeDynamicSupport.bootstrap("restoreRotationStateLocked", $$robo$$android_app_UiAutomationConnection$restoreRotationStateLocked(), 0, this);
    }

    private boolean isConnectedLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectedLocked", $$robo$$android_app_UiAutomationConnection$isConnectedLocked(), 0, this);
    }

    private void throwIfShutdownLocked() {
        InvokeDynamicSupport.bootstrap("throwIfShutdownLocked", $$robo$$android_app_UiAutomationConnection$throwIfShutdownLocked(), 0, this);
    }

    private void throwIfNotConnectedLocked() {
        InvokeDynamicSupport.bootstrap("throwIfNotConnectedLocked", $$robo$$android_app_UiAutomationConnection$throwIfNotConnectedLocked(), 0, this);
    }

    private void throwIfCalledByNotTrustedUidLocked() {
        InvokeDynamicSupport.bootstrap("throwIfCalledByNotTrustedUidLocked", $$robo$$android_app_UiAutomationConnection$throwIfCalledByNotTrustedUidLocked(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiAutomationConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

